/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CaretSelectionBind;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyledDocument;
import org.reactfx.EventStream;
import org.reactfx.SuspendableNo;
import org.reactfx.value.Var;

public interface TextEditingArea<PS, SEG, S> {
    default public int getLength() {
        return (Integer)this.lengthProperty().getValue();
    }

    public ObservableValue<Integer> lengthProperty();

    default public Locale getLocale() {
        return Locale.getDefault();
    }

    default public String getText() {
        return (String)this.textProperty().getValue();
    }

    public ObservableValue<String> textProperty();

    public StyledDocument<PS, SEG, S> getDocument();

    public EditableStyledDocument<PS, SEG, S> getContent();

    public SegmentOps<SEG, S> getSegOps();

    default public int getCaretPosition() {
        return this.getCaretSelectionBind().getPosition();
    }

    default public ObservableValue<Integer> caretPositionProperty() {
        return this.getCaretSelectionBind().positionProperty();
    }

    default public int getCurrentParagraph() {
        return this.getCaretSelectionBind().getParagraphIndex();
    }

    default public ObservableValue<Integer> currentParagraphProperty() {
        return this.getCaretSelectionBind().paragraphIndexProperty();
    }

    default public int getCaretColumn() {
        return this.getCaretSelectionBind().getColumnPosition();
    }

    default public ObservableValue<Integer> caretColumnProperty() {
        return this.getCaretSelectionBind().columnPositionProperty();
    }

    default public Optional<Bounds> getCaretBounds() {
        return this.getCaretSelectionBind().getCaretBounds();
    }

    default public ObservableValue<Optional<Bounds>> caretBoundsProperty() {
        return this.getCaretSelectionBind().caretBoundsProperty();
    }

    default public Caret.CaretVisibility getShowCaret() {
        return this.getCaretSelectionBind().getShowCaret();
    }

    default public void setShowCaret(Caret.CaretVisibility value) {
        this.getCaretSelectionBind().setShowCaret(value);
    }

    default public Var<Caret.CaretVisibility> showCaretProperty() {
        return this.getCaretSelectionBind().showCaretProperty();
    }

    public CaretSelectionBind<PS, SEG, S> getCaretSelectionBind();

    default public int getAnchor() {
        return this.getCaretSelectionBind().getAnchorPosition();
    }

    default public ObservableValue<Integer> anchorProperty() {
        return this.getCaretSelectionBind().anchorPositionProperty();
    }

    default public IndexRange getSelection() {
        return this.getCaretSelectionBind().getRange();
    }

    default public ObservableValue<IndexRange> selectionProperty() {
        return this.getCaretSelectionBind().rangeProperty();
    }

    default public String getSelectedText() {
        return this.getCaretSelectionBind().getSelectedText();
    }

    default public ObservableValue<String> selectedTextProperty() {
        return this.getCaretSelectionBind().selectedTextProperty();
    }

    default public Optional<Bounds> getSelectionBounds() {
        return this.getCaretSelectionBind().getSelectionBounds();
    }

    default public ObservableValue<Optional<Bounds>> selectionBoundsProperty() {
        return this.getCaretSelectionBind().selectionBoundsProperty();
    }

    public ObservableList<Paragraph<PS, SEG, S>> getParagraphs();

    default public Paragraph<PS, SEG, S> getParagraph(int index) {
        return (Paragraph)this.getParagraphs().get(index);
    }

    default public int getParagraphLength(int index) {
        return this.getParagraph(index).length();
    }

    public SuspendableNo beingUpdatedProperty();

    default public boolean isBeingUpdated() {
        return this.beingUpdatedProperty().get();
    }

    public EventStream<List<PlainTextChange>> multiPlainChanges();

    public EventStream<PlainTextChange> plainTextChanges();

    public EventStream<List<RichTextChange<PS, SEG, S>>> multiRichChanges();

    public EventStream<RichTextChange<PS, SEG, S>> richChanges();

    public String getText(int var1);

    public String getText(int var1, int var2);

    public String getText(IndexRange var1);

    default public String getText(int startParagraph, int startColumn, int endParagraph, int endColumn) {
        int start = this.getAbsolutePosition(startParagraph, startColumn);
        int end = this.getAbsolutePosition(endParagraph, endColumn);
        return this.getText(start, end);
    }

    public StyledDocument<PS, SEG, S> subDocument(int var1);

    default public StyledDocument<PS, SEG, S> subDocument(IndexRange range) {
        return this.subDocument(range.getStart(), range.getEnd());
    }

    public StyledDocument<PS, SEG, S> subDocument(int var1, int var2);

    default public StyledDocument<PS, SEG, S> subDocument(int startParagraph, int startColumn, int endParagraph, int endColumn) {
        int start = this.getAbsolutePosition(startParagraph, startColumn);
        int end = this.getAbsolutePosition(endParagraph, endColumn);
        return this.subDocument(start, end);
    }

    default public IndexRange getParagraphSelection(int paragraph) {
        return this.getParagraphSelection(this.getCaretSelectionBind(), paragraph);
    }

    public IndexRange getParagraphSelection(Selection var1, int var2);

    default public void selectRange(int anchor, int caretPosition) {
        this.getCaretSelectionBind().selectRangeExpl(anchor, caretPosition);
    }

    default public void selectRange(int anchorParagraph, int anchorColumn, int caretPositionParagraph, int caretPositionColumn) {
        int anchor = this.getAbsolutePosition(anchorParagraph, anchorColumn);
        int caretPosition = this.getAbsolutePosition(caretPositionParagraph, caretPositionColumn);
        this.selectRange(anchor, caretPosition);
    }

    public void displaceCaret(int var1);

    public void replaceText(int var1, int var2, String var3);

    default public void replaceText(int startParagraph, int startColumn, int endParagraph, int endColumn, String text) {
        int start = this.getAbsolutePosition(startParagraph, startColumn);
        int end = this.getAbsolutePosition(endParagraph, endColumn);
        this.replaceText(start, end, text);
    }

    public void replace(int var1, int var2, StyledDocument<PS, SEG, S> var3);

    public MultiChangeBuilder<PS, SEG, S> createMultiChange();

    public MultiChangeBuilder<PS, SEG, S> createMultiChange(int var1);

    public void replace(int var1, int var2, SEG var3, S var4);

    default public void replace(int startParagraph, int startColumn, int endParagraph, int endColumn, SEG seg, S style) {
        int start = this.getAbsolutePosition(startParagraph, startColumn);
        int end = this.getAbsolutePosition(endParagraph, endColumn);
        this.replace(start, end, seg, style);
    }

    default public void replace(int startParagraph, int startColumn, int endParagraph, int endColumn, StyledDocument<PS, SEG, S> replacement) {
        int start = this.getAbsolutePosition(startParagraph, startColumn);
        int end = this.getAbsolutePosition(endParagraph, endColumn);
        this.replace(start, end, replacement);
    }

    default public void replaceText(IndexRange range, String text) {
        this.replaceText(range.getStart(), range.getEnd(), text);
    }

    default public void replace(IndexRange range, SEG seg, S style) {
        this.replace(range.getStart(), range.getEnd(), seg, style);
    }

    default public void replace(IndexRange range, StyledDocument<PS, SEG, S> replacement) {
        this.replace(range.getStart(), range.getEnd(), replacement);
    }

    public int getAbsolutePosition(int var1, int var2);

    public void dispose();
}

