/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.secure_io;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.MAC;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.secure_io.KeyManagerSingleton;
import io.olvid.engine.secure_io.SecureFileHeader;
import io.olvid.engine.secure_io.datatypes.FileKeys;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.InvalidKeyException;
import java.util.Arrays;

class SecureIOHelper {
    static final int BLOCK_SIZE = 4096;
    static final int BLOCK_PAYLOAD_SIZE = 4056;
    static final int BLOCK_ENCRYPTION_OVERHEAD_SIZE = 40;
    static final MAC macHmacSha256 = Suite.getMAC("hmac_sha-256");
    static final AuthEnc authEnc = Suite.getAuthEnc("ctr-aes-256_then_hmac_sha-256");
    static final PRNG prng = Suite.getPRNGService("prng_hmac_sha-256");

    SecureIOHelper() {
    }

    static int bulletProofRead(RandomAccessFile fileAccessor, byte[] buff) throws IOException {
        return SecureIOHelper.bulletProofRead(fileAccessor, buff, 0, buff.length);
    }

    static int bulletProofRead(FileInputStream fileAccessor, byte[] buff) throws IOException {
        return SecureIOHelper.bulletProofRead(fileAccessor, buff, 0, buff.length);
    }

    static int bulletProofRead(RandomAccessFile fileAccessor, byte[] buffer, int off, int len) throws IOException {
        int bufferFullness;
        int count;
        for (bufferFullness = off; bufferFullness < off + len && (count = fileAccessor.read(buffer, bufferFullness, off + len - bufferFullness)) >= 0; bufferFullness += count) {
        }
        return bufferFullness - off;
    }

    static int bulletProofRead(FileInputStream fileAccessor, byte[] buffer, int off, int len) throws IOException {
        int bufferFullness;
        int count;
        for (bufferFullness = off; bufferFullness < off + len && (count = fileAccessor.read(buffer, bufferFullness, off + len - bufferFullness)) >= 0; bufferFullness += count) {
        }
        return bufferFullness - off;
    }

    static Encoded[] getSecureHeaderEncodedInfosFromFS(RandomAccessFile fileAccessor) throws IOException {
        try {
            byte[] headerBytes = new byte[4096];
            fileAccessor.seek(0L);
            if (SecureIOHelper.bulletProofRead(fileAccessor, headerBytes) != headerBytes.length) {
                throw new IOException();
            }
            Encoded encodedHeaderInfo = Encoded.fromLongerByteArray(headerBytes);
            Encoded[] headerItems = encodedHeaderInfo.decodeList();
            if (headerItems.length == 3) {
                return headerItems;
            }
            return null;
        }
        catch (DecodingException | IllegalArgumentException exception) {
            Logger.e("Decoding exception : \n " + exception.getMessage());
            return null;
        }
    }

    static SecureFileHeader getSecureFileHeaderFromFS(RandomAccessFile fileAccessor, String FSFileName, boolean check) throws IOException {
        try {
            if (macHmacSha256 != null) {
                FileKeys associatedKeys = new FileKeys(KeyManagerSingleton.getInstance().generateKeysForFileName());
                Encoded[] headerItems = SecureIOHelper.getSecureHeaderEncodedInfosFromFS(fileAccessor);
                if (headerItems != null) {
                    long fileSize = headerItems[0].decodeLong();
                    byte[] fileName = headerItems[1].decodeBytes();
                    byte[] encFileContentKey = headerItems[2].decodeBytes();
                    byte[] plainEncFileContentKey = authEnc.decrypt(associatedKeys.getFileNameEncryptionKeys().getSecond(), new EncryptedBytes(encFileContentKey));
                    Encoded enc = new Encoded(plainEncFileContentKey);
                    AuthEncKey key = (AuthEncKey)enc.decodeSymmetricKey();
                    if (key == null) {
                        throw new IOException("Couldn't get content encryption key");
                    }
                    associatedKeys.setFileContentEncryptionKey(key);
                    byte[] plainFileName = authEnc.decrypt(associatedKeys.getFileNameEncryptionKeys().getSecond(), new EncryptedBytes(fileName));
                    if (check) {
                        byte[] fileNameMac = macHmacSha256.digest(associatedKeys.getFileNameEncryptionKeys().getFirst(), plainFileName);
                        if (Arrays.equals(fileNameMac, Logger.fromHexString(FSFileName))) {
                            return new SecureFileHeader(fileSize, fileName, enc, associatedKeys, plainFileName);
                        }
                        Logger.e("Mac Mismatch on given file name : \n" + FSFileName);
                        throw new IOException();
                    }
                    return new SecureFileHeader(fileSize, fileName, enc, associatedKeys, plainFileName);
                }
                Logger.e("Couldn't retrieve header from FS : \n" + FSFileName);
                return null;
            }
            Logger.e("Couldn't generate MAC digest handler, SecureHeaderFile is null");
        }
        catch (DecodingException e) {
            Logger.e("Decoding error...message --> : \n" + e.getMessage());
            throw new IOException();
        }
        catch (InvalidKeyException e) {
            Logger.e("Bad Key...message --> : \n" + e.getMessage());
            throw new IOException();
        }
        catch (DecryptionException e) {
            Logger.e("Decryption error...message --> : \n" + e.getMessage());
            throw new IOException();
        }
        return null;
    }

    static File buildFileFromPlainFileName(String dir, String fileName, FileKeys keys) {
        if (macHmacSha256 != null) {
            try {
                byte[] digestedFileName = macHmacSha256.digest(keys.getFileNameEncryptionKeys().getFirst(), fileName.getBytes());
                return new File(dir, Logger.toHexString(digestedFileName));
            }
            catch (InvalidKeyException e) {
                Logger.e("Invalid key : \n " + e.getMessage());
            }
        }
        return null;
    }

    static long computeEncryptedDataOffsetFromPlainDataOffset(long plainDataOffset) {
        long modulo = plainDataOffset % 4056L;
        if (modulo > 0L) {
            return plainDataOffset / 4056L * 4096L + modulo + 40L + 4096L;
        }
        return plainDataOffset / 4056L * 4096L + 4096L;
    }
}

