/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.secure_io;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileHeader;
import io.olvid.engine.secure_io.SecureIOHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.InvalidKeyException;

public class SecureFileInputStream
extends InputStream {
    private SecureFile associatedSecureFile;
    private long FSReadPosition = 4096L;
    private SecureFileHeader secureFileHeader;
    private RandomAccessFile fileAccessor;
    private long plainTxtReadPosition = 0L;
    private byte[] blockPlainTxt;
    boolean fileReadNeeded = true;

    public SecureFileInputStream(SecureFile associatedFile) throws IOException {
        if (associatedFile != null && associatedFile.getFSNameFile() != null) {
            if (!associatedFile.getFSNameFile().exists()) {
                throw new FileNotFoundException();
            }
            this.associatedSecureFile = associatedFile;
            this.fileAccessor = new RandomAccessFile(this.associatedSecureFile.getFSNameFile(), "r");
            this.secureFileHeader = SecureIOHelper.getSecureFileHeaderFromFS(this.fileAccessor, this.associatedSecureFile.getFSNameFile().getName(), false);
        }
        if (this.secureFileHeader == null) {
            throw new RuntimeException();
        }
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        if (this.read(bytes, 0, 1) == 1) {
            return Byte.toUnsignedInt(bytes[0]);
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            Logger.d("Nothing to read....or inconsistent args?\ngiven length : " + len);
            return 0;
        }
        if (off > b.length) {
            Logger.w("destination offset is inconsistent with output byte array length\ngiven off : " + off + "given output byte length." + b.length);
            return 0;
        }
        if (this.FSReadPosition >= this.fileAccessor.length() - 1L && this.plainTxtReadPosition == this.secureFileHeader.getFileSize()) {
            return -1;
        }
        if ((long)len > this.secureFileHeader.getFileSize() - this.plainTxtReadPosition) {
            len = (int)(this.secureFileHeader.getFileSize() - this.plainTxtReadPosition);
        }
        if (b.length - off < len) {
            len = b.length - off;
        }
        int originalLen = len;
        byte[] readBuffer = new byte[4096];
        int plainTxtBlockOffset = (int)(this.plainTxtReadPosition % 4056L);
        this.fileAccessor.seek(this.FSReadPosition);
        while (len > 0) {
            try {
                if (this.FSReadPosition + 4096L >= this.fileAccessor.length()) {
                    readBuffer = new byte[(int)(this.fileAccessor.length() - this.FSReadPosition)];
                }
                if (this.fileReadNeeded) {
                    if (SecureIOHelper.bulletProofRead(this.fileAccessor, readBuffer) != readBuffer.length) {
                        throw new IOException();
                    }
                    this.blockPlainTxt = SecureIOHelper.authEnc.decrypt(this.secureFileHeader.getAssociatedKeys().getFileContentEncryptionKey(), new EncryptedBytes(readBuffer));
                    this.fileReadNeeded = false;
                    this.FSReadPosition += (long)SecureIOHelper.authEnc.ciphertextLengthFromPlaintextLength(this.blockPlainTxt.length);
                }
                int bytesToRead = Math.min(this.blockPlainTxt.length - plainTxtBlockOffset, len);
                System.arraycopy(this.blockPlainTxt, plainTxtBlockOffset, b, off, bytesToRead);
                plainTxtBlockOffset = 0;
                this.plainTxtReadPosition += (long)bytesToRead;
                this.fileReadNeeded = this.plainTxtReadPosition % 4056L == 0L;
                len -= bytesToRead;
                off += bytesToRead;
            }
            catch (DecryptionException e) {
                Logger.e("Decryption Exception : \n" + e.getMessage(), e);
                throw new IOException();
            }
            catch (InvalidKeyException e) {
                Logger.e("Invalid Key : \n" + e.getMessage());
                throw new IOException();
            }
        }
        return originalLen;
    }

    public void seek(long index) throws IOException {
        if (index < 0L || index >= this.secureFileHeader.getFileSize()) {
            throw new IOException("seek index cannot be negative or greater than file size, given index value : " + index);
        }
        this.plainTxtReadPosition = index;
        this.FSReadPosition = index / 4056L * 4096L + 4096L;
        this.fileReadNeeded = true;
    }

    @Override
    public void close() throws IOException {
        this.fileAccessor.close();
    }
}

