/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.secure_io;

import io.olvid.engine.Logger;
import io.olvid.engine.secure_io.KeyManagerSingleton;
import io.olvid.engine.secure_io.SecureFileHeader;
import io.olvid.engine.secure_io.SecureIOHelper;
import io.olvid.engine.secure_io.datatypes.DirectoryListingResult;
import io.olvid.engine.secure_io.datatypes.FileKeys;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;

public class SecureFile {
    private final FileKeys associatedKeys;
    private final File plainNameFile;
    private File FSNameFile;
    private final boolean isDirectory;

    public SecureFile(String absolutePath) {
        this(new File(absolutePath));
    }

    public SecureFile(String givenBaseDir, String fileName) {
        this(new File(givenBaseDir, fileName));
    }

    private SecureFile(File plainFile) {
        if (plainFile == null) {
            throw new NullPointerException();
        }
        this.isDirectory = plainFile.isDirectory();
        this.associatedKeys = this.isDirectory ? null : new FileKeys(KeyManagerSingleton.getInstance().generateKeysForFileName());
        this.FSNameFile = this.isDirectory ? plainFile : SecureIOHelper.buildFileFromPlainFileName(plainFile.getParent(), plainFile.getName(), this.associatedKeys);
        this.plainNameFile = plainFile;
    }

    File getFSNameFile() {
        return this.FSNameFile;
    }

    FileKeys getAssociatedKeys() {
        return this.associatedKeys;
    }

    boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean renameTo(String newDir, String newName) throws IOException {
        try {
            if (newDir != null && newName != null) {
                File targetFile = SecureIOHelper.buildFileFromPlainFileName(newDir, newName, this.associatedKeys);
                if (this.FSNameFile == null || targetFile == null) {
                    Logger.e("Couldn't build FS file names");
                    return false;
                }
                if (this.FSNameFile.renameTo(targetFile)) {
                    Logger.d("Renamed file to " + newDir + "/" + newName + " successfully....updating header ");
                    RandomAccessFile fileAccessor = new RandomAccessFile(targetFile, "rw");
                    SecureFileHeader fileHeader = SecureIOHelper.getSecureFileHeaderFromFS(fileAccessor, targetFile.getName(), false);
                    if (fileHeader != null) {
                        fileHeader.setEncryptedFileName(SecureIOHelper.authEnc.encrypt(this.associatedKeys.getFileNameEncryptionKeys().getSecond(), newName.getBytes(StandardCharsets.UTF_8), SecureIOHelper.prng).getBytes());
                        byte[] newHeader = fileHeader.buildHeaderBlock(this.associatedKeys.getFileNameEncryptionKeys().getSecond());
                        fileAccessor.seek(0L);
                        fileAccessor.write(newHeader);
                        fileAccessor.close();
                        this.FSNameFile = new File(targetFile.getParent(), newName);
                        Logger.d("Updated header successfully");
                        return true;
                    }
                } else {
                    Logger.d("Couldn't update header on FS");
                    throw new IOException();
                }
            }
            throw new IllegalArgumentException();
        }
        catch (InvalidKeyException invalidKeyException) {
            Logger.e("Bad key used for HMAC SHA256 generation", invalidKeyException);
            throw new IOException();
        }
    }

    public DirectoryListingResult listDirectory() throws IOException {
        if (this.plainNameFile == null) {
            Logger.e("File is null, can't list children");
            throw new IOException();
        }
        if (!this.plainNameFile.isDirectory()) {
            Logger.e("File is not a directory, can't list...");
            throw new IOException();
        }
        DirectoryListingResult directoryListingResult = new DirectoryListingResult();
        String[] childrenNames = this.plainNameFile.list();
        if (childrenNames != null) {
            for (String child : childrenNames) {
                File childFile = new File(this.plainNameFile.getAbsolutePath() + File.separator + child);
                if (childFile.isDirectory()) {
                    directoryListingResult.getDirList().add(childFile);
                    continue;
                }
                RandomAccessFile randomAccessFile = new RandomAccessFile(childFile, "r");
                SecureFileHeader secureFileHeader = SecureIOHelper.getSecureFileHeaderFromFS(randomAccessFile, child, true);
                if (secureFileHeader != null) {
                    SecureFile secureFile = new SecureFile(this.plainNameFile.getAbsolutePath() + File.separator + new String(secureFileHeader.getPlainFileName()));
                    directoryListingResult.getSecureFileList().add(secureFile);
                    continue;
                }
                directoryListingResult.getFileList().add(childFile);
            }
            return directoryListingResult;
        }
        return null;
    }

    public boolean delete() throws IOException {
        if (this.FSNameFile != null) {
            return this.FSNameFile.delete();
        }
        return false;
    }

    public boolean exists() {
        return this.FSNameFile != null && this.FSNameFile.exists();
    }

    public boolean canRead() {
        SecureFileHeader secureFileHeader;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.getFSNameFile(), "r");
            secureFileHeader = SecureIOHelper.getSecureFileHeaderFromFS(randomAccessFile, this.getFSNameFile().getName(), true);
        }
        catch (IOException e) {
            Logger.d("couldn't read header of file : " + this.plainNameFile.getName());
            secureFileHeader = null;
        }
        return secureFileHeader != null;
    }

    public long length() {
        return this.FSNameFile != null ? this.FSNameFile.length() : 0L;
    }

    public File getPlainNameFile() {
        return this.plainNameFile;
    }

    public boolean isFile() {
        return this.FSNameFile.isFile();
    }
}

