/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.secure_io;

import io.olvid.engine.crypto.Suite;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.secure_io.SecureIOHelper;
import io.olvid.engine.secure_io.datatypes.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Properties;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PropertiesHelper {
    private final Properties props;
    private final File ourFile;
    private static final String PWD_HASH_METHOD = "PBKDF2WithHmacSHA512";
    private byte[] userSecretSeed;
    private byte[] salt = new byte[16];

    public PropertiesHelper(String confBaseDir, String fileLocation, String userSecret) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException, DecryptionException, InvalidKeyException {
        this.props = new Properties();
        File dir = new File(confBaseDir);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Couldn't create props dir");
            }
            this.ourFile = new File(dir, fileLocation);
            if (!this.ourFile.createNewFile()) {
                throw new IOException("Couldn't create key props file");
            }
            char[] pwd = userSecret.toCharArray();
            this.salt = Suite.getPRNGService("prng_hmac_sha-256").bytes(16);
            PBEKeySpec spec = new PBEKeySpec(pwd, this.salt, 10000, 256);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PWD_HASH_METHOD);
            this.userSecretSeed = secretKeyFactory.generateSecret(spec).getEncoded();
        } else {
            this.ourFile = new File(dir, fileLocation);
            this.readSecuredProperties(userSecret);
        }
    }

    public Properties getProps() {
        return this.props;
    }

    public void addProp(Pair<String, String> prop) throws DecryptionException, IOException, InvalidKeyException {
        if (prop != null) {
            this.props.setProperty(prop.getFirst(), prop.getSecond());
            this.commitChanges();
        }
    }

    private void readProperties(InputStream fileContent) throws IOException {
        this.props.load(fileContent);
    }

    private void readSecuredProperties(String userSecret) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException, DecryptionException, InvalidKeyException {
        if (userSecret != null && userSecret.length() != 0) {
            try (FileInputStream is = new FileInputStream(this.ourFile.getPath());){
                SecureIOHelper.bulletProofRead(is, this.salt);
                char[] pwd = userSecret.toCharArray();
                PBEKeySpec spec = new PBEKeySpec(pwd, this.salt, 10000, 256);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PWD_HASH_METHOD);
                this.userSecretSeed = secretKeyFactory.generateSecret(spec).getEncoded();
                AuthEncKey encKey = Suite.getAuthEnc("ctr-aes-256_then_hmac_sha-256").generateKey(Suite.getPRNG("prng_hmac_sha-256", new Seed(this.userSecretSeed)));
                if (is.getChannel().size() > 0L) {
                    byte[] encData = new byte[(int)(is.getChannel().size() - 16L)];
                    SecureIOHelper.bulletProofRead(is, encData);
                    byte[] clearText = Suite.getAuthEnc("ctr-aes-256_then_hmac_sha-256").decrypt(encKey, new EncryptedBytes(encData));
                    ByteArrayInputStream bais = new ByteArrayInputStream(clearText);
                    this.readProperties(bais);
                }
            }
        }
    }

    private void commitChanges() throws IOException, InvalidKeyException {
        try (FileOutputStream os = new FileOutputStream(this.ourFile.getPath());){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.props.store(baos, null);
            if (this.userSecretSeed != null) {
                AuthEncKey encKey = Suite.getAuthEnc("ctr-aes-256_then_hmac_sha-256").generateKey(Suite.getPRNG("prng_hmac_sha-256", new Seed(this.userSecretSeed)));
                EncryptedBytes encBytes = Suite.getAuthEnc("ctr-aes-256_then_hmac_sha-256").encrypt(encKey, baos.toByteArray(), Suite.getPRNG("prng_hmac_sha-256", new Seed(this.userSecretSeed)));
                baos.reset();
                baos.write(this.salt);
                baos.write(encBytes.getBytes());
            }
            os.write(baos.toByteArray());
            baos.close();
        }
    }
}

