/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Commitment;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.SAS;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.DialogType;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.TrustOrigin;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.metamanager.IdentityDelegate;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.databases.TrustEstablishmentCommitmentReceived;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.OneWayDialogProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.DeviceDiscoveryProtocol;
import java.util.Arrays;
import java.util.UUID;

public class TrustEstablishmentWithSasProtocol
extends ConcreteProtocol {
    static final int WAITING_FOR_SEED_STATE_ID = 1;
    static final int WAITING_FOR_CONFIRMATION_STATE_ID = 2;
    static final int CANCELLED_STATE_ID = 3;
    static final int WAITING_FOR_DECOMMITMENT_STATE_ID = 4;
    static final int WAITING_FOR_USER_SAS_STATE_ID = 5;
    static final int CONTACT_IDENTITY_TRUSTED_LEGACY_STATE_ID = 6;
    static final int MUTUAL_TRUST_CONFIRMED_STATE_ID = 7;
    static final int CONTACT_SAS_CHECKED_STATE_ID = 8;
    static final int INITIAL_MESSAGE_ID = 0;
    static final int SEND_COMMITMENT_MESSAGE_ID = 1;
    static final int PROPAGATE_INVITATION_TO_ALICE_DEVICES_MESSAGE_ID = 2;
    static final int PROPAGATE_COMMITMENT_TO_BOB_DEVICES_MESSAGE_ID = 4;
    static final int BOB_DIALOG_INVITATION_CONFIRMATION_MESSAGE_ID = 5;
    static final int PROPAGATE_CONFIRMATION_TO_BOB_DEVICES_MESSAGE_ID = 6;
    static final int SEND_BOB_SEED_MESSAGE_ID = 8;
    static final int SEND_DECOMMITMENT_MESSAGE_ID = 9;
    static final int DIALOG_FOR_SAS_EXCHANGE_MESSAGE_ID = 10;
    static final int PROPAGATE_ENTERED_SAS_TO_OTHER_DEVICES_MESSAGE_ID = 12;
    static final int MUTUAL_TRUST_CONFIRMATION_MESSAGE_ID = 13;

    public TrustEstablishmentWithSasProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 11;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{3, 7};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return WaitingForSeedState.class;
            }
            case 2: {
                return WaitingForConfirmationState.class;
            }
            case 3: {
                return CancelledState.class;
            }
            case 4: {
                return WaitingForDecommitmentState.class;
            }
            case 5: {
                return WaitingForUserSasState.class;
            }
            case 6: {
                return ContactIdentityTrustedLegacyState.class;
            }
            case 7: {
                return MutualTrustConfirmedState.class;
            }
            case 8: {
                return ContactSasCheckedState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return SendCommitmentMessage.class;
            }
            case 2: {
                return PropagateInvitationToAliceDevicesMessage.class;
            }
            case 4: {
                return PropagateCommitmentToBobDevicesMessage.class;
            }
            case 5: {
                return BobDialogInvitationConfirmationMessage.class;
            }
            case 6: {
                return PropagateConfirmationToBobDevicesMessage.class;
            }
            case 8: {
                return SendBobSeedMessage.class;
            }
            case 9: {
                return SendDecommitmentMessage.class;
            }
            case 10: {
                return DialogForSasExchangeMessage.class;
            }
            case 12: {
                return PropagateEnteredSasToOtherDevicesMessage.class;
            }
            case 13: {
                return MutualTrustConfirmationMessage.class;
            }
        }
        return null;
    }

    @Override
    public Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{SendCommitmentStep.class, StoreDecommitmentStep.class, StoreAndPropagateCommitmentAndAskForConfirmationStep.class, StoreCommitmentAndAskForConfirmationStep.class};
            }
            case 2: {
                return new Class[]{SendSeedAndPropagateConfirmationStep.class, ReceivedConfirmationFromOtherDeviceStep.class};
            }
            case 1: {
                return new Class[]{ShowSasDialogAndSendDecommitmentStep.class};
            }
            case 4: {
                return new Class[]{ShowSasDialogStep.class};
            }
            case 5: {
                return new Class[]{CheckPropagatedSasStep.class, CheckSasStep.class};
            }
            case 6: {
                return new Class[]{NotifiedMutualTrustEstablishedLegacyStep.class};
            }
            case 8: {
                return new Class[]{AddTrustStep.class};
            }
        }
        return new Class[0];
    }

    public static class WaitingForSeedState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final byte[] decommitment;
        private final Seed seedAliceForSas;
        private final UUID dialogUuid;

        public WaitingForSeedState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 4) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.decommitment = list[1].decodeBytes();
            this.seedAliceForSas = list[2].decodeSeed();
            this.dialogUuid = list[3].decodeUuid();
        }

        WaitingForSeedState(Identity contactIdentity, byte[] decommitment, Seed seedAliceForSas, UUID dialogUuid) {
            super(1);
            this.contactIdentity = contactIdentity;
            this.decommitment = decommitment;
            this.seedAliceForSas = seedAliceForSas;
            this.dialogUuid = dialogUuid;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.decommitment), Encoded.of(this.seedAliceForSas), Encoded.of(this.dialogUuid)});
        }
    }

    public static class WaitingForConfirmationState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final String contactSerializedDetails;
        private final UID[] contactDeviceUids;
        private final byte[] commitment;
        private final UUID dialogUuid;

        public WaitingForConfirmationState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 5) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.contactSerializedDetails = list[1].decodeString();
            this.contactDeviceUids = list[2].decodeUidArray();
            this.commitment = list[3].decodeBytes();
            this.dialogUuid = list[4].decodeUuid();
        }

        WaitingForConfirmationState(Identity contactIdentity, String contactSerializedDetails, UID[] contactDeviceUids, byte[] commitment, UUID dialogUuid) {
            super(2);
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
            this.contactDeviceUids = contactDeviceUids;
            this.commitment = commitment;
            this.dialogUuid = dialogUuid;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails), Encoded.of(this.contactDeviceUids), Encoded.of(this.commitment), Encoded.of(this.dialogUuid)});
        }
    }

    public static class CancelledState
    extends ConcreteProtocolState {
        public CancelledState(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        CancelledState() {
            super(3);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class WaitingForDecommitmentState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final String contactSerializedDetails;
        private final UID[] contactDeviceUids;
        private final byte[] commitment;
        private final Seed seedBobForSas;
        private final UUID dialogUuid;

        public WaitingForDecommitmentState(Encoded encodedState) throws Exception {
            super(4);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 6) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.contactSerializedDetails = list[1].decodeString();
            this.contactDeviceUids = list[2].decodeUidArray();
            this.commitment = list[3].decodeBytes();
            this.seedBobForSas = list[4].decodeSeed();
            this.dialogUuid = list[5].decodeUuid();
        }

        WaitingForDecommitmentState(Identity contactIdentity, String contactSerializedDetails, UID[] contactDeviceUids, byte[] commitment, Seed seedBobForSas, UUID dialogUuid) {
            super(4);
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
            this.contactDeviceUids = contactDeviceUids;
            this.commitment = commitment;
            this.seedBobForSas = seedBobForSas;
            this.dialogUuid = dialogUuid;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails), Encoded.of(this.contactDeviceUids), Encoded.of(this.commitment), Encoded.of(this.seedBobForSas), Encoded.of(this.dialogUuid)});
        }
    }

    public static class WaitingForUserSasState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final String contactSerializedDetails;
        private final UID[] contactDeviceUids;
        private final Seed seedForSas;
        private final Seed contactSeedForSas;
        private final UUID dialogUuid;
        private final boolean isAlice;

        public WaitingForUserSasState(Encoded encodedState) throws Exception {
            super(5);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 7) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.contactSerializedDetails = list[1].decodeString();
            this.contactDeviceUids = list[2].decodeUidArray();
            this.seedForSas = list[3].decodeSeed();
            this.contactSeedForSas = list[4].decodeSeed();
            this.dialogUuid = list[5].decodeUuid();
            this.isAlice = list[6].decodeBoolean();
        }

        WaitingForUserSasState(Identity contactIdentity, String contactSerializedDetails, UID[] contactDeviceUids, Seed seedForSas, Seed contactSeedForSas, UUID dialogUuid, boolean isAlice) {
            super(5);
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
            this.contactDeviceUids = contactDeviceUids;
            this.seedForSas = seedForSas;
            this.contactSeedForSas = contactSeedForSas;
            this.dialogUuid = dialogUuid;
            this.isAlice = isAlice;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails), Encoded.of(this.contactDeviceUids), Encoded.of(this.seedForSas), Encoded.of(this.contactSeedForSas), Encoded.of(this.dialogUuid), Encoded.of(this.isAlice)});
        }
    }

    public static class ContactIdentityTrustedLegacyState
    extends ConcreteProtocolState {
        private final String contactSerializedDetails;
        private final Identity contactIdentity;
        private final UUID dialogUuid;

        public ContactIdentityTrustedLegacyState(Encoded encodedState) throws Exception {
            super(6);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 3) {
                throw new Exception();
            }
            this.contactSerializedDetails = list[0].decodeString();
            this.contactIdentity = list[1].decodeIdentity();
            this.dialogUuid = list[2].decodeUuid();
        }

        ContactIdentityTrustedLegacyState(String contactSerializedDetails, Identity contactIdentity, UUID dialogUuid) {
            super(6);
            Logger.e("Error: ContactIdentityTrustedLegacyState called and is deprecated.");
            this.contactSerializedDetails = contactSerializedDetails;
            this.contactIdentity = contactIdentity;
            this.dialogUuid = dialogUuid;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactSerializedDetails), Encoded.of(this.contactIdentity), Encoded.of(this.dialogUuid)});
        }
    }

    public static class MutualTrustConfirmedState
    extends ConcreteProtocolState {
        public MutualTrustConfirmedState(Encoded encodedState) throws Exception {
            super(7);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        MutualTrustConfirmedState() {
            super(7);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class ContactSasCheckedState
    extends ConcreteProtocolState {
        private final String contactSerializedDetails;
        private final Identity contactIdentity;
        private final UUID dialogUuid;
        private final UID[] contactDeviceUids;

        public ContactSasCheckedState(Encoded encodedState) throws Exception {
            super(8);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 4) {
                throw new Exception();
            }
            this.contactSerializedDetails = list[0].decodeString();
            this.contactIdentity = list[1].decodeIdentity();
            this.dialogUuid = list[2].decodeUuid();
            this.contactDeviceUids = list[3].decodeUidArray();
        }

        ContactSasCheckedState(String contactSerializedDetails, Identity contactIdentity, UUID dialogUuid, UID[] contactDeviceUids) {
            super(8);
            this.contactSerializedDetails = contactSerializedDetails;
            this.contactIdentity = contactIdentity;
            this.dialogUuid = dialogUuid;
            this.contactDeviceUids = contactDeviceUids;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactSerializedDetails), Encoded.of(this.contactIdentity), Encoded.of(this.dialogUuid), Encoded.of(this.contactDeviceUids)});
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final String contactDisplayName;
        private final String ownSerializedDetails;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, String contactDisplayName, String ownSerializedDetails) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.contactDisplayName = contactDisplayName;
            this.ownSerializedDetails = ownSerializedDetails;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 3) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.contactDisplayName = receivedMessage.getInputs()[1].decodeString();
            this.ownSerializedDetails = receivedMessage.getInputs()[2].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactDisplayName), Encoded.of(this.ownSerializedDetails)};
        }
    }

    public static class SendCommitmentMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final String contactSerializedDetails;
        private final UID[] contactDeviceUids;
        private final byte[] commitment;

        SendCommitmentMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, String contactSerializedDetails, UID[] contactDeviceUids, byte[] commitment) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
            this.contactDeviceUids = contactDeviceUids;
            this.commitment = commitment;
        }

        public SendCommitmentMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 4) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.contactSerializedDetails = receivedMessage.getInputs()[1].decodeString();
            this.contactDeviceUids = receivedMessage.getInputs()[2].decodeUidArray();
            this.commitment = receivedMessage.getInputs()[3].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails), Encoded.of(this.contactDeviceUids), Encoded.of(this.commitment)};
        }
    }

    public static class PropagateInvitationToAliceDevicesMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final String contactDisplayName;
        private final byte[] decommitment;
        private final Seed seedAliceForSas;

        PropagateInvitationToAliceDevicesMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, String contactDisplayName, byte[] decommitment, Seed seedAliceForSas) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.contactDisplayName = contactDisplayName;
            this.decommitment = decommitment;
            this.seedAliceForSas = seedAliceForSas;
        }

        public PropagateInvitationToAliceDevicesMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 4) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.contactDisplayName = receivedMessage.getInputs()[1].decodeString();
            this.decommitment = receivedMessage.getInputs()[2].decodeBytes();
            this.seedAliceForSas = receivedMessage.getInputs()[3].decodeSeed();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactDisplayName), Encoded.of(this.decommitment), Encoded.of(this.seedAliceForSas)};
        }
    }

    public static class PropagateCommitmentToBobDevicesMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final String contactSerializedDetails;
        private final UID[] contactDeviceUids;
        private final byte[] commitment;

        PropagateCommitmentToBobDevicesMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, String contactSerializedDetails, UID[] contactDeviceUids, byte[] commitment) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
            this.contactDeviceUids = contactDeviceUids;
            this.commitment = commitment;
        }

        public PropagateCommitmentToBobDevicesMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 4) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.contactSerializedDetails = receivedMessage.getInputs()[1].decodeString();
            this.contactDeviceUids = receivedMessage.getInputs()[2].decodeUidArray();
            this.commitment = receivedMessage.getInputs()[3].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails), Encoded.of(this.contactDeviceUids), Encoded.of(this.commitment)};
        }
    }

    public static class BobDialogInvitationConfirmationMessage
    extends ConcreteProtocolMessage {
        private final boolean invitationAccepted;
        private final UUID dialogUuid;

        BobDialogInvitationConfirmationMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.invitationAccepted = false;
            this.dialogUuid = null;
        }

        public BobDialogInvitationConfirmationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                throw new Exception();
            }
            this.invitationAccepted = receivedMessage.getEncodedResponse().decodeBoolean();
            this.dialogUuid = receivedMessage.getUserDialogUuid();
        }

        @Override
        public int getProtocolMessageId() {
            return 5;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class PropagateConfirmationToBobDevicesMessage
    extends ConcreteProtocolMessage {
        private final boolean invitationAccepted;

        PropagateConfirmationToBobDevicesMessage(CoreProtocolMessage coreProtocolMessage, boolean invitationAccepted) {
            super(coreProtocolMessage);
            this.invitationAccepted = invitationAccepted;
        }

        public PropagateConfirmationToBobDevicesMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.invitationAccepted = receivedMessage.getInputs()[0].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 6;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.invitationAccepted)};
        }
    }

    public static class SendBobSeedMessage
    extends ConcreteProtocolMessage {
        private final Seed seedBobForSas;
        private final UID[] contactDeviceUids;
        private final String contactSerializedDetails;

        SendBobSeedMessage(CoreProtocolMessage coreProtocolMessage, Seed seedBobForSas, UID[] contactDeviceUids, String contactSerializedDetails) {
            super(coreProtocolMessage);
            this.seedBobForSas = seedBobForSas;
            this.contactDeviceUids = contactDeviceUids;
            this.contactSerializedDetails = contactSerializedDetails;
        }

        public SendBobSeedMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 3) {
                throw new Exception();
            }
            this.seedBobForSas = receivedMessage.getInputs()[0].decodeSeed();
            this.contactDeviceUids = receivedMessage.getInputs()[1].decodeUidArray();
            this.contactSerializedDetails = receivedMessage.getInputs()[2].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 8;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.seedBobForSas), Encoded.of(this.contactDeviceUids), Encoded.of(this.contactSerializedDetails)};
        }
    }

    public static class SendDecommitmentMessage
    extends ConcreteProtocolMessage {
        private final byte[] decommitment;

        SendDecommitmentMessage(CoreProtocolMessage coreProtocolMessage, byte[] decommitment) {
            super(coreProtocolMessage);
            this.decommitment = decommitment;
        }

        public SendDecommitmentMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.decommitment = receivedMessage.getInputs()[0].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 9;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.decommitment)};
        }
    }

    public static class DialogForSasExchangeMessage
    extends ConcreteProtocolMessage {
        private final byte[] sasEnteredByUser;
        private final UUID userDialogUuid;

        DialogForSasExchangeMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.sasEnteredByUser = null;
            this.userDialogUuid = null;
        }

        public DialogForSasExchangeMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                throw new Exception();
            }
            this.sasEnteredByUser = receivedMessage.getEncodedResponse().decodeBytes();
            this.userDialogUuid = receivedMessage.getUserDialogUuid();
        }

        @Override
        public int getProtocolMessageId() {
            return 10;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class PropagateEnteredSasToOtherDevicesMessage
    extends ConcreteProtocolMessage {
        private final byte[] sasEnteredByUser;

        PropagateEnteredSasToOtherDevicesMessage(CoreProtocolMessage coreProtocolMessage, byte[] sasEnteredByUser) {
            super(coreProtocolMessage);
            this.sasEnteredByUser = sasEnteredByUser;
        }

        public PropagateEnteredSasToOtherDevicesMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.sasEnteredByUser = receivedMessage.getInputs()[0].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 12;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.sasEnteredByUser)};
        }
    }

    public static class MutualTrustConfirmationMessage
    extends ConcreteProtocolMessage {
        MutualTrustConfirmationMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public MutualTrustConfirmationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 13;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class SendCommitmentStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public SendCommitmentStep(InitialProtocolState startState, InitialMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UID[] ownedDeviceUids = protocolManagerSession.identityDelegate.getDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            UUID dialogUuid = UUID.randomUUID();
            Seed seedAliceForSas = new Seed(this.getPrng());
            Commitment commitmentScheme = Suite.getDefaultCommitment(0);
            Commitment.CommitmentOutput commitmentOutput = commitmentScheme.commit(this.getOwnedIdentity().getBytes(), seedAliceForSas.getBytes(), this.getPrng());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createInviteSentDialog(this.receivedMessage.contactDisplayName, this.receivedMessage.contactIdentity), dialogUuid));
            ChannelMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend2 = new PropagateInvitationToAliceDevicesMessage(coreProtocolMessage2, this.receivedMessage.contactIdentity, this.receivedMessage.contactDisplayName, commitmentOutput.decommitment, seedAliceForSas).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage2) {
                    // empty catch block
                }
            }
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity()));
            messageToSend = new SendCommitmentMessage(coreProtocolMessage, this.getOwnedIdentity(), this.receivedMessage.ownSerializedDetails, ownedDeviceUids, commitmentOutput.commitment).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitingForSeedState(this.receivedMessage.contactIdentity, commitmentOutput.decommitment, seedAliceForSas, dialogUuid);
        }
    }

    public static class StoreDecommitmentStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagateInvitationToAliceDevicesMessage receivedMessage;

        public StoreDecommitmentStep(InitialProtocolState startState, PropagateInvitationToAliceDevicesMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UUID dialogUuid = UUID.randomUUID();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createInviteSentDialog(this.receivedMessage.contactDisplayName, this.receivedMessage.contactIdentity), dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitingForSeedState(this.receivedMessage.contactIdentity, this.receivedMessage.decommitment, this.receivedMessage.seedAliceForSas, dialogUuid);
        }
    }

    public static class StoreAndPropagateCommitmentAndAskForConfirmationStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final SendCommitmentMessage receivedMessage;

        public StoreAndPropagateCommitmentAndAskForConfirmationStep(InitialProtocolState startState, SendCommitmentMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (TrustEstablishmentCommitmentReceived.exists(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.commitment)) {
                return new CancelledState();
            }
            TrustEstablishmentCommitmentReceived.create(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.commitment);
            UUID dialogUuid = UUID.randomUUID();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createAcceptInviteDialog(this.receivedMessage.contactSerializedDetails, this.receivedMessage.contactIdentity, this.receivedMessage.getServerTimestamp()), dialogUuid));
            ChannelDialogMessageToSend messageToSend = new BobDialogInvitationConfirmationMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend2 = new PropagateCommitmentToBobDevicesMessage(coreProtocolMessage2, this.receivedMessage.contactIdentity, this.receivedMessage.contactSerializedDetails, this.receivedMessage.contactDeviceUids, this.receivedMessage.commitment).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new WaitingForConfirmationState(this.receivedMessage.contactIdentity, this.receivedMessage.contactSerializedDetails, this.receivedMessage.contactDeviceUids, this.receivedMessage.commitment, dialogUuid);
        }
    }

    public static class StoreCommitmentAndAskForConfirmationStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagateCommitmentToBobDevicesMessage receivedMessage;

        public StoreCommitmentAndAskForConfirmationStep(InitialProtocolState startState, PropagateCommitmentToBobDevicesMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (TrustEstablishmentCommitmentReceived.exists(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.commitment)) {
                return new CancelledState();
            }
            TrustEstablishmentCommitmentReceived.create(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.commitment);
            UUID dialogUuid = UUID.randomUUID();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createAcceptInviteDialog(this.receivedMessage.contactSerializedDetails, this.receivedMessage.contactIdentity, this.receivedMessage.getServerTimestamp()), dialogUuid));
            ChannelDialogMessageToSend messageToSend = new BobDialogInvitationConfirmationMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitingForConfirmationState(this.receivedMessage.contactIdentity, this.receivedMessage.contactSerializedDetails, this.receivedMessage.contactDeviceUids, this.receivedMessage.commitment, dialogUuid);
        }
    }

    public static class SendSeedAndPropagateConfirmationStep
    extends ProtocolStep {
        private final WaitingForConfirmationState startState;
        private final BobDialogInvitationConfirmationMessage receivedMessage;

        public SendSeedAndPropagateConfirmationStep(WaitingForConfirmationState startState, BobDialogInvitationConfirmationMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ChannelDialogMessageToSend messageToSend;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.startState.dialogUuid.equals(this.receivedMessage.dialogUuid)) {
                Logger.e("ObvDialog uuid mismatch in BobDialogInvitationConfirmationMessage.");
                return null;
            }
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend2 = new PropagateConfirmationToBobDevicesMessage(coreProtocolMessage, this.receivedMessage.invitationAccepted).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            if (!this.receivedMessage.invitationAccepted) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
                messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new CancelledState();
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createInviteAcceptedDialog(this.startState.contactSerializedDetails, this.startState.contactIdentity), this.startState.dialogUuid));
            messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            Seed seedBobForSas = protocolManagerSession.identityDelegate.getDeterministicSeedForOwnedIdentity(this.getOwnedIdentity(), this.startState.commitment, IdentityDelegate.DeterministicSeedContext.COMPUTE_SAS);
            UID[] ownedDeviceUids = protocolManagerSession.identityDelegate.getDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            String ownSerializedDetails = protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.startState.contactIdentity, this.getOwnedIdentity(), this.startState.contactDeviceUids));
            ChannelProtocolMessageToSend messageToSend3 = new SendBobSeedMessage(coreProtocolMessage2, seedBobForSas, ownedDeviceUids, ownSerializedDetails).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend3, this.getPrng());
            return new WaitingForDecommitmentState(this.startState.contactIdentity, this.startState.contactSerializedDetails, this.startState.contactDeviceUids, this.startState.commitment, seedBobForSas, this.startState.dialogUuid);
        }
    }

    public static class ReceivedConfirmationFromOtherDeviceStep
    extends ProtocolStep {
        private final WaitingForConfirmationState startState;
        private final PropagateConfirmationToBobDevicesMessage receivedMessage;

        public ReceivedConfirmationFromOtherDeviceStep(WaitingForConfirmationState startState, PropagateConfirmationToBobDevicesMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.invitationAccepted) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
                ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new CancelledState();
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createInviteAcceptedDialog(this.startState.contactSerializedDetails, this.startState.contactIdentity), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            Seed seedBobForSas = protocolManagerSession.identityDelegate.getDeterministicSeedForOwnedIdentity(this.getOwnedIdentity(), this.startState.commitment, IdentityDelegate.DeterministicSeedContext.COMPUTE_SAS);
            return new WaitingForDecommitmentState(this.startState.contactIdentity, this.startState.contactSerializedDetails, this.startState.contactDeviceUids, this.startState.commitment, seedBobForSas, this.startState.dialogUuid);
        }
    }

    public static class ShowSasDialogAndSendDecommitmentStep
    extends ProtocolStep {
        private final WaitingForSeedState startState;
        private final SendBobSeedMessage receivedMessage;

        public ShowSasDialogAndSendDecommitmentStep(WaitingForSeedState startState, SendBobSeedMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.startState.contactIdentity, this.getOwnedIdentity(), this.receivedMessage.contactDeviceUids));
            ChannelProtocolMessageToSend messageToSend = new SendDecommitmentMessage(coreProtocolMessage, this.startState.decommitment).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            byte[] fullSas = SAS.computeDouble(this.startState.seedAliceForSas, this.receivedMessage.seedBobForSas, this.startState.contactIdentity, 4);
            byte[] sasToDisplay = Arrays.copyOfRange(fullSas, 0, 4);
            CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createSasExchangeDialog(this.receivedMessage.contactSerializedDetails, this.startState.contactIdentity, sasToDisplay, this.receivedMessage.getServerTimestamp()), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend2 = new DialogForSasExchangeMessage(coreProtocolMessage2).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
            return new WaitingForUserSasState(this.startState.contactIdentity, this.receivedMessage.contactSerializedDetails, this.receivedMessage.contactDeviceUids, this.startState.seedAliceForSas, this.receivedMessage.seedBobForSas, this.startState.dialogUuid, true);
        }
    }

    public static class ShowSasDialogStep
    extends ProtocolStep {
        private final WaitingForDecommitmentState startState;
        private final SendDecommitmentMessage receivedMessage;

        public ShowSasDialogStep(WaitingForDecommitmentState startState, SendDecommitmentMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            Commitment commitmentScheme = Suite.getDefaultCommitment(0);
            byte[] opened = commitmentScheme.open(this.startState.contactIdentity.getBytes(), this.startState.commitment, this.receivedMessage.decommitment);
            if (opened == null) {
                Logger.e("Unable to open commitment.");
                return null;
            }
            Seed contactSeedForSas = new Seed(opened);
            byte[] fullSas = SAS.computeDouble(contactSeedForSas, this.startState.seedBobForSas, this.getOwnedIdentity(), 4);
            byte[] sasToDisplay = Arrays.copyOfRange(fullSas, 4, 8);
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createSasExchangeDialog(this.startState.contactSerializedDetails, this.startState.contactIdentity, sasToDisplay, this.receivedMessage.getServerTimestamp()), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new DialogForSasExchangeMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitingForUserSasState(this.startState.contactIdentity, this.startState.contactSerializedDetails, this.startState.contactDeviceUids, this.startState.seedBobForSas, contactSeedForSas, this.startState.dialogUuid, false);
        }
    }

    public static class CheckPropagatedSasStep
    extends ProtocolStep {
        private final WaitingForUserSasState startState;
        private final PropagateEnteredSasToOtherDevicesMessage receivedMessage;

        public CheckPropagatedSasStep(WaitingForUserSasState startState, PropagateEnteredSasToOtherDevicesMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            CoreProtocolMessage coreProtocolMessage;
            byte[] computedSas;
            byte[] sasToDisplay;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.startState.isAlice) {
                fullSas = SAS.computeDouble(this.startState.seedForSas, this.startState.contactSeedForSas, this.startState.contactIdentity, 4);
                sasToDisplay = Arrays.copyOfRange(fullSas, 0, 4);
                computedSas = Arrays.copyOfRange(fullSas, 4, 8);
            } else {
                fullSas = SAS.computeDouble(this.startState.contactSeedForSas, this.startState.seedForSas, this.getOwnedIdentity(), 4);
                sasToDisplay = Arrays.copyOfRange(fullSas, 4, 8);
                computedSas = Arrays.copyOfRange(fullSas, 0, 4);
            }
            if (!Arrays.equals(computedSas, this.receivedMessage.sasEnteredByUser)) {
                Logger.e("The propagated SAS does not match the computed SAS.");
                coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
                ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new CancelledState();
            }
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createSasConfirmedDialog(this.startState.contactSerializedDetails, this.startState.contactIdentity, sasToDisplay, this.receivedMessage.sasEnteredByUser), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new ContactSasCheckedState(this.startState.contactSerializedDetails, this.startState.contactIdentity, this.startState.dialogUuid, this.startState.contactDeviceUids);
        }
    }

    public static class CheckSasStep
    extends ProtocolStep {
        private final WaitingForUserSasState startState;
        private final DialogForSasExchangeMessage receivedMessage;

        public CheckSasStep(WaitingForUserSasState startState, DialogForSasExchangeMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            byte[] computedSas;
            byte[] sasToDisplay;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.startState.dialogUuid.equals(this.receivedMessage.userDialogUuid)) {
                Logger.e("ObvDialog uuid mismatch in DialogForSasExchangeMessage.");
                return null;
            }
            if (this.startState.isAlice) {
                fullSas = SAS.computeDouble(this.startState.seedForSas, this.startState.contactSeedForSas, this.startState.contactIdentity, 4);
                sasToDisplay = Arrays.copyOfRange(fullSas, 0, 4);
                computedSas = Arrays.copyOfRange(fullSas, 4, 8);
            } else {
                fullSas = SAS.computeDouble(this.startState.contactSeedForSas, this.startState.seedForSas, this.getOwnedIdentity(), 4);
                sasToDisplay = Arrays.copyOfRange(fullSas, 4, 8);
                computedSas = Arrays.copyOfRange(fullSas, 0, 4);
            }
            if (!Arrays.equals(computedSas, this.receivedMessage.sasEnteredByUser)) {
                Logger.d("The SAS entered by the user does not match the computed SAS.");
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createSasExchangeDialog(this.startState.contactSerializedDetails, this.startState.contactIdentity, sasToDisplay, System.currentTimeMillis()), this.startState.dialogUuid));
                ChannelDialogMessageToSend messageToSend = new DialogForSasExchangeMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return this.startState;
            }
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagateEnteredSasToOtherDevicesMessage(coreProtocolMessage, this.receivedMessage.sasEnteredByUser).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createSasConfirmedDialog(this.startState.contactSerializedDetails, this.startState.contactIdentity, sasToDisplay, this.receivedMessage.sasEnteredByUser), this.startState.dialogUuid));
            ChannelMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.startState.contactIdentity, this.getOwnedIdentity(), this.startState.contactDeviceUids));
            messageToSend = new MutualTrustConfirmationMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new ContactSasCheckedState(this.startState.contactSerializedDetails, this.startState.contactIdentity, this.startState.dialogUuid, this.startState.contactDeviceUids);
        }
    }

    public static class NotifiedMutualTrustEstablishedLegacyStep
    extends ProtocolStep {
        private final ContactIdentityTrustedLegacyState startState;
        private final MutualTrustConfirmationMessage receivedMessage;

        public NotifiedMutualTrustEstablishedLegacyStep(ContactIdentityTrustedLegacyState startState, MutualTrustConfirmationMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new MutualTrustConfirmedState();
        }
    }

    public static class AddTrustStep
    extends ProtocolStep {
        private final ContactSasCheckedState startState;
        private final MutualTrustConfirmationMessage receivedMessage;

        public AddTrustStep(ContactSasCheckedState startState, MutualTrustConfirmationMessage receivedMessage, TrustEstablishmentWithSasProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            CoreProtocolMessage coreProtocolMessage;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!protocolManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity)) {
                protocolManagerSession.identityDelegate.addContactIdentity(protocolManagerSession.session, this.startState.contactIdentity, this.startState.contactSerializedDetails, this.getOwnedIdentity(), TrustOrigin.createDirectTrustOrigin(System.currentTimeMillis()), true);
            } else {
                protocolManagerSession.identityDelegate.addTrustOriginToContact(protocolManagerSession.session, this.startState.contactIdentity, this.getOwnedIdentity(), TrustOrigin.createDirectTrustOrigin(System.currentTimeMillis()), true);
            }
            boolean triggerDeviceDiscovery = false;
            for (UID contactDeviceUid : this.startState.contactDeviceUids) {
                triggerDeviceDiscovery |= protocolManagerSession.identityDelegate.addDeviceForContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity, contactDeviceUid, null, false);
            }
            if (triggerDeviceDiscovery) {
                coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 0, new UID(this.getPrng()));
                ChannelProtocolMessageToSend messageToSend = new DeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage, this.startState.contactIdentity).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new MutualTrustConfirmedState();
        }
    }
}

