/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.TrustOrigin;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.databases.MutualScanSignatureReceived;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.DeviceDiscoveryProtocol;
import java.util.HashMap;

public class TrustEstablishmentWithMutualScanProtocol
extends ConcreteProtocol {
    public static final int WAITING_FOR_CONFIRMATION_STATE_ID = 1;
    public static final int FINISHED_STATE_ID = 2;
    public static final int INITIAL_MESSAGE_ID = 0;
    public static final int ALICE_SENDS_SIGNATURE_TO_BOB_MESSAGE_ID = 1;
    public static final int ALICE_PROPAGATES_QR_CODE_MESSAGE_ID = 2;
    public static final int BOB_SENDS_CONFIRMATION_AND_DETAILS_TO_ALICE_MESSAGE_ID = 3;
    public static final int BOB_PROPAGATES_SIGNATURE_MESSAGE_ID = 4;

    public TrustEstablishmentWithMutualScanProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 12;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{2};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return WaitingForConfirmationState.class;
            }
            case 2: {
                return FinishedState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return AliceSendsSignatureToBobMessage.class;
            }
            case 2: {
                return AlicePropagatesQrCodeMessage.class;
            }
            case 3: {
                return BobSendsConfirmationAndDetailsToAliceMessage.class;
            }
            case 4: {
                return BobPropagatesSignatureMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{AliceSendStep.class, AliceHandlesPropagatedQRCodeStep.class, BobAddsContactAndConfirmsStep.class, BobHandlesPropagatedSignatureStep.class};
            }
            case 1: {
                return new Class[]{AliceAddsContactStep.class};
            }
        }
        return new Class[0];
    }

    public static class WaitingForConfirmationState
    extends ConcreteProtocolState {
        private final Identity bobIdentity;

        public WaitingForConfirmationState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 1) {
                throw new Exception();
            }
            this.bobIdentity = list[0].decodeIdentity();
        }

        public WaitingForConfirmationState(Identity bobIdentity) {
            super(1);
            this.bobIdentity = bobIdentity;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.bobIdentity)});
        }
    }

    public static class FinishedState
    extends ConcreteProtocolState {
        public FinishedState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public FinishedState() {
            super(2);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final byte[] signature;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, byte[] signature) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.signature = signature;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.signature = receivedMessage.getInputs()[1].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.signature)};
        }
    }

    public static class AliceSendsSignatureToBobMessage
    extends ConcreteProtocolMessage {
        private final Identity aliceIdentity;
        private final byte[] signature;
        private final String serializedAliceDetails;
        private final UID[] aliceDeviceUids;

        public AliceSendsSignatureToBobMessage(CoreProtocolMessage coreProtocolMessage, Identity aliceIdentity, byte[] signature, String serializedAliceDetails, UID[] aliceDeviceUids) {
            super(coreProtocolMessage);
            this.aliceIdentity = aliceIdentity;
            this.signature = signature;
            this.serializedAliceDetails = serializedAliceDetails;
            this.aliceDeviceUids = aliceDeviceUids;
        }

        public AliceSendsSignatureToBobMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 4) {
                throw new Exception();
            }
            this.aliceIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.signature = receivedMessage.getInputs()[1].decodeBytes();
            this.serializedAliceDetails = receivedMessage.getInputs()[2].decodeString();
            this.aliceDeviceUids = receivedMessage.getInputs()[3].decodeUidArray();
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.aliceIdentity), Encoded.of(this.signature), Encoded.of(this.serializedAliceDetails), Encoded.of(this.aliceDeviceUids)};
        }
    }

    public static class AlicePropagatesQrCodeMessage
    extends ConcreteProtocolMessage {
        private final Identity bobIdentity;
        private final byte[] signature;

        public AlicePropagatesQrCodeMessage(CoreProtocolMessage coreProtocolMessage, Identity bobIdentity, byte[] signature) {
            super(coreProtocolMessage);
            this.bobIdentity = bobIdentity;
            this.signature = signature;
        }

        public AlicePropagatesQrCodeMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.bobIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.signature = receivedMessage.getInputs()[1].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.bobIdentity), Encoded.of(this.signature)};
        }
    }

    public static class BobSendsConfirmationAndDetailsToAliceMessage
    extends ConcreteProtocolMessage {
        private final String serializedBobDetails;
        private final UID[] bobDeviceUids;

        public BobSendsConfirmationAndDetailsToAliceMessage(CoreProtocolMessage coreProtocolMessage, String serializedBobDetails, UID[] bobDeviceUids) {
            super(coreProtocolMessage);
            this.serializedBobDetails = serializedBobDetails;
            this.bobDeviceUids = bobDeviceUids;
        }

        public BobSendsConfirmationAndDetailsToAliceMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.serializedBobDetails = receivedMessage.getInputs()[0].decodeString();
            this.bobDeviceUids = receivedMessage.getInputs()[1].decodeUidArray();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.serializedBobDetails), Encoded.of(this.bobDeviceUids)};
        }
    }

    public static class BobPropagatesSignatureMessage
    extends ConcreteProtocolMessage {
        private final Identity aliceIdentity;
        private final byte[] signature;
        private final String serializedAliceDetails;
        private final UID[] aliceDeviceUids;

        public BobPropagatesSignatureMessage(CoreProtocolMessage coreProtocolMessage, Identity aliceIdentity, byte[] signature, String serializedAliceDetails, UID[] aliceDeviceUids) {
            super(coreProtocolMessage);
            this.aliceIdentity = aliceIdentity;
            this.signature = signature;
            this.serializedAliceDetails = serializedAliceDetails;
            this.aliceDeviceUids = aliceDeviceUids;
        }

        public BobPropagatesSignatureMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 4) {
                throw new Exception();
            }
            this.aliceIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.signature = receivedMessage.getInputs()[1].decodeBytes();
            this.serializedAliceDetails = receivedMessage.getInputs()[2].decodeString();
            this.aliceDeviceUids = receivedMessage.getInputs()[3].decodeUidArray();
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.aliceIdentity), Encoded.of(this.signature), Encoded.of(this.serializedAliceDetails), Encoded.of(this.aliceDeviceUids)};
        }
    }

    public static class AliceSendStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public AliceSendStep(InitialProtocolState startState, InitialMessage receivedMessage, TrustEstablishmentWithMutualScanProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!Signature.verify(Constants.SignatureContext.MUTUAL_SCAN, new Identity[]{this.getOwnedIdentity(), this.receivedMessage.contactIdentity}, this.receivedMessage.contactIdentity, this.receivedMessage.signature)) {
                return new FinishedState();
            }
            UID[] deviceUids = protocolManagerSession.identityDelegate.getDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            String serializedAliceDetails = protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity()));
            ChannelProtocolMessageToSend messageToSend = new AliceSendsSignatureToBobMessage(coreProtocolMessage, this.getOwnedIdentity(), this.receivedMessage.signature, serializedAliceDetails, deviceUids).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend2 = new AlicePropagatesQrCodeMessage(coreProtocolMessage2, this.receivedMessage.contactIdentity, this.receivedMessage.signature).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new WaitingForConfirmationState(this.receivedMessage.contactIdentity);
        }
    }

    public static class AliceHandlesPropagatedQRCodeStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final AlicePropagatesQrCodeMessage receivedMessage;

        public AliceHandlesPropagatedQRCodeStep(InitialProtocolState startState, AlicePropagatesQrCodeMessage receivedMessage, TrustEstablishmentWithMutualScanProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            if (!Signature.verify(Constants.SignatureContext.MUTUAL_SCAN, new Identity[]{this.getOwnedIdentity(), this.receivedMessage.bobIdentity}, this.receivedMessage.bobIdentity, this.receivedMessage.signature)) {
                return new FinishedState();
            }
            return new WaitingForConfirmationState(this.receivedMessage.bobIdentity);
        }
    }

    public static class BobAddsContactAndConfirmsStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final AliceSendsSignatureToBobMessage receivedMessage;

        public BobAddsContactAndConfirmsStep(InitialProtocolState startState, AliceSendsSignatureToBobMessage receivedMessage, TrustEstablishmentWithMutualScanProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            CoreProtocolMessage coreProtocolMessage;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!Signature.verify(Constants.SignatureContext.MUTUAL_SCAN, new Identity[]{this.receivedMessage.aliceIdentity, this.getOwnedIdentity()}, this.getOwnedIdentity(), this.receivedMessage.signature)) {
                return new FinishedState();
            }
            if (MutualScanSignatureReceived.exists(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature)) {
                Logger.e("Mutual scan signature reuse!");
                return new FinishedState();
            }
            if (MutualScanSignatureReceived.create(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature) == null) {
                return new FinishedState();
            }
            if (!protocolManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.aliceIdentity)) {
                protocolManagerSession.identityDelegate.addContactIdentity(protocolManagerSession.session, this.receivedMessage.aliceIdentity, this.receivedMessage.serializedAliceDetails, this.getOwnedIdentity(), TrustOrigin.createDirectTrustOrigin(System.currentTimeMillis()), true);
            } else {
                protocolManagerSession.identityDelegate.addTrustOriginToContact(protocolManagerSession.session, this.receivedMessage.aliceIdentity, this.getOwnedIdentity(), TrustOrigin.createDirectTrustOrigin(System.currentTimeMillis()), true);
            }
            boolean triggerDeviceDiscovery = false;
            for (UID contactDeviceUid : this.receivedMessage.aliceDeviceUids) {
                triggerDeviceDiscovery |= protocolManagerSession.identityDelegate.addDeviceForContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.aliceIdentity, contactDeviceUid, null, false);
            }
            if (triggerDeviceDiscovery) {
                coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 0, new UID(this.getPrng()));
                ChannelProtocolMessageToSend messageToSend = new DeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.aliceIdentity).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            UID[] deviceUids = protocolManagerSession.identityDelegate.getDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            String serializedBobDetails = protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.receivedMessage.aliceIdentity, this.getOwnedIdentity(), this.receivedMessage.aliceDeviceUids));
            ChannelProtocolMessageToSend messageToSend = new BobSendsConfirmationAndDetailsToAliceMessage(coreProtocolMessage2, serializedBobDetails, deviceUids).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend2 = new BobPropagatesSignatureMessage(coreProtocolMessage, this.receivedMessage.aliceIdentity, this.receivedMessage.signature, this.receivedMessage.serializedAliceDetails, this.receivedMessage.aliceDeviceUids).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            protocolManagerSession.session.addSessionCommitListener(() -> {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", this.getOwnedIdentity());
                userInfo.put("contact_identity", this.receivedMessage.aliceIdentity);
                userInfo.put("nonce", this.receivedMessage.signature);
                protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_mutual_scan_contact_added", userInfo);
            });
            return new FinishedState();
        }
    }

    public static class BobHandlesPropagatedSignatureStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final BobPropagatesSignatureMessage receivedMessage;

        public BobHandlesPropagatedSignatureStep(InitialProtocolState startState, BobPropagatesSignatureMessage receivedMessage, TrustEstablishmentWithMutualScanProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!Signature.verify(Constants.SignatureContext.MUTUAL_SCAN, new Identity[]{this.receivedMessage.aliceIdentity, this.getOwnedIdentity()}, this.getOwnedIdentity(), this.receivedMessage.signature)) {
                return new FinishedState();
            }
            if (MutualScanSignatureReceived.exists(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature)) {
                return new FinishedState();
            }
            if (MutualScanSignatureReceived.create(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature) == null) {
                return new FinishedState();
            }
            if (!protocolManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.aliceIdentity)) {
                protocolManagerSession.identityDelegate.addContactIdentity(protocolManagerSession.session, this.receivedMessage.aliceIdentity, this.receivedMessage.serializedAliceDetails, this.getOwnedIdentity(), TrustOrigin.createDirectTrustOrigin(System.currentTimeMillis()), true);
            } else {
                protocolManagerSession.identityDelegate.addTrustOriginToContact(protocolManagerSession.session, this.receivedMessage.aliceIdentity, this.getOwnedIdentity(), TrustOrigin.createDirectTrustOrigin(System.currentTimeMillis()), true);
            }
            boolean triggerDeviceDiscovery = false;
            for (UID contactDeviceUid : this.receivedMessage.aliceDeviceUids) {
                triggerDeviceDiscovery |= protocolManagerSession.identityDelegate.addDeviceForContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.aliceIdentity, contactDeviceUid, null, false);
            }
            if (triggerDeviceDiscovery) {
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 0, new UID(this.getPrng()));
                ChannelProtocolMessageToSend messageToSend = new DeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.aliceIdentity).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            protocolManagerSession.session.addSessionCommitListener(() -> {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", this.getOwnedIdentity());
                userInfo.put("contact_identity", this.receivedMessage.aliceIdentity);
                userInfo.put("nonce", this.receivedMessage.signature);
                protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_mutual_scan_contact_added", userInfo);
            });
            return new FinishedState();
        }
    }

    public static class AliceAddsContactStep
    extends ProtocolStep {
        private final WaitingForConfirmationState startState;
        private final BobSendsConfirmationAndDetailsToAliceMessage receivedMessage;

        public AliceAddsContactStep(WaitingForConfirmationState startState, BobSendsConfirmationAndDetailsToAliceMessage receivedMessage, TrustEstablishmentWithMutualScanProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!protocolManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.bobIdentity)) {
                protocolManagerSession.identityDelegate.addContactIdentity(protocolManagerSession.session, this.startState.bobIdentity, this.receivedMessage.serializedBobDetails, this.getOwnedIdentity(), TrustOrigin.createDirectTrustOrigin(System.currentTimeMillis()), true);
            } else {
                protocolManagerSession.identityDelegate.addTrustOriginToContact(protocolManagerSession.session, this.startState.bobIdentity, this.getOwnedIdentity(), TrustOrigin.createDirectTrustOrigin(System.currentTimeMillis()), true);
            }
            boolean triggerDeviceDiscovery = false;
            for (UID contactDeviceUid : this.receivedMessage.bobDeviceUids) {
                triggerDeviceDiscovery |= protocolManagerSession.identityDelegate.addDeviceForContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.bobIdentity, contactDeviceUid, null, false);
            }
            if (triggerDeviceDiscovery) {
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 0, new UID(this.getPrng()));
                ChannelProtocolMessageToSend messageToSend = new DeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage, this.startState.bobIdentity).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            protocolManagerSession.session.addSessionCommitListener(() -> {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", this.getOwnedIdentity());
                userInfo.put("contact_identity", this.startState.bobIdentity);
                protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_mutual_scan_contact_added", userInfo);
            });
            return new FinishedState();
        }
    }
}

