/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.DialogType;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.sync.ObvSyncAtom;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.OneWayDialogProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import java.util.UUID;

public class SynchronizationProtocol
extends ConcreteProtocol {
    private static final int FINAL_STATE_ID = 99;
    public static final int INITIATE_SINGLE_ITEM_SYNC_MESSAGE_ID = 0;
    public static final int SINGLE_ITEM_SYNC_MESSAGE_ID = 1;

    public SynchronizationProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 25;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{99};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 99: {
                return FinalState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitiateSingleItemSyncMessage.class;
            }
            case 1: {
                return SingleItemSyncMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{SendSingleItemSyncMessageStep.class, ProcessSingleItemSyncMessageStep.class};
            }
        }
        return new Class[0];
    }

    public static class FinalState
    extends ConcreteProtocolState {
        protected FinalState() {
            super(99);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitiateSingleItemSyncMessage
    extends ConcreteProtocolMessage {
        final ObvSyncAtom obvSyncAtom;

        public InitiateSingleItemSyncMessage(CoreProtocolMessage coreProtocolMessage, ObvSyncAtom obvSyncAtom) {
            super(coreProtocolMessage);
            this.obvSyncAtom = obvSyncAtom;
        }

        public InitiateSingleItemSyncMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 1) {
                throw new Exception();
            }
            this.obvSyncAtom = ObvSyncAtom.of(list[0]);
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.obvSyncAtom.encode()};
        }
    }

    public static class SingleItemSyncMessage
    extends ConcreteProtocolMessage {
        final ObvSyncAtom obvSyncAtom;

        public SingleItemSyncMessage(CoreProtocolMessage coreProtocolMessage, ObvSyncAtom obvSyncAtom) {
            super(coreProtocolMessage);
            this.obvSyncAtom = obvSyncAtom;
        }

        public SingleItemSyncMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 1) {
                throw new Exception();
            }
            this.obvSyncAtom = ObvSyncAtom.of(list[0]);
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.obvSyncAtom.encode()};
        }
    }

    public static class SendSingleItemSyncMessageStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitiateSingleItemSyncMessage receivedMessage;

        public SendSingleItemSyncMessageStep(InitialProtocolState startState, InitiateSingleItemSyncMessage receivedMessage, SynchronizationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UID[] otherDeviceUids = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            if (otherDeviceUids.length > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new SingleItemSyncMessage(coreProtocolMessage, this.receivedMessage.obvSyncAtom).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            return new FinalState();
        }
    }

    public static class ProcessSingleItemSyncMessageStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final SingleItemSyncMessage receivedMessage;

        public ProcessSingleItemSyncMessageStep(InitialProtocolState startState, SingleItemSyncMessage receivedMessage, SynchronizationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.obvSyncAtom.isAppSyncItem()) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createSyncItemToApplyDialog(this.receivedMessage.obvSyncAtom), UUID.randomUUID()));
                ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            } else {
                protocolManagerSession.identityDelegate.processSyncItem(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.obvSyncAtom);
            }
            return new FinalState();
        }
    }
}

