/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Commitment;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.SAS;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.PrivateIdentity;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.DialogType;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPrivateKey;
import io.olvid.engine.datatypes.key.symmetric.MACKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvDeviceManagementRequest;
import io.olvid.engine.engine.types.ObvTransferStep;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshot;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.sync.IdentityManagerSyncSnapshot;
import io.olvid.engine.metamanager.IdentityDelegate;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.EmptyProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.OneWayDialogProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;

public class OwnedIdentityTransferProtocol
extends ConcreteProtocol {
    public static final int SOURCE_WAITING_FOR_SESSION_NUMBER_STATE_ID = 1;
    public static final int SOURCE_WAITING_FOR_TARGET_CONNECTION_STATE_ID = 2;
    public static final int TARGET_WAITING_FOR_SESSION_NUMBER_STATE_ID = 3;
    public static final int TARGET_WAITING_FOR_TRANSFERRED_IDENTITY_STATE_ID = 4;
    public static final int SOURCE_WAITING_FOR_TARGET_SEED_STATE_ID = 5;
    public static final int TARGET_WAITING_FOR_DECOMMITMENT_STATE_ID = 6;
    public static final int SOURCE_WAITING_FOR_SAS_INPUT_STATE_ID = 7;
    public static final int TARGET_WAITING_FOR_SNAPSHOT_STATE_ID = 8;
    public static final int SOURCE_WAIT_FOR_KEYCLOAK_AUTHENTICATION_PROOF_STATE_ID = 9;
    public static final int TARGET_WAITING_FOR_KEYCLOAK_AUTHENTICATION_PROOF_STATE_ID = 10;
    public static final int FINAL_STATE_ID = 99;
    public static final int INITIATE_TRANSFER_ON_SOURCE_DEVICE_MESSAGE_ID = 0;
    public static final int INITIATE_TRANSFER_ON_TARGET_DEVICE_MESSAGE_ID = 1;
    public static final int SOURCE_GET_SESSION_NUMBER_MESSAGE_ID = 2;
    public static final int ABORTABLE_ONE_WAY_DIALOG_MESSAGE_ID = 3;
    public static final int SOURCE_WAIT_FOR_TARGET_CONNECTION_MESSAGE_ID = 4;
    public static final int TARGET_GET_SESSION_NUMBER_MESSAGE_ID = 5;
    public static final int TARGET_SEND_EPHEMERAL_IDENTITY_MESSAGE_ID = 6;
    public static final int SOURCE_SEND_COMMITMENT_MESSAGE_ID = 7;
    public static final int TARGET_SEED_MESSAGE_ID = 8;
    public static final int SOURCE_SAS_INPUT_MESSAGE_ID = 9;
    public static final int SOURCE_DECOMMITMENT_MESSAGE_ID = 10;
    public static final int TARGET_WAIT_FOR_SNAPSHOT_MESSAGE_ID = 11;
    public static final int SOURCE_SNAPSHOT_MESSAGE_ID = 12;
    public static final int SOURCE_WAIT_FOR_KEYCLOAK_AUTHENTICATION_PROOF_MESSAGE_ID = 13;
    public static final int TARGET_RETRIEVE_KEYCLOAK_AUTHENTICATION_PROOF_MESSAGE_ID = 14;

    public OwnedIdentityTransferProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 26;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{99};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return SourceWaitingForSessionNumberState.class;
            }
            case 2: {
                return SourceWaitingForTargetConnectionState.class;
            }
            case 3: {
                return TargetWaitingForSessionNumberState.class;
            }
            case 4: {
                return TargetWaitingForTransferredIdentityState.class;
            }
            case 5: {
                return SourceWaitingForTargetSeedState.class;
            }
            case 6: {
                return TargetWaitingForDecommitmentState.class;
            }
            case 7: {
                return SourceWaitingForSasInputState.class;
            }
            case 8: {
                return TargetWaitingForSnapshotState.class;
            }
            case 9: {
                return SourceWaitForKeycloakAuthenticationProofState.class;
            }
            case 10: {
                return TargetWaitingForKeycloakAuthenticationProofState.class;
            }
            case 99: {
                return FinalState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitiateTransferOnSourceDeviceMessage.class;
            }
            case 1: {
                return InitiateTransferOnTargetDeviceMessage.class;
            }
            case 2: {
                return SourceGetSessionNumberMessage.class;
            }
            case 3: {
                return AbortableOneWayDialogMessage.class;
            }
            case 4: {
                return SourceWaitForTargetConnectionMessage.class;
            }
            case 5: {
                return TargetGetSessionNumberMessage.class;
            }
            case 6: {
                return TargetSendEphemeralIdentityMessage.class;
            }
            case 7: {
                return SourceSendCommitmentMessage.class;
            }
            case 8: {
                return TargetSeedMessage.class;
            }
            case 9: {
                return SourceSasInputMessage.class;
            }
            case 10: {
                return SourceDecommitmentMessage.class;
            }
            case 11: {
                return TargetWaitForSnapshotMessage.class;
            }
            case 12: {
                return SourceSnapshotMessage.class;
            }
            case 13: {
                return SourceWaitForKeycloakAuthenticationProofMessage.class;
            }
            case 14: {
                return TargetRetrieveKeycloakAuthenticationProofMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{InitiateTransferOnSourceDeviceStep.class, InitiateTransferOnTargetDeviceStep.class};
            }
            case 1: {
                return new Class[]{SourceDisplaysSessionNumberStep.class, UserInitiatedAbortProtocolStep.class};
            }
            case 2: {
                return new Class[]{SourceSendsTransferredIdentityAndCommitmentStep.class, UserInitiatedAbortProtocolStep.class};
            }
            case 3: {
                return new Class[]{TargetProcessesSessionNumberAndSendsEphemeralIdentityStep.class};
            }
            case 4: {
                return new Class[]{TargetSendsSeedStep.class, UserInitiatedAbortProtocolStep.class};
            }
            case 5: {
                return new Class[]{SourceSendsDecommitmentAndShowsSasInputStep.class, UserInitiatedAbortProtocolStep.class};
            }
            case 6: {
                return new Class[]{TargetShowsSasStep.class, UserInitiatedAbortProtocolStep.class};
            }
            case 7: {
                return new Class[]{SourceCheckSasInputAndSendSnapshotStep.class};
            }
            case 8: {
                return new Class[]{TargetProcessesSnapshotStep.class, UserInitiatedAbortProtocolStep.class};
            }
            case 9: {
                return new Class[]{SourceCheckTransferProofAndSendSnapshotStep.class};
            }
            case 10: {
                return new Class[]{TargetSendKeycloakAuthenticationProofStep.class};
            }
        }
        return new Class[0];
    }

    private static void sendSnapshotAndCloseWebsocket(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, Identity ownedIdentity, UID deviceUidToKeepActive, String otherConnectionIdentifier, Identity ephemeralIdentity, UUID dialogUuid, PRNGService prng) throws Exception {
        ObvBackupAndSyncDelegate wrappedIdentityDelegate = protocolManagerSession.identityDelegate.getSyncDelegateWithinTransaction(protocolManagerSession.session);
        ObvSyncSnapshot syncSnapshot = ObvSyncSnapshot.get(ownedIdentity, wrappedIdentityDelegate, protocolManagerSession.appBackupAndSyncDelegate);
        byte[] cleartext = deviceUidToKeepActive == null ? Encoded.of(new Encoded[]{Encoded.of(syncSnapshot.toEncodedDictionary(wrappedIdentityDelegate, protocolManagerSession.appBackupAndSyncDelegate))}).getBytes() : Encoded.of(new Encoded[]{Encoded.of(syncSnapshot.toEncodedDictionary(wrappedIdentityDelegate, protocolManagerSession.appBackupAndSyncDelegate)), Encoded.of(deviceUidToKeepActive)}).getBytes();
        EncryptedBytes payload = Suite.getPublicKeyEncryption(ephemeralIdentity.getEncryptionPublicKey()).encrypt(ephemeralIdentity.getEncryptionPublicKey(), cleartext, prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(ownedIdentity, new ServerQuery.TransferRelayQuery(otherConnectionIdentifier, payload.getBytes(), true)), 26, protocolInstanceUid);
        ChannelServerQueryMessageToSend messageToSend = new SourceSnapshotMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, prng);
        CoreProtocolMessage coreProtocolMessage2 = new CoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(ownedIdentity, new ServerQuery.TransferCloseQuery(false)), 26, protocolInstanceUid);
        ChannelMessageToSend messageToSend2 = new CloseWebSocketMessage(coreProtocolMessage2).generateChannelServerQueryMessageToSend();
        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, prng);
        coreProtocolMessage2 = new CoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(ownedIdentity, DialogType.createTransferDialog(new ObvTransferStep.SourceSnapshotSent()), dialogUuid), 26, protocolInstanceUid);
        messageToSend2 = new OneWayDialogProtocolMessage(coreProtocolMessage2).generateChannelDialogMessageToSend();
        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, prng);
    }

    private static ConcreteProtocolState userInitiatedAbortProtocol(ProtocolStep protocolStep, UUID dialogUuid) throws Exception {
        CoreProtocolMessage coreProtocolMessage = protocolStep.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(protocolStep.getOwnedIdentity(), DialogType.createDeleteDialog(), dialogUuid));
        ChannelMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
        protocolStep.getProtocolManagerSession().channelDelegate.post(protocolStep.getProtocolManagerSession().session, messageToSend, protocolStep.getPrng());
        coreProtocolMessage = protocolStep.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(protocolStep.getOwnedIdentity(), new ServerQuery.TransferCloseQuery(true)));
        messageToSend = new CloseWebSocketMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
        protocolStep.getProtocolManagerSession().channelDelegate.post(protocolStep.getProtocolManagerSession().session, messageToSend, protocolStep.getPrng());
        return new FinalState();
    }

    private static ConcreteProtocolState failProtocol(ProtocolStep protocolStep, UUID dialogUuid, int failReason) throws Exception {
        CoreProtocolMessage coreProtocolMessage = protocolStep.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(protocolStep.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.Fail(failReason)), dialogUuid));
        ChannelMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
        protocolStep.getProtocolManagerSession().channelDelegate.post(protocolStep.getProtocolManagerSession().session, messageToSend, protocolStep.getPrng());
        coreProtocolMessage = protocolStep.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(protocolStep.getOwnedIdentity(), new ServerQuery.TransferCloseQuery(true)));
        messageToSend = new CloseWebSocketMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
        protocolStep.getProtocolManagerSession().channelDelegate.post(protocolStep.getProtocolManagerSession().session, messageToSend, protocolStep.getPrng());
        return new FinalState();
    }

    public static class SourceWaitingForSessionNumberState
    extends ConcreteProtocolState {
        private final UUID dialogUuid;

        protected SourceWaitingForSessionNumberState(UUID dialogUuid) {
            super(1);
            this.dialogUuid = dialogUuid;
        }

        public SourceWaitingForSessionNumberState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 1) {
                throw new Exception();
            }
            this.dialogUuid = list[0].decodeUuid();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid)});
        }
    }

    public static class SourceWaitingForTargetConnectionState
    extends ConcreteProtocolState {
        private final UUID dialogUuid;
        private final String ownConnectionIdentifier;
        private final long sessionNumber;

        protected SourceWaitingForTargetConnectionState(UUID dialogUuid, String ownConnectionIdentifier, long sessionNumber) {
            super(2);
            this.dialogUuid = dialogUuid;
            this.ownConnectionIdentifier = ownConnectionIdentifier;
            this.sessionNumber = sessionNumber;
        }

        public SourceWaitingForTargetConnectionState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 3) {
                throw new Exception();
            }
            this.dialogUuid = list[0].decodeUuid();
            this.ownConnectionIdentifier = list[1].decodeString();
            this.sessionNumber = list[2].decodeLong();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid), Encoded.of(this.ownConnectionIdentifier), Encoded.of(this.sessionNumber)});
        }
    }

    public static class TargetWaitingForSessionNumberState
    extends ConcreteProtocolState {
        private final UUID dialogUuid;
        private final String deviceName;
        private final ServerAuthenticationPrivateKey serverAuthenticationPrivateKey;
        private final EncryptionPrivateKey encryptionPrivateKey;
        private final MACKey macKey;

        protected TargetWaitingForSessionNumberState(UUID dialogUuid, String deviceName, ServerAuthenticationPrivateKey serverAuthenticationPrivateKey, EncryptionPrivateKey encryptionPrivateKey, MACKey macKey) {
            super(3);
            this.dialogUuid = dialogUuid;
            this.deviceName = deviceName;
            this.serverAuthenticationPrivateKey = serverAuthenticationPrivateKey;
            this.encryptionPrivateKey = encryptionPrivateKey;
            this.macKey = macKey;
        }

        public TargetWaitingForSessionNumberState(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 5) {
                throw new Exception();
            }
            this.dialogUuid = list[0].decodeUuid();
            this.deviceName = list[1].decodeString();
            this.serverAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)list[2].decodePrivateKey();
            this.encryptionPrivateKey = (EncryptionPrivateKey)list[3].decodePrivateKey();
            this.macKey = (MACKey)list[4].decodeSymmetricKey();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid), Encoded.of(this.deviceName), Encoded.of(this.serverAuthenticationPrivateKey), Encoded.of(this.encryptionPrivateKey), Encoded.of(this.macKey)});
        }
    }

    public static class TargetWaitingForTransferredIdentityState
    extends ConcreteProtocolState {
        private final UUID dialogUuid;
        private final String deviceName;
        private final ServerAuthenticationPrivateKey serverAuthenticationPrivateKey;
        private final EncryptionPrivateKey encryptionPrivateKey;
        private final MACKey macKey;
        private final long sessionNumber;

        protected TargetWaitingForTransferredIdentityState(UUID dialogUuid, String deviceName, ServerAuthenticationPrivateKey serverAuthenticationPrivateKey, EncryptionPrivateKey encryptionPrivateKey, MACKey macKey, long sessionNumber) {
            super(4);
            this.dialogUuid = dialogUuid;
            this.deviceName = deviceName;
            this.serverAuthenticationPrivateKey = serverAuthenticationPrivateKey;
            this.encryptionPrivateKey = encryptionPrivateKey;
            this.macKey = macKey;
            this.sessionNumber = sessionNumber;
        }

        public TargetWaitingForTransferredIdentityState(Encoded encodedState) throws Exception {
            super(4);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 6) {
                throw new Exception();
            }
            this.dialogUuid = list[0].decodeUuid();
            this.deviceName = list[1].decodeString();
            this.serverAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)list[2].decodePrivateKey();
            this.encryptionPrivateKey = (EncryptionPrivateKey)list[3].decodePrivateKey();
            this.macKey = (MACKey)list[4].decodeSymmetricKey();
            this.sessionNumber = list[5].decodeLong();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid), Encoded.of(this.deviceName), Encoded.of(this.serverAuthenticationPrivateKey), Encoded.of(this.encryptionPrivateKey), Encoded.of(this.macKey), Encoded.of(this.sessionNumber)});
        }
    }

    public static class SourceWaitingForTargetSeedState
    extends ConcreteProtocolState {
        private final UUID dialogUuid;
        private final String otherConnectionIdentifier;
        private final Identity ephemeralIdentity;
        private final Seed seedSourceForSas;
        private final byte[] decommitment;
        private final long sessionNumber;

        public SourceWaitingForTargetSeedState(UUID dialogUuid, String otherConnectionIdentifier, Identity ephemeralIdentity, Seed seedSourceForSas, byte[] decommitment, long sessionNumber) {
            super(5);
            this.dialogUuid = dialogUuid;
            this.otherConnectionIdentifier = otherConnectionIdentifier;
            this.ephemeralIdentity = ephemeralIdentity;
            this.seedSourceForSas = seedSourceForSas;
            this.decommitment = decommitment;
            this.sessionNumber = sessionNumber;
        }

        public SourceWaitingForTargetSeedState(Encoded encodedState) throws Exception {
            super(5);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 6) {
                throw new Exception();
            }
            this.dialogUuid = list[0].decodeUuid();
            this.otherConnectionIdentifier = list[1].decodeString();
            this.ephemeralIdentity = list[2].decodeIdentity();
            this.seedSourceForSas = list[3].decodeSeed();
            this.decommitment = list[4].decodeBytes();
            this.sessionNumber = list[5].decodeLong();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid), Encoded.of(this.otherConnectionIdentifier), Encoded.of(this.ephemeralIdentity), Encoded.of(this.seedSourceForSas), Encoded.of(this.decommitment), Encoded.of(this.sessionNumber)});
        }
    }

    public static class TargetWaitingForDecommitmentState
    extends ConcreteProtocolState {
        private final UUID dialogUuid;
        private final String deviceName;
        private final String otherConnectionIdentifier;
        private final Identity transferredIdentity;
        private final byte[] commitment;
        private final Seed seedTargetForSas;
        private final ServerAuthenticationPrivateKey serverAuthenticationPrivateKey;
        private final EncryptionPrivateKey encryptionPrivateKey;
        private final MACKey macKey;
        private final long sessionNumber;

        public TargetWaitingForDecommitmentState(UUID dialogUuid, String deviceName, String otherConnectionIdentifier, Identity transferredIdentity, byte[] commitment, Seed seedTargetForSas, ServerAuthenticationPrivateKey serverAuthenticationPrivateKey, EncryptionPrivateKey encryptionPrivateKey, MACKey macKey, long sessionNumber) {
            super(6);
            this.dialogUuid = dialogUuid;
            this.deviceName = deviceName;
            this.otherConnectionIdentifier = otherConnectionIdentifier;
            this.transferredIdentity = transferredIdentity;
            this.commitment = commitment;
            this.seedTargetForSas = seedTargetForSas;
            this.serverAuthenticationPrivateKey = serverAuthenticationPrivateKey;
            this.encryptionPrivateKey = encryptionPrivateKey;
            this.macKey = macKey;
            this.sessionNumber = sessionNumber;
        }

        public TargetWaitingForDecommitmentState(Encoded encodedState) throws Exception {
            super(6);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 10) {
                throw new Exception();
            }
            this.dialogUuid = list[0].decodeUuid();
            this.deviceName = list[1].decodeString();
            this.otherConnectionIdentifier = list[2].decodeString();
            this.transferredIdentity = list[3].decodeIdentity();
            this.commitment = list[4].decodeBytes();
            this.seedTargetForSas = list[5].decodeSeed();
            this.serverAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)list[6].decodePrivateKey();
            this.encryptionPrivateKey = (EncryptionPrivateKey)list[7].decodePrivateKey();
            this.macKey = (MACKey)list[8].decodeSymmetricKey();
            this.sessionNumber = list[9].decodeLong();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid), Encoded.of(this.deviceName), Encoded.of(this.otherConnectionIdentifier), Encoded.of(this.transferredIdentity), Encoded.of(this.commitment), Encoded.of(this.seedTargetForSas), Encoded.of(this.serverAuthenticationPrivateKey), Encoded.of(this.encryptionPrivateKey), Encoded.of(this.macKey), Encoded.of(this.sessionNumber)});
        }
    }

    public static class SourceWaitingForSasInputState
    extends ConcreteProtocolState {
        private final UUID dialogUuid;
        private final String otherConnectionIdentifier;
        private final String targetDeviceName;
        private final Identity ephemeralIdentity;
        private final String fullSas;
        private final long sessionNumber;

        public SourceWaitingForSasInputState(UUID dialogUuid, String otherConnectionIdentifier, String targetDeviceName, Identity ephemeralIdentity, String fullSas, long sessionNumber) {
            super(7);
            this.dialogUuid = dialogUuid;
            this.otherConnectionIdentifier = otherConnectionIdentifier;
            this.targetDeviceName = targetDeviceName;
            this.ephemeralIdentity = ephemeralIdentity;
            this.fullSas = fullSas;
            this.sessionNumber = sessionNumber;
        }

        public SourceWaitingForSasInputState(Encoded encodedState) throws Exception {
            super(7);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 6) {
                throw new Exception();
            }
            this.dialogUuid = list[0].decodeUuid();
            this.otherConnectionIdentifier = list[1].decodeString();
            this.targetDeviceName = list[2].decodeString();
            this.ephemeralIdentity = list[3].decodeIdentity();
            this.fullSas = list[4].decodeString();
            this.sessionNumber = list[5].decodeLong();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid), Encoded.of(this.otherConnectionIdentifier), Encoded.of(this.targetDeviceName), Encoded.of(this.ephemeralIdentity), Encoded.of(this.fullSas), Encoded.of(this.sessionNumber)});
        }
    }

    public static class TargetWaitingForSnapshotState
    extends ConcreteProtocolState {
        private final UUID dialogUuid;
        private final String deviceName;
        private final String otherConnectionIdentifier;
        private final Identity transferredIdentity;
        private final ServerAuthenticationPrivateKey serverAuthenticationPrivateKey;
        private final EncryptionPrivateKey encryptionPrivateKey;
        private final MACKey macKey;
        private final String fullSas;
        private final long sessionNumber;
        private final String serializedKeycloakAuthState;

        public TargetWaitingForSnapshotState(UUID dialogUuid, String deviceName, String otherConnectionIdentifier, Identity transferredIdentity, ServerAuthenticationPrivateKey serverAuthenticationPrivateKey, EncryptionPrivateKey encryptionPrivateKey, MACKey macKey, String fullSas, long sessionNumber, String serializedKeycloakAuthState) {
            super(8);
            this.dialogUuid = dialogUuid;
            this.deviceName = deviceName;
            this.otherConnectionIdentifier = otherConnectionIdentifier;
            this.transferredIdentity = transferredIdentity;
            this.serverAuthenticationPrivateKey = serverAuthenticationPrivateKey;
            this.encryptionPrivateKey = encryptionPrivateKey;
            this.macKey = macKey;
            this.fullSas = fullSas;
            this.sessionNumber = sessionNumber;
            this.serializedKeycloakAuthState = serializedKeycloakAuthState;
        }

        public TargetWaitingForSnapshotState(Encoded encodedState) throws Exception {
            super(8);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 10 && list.length != 9) {
                throw new Exception();
            }
            this.dialogUuid = list[0].decodeUuid();
            this.deviceName = list[1].decodeString();
            this.otherConnectionIdentifier = list[2].decodeString();
            this.transferredIdentity = list[3].decodeIdentity();
            this.serverAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)list[4].decodePrivateKey();
            this.encryptionPrivateKey = (EncryptionPrivateKey)list[5].decodePrivateKey();
            this.macKey = (MACKey)list[6].decodeSymmetricKey();
            this.fullSas = list[7].decodeString();
            this.sessionNumber = list[8].decodeLong();
            this.serializedKeycloakAuthState = list.length == 10 ? list[9].decodeString() : null;
        }

        @Override
        public Encoded encode() {
            if (this.serializedKeycloakAuthState == null) {
                return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid), Encoded.of(this.deviceName), Encoded.of(this.otherConnectionIdentifier), Encoded.of(this.transferredIdentity), Encoded.of(this.serverAuthenticationPrivateKey), Encoded.of(this.encryptionPrivateKey), Encoded.of(this.macKey), Encoded.of(this.fullSas), Encoded.of(this.sessionNumber)});
            }
            return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid), Encoded.of(this.deviceName), Encoded.of(this.otherConnectionIdentifier), Encoded.of(this.transferredIdentity), Encoded.of(this.serverAuthenticationPrivateKey), Encoded.of(this.encryptionPrivateKey), Encoded.of(this.macKey), Encoded.of(this.fullSas), Encoded.of(this.sessionNumber), Encoded.of(this.serializedKeycloakAuthState)});
        }
    }

    public static class SourceWaitForKeycloakAuthenticationProofState
    extends ConcreteProtocolState {
        private final UUID dialogUuid;
        private final String otherConnectionIdentifier;
        private final Identity ephemeralIdentity;
        private final String fullSas;
        private final long sessionNumber;
        private final UID deviceUidToKeepActive;

        public SourceWaitForKeycloakAuthenticationProofState(UUID dialogUuid, String otherConnectionIdentifier, Identity ephemeralIdentity, String fullSas, long sessionNumber, UID deviceUidToKeepActive) {
            super(9);
            this.dialogUuid = dialogUuid;
            this.otherConnectionIdentifier = otherConnectionIdentifier;
            this.ephemeralIdentity = ephemeralIdentity;
            this.fullSas = fullSas;
            this.sessionNumber = sessionNumber;
            this.deviceUidToKeepActive = deviceUidToKeepActive;
        }

        public SourceWaitForKeycloakAuthenticationProofState(Encoded encodedState) throws Exception {
            super(9);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 6 && list.length != 5) {
                throw new Exception();
            }
            this.dialogUuid = list[0].decodeUuid();
            this.otherConnectionIdentifier = list[1].decodeString();
            this.ephemeralIdentity = list[2].decodeIdentity();
            this.fullSas = list[3].decodeString();
            this.sessionNumber = list[4].decodeLong();
            this.deviceUidToKeepActive = list.length == 6 ? list[5].decodeUid() : null;
        }

        @Override
        public Encoded encode() {
            if (this.deviceUidToKeepActive != null) {
                return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid), Encoded.of(this.otherConnectionIdentifier), Encoded.of(this.ephemeralIdentity), Encoded.of(this.fullSas), Encoded.of(this.sessionNumber), Encoded.of(this.deviceUidToKeepActive)});
            }
            return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid), Encoded.of(this.otherConnectionIdentifier), Encoded.of(this.ephemeralIdentity), Encoded.of(this.fullSas), Encoded.of(this.sessionNumber)});
        }
    }

    public static class TargetWaitingForKeycloakAuthenticationProofState
    extends ConcreteProtocolState {
        private final UUID dialogUuid;
        private final String deviceName;
        private final String otherConnectionIdentifier;
        private final Identity transferredIdentity;
        private final ServerAuthenticationPrivateKey serverAuthenticationPrivateKey;
        private final EncryptionPrivateKey encryptionPrivateKey;
        private final MACKey macKey;
        private final String fullSas;
        private final long sessionNumber;

        public TargetWaitingForKeycloakAuthenticationProofState(UUID dialogUuid, String deviceName, String otherConnectionIdentifier, Identity transferredIdentity, ServerAuthenticationPrivateKey serverAuthenticationPrivateKey, EncryptionPrivateKey encryptionPrivateKey, MACKey macKey, String fullSas, long sessionNumber) {
            super(10);
            this.dialogUuid = dialogUuid;
            this.deviceName = deviceName;
            this.otherConnectionIdentifier = otherConnectionIdentifier;
            this.transferredIdentity = transferredIdentity;
            this.serverAuthenticationPrivateKey = serverAuthenticationPrivateKey;
            this.encryptionPrivateKey = encryptionPrivateKey;
            this.macKey = macKey;
            this.fullSas = fullSas;
            this.sessionNumber = sessionNumber;
        }

        public TargetWaitingForKeycloakAuthenticationProofState(Encoded encodedState) throws Exception {
            super(10);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 9) {
                throw new Exception();
            }
            this.dialogUuid = list[0].decodeUuid();
            this.deviceName = list[1].decodeString();
            this.otherConnectionIdentifier = list[2].decodeString();
            this.transferredIdentity = list[3].decodeIdentity();
            this.serverAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)list[4].decodePrivateKey();
            this.encryptionPrivateKey = (EncryptionPrivateKey)list[5].decodePrivateKey();
            this.macKey = (MACKey)list[6].decodeSymmetricKey();
            this.fullSas = list[7].decodeString();
            this.sessionNumber = list[8].decodeLong();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.dialogUuid), Encoded.of(this.deviceName), Encoded.of(this.otherConnectionIdentifier), Encoded.of(this.transferredIdentity), Encoded.of(this.serverAuthenticationPrivateKey), Encoded.of(this.encryptionPrivateKey), Encoded.of(this.macKey), Encoded.of(this.fullSas), Encoded.of(this.sessionNumber)});
        }
    }

    public static class FinalState
    extends ConcreteProtocolState {
        protected FinalState() {
            super(99);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitiateTransferOnSourceDeviceMessage
    extends ConcreteProtocolMessage {
        public InitiateTransferOnSourceDeviceMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public InitiateTransferOnSourceDeviceMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class InitiateTransferOnTargetDeviceMessage
    extends ConcreteProtocolMessage {
        private final String deviceName;
        private final ServerAuthenticationPrivateKey serverAuthenticationPrivateKey;
        private final EncryptionPrivateKey encryptionPrivateKey;
        private final MACKey macKey;

        public InitiateTransferOnTargetDeviceMessage(CoreProtocolMessage coreProtocolMessage, String deviceName, ServerAuthenticationPrivateKey serverAuthenticationPrivateKey, EncryptionPrivateKey encryptionPrivateKey, MACKey macKey) {
            super(coreProtocolMessage);
            this.deviceName = deviceName;
            this.serverAuthenticationPrivateKey = serverAuthenticationPrivateKey;
            this.encryptionPrivateKey = encryptionPrivateKey;
            this.macKey = macKey;
        }

        public InitiateTransferOnTargetDeviceMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 4) {
                throw new Exception();
            }
            this.deviceName = list[0].decodeString();
            this.serverAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)list[1].decodePrivateKey();
            this.encryptionPrivateKey = (EncryptionPrivateKey)list[2].decodePrivateKey();
            this.macKey = (MACKey)list[3].decodeSymmetricKey();
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.deviceName), Encoded.of(this.serverAuthenticationPrivateKey), Encoded.of(this.encryptionPrivateKey), Encoded.of(this.macKey)};
        }
    }

    public static class SourceGetSessionNumberMessage
    extends EmptyProtocolMessage {
        private final String serializedJsonResponseSource;

        public SourceGetSessionNumberMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.serializedJsonResponseSource = null;
        }

        public SourceGetSessionNumberMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
            this.serializedJsonResponseSource = receivedMessage.getEncodedResponse() == null ? null : receivedMessage.getEncodedResponse().decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }
    }

    public static class AbortableOneWayDialogMessage
    extends EmptyProtocolMessage {
        private final UUID dialogUuid;

        AbortableOneWayDialogMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.dialogUuid = null;
        }

        public AbortableOneWayDialogMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
            if (receivedMessage.getEncodedResponse() != null) {
                throw new Exception();
            }
            this.dialogUuid = receivedMessage.getUserDialogUuid();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }
    }

    public static class SourceWaitForTargetConnectionMessage
    extends WaitOrRelayMessage {
        protected SourceWaitForTargetConnectionMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public SourceWaitForTargetConnectionMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }
    }

    public static class TargetGetSessionNumberMessage
    extends EmptyProtocolMessage {
        private final Long sessionNumber;

        TargetGetSessionNumberMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.sessionNumber = null;
        }

        public TargetGetSessionNumberMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
            this.sessionNumber = receivedMessage.getEncodedResponse() == null ? null : Long.valueOf(receivedMessage.getEncodedResponse().decodeLong());
        }

        @Override
        public int getProtocolMessageId() {
            return 5;
        }
    }

    public static class TargetSendEphemeralIdentityMessage
    extends WaitOrRelayMessage {
        protected TargetSendEphemeralIdentityMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public TargetSendEphemeralIdentityMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 6;
        }
    }

    public static class SourceSendCommitmentMessage
    extends WaitOrRelayMessage {
        protected SourceSendCommitmentMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public SourceSendCommitmentMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 7;
        }
    }

    public static class TargetSeedMessage
    extends WaitOrRelayMessage {
        protected TargetSeedMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public TargetSeedMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 8;
        }
    }

    public static class SourceSasInputMessage
    extends EmptyProtocolMessage {
        private final String sas;
        private final UID deviceUidToKeepActive;

        protected SourceSasInputMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.sas = null;
            this.deviceUidToKeepActive = null;
        }

        public SourceSasInputMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
            if (receivedMessage.getEncodedResponse() == null) {
                this.sas = null;
                this.deviceUidToKeepActive = null;
            } else {
                Encoded[] list = receivedMessage.getEncodedResponse().decodeList();
                if (list.length == 1) {
                    this.sas = list[0].decodeString();
                    this.deviceUidToKeepActive = null;
                } else {
                    this.sas = list[0].decodeString();
                    this.deviceUidToKeepActive = list[1].decodeUid();
                }
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 9;
        }
    }

    public static class SourceDecommitmentMessage
    extends WaitOrRelayMessage {
        protected SourceDecommitmentMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public SourceDecommitmentMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 10;
        }
    }

    public static class TargetWaitForSnapshotMessage
    extends WaitOrRelayMessage {
        protected TargetWaitForSnapshotMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public TargetWaitForSnapshotMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 11;
        }
    }

    public static class SourceSnapshotMessage
    extends WaitOrRelayMessage {
        protected SourceSnapshotMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public SourceSnapshotMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 12;
        }
    }

    public static class SourceWaitForKeycloakAuthenticationProofMessage
    extends WaitOrRelayMessage {
        protected SourceWaitForKeycloakAuthenticationProofMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public SourceWaitForKeycloakAuthenticationProofMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 13;
        }
    }

    public static class TargetRetrieveKeycloakAuthenticationProofMessage
    extends EmptyProtocolMessage {
        private final String signature;
        private final String serializedKeycloakAuthState;

        public TargetRetrieveKeycloakAuthenticationProofMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.signature = null;
            this.serializedKeycloakAuthState = null;
        }

        public TargetRetrieveKeycloakAuthenticationProofMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
            if (receivedMessage.getEncodedResponse() == null) {
                this.signature = null;
                this.serializedKeycloakAuthState = null;
            } else {
                Encoded[] list = receivedMessage.getEncodedResponse().decodeList();
                if (list.length == 2) {
                    this.signature = list[0].decodeString();
                    this.serializedKeycloakAuthState = list[1].decodeString();
                } else {
                    this.signature = null;
                    this.serializedKeycloakAuthState = null;
                }
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 14;
        }
    }

    public static class InitiateTransferOnSourceDeviceStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitiateTransferOnSourceDeviceMessage receivedMessage;

        public InitiateTransferOnSourceDeviceStep(InitialProtocolState startState, InitiateTransferOnSourceDeviceMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UUID dialogUuid = UUID.randomUUID();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.SourceWaitForSessionNumberStep()), dialogUuid));
            ChannelMessageToSend messageToSend = new AbortableOneWayDialogMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferSourceQuery()));
            messageToSend = new SourceGetSessionNumberMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new SourceWaitingForSessionNumberState(dialogUuid);
        }
    }

    public static class InitiateTransferOnTargetDeviceStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitiateTransferOnTargetDeviceMessage receivedMessage;

        public InitiateTransferOnTargetDeviceStep(InitialProtocolState startState, InitiateTransferOnTargetDeviceMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UUID dialogUuid = UUID.randomUUID();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.TargetSessionNumberInput()), dialogUuid));
            ChannelDialogMessageToSend messageToSend = new TargetGetSessionNumberMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new TargetWaitingForSessionNumberState(dialogUuid, this.receivedMessage.deviceName, this.receivedMessage.serverAuthenticationPrivateKey, this.receivedMessage.encryptionPrivateKey, this.receivedMessage.macKey);
        }
    }

    public static class SourceDisplaysSessionNumberStep
    extends ProtocolStep {
        private final SourceWaitingForSessionNumberState startState;
        private final SourceGetSessionNumberMessage receivedMessage;

        public SourceDisplaysSessionNumberStep(SourceWaitingForSessionNumberState startState, SourceGetSessionNumberMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            String ownConnectionIdentifier;
            Long sessionNumber;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UUID dialogUuid = this.startState.dialogUuid;
            if (this.receivedMessage.serializedJsonResponseSource == null) {
                return OwnedIdentityTransferProtocol.failProtocol(this, dialogUuid, 1);
            }
            try {
                JsonResponseSource jsonResponseSource = (JsonResponseSource)this.getJsonObjectMapper().readValue(this.receivedMessage.serializedJsonResponseSource, JsonResponseSource.class);
                sessionNumber = jsonResponseSource.sessionNumber;
                ownConnectionIdentifier = jsonResponseSource.awsConnectionId;
            }
            catch (Exception e) {
                return OwnedIdentityTransferProtocol.failProtocol(this, dialogUuid, 3);
            }
            if (sessionNumber == null || ownConnectionIdentifier == null) {
                return OwnedIdentityTransferProtocol.failProtocol(this, dialogUuid, 1);
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.SourceDisplaySessionNumber(sessionNumber)), dialogUuid));
            ChannelMessageToSend messageToSend = new AbortableOneWayDialogMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferWaitQuery()));
            messageToSend = new SourceWaitForTargetConnectionMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new SourceWaitingForTargetConnectionState(dialogUuid, ownConnectionIdentifier, sessionNumber);
        }
    }

    public static class UserInitiatedAbortProtocolStep
    extends ProtocolStep {
        private final AbortableOneWayDialogMessage receivedMessage;

        public UserInitiatedAbortProtocolStep(SourceWaitingForSessionNumberState startState, AbortableOneWayDialogMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.receivedMessage = receivedMessage;
        }

        public UserInitiatedAbortProtocolStep(SourceWaitingForTargetConnectionState startState, AbortableOneWayDialogMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.receivedMessage = receivedMessage;
        }

        public UserInitiatedAbortProtocolStep(TargetWaitingForTransferredIdentityState startState, AbortableOneWayDialogMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.receivedMessage = receivedMessage;
        }

        public UserInitiatedAbortProtocolStep(SourceWaitingForTargetSeedState startState, AbortableOneWayDialogMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.receivedMessage = receivedMessage;
        }

        public UserInitiatedAbortProtocolStep(TargetWaitingForDecommitmentState startState, AbortableOneWayDialogMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.receivedMessage = receivedMessage;
        }

        public UserInitiatedAbortProtocolStep(TargetWaitingForSnapshotState startState, AbortableOneWayDialogMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            return OwnedIdentityTransferProtocol.userInitiatedAbortProtocol(this, this.receivedMessage.dialogUuid);
        }
    }

    public static class SourceSendsTransferredIdentityAndCommitmentStep
    extends ProtocolStep {
        private final SourceWaitingForTargetConnectionState startState;
        private final SourceWaitForTargetConnectionMessage receivedMessage;

        public SourceSendsTransferredIdentityAndCommitmentStep(SourceWaitingForTargetConnectionState startState, SourceWaitForTargetConnectionMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        private ConcreteProtocolState restartStep(ProtocolManagerSession protocolManagerSession) throws Exception {
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferWaitQuery()));
            ChannelServerQueryMessageToSend messageToSend = new SourceWaitForTargetConnectionMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return this.startState;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            Identity ephemeralIdentity;
            JsonResponse jsonResponse;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.serializedJsonResponse == null) {
                return OwnedIdentityTransferProtocol.failProtocol(this, this.startState.dialogUuid, 1);
            }
            try {
                jsonResponse = (JsonResponse)this.getJsonObjectMapper().readValue(this.receivedMessage.serializedJsonResponse, JsonResponse.class);
                ephemeralIdentity = new Encoded(jsonResponse.payload).decodeIdentity();
            }
            catch (Exception e) {
                Logger.w("OwnedIdentityTransferProtocol.SourceSendsTransferredIdentityAndCommitmentStep failed to parse response");
                return this.restartStep(protocolManagerSession);
            }
            if (jsonResponse.otherConnectionId == null || ephemeralIdentity == null) {
                Logger.w("OwnedIdentityTransferProtocol.SourceSendsTransferredIdentityAndCommitmentStep invalid response");
                return this.restartStep(protocolManagerSession);
            }
            Seed seedSourceForSas = new Seed(this.getPrng());
            Commitment commitmentScheme = Suite.getDefaultCommitment(0);
            Commitment.CommitmentOutput commitmentOutput = commitmentScheme.commit(this.getOwnedIdentity().getBytes(), seedSourceForSas.getBytes(), this.getPrng());
            byte[] cleartextPayload = Encoded.of(new Encoded[]{Encoded.of(this.startState.ownConnectionIdentifier), Encoded.of(this.getOwnedIdentity()), Encoded.of(commitmentOutput.commitment)}).getBytes();
            EncryptedBytes payload = Suite.getPublicKeyEncryption(ephemeralIdentity.getEncryptionPublicKey()).encrypt(ephemeralIdentity.getEncryptionPublicKey(), cleartextPayload, this.getPrng());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferRelayQuery(jsonResponse.otherConnectionId, payload.getBytes(), false)));
            ChannelMessageToSend messageToSend = new SourceSendCommitmentMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.OngoingProtocol()), this.startState.dialogUuid));
            messageToSend = new AbortableOneWayDialogMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new SourceWaitingForTargetSeedState(this.startState.dialogUuid, jsonResponse.otherConnectionId, ephemeralIdentity, seedSourceForSas, commitmentOutput.decommitment, this.startState.sessionNumber);
        }
    }

    public static class TargetProcessesSessionNumberAndSendsEphemeralIdentityStep
    extends ProtocolStep {
        private final TargetWaitingForSessionNumberState startState;
        private final TargetGetSessionNumberMessage receivedMessage;

        public TargetProcessesSessionNumberAndSendsEphemeralIdentityStep(TargetWaitingForSessionNumberState startState, TargetGetSessionNumberMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.sessionNumber == null) {
                return OwnedIdentityTransferProtocol.userInitiatedAbortProtocol(this, this.startState.dialogUuid);
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.OngoingProtocol()), this.startState.dialogUuid));
            ChannelMessageToSend messageToSend = new AbortableOneWayDialogMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferTargetQuery(this.receivedMessage.sessionNumber, Encoded.of(this.getOwnedIdentity()).getBytes())));
            messageToSend = new TargetSendEphemeralIdentityMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new TargetWaitingForTransferredIdentityState(this.startState.dialogUuid, this.startState.deviceName, this.startState.serverAuthenticationPrivateKey, this.startState.encryptionPrivateKey, this.startState.macKey, this.receivedMessage.sessionNumber);
        }
    }

    public static class TargetSendsSeedStep
    extends ProtocolStep {
        private final TargetWaitingForTransferredIdentityState startState;
        private final TargetSendEphemeralIdentityMessage receivedMessage;

        public TargetSendsSeedStep(TargetWaitingForTransferredIdentityState startState, TargetSendEphemeralIdentityMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        private ConcreteProtocolState restartStep(ProtocolManagerSession protocolManagerSession) throws Exception {
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferWaitQuery()));
            ChannelServerQueryMessageToSend messageToSend = new TargetSendEphemeralIdentityMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return this.startState;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            byte[] commitment;
            Identity transferredIdentity;
            String otherConnectionIdentifier;
            JsonResponse jsonResponse;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.serializedJsonResponse == null) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.TargetSessionNumberInput()), this.startState.dialogUuid));
                ChannelDialogMessageToSend messageToSend = new TargetGetSessionNumberMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new TargetWaitingForSessionNumberState(this.startState.dialogUuid, this.startState.deviceName, this.startState.serverAuthenticationPrivateKey, this.startState.encryptionPrivateKey, this.startState.macKey);
            }
            try {
                jsonResponse = (JsonResponse)this.getJsonObjectMapper().readValue(this.receivedMessage.serializedJsonResponse, JsonResponse.class);
            }
            catch (Exception e) {
                Logger.w("OwnedIdentityTransferProtocol.TargetSendsSeedStep failed to parse response");
                return this.restartStep(protocolManagerSession);
            }
            if (jsonResponse.otherConnectionId == null || jsonResponse.payload == null) {
                Logger.w("OwnedIdentityTransferProtocol.TargetSendsSeedStep invalid response");
                return this.restartStep(protocolManagerSession);
            }
            try {
                byte[] cleartextPayload = Suite.getPublicKeyEncryption(this.startState.encryptionPrivateKey).decrypt(this.startState.encryptionPrivateKey, new EncryptedBytes(jsonResponse.payload));
                Encoded[] list = new Encoded(cleartextPayload).decodeList();
                if (list.length != 3) {
                    throw new DecodingException();
                }
                otherConnectionIdentifier = list[0].decodeString();
                transferredIdentity = list[1].decodeIdentity();
                commitment = list[2].decodeBytes();
            }
            catch (Exception e) {
                Logger.w("OwnedIdentityTransferProtocol.TargetSendsSeedStep failed to decrypt and parse response");
                return this.restartStep(protocolManagerSession);
            }
            if (!Objects.equals(otherConnectionIdentifier, jsonResponse.otherConnectionId)) {
                Logger.w("OwnedIdentityTransferProtocol.TargetSendsSeedStep connection identifier mismatch!");
                return this.restartStep(protocolManagerSession);
            }
            if (protocolManagerSession.identityDelegate.isOwnedIdentity(protocolManagerSession.session, transferredIdentity)) {
                Logger.w("OwnedIdentityTransferProtocol: transferred identity is already an owned identity!");
                return OwnedIdentityTransferProtocol.failProtocol(this, this.startState.dialogUuid, 2);
            }
            PrivateIdentity privateIdentity = new PrivateIdentity(this.getOwnedIdentity(), this.startState.serverAuthenticationPrivateKey, this.startState.encryptionPrivateKey, this.startState.macKey);
            Seed seedTargetForSas = privateIdentity.getDeterministicSeedForOwnedIdentity(commitment, IdentityDelegate.DeterministicSeedContext.COMPUTE_TRANSFER_SAS);
            Encoded dataToSend = Encoded.of(new Encoded[]{Encoded.of(this.startState.deviceName), Encoded.of(seedTargetForSas)});
            EncryptedBytes payload = Suite.getPublicKeyEncryption(transferredIdentity.getEncryptionPublicKey()).encrypt(transferredIdentity.getEncryptionPublicKey(), dataToSend.getBytes(), this.getPrng());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferRelayQuery(otherConnectionIdentifier, payload.getBytes(), false)));
            ChannelServerQueryMessageToSend messageToSend = new TargetSeedMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new TargetWaitingForDecommitmentState(this.startState.dialogUuid, this.startState.deviceName, otherConnectionIdentifier, transferredIdentity, commitment, seedTargetForSas, this.startState.serverAuthenticationPrivateKey, this.startState.encryptionPrivateKey, this.startState.macKey, this.startState.sessionNumber);
        }
    }

    public static class SourceSendsDecommitmentAndShowsSasInputStep
    extends ProtocolStep {
        private final SourceWaitingForTargetSeedState startState;
        private final SourceSendCommitmentMessage receivedMessage;

        public SourceSendsDecommitmentAndShowsSasInputStep(SourceWaitingForTargetSeedState startState, SourceSendCommitmentMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        private ConcreteProtocolState restartStep(ProtocolManagerSession protocolManagerSession) throws Exception {
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferWaitQuery()));
            ChannelServerQueryMessageToSend messageToSend = new SourceSendCommitmentMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return this.startState;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            Seed seedTargetForSas;
            String targetDeviceName;
            JsonResponse jsonResponse;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.serializedJsonResponse == null) {
                return OwnedIdentityTransferProtocol.failProtocol(this, this.startState.dialogUuid, 1);
            }
            try {
                jsonResponse = (JsonResponse)this.getJsonObjectMapper().readValue(this.receivedMessage.serializedJsonResponse, JsonResponse.class);
            }
            catch (Exception e) {
                Logger.w("OwnedIdentityTransferProtocol.SourceSendsDecommitmentAndShowsSasInputStep failed to parse response");
                return this.restartStep(protocolManagerSession);
            }
            if (!Objects.equals(jsonResponse.otherConnectionId, this.startState.otherConnectionIdentifier) || jsonResponse.payload == null) {
                Logger.w("OwnedIdentityTransferProtocol.SourceSendsDecommitmentAndShowsSasInputStep invalid response or connectionIdentifier mismatch");
                return this.restartStep(protocolManagerSession);
            }
            try {
                byte[] cleartextPayload = protocolManagerSession.encryptionForIdentityDelegate.decrypt(protocolManagerSession.session, new EncryptedBytes(jsonResponse.payload), this.getOwnedIdentity());
                Encoded[] list = new Encoded(cleartextPayload).decodeList();
                targetDeviceName = list[0].decodeString();
                seedTargetForSas = list[1].decodeSeed();
            }
            catch (Exception e) {
                Logger.w("OwnedIdentityTransferProtocol.SourceSendsDecommitmentAndShowsSasInputStep failed to decrypt and parse response");
                return this.restartStep(protocolManagerSession);
            }
            EncryptedBytes payload = Suite.getPublicKeyEncryption(this.startState.ephemeralIdentity.getEncryptionPublicKey()).encrypt(this.startState.ephemeralIdentity.getEncryptionPublicKey(), this.startState.decommitment, this.getPrng());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferRelayQuery(this.startState.otherConnectionIdentifier, payload.getBytes(), true)));
            ChannelMessageToSend messageToSend = new SourceDecommitmentMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            String fullSas = new String(SAS.computeDouble(this.startState.seedSourceForSas, seedTargetForSas, this.startState.ephemeralIdentity, 4), StandardCharsets.UTF_8);
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.SourceSasInput(fullSas, targetDeviceName)), this.startState.dialogUuid));
            messageToSend = new SourceSasInputMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new SourceWaitingForSasInputState(this.startState.dialogUuid, this.startState.otherConnectionIdentifier, targetDeviceName, this.startState.ephemeralIdentity, fullSas, this.startState.sessionNumber);
        }
    }

    public static class TargetShowsSasStep
    extends ProtocolStep {
        private final TargetWaitingForDecommitmentState startState;
        private final TargetSeedMessage receivedMessage;

        public TargetShowsSasStep(TargetWaitingForDecommitmentState startState, TargetSeedMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        private ConcreteProtocolState restartStep(ProtocolManagerSession protocolManagerSession) throws Exception {
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferWaitQuery()));
            ChannelServerQueryMessageToSend messageToSend = new TargetSeedMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return this.startState;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            byte[] decommitment;
            JsonResponse jsonResponse;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.serializedJsonResponse == null) {
                return OwnedIdentityTransferProtocol.failProtocol(this, this.startState.dialogUuid, 1);
            }
            try {
                jsonResponse = (JsonResponse)this.getJsonObjectMapper().readValue(this.receivedMessage.serializedJsonResponse, JsonResponse.class);
            }
            catch (Exception e) {
                Logger.w("OwnedIdentityTransferProtocol.TargetShowsSasStep failed to parse response");
                return this.restartStep(protocolManagerSession);
            }
            if (!Objects.equals(jsonResponse.otherConnectionId, this.startState.otherConnectionIdentifier) || jsonResponse.payload == null) {
                Logger.w("OwnedIdentityTransferProtocol.TargetShowsSasStep invalid response or connectionIdentifier mismatch");
                return this.restartStep(protocolManagerSession);
            }
            try {
                decommitment = Suite.getPublicKeyEncryption(this.startState.encryptionPrivateKey).decrypt(this.startState.encryptionPrivateKey, new EncryptedBytes(jsonResponse.payload));
                if (decommitment == null) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                Logger.w("OwnedIdentityTransferProtocol.TargetShowsSasStep failed to decrypt and parse response");
                return this.restartStep(protocolManagerSession);
            }
            Commitment commitmentScheme = Suite.getDefaultCommitment(0);
            byte[] opened = commitmentScheme.open(this.startState.transferredIdentity.getBytes(), this.startState.commitment, decommitment);
            if (opened == null) {
                Logger.e("Unable to open commitment.");
                return OwnedIdentityTransferProtocol.failProtocol(this, this.startState.dialogUuid, 3);
            }
            Seed seedSourceForSas = new Seed(opened);
            byte[] fullSas = SAS.computeDouble(seedSourceForSas, this.startState.seedTargetForSas, this.getOwnedIdentity(), 4);
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.TargetShowSas(new String(fullSas, StandardCharsets.UTF_8))), this.startState.dialogUuid));
            ChannelMessageToSend messageToSend = new AbortableOneWayDialogMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferWaitQuery()));
            messageToSend = new TargetWaitForSnapshotMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new TargetWaitingForSnapshotState(this.startState.dialogUuid, this.startState.deviceName, this.startState.otherConnectionIdentifier, this.startState.transferredIdentity, this.startState.serverAuthenticationPrivateKey, this.startState.encryptionPrivateKey, this.startState.macKey, new String(fullSas, StandardCharsets.UTF_8), this.startState.sessionNumber, null);
        }
    }

    public static class SourceCheckSasInputAndSendSnapshotStep
    extends ProtocolStep {
        private final SourceWaitingForSasInputState startState;
        private final SourceSasInputMessage receivedMessage;

        public SourceCheckSasInputAndSendSnapshotStep(SourceWaitingForSasInputState startState, SourceSasInputMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.sas == null) {
                return OwnedIdentityTransferProtocol.userInitiatedAbortProtocol(this, this.startState.dialogUuid);
            }
            if (!Objects.equals(this.receivedMessage.sas, this.startState.fullSas)) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.SourceSasInput(this.startState.fullSas, this.startState.targetDeviceName)), this.startState.dialogUuid));
                ChannelDialogMessageToSend messageToSend = new SourceSasInputMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return this.startState;
            }
            ObvKeycloakState keycloakState = protocolManagerSession.identityDelegate.getOwnedIdentityKeycloakState(protocolManagerSession.session, this.getOwnedIdentity());
            if (keycloakState != null && keycloakState.transferRestricted) {
                JsonKeycloakConfiguration configuration = new JsonKeycloakConfiguration();
                configuration.server = keycloakState.keycloakServer;
                configuration.cid = keycloakState.clientId;
                configuration.secret = keycloakState.clientSecret;
                byte[] dataToSend = this.getJsonObjectMapper().writeValueAsBytes((Object)configuration);
                EncryptedBytes payload = Suite.getPublicKeyEncryption(this.startState.ephemeralIdentity.getEncryptionPublicKey()).encrypt(this.startState.ephemeralIdentity.getEncryptionPublicKey(), dataToSend, this.getPrng());
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferRelayQuery(this.startState.otherConnectionIdentifier, payload.getBytes(), false)));
                ChannelServerQueryMessageToSend messageToSend = new SourceWaitForKeycloakAuthenticationProofMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new SourceWaitForKeycloakAuthenticationProofState(this.startState.dialogUuid, this.startState.otherConnectionIdentifier, this.startState.ephemeralIdentity, this.startState.fullSas, this.startState.sessionNumber, this.receivedMessage.deviceUidToKeepActive);
            }
            OwnedIdentityTransferProtocol.sendSnapshotAndCloseWebsocket(protocolManagerSession, this.getProtocolInstanceUid(), this.getOwnedIdentity(), this.receivedMessage.deviceUidToKeepActive, this.startState.otherConnectionIdentifier, this.startState.ephemeralIdentity, this.startState.dialogUuid, this.getPrng());
            return new FinalState();
        }
    }

    public static class TargetProcessesSnapshotStep
    extends ProtocolStep {
        private static NotificationListener deviceRegisteredNotificationListener = null;
        private static Long deviceRegisteredNotificationListenerNumber = null;
        private final TargetWaitingForSnapshotState startState;
        private final TargetWaitForSnapshotMessage receivedMessage;

        public TargetProcessesSnapshotStep(TargetWaitingForSnapshotState startState, TargetWaitForSnapshotMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        private ConcreteProtocolState restartStep(ProtocolManagerSession protocolManagerSession) throws Exception {
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferWaitQuery()));
            ChannelServerQueryMessageToSend messageToSend = new TargetWaitForSnapshotMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return this.startState;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            UID deviceUidToKeepActive;
            ObvSyncSnapshot syncSnapshot;
            JsonResponse jsonResponse;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.serializedJsonResponse == null) {
                return OwnedIdentityTransferProtocol.failProtocol(this, this.startState.dialogUuid, 1);
            }
            try {
                jsonResponse = (JsonResponse)this.getJsonObjectMapper().readValue(this.receivedMessage.serializedJsonResponse, JsonResponse.class);
            }
            catch (Exception e) {
                Logger.w("OwnedIdentityTransferProtocol.TargetProcessesSnapshotStep failed to parse response");
                return this.restartStep(protocolManagerSession);
            }
            if (!Objects.equals(jsonResponse.otherConnectionId, this.startState.otherConnectionIdentifier) || jsonResponse.payload == null) {
                Logger.w("OwnedIdentityTransferProtocol.TargetProcessesSnapshotStep invalid response or connectionIdentifier mismatch");
                return this.restartStep(protocolManagerSession);
            }
            ObvBackupAndSyncDelegate wrappedIdentityDelegate = protocolManagerSession.identityDelegate.getSyncDelegateWithinTransaction(protocolManagerSession.session);
            byte[] plaintext = null;
            try {
                plaintext = Suite.getPublicKeyEncryption(this.startState.encryptionPrivateKey).decrypt(this.startState.encryptionPrivateKey, new EncryptedBytes(jsonResponse.payload));
                Encoded[] list = new Encoded(plaintext).decodeList();
                syncSnapshot = ObvSyncSnapshot.fromEncodedDictionary(list[0].decodeDictionary(), wrappedIdentityDelegate, protocolManagerSession.appBackupAndSyncDelegate);
                if (syncSnapshot == null) {
                    return OwnedIdentityTransferProtocol.failProtocol(this, this.startState.dialogUuid, 3);
                }
                deviceUidToKeepActive = list.length == 2 ? list[1].decodeUid() : null;
            }
            catch (Exception e) {
                if (plaintext != null) {
                    try {
                        JsonKeycloakConfiguration jsonKeycloakConfiguration = (JsonKeycloakConfiguration)this.getJsonObjectMapper().readValue(plaintext, JsonKeycloakConfiguration.class);
                        if (jsonKeycloakConfiguration != null && jsonKeycloakConfiguration.server != null && jsonKeycloakConfiguration.cid != null) {
                            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.TargetRequestsKeycloakAuthenticationProof(jsonKeycloakConfiguration.server, jsonKeycloakConfiguration.cid, jsonKeycloakConfiguration.secret, this.startState.fullSas, this.startState.sessionNumber)), this.startState.dialogUuid));
                            ChannelDialogMessageToSend messageToSend = new TargetRetrieveKeycloakAuthenticationProofMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                            return new TargetWaitingForKeycloakAuthenticationProofState(this.startState.dialogUuid, this.startState.deviceName, this.startState.otherConnectionIdentifier, this.startState.transferredIdentity, this.startState.serverAuthenticationPrivateKey, this.startState.encryptionPrivateKey, this.startState.macKey, this.startState.fullSas, this.startState.sessionNumber);
                        }
                    }
                    catch (Exception jsonKeycloakConfiguration) {
                        // empty catch block
                    }
                }
                Logger.w("OwnedIdentityTransferProtocol.TargetProcessesSnapshotStep failed to decrypt and parse response");
                return this.restartStep(protocolManagerSession);
            }
            ArrayList<ObvBackupAndSyncDelegate.RestoreFinishedCallback> commitCallbackList = new ArrayList<ObvBackupAndSyncDelegate.RestoreFinishedCallback>();
            protocolManagerSession.session.addSessionCommitListener(() -> {
                for (ObvBackupAndSyncDelegate.RestoreFinishedCallback callback : commitCallbackList) {
                    callback.onRestoreSuccess();
                }
            });
            try {
                List<ObvBackupAndSyncDelegate.RestoreFinishedCallback> callbacks;
                ObvIdentity obvOwnedIdentity;
                ObvSyncSnapshotNode node = syncSnapshot.getSnapshotNode(wrappedIdentityDelegate.getTag());
                if (node instanceof IdentityManagerSyncSnapshot) {
                    obvOwnedIdentity = protocolManagerSession.identityDelegate.restoreTransferredOwnedIdentity(protocolManagerSession.session, this.startState.deviceName, (IdentityManagerSyncSnapshot)node);
                    if (this.startState.serializedKeycloakAuthState != null) {
                        protocolManagerSession.identityDelegate.saveKeycloakAuthState(protocolManagerSession.session, obvOwnedIdentity.getIdentity(), this.startState.serializedKeycloakAuthState);
                    }
                } else {
                    throw new Exception();
                }
                List<ObvBackupAndSyncDelegate.RestoreFinishedCallback> callbacksOwnedIdentity = syncSnapshot.restoreOwnedIdentity(obvOwnedIdentity, wrappedIdentityDelegate, protocolManagerSession.appBackupAndSyncDelegate);
                if (callbacksOwnedIdentity != null && !callbacksOwnedIdentity.isEmpty()) {
                    commitCallbackList.addAll(callbacksOwnedIdentity);
                }
                if ((callbacks = syncSnapshot.restore(wrappedIdentityDelegate, protocolManagerSession.appBackupAndSyncDelegate)) != null && !callbacks.isEmpty()) {
                    commitCallbackList.addAll(callbacks);
                }
            }
            catch (Exception e) {
                for (ObvBackupAndSyncDelegate.RestoreFinishedCallback callback : commitCallbackList) {
                    callback.onRestoreFailure();
                }
                throw e;
            }
            if (deviceUidToKeepActive != null) {
                if (deviceRegisteredNotificationListenerNumber != null) {
                    protocolManagerSession.notificationListeningDelegate.removeListener("network_fetch_notification_push_notification_registered", deviceRegisteredNotificationListenerNumber);
                }
                deviceRegisteredNotificationListener = (notificationName, userInfo) -> {
                    try {
                        if (!Objects.equals(notificationName, "network_fetch_notification_push_notification_registered") || userInfo == null) {
                            return;
                        }
                        Object identity = userInfo.get("owned_identity");
                        if (!(identity instanceof Identity) || !Objects.equals(this.startState.transferredIdentity, identity)) {
                            return;
                        }
                        if (deviceRegisteredNotificationListenerNumber != null) {
                            protocolManagerSession.notificationListeningDelegate.removeListener("network_fetch_notification_push_notification_registered", deviceRegisteredNotificationListenerNumber);
                            deviceRegisteredNotificationListener = null;
                            deviceRegisteredNotificationListenerNumber = null;
                        }
                        protocolManagerSession.protocolStarterDelegate.processDeviceManagementRequest(this.startState.transferredIdentity, ObvDeviceManagementRequest.createSetUnexpiringDeviceRequest(deviceUidToKeepActive.getBytes()));
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                };
                deviceRegisteredNotificationListenerNumber = protocolManagerSession.notificationListeningDelegate.addListener("network_fetch_notification_push_notification_registered", deviceRegisteredNotificationListener);
            }
            try {
                protocolManagerSession.identityDelegate.downloadAllUserData(protocolManagerSession.session);
            }
            catch (Exception e) {
                // empty catch block
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferCloseQuery(false)));
            ChannelMessageToSend messageToSend = new CloseWebSocketMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createTransferDialog(new ObvTransferStep.TargetSnapshotReceived()), this.startState.dialogUuid));
            messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            protocolManagerSession.session.addSessionCommitListener(() -> protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_snapshot_restoration_finished", Collections.emptyMap()));
            return new FinalState();
        }
    }

    public static class SourceCheckTransferProofAndSendSnapshotStep
    extends ProtocolStep {
        private final SourceWaitForKeycloakAuthenticationProofState startState;
        private final SourceWaitForKeycloakAuthenticationProofMessage receivedMessage;

        public SourceCheckTransferProofAndSendSnapshotStep(SourceWaitForKeycloakAuthenticationProofState startState, SourceWaitForKeycloakAuthenticationProofMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        private ConcreteProtocolState restartStep(ProtocolManagerSession protocolManagerSession) throws Exception {
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferWaitQuery()));
            ChannelServerQueryMessageToSend messageToSend = new SourceWaitForKeycloakAuthenticationProofMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return this.startState;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            String signature;
            JsonResponse jsonResponse;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.serializedJsonResponse == null) {
                return OwnedIdentityTransferProtocol.failProtocol(this, this.startState.dialogUuid, 1);
            }
            try {
                jsonResponse = (JsonResponse)this.getJsonObjectMapper().readValue(this.receivedMessage.serializedJsonResponse, JsonResponse.class);
                byte[] cleartextPayload = protocolManagerSession.encryptionForIdentityDelegate.decrypt(protocolManagerSession.session, new EncryptedBytes(jsonResponse.payload), this.getOwnedIdentity());
                signature = new String(cleartextPayload, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                Logger.w("OwnedIdentityTransferProtocol.SourceCheckTransferProofAndSendSnapshotStep failed to parse response");
                return this.restartStep(protocolManagerSession);
            }
            if (!Objects.equals(jsonResponse.otherConnectionId, this.startState.otherConnectionIdentifier)) {
                Logger.w("OwnedIdentityTransferProtocol.SourceCheckTransferProofAndSendSnapshotStep invalid response");
                return this.restartStep(protocolManagerSession);
            }
            try {
                String signedContent = protocolManagerSession.identityDelegate.verifyKeycloakSignature(protocolManagerSession.session, this.getOwnedIdentity(), signature);
                JsonTransferProof transferProof = (JsonTransferProof)this.getJsonObjectMapper().readValue(signedContent, JsonTransferProof.class);
                String keycloakUserId = protocolManagerSession.identityDelegate.getOwnedIdentityKeycloakUserId(protocolManagerSession.session, this.getOwnedIdentity());
                if (!(Objects.equals(transferProof.session_id, String.format(Locale.ENGLISH, "%08d", this.startState.sessionNumber)) && Objects.equals(transferProof.sas, this.startState.fullSas) && Arrays.equals(transferProof.identity, this.getOwnedIdentity().getBytes()) && Objects.equals(transferProof.keycloak_id, keycloakUserId))) {
                    return OwnedIdentityTransferProtocol.failProtocol(this, this.startState.dialogUuid, 3);
                }
            }
            catch (Exception ignored) {
                return OwnedIdentityTransferProtocol.failProtocol(this, this.startState.dialogUuid, 3);
            }
            OwnedIdentityTransferProtocol.sendSnapshotAndCloseWebsocket(protocolManagerSession, this.getProtocolInstanceUid(), this.getOwnedIdentity(), this.startState.deviceUidToKeepActive, this.startState.otherConnectionIdentifier, this.startState.ephemeralIdentity, this.startState.dialogUuid, this.getPrng());
            return new FinalState();
        }
    }

    public static class TargetSendKeycloakAuthenticationProofStep
    extends ProtocolStep {
        private final TargetWaitingForKeycloakAuthenticationProofState startState;
        private final TargetRetrieveKeycloakAuthenticationProofMessage receivedMessage;

        public TargetSendKeycloakAuthenticationProofStep(TargetWaitingForKeycloakAuthenticationProofState startState, TargetRetrieveKeycloakAuthenticationProofMessage receivedMessage, OwnedIdentityTransferProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.signature == null) {
                return OwnedIdentityTransferProtocol.failProtocol(this, this.startState.dialogUuid, 3);
            }
            EncryptedBytes payload = Suite.getPublicKeyEncryption(this.startState.transferredIdentity.getEncryptionPublicKey()).encrypt(this.startState.transferredIdentity.getEncryptionPublicKey(), this.receivedMessage.signature.getBytes(StandardCharsets.UTF_8), this.getPrng());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.TransferRelayQuery(this.startState.otherConnectionIdentifier, payload.getBytes(), false)));
            ChannelServerQueryMessageToSend messageToSend = new TargetWaitForSnapshotMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new TargetWaitingForSnapshotState(this.startState.dialogUuid, this.startState.deviceName, this.startState.otherConnectionIdentifier, this.startState.transferredIdentity, this.startState.serverAuthenticationPrivateKey, this.startState.encryptionPrivateKey, this.startState.macKey, this.startState.fullSas, this.startState.sessionNumber, this.receivedMessage.serializedKeycloakAuthState);
        }
    }

    public static class CloseWebSocketMessage
    extends EmptyProtocolMessage {
        protected CloseWebSocketMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return -1;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonTransferProof {
        public String session_id;
        public String sas;
        public byte[] identity;
        public String keycloak_id;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonKeycloakConfiguration {
        public String server;
        public String cid;
        public String secret;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonResponse {
        public String otherConnectionId;
        public byte[] payload;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonResponseSource {
        public String awsConnectionId;
        public Long sessionNumber;
    }

    public static abstract class WaitOrRelayMessage
    extends EmptyProtocolMessage {
        protected final String serializedJsonResponse;

        protected WaitOrRelayMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.serializedJsonResponse = null;
        }

        public WaitOrRelayMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
            this.serializedJsonResponse = receivedMessage.getEncodedResponse() == null ? null : receivedMessage.getEncodedResponse().decodeString();
        }
    }
}

