/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.GroupMembersChangedCallback;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.Group;
import io.olvid.engine.datatypes.containers.GroupInformation;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.containers.GroupWithDetails;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.engine.protocol.databases.IdentityDeletionSignatureReceived;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.EmptyProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.ContactManagementProtocol;
import io.olvid.engine.protocol.protocols.GroupManagementProtocol;
import io.olvid.engine.protocol.protocols.GroupsV2Protocol;
import io.olvid.engine.protocol.protocols.OwnedDeviceDiscoveryProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class OwnedIdentityDeletionProtocol
extends ConcreteProtocol {
    public static final int FINISHED_STATED_ID = 1;
    public static final int UNREGISTERING_FROM_SERVER_STATE_ID = 2;
    static final int INITIAL_MESSAGE_ID = 0;
    static final int CONTACT_OWNED_IDENTITY_WAS_DELETED_MESSAGE_ID = 1;
    static final int PROPAGATE_OWNED_IDENTITY_DELETED_MESSAGE_ID = 2;
    static final int SKIP_SERVER_QUERY_MESSAGE_ID = 3;
    static final int DEACTIVATE_CURRENT_DEVICE_SERVER_QUERY_MESSAGE_ID = 4;

    public OwnedIdentityDeletionProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 20;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{1};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return FinishedProtocolState.class;
            }
            case 2: {
                return UnregisteringFromServerState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return ContactOwnedIdentityWasDeletedMessage.class;
            }
            case 2: {
                return PropagateOwnedIdentityDeletedMessage.class;
            }
            case 3: {
                return SkipServerQueryMessage.class;
            }
            case 4: {
                return DeactivateCurrentDeviceServerQueryMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{StartDeletionStep.class, ProcessContactOwnedIdentityWasDeletedMessageStep.class};
            }
            case 2: {
                return new Class[]{FinalizeDeletionStep.class};
            }
        }
        return new Class[0];
    }

    public static class FinishedProtocolState
    extends ConcreteProtocolState {
        public FinishedProtocolState() {
            super(2);
        }

        public FinishedProtocolState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class UnregisteringFromServerState
    extends ConcreteProtocolState {
        private final boolean deleteEverywhere;
        private final boolean propagated;

        public UnregisteringFromServerState(boolean deleteEverywhere, boolean propagated) {
            super(2);
            this.deleteEverywhere = deleteEverywhere;
            this.propagated = propagated;
        }

        public UnregisteringFromServerState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 2) {
                throw new Exception();
            }
            this.deleteEverywhere = list[0].decodeBoolean();
            this.propagated = list[1].decodeBoolean();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.deleteEverywhere), Encoded.of(this.propagated)});
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        protected final boolean deleteEverywhere;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, boolean deleteEverywhere) {
            super(coreProtocolMessage);
            this.deleteEverywhere = deleteEverywhere;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.deleteEverywhere = receivedMessage.getInputs()[0].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.deleteEverywhere)};
        }
    }

    public static class ContactOwnedIdentityWasDeletedMessage
    extends ConcreteProtocolMessage {
        private final Identity deletedContactOwnedIdentity;
        private final byte[] signature;

        public ContactOwnedIdentityWasDeletedMessage(CoreProtocolMessage coreProtocolMessage, Identity deletedContactOwnedIdentity, byte[] signature) {
            super(coreProtocolMessage);
            this.deletedContactOwnedIdentity = deletedContactOwnedIdentity;
            this.signature = signature;
        }

        public ContactOwnedIdentityWasDeletedMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] inputs = receivedMessage.getInputs();
            if (inputs.length != 2) {
                throw new Exception();
            }
            this.deletedContactOwnedIdentity = inputs[0].decodeIdentity();
            this.signature = inputs[1].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.deletedContactOwnedIdentity), Encoded.of(this.signature)};
        }
    }

    public static class PropagateOwnedIdentityDeletedMessage
    extends EmptyProtocolMessage {
        public PropagateOwnedIdentityDeletedMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public PropagateOwnedIdentityDeletedMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }
    }

    public static class SkipServerQueryMessage
    extends EmptyProtocolMessage {
        public SkipServerQueryMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public SkipServerQueryMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }
    }

    public static class DeactivateCurrentDeviceServerQueryMessage
    extends EmptyProtocolMessage {
        public DeactivateCurrentDeviceServerQueryMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public DeactivateCurrentDeviceServerQueryMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }
    }

    public static class StartDeletionStep
    extends ProtocolStep {
        InitialProtocolState startState;
        boolean deleteEverywhere;
        boolean propagated;

        public StartDeletionStep(InitialProtocolState startState, InitialMessage receivedMessage, OwnedIdentityDeletionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.deleteEverywhere = receivedMessage.deleteEverywhere;
            this.propagated = false;
        }

        public StartDeletionStep(InitialProtocolState startState, PropagateOwnedIdentityDeletedMessage receivedMessage, OwnedIdentityDeletionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.deleteEverywhere = true;
            this.propagated = true;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            boolean ownedIdentityIsActive = protocolManagerSession.identityDelegate.isActiveOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            if (!ownedIdentityIsActive && !this.propagated && this.deleteEverywhere) {
                Logger.e("Error: running OwnedIdentityDeletionProtocol.StartDeletionStep with deleteEverywhere and an inactive identity.");
                throw new Exception();
            }
            protocolManagerSession.engineOwnedIdentityCleanupDelegate.deleteOwnedIdentityFromInboxOutboxProtocolsAndDialogs(protocolManagerSession.session, this.getOwnedIdentity(), this.getProtocolInstanceUid());
            protocolManagerSession.identityDelegate.markOwnedIdentityForDeletion(protocolManagerSession.session, this.getOwnedIdentity());
            if (ownedIdentityIsActive) {
                int numberOfOtherDevices;
                UID currentDeviceUid = protocolManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.DeviceManagementDeactivateDeviceQuery(this.getOwnedIdentity(), currentDeviceUid)));
                ChannelMessageToSend messageToSend = new DeactivateCurrentDeviceServerQueryMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                if (!this.propagated && this.deleteEverywhere && (numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                    try {
                        coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                        messageToSend = new PropagateOwnedIdentityDeletedMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (NoAcceptableChannelException coreProtocolMessage2) {}
                }
            } else {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new SkipServerQueryMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new UnregisteringFromServerState(this.deleteEverywhere, this.propagated);
        }
    }

    public static class ProcessContactOwnedIdentityWasDeletedMessageStep
    extends ProtocolStep {
        InitialProtocolState startState;
        ContactOwnedIdentityWasDeletedMessage receivedMessage;
        boolean propagated;

        public ProcessContactOwnedIdentityWasDeletedMessageStep(InitialProtocolState startState, ContactOwnedIdentityWasDeletedMessage receivedMessage, OwnedIdentityDeletionProtocol protocol) throws Exception {
            super(receivedMessage.getReceptionChannelInfo().getChannelType() == 2 ? ReceptionChannelInfo.createAsymmetricChannelInfo() : ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagated = receivedMessage.getReceptionChannelInfo().getChannelType() != 2;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (IdentityDeletionSignatureReceived.exists(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature)) {
                Logger.w("Received a ContactOwnedIdentityWasDeletedMessage with a known signature");
                return new FinishedProtocolState();
            }
            if (!Signature.verify(Constants.SignatureContext.OWNED_IDENTITY_DELETION, this.getOwnedIdentity().getBytes(), this.receivedMessage.deletedContactOwnedIdentity, this.receivedMessage.signature)) {
                Logger.w("Received a ContactOwnedIdentityWasDeletedMessage with an invalid signature");
                return new FinishedProtocolState();
            }
            IdentityDeletionSignatureReceived.create(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature);
            if (!this.propagated && (numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new ContactOwnedIdentityWasDeletedMessage(coreProtocolMessage, this.receivedMessage.deletedContactOwnedIdentity, this.receivedMessage.signature).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            protocolManagerSession.channelDelegate.deleteObliviousChannelsWithContact(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.deletedContactOwnedIdentity);
            ArrayList groupOwnerAndUids = new ArrayList(Arrays.asList(protocolManagerSession.identityDelegate.getGroupOwnerAndUidOfGroupsWhereContactIsPending(protocolManagerSession.session, this.receivedMessage.deletedContactOwnedIdentity, this.getOwnedIdentity())));
            groupOwnerAndUids.addAll(Arrays.asList(protocolManagerSession.identityDelegate.getGroupOwnerAndUidsOfGroupsContainingContact(protocolManagerSession.session, this.receivedMessage.deletedContactOwnedIdentity, this.getOwnedIdentity())));
            for (byte[] groupOwnerAndUid : groupOwnerAndUids) {
                Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), groupOwnerAndUid);
                if (!this.propagated && group.getGroupOwner() == null) {
                    GroupInformation groupInformation = protocolManagerSession.identityDelegate.getGroupInformation(protocolManagerSession.session, this.getOwnedIdentity(), groupOwnerAndUid);
                    GroupMembersChangedCallback groupMembersChangedCallback = () -> {
                        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 9, groupInformation.computeProtocolUid());
                        ChannelProtocolMessageToSend messageToSend = new GroupManagementProtocol.GroupMembersOrDetailsChangedTriggerMessage(coreProtocolMessage, groupInformation).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    };
                    protocolManagerSession.identityDelegate.removeMembersAndPendingFromGroup(protocolManagerSession.session, groupOwnerAndUid, this.getOwnedIdentity(), new Identity[]{this.receivedMessage.deletedContactOwnedIdentity}, groupMembersChangedCallback);
                    continue;
                }
                if (this.receivedMessage.deletedContactOwnedIdentity.equals(group.getGroupOwner())) {
                    protocolManagerSession.identityDelegate.leaveGroup(protocolManagerSession.session, groupOwnerAndUid, this.getOwnedIdentity());
                    continue;
                }
                protocolManagerSession.identityDelegate.forcefullyRemoveMemberOrPendingFromJoinedGroup(protocolManagerSession.session, this.getOwnedIdentity(), groupOwnerAndUid, this.receivedMessage.deletedContactOwnedIdentity);
            }
            for (GroupV2.IdentifierAndAdminStatus identifierAndAdminStatus : protocolManagerSession.identityDelegate.getServerGroupsV2IdentifierAndMyAdminStatusForContact(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.deletedContactOwnedIdentity)) {
                if (!this.propagated && identifierAndAdminStatus.iAmAdmin) {
                    ObvGroupV2.ObvGroupV2ChangeSet changeSet = new ObvGroupV2.ObvGroupV2ChangeSet();
                    changeSet.removedMembers.add(this.receivedMessage.deletedContactOwnedIdentity.getBytes());
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 18, identifierAndAdminStatus.groupIdentifier.computeProtocolInstanceUid());
                    ChannelProtocolMessageToSend messageToSend = new GroupsV2Protocol.GroupUpdateInitialMessage(coreProtocolMessage, identifierAndAdminStatus.groupIdentifier, changeSet).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                protocolManagerSession.identityDelegate.forcefullyRemoveMemberOrPendingFromNonAdminGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), identifierAndAdminStatus.groupIdentifier, this.receivedMessage.deletedContactOwnedIdentity);
            }
            protocolManagerSession.identityDelegate.deleteContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.deletedContactOwnedIdentity, false);
            return new FinishedProtocolState();
        }
    }

    public static class FinalizeDeletionStep
    extends ProtocolStep {
        UnregisteringFromServerState startState;

        public FinalizeDeletionStep(UnregisteringFromServerState startState, DeactivateCurrentDeviceServerQueryMessage receivedMessage, OwnedIdentityDeletionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
        }

        public FinalizeDeletionStep(UnregisteringFromServerState startState, SkipServerQueryMessage receivedMessage, OwnedIdentityDeletionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ChannelMessageToSend messageToSend;
            CoreProtocolMessage coreProtocolMessage3;
            byte[] signature2;
            Identity[] contactIdentities;
            Object messageToSend22;
            Object coreProtocolMessage22;
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            boolean ownedIdentityIsActive = protocolManagerSession.identityDelegate.isActiveOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            if (ownedIdentityIsActive && !this.startState.propagated && !this.startState.deleteEverywhere && (numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    coreProtocolMessage22 = new CoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()), 21, new UID(this.getPrng()));
                    messageToSend22 = new OwnedDeviceDiscoveryProtocol.TriggerOwnedDeviceDiscoveryMessage((CoreProtocolMessage)coreProtocolMessage22).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, (ChannelMessageToSend)messageToSend22, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage22) {
                    // empty catch block
                }
            }
            if (ownedIdentityIsActive && !this.startState.propagated && (contactIdentities = protocolManagerSession.identityDelegate.getContactsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity())).length > 0) {
                if (this.startState.deleteEverywhere) {
                    coreProtocolMessage22 = contactIdentities;
                    int messageToSend22 = ((Identity[])coreProtocolMessage22).length;
                    for (var6_12 = 0; var6_12 < messageToSend22; ++var6_12) {
                        Identity contactIdentity = coreProtocolMessage22[var6_12];
                        try {
                            signature2 = protocolManagerSession.identityDelegate.signBlock(protocolManagerSession.session, Constants.SignatureContext.OWNED_IDENTITY_DELETION, contactIdentity.getBytes(), this.getOwnedIdentity(), this.getPrng());
                            coreProtocolMessage3 = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(contactIdentity, this.getOwnedIdentity()));
                            messageToSend = new ContactOwnedIdentityWasDeletedMessage(coreProtocolMessage3, this.getOwnedIdentity(), signature2).generateChannelProtocolMessageToSend();
                            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                            continue;
                        }
                        catch (Exception signature2) {
                            // empty catch block
                        }
                    }
                } else {
                    SendChannelInfo[] sendChannelInfos;
                    messageToSend22 = sendChannelInfos = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(contactIdentities, this.getOwnedIdentity());
                    var6_12 = ((SendChannelInfo[])messageToSend22).length;
                    for (int contactIdentity = 0; contactIdentity < var6_12; ++contactIdentity) {
                        SendChannelInfo sendChannelInfo = messageToSend22[contactIdentity];
                        try {
                            coreProtocolMessage3 = new CoreProtocolMessage(sendChannelInfo, 10, new UID(this.getPrng()));
                            messageToSend = new ContactManagementProtocol.PerformContactDeviceDiscoveryMessage(coreProtocolMessage3).generateChannelProtocolMessageToSend();
                            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                            continue;
                        }
                        catch (Exception coreProtocolMessage3) {
                            // empty catch block
                        }
                    }
                }
            }
            if (ownedIdentityIsActive && !this.startState.propagated && this.startState.deleteEverywhere) {
                ChannelProtocolMessageToSend messageToSend3;
                CoreProtocolMessage coreProtocolMessage42;
                GroupWithDetails[] groups = protocolManagerSession.identityDelegate.getGroupsForOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
                for (GroupWithDetails group : groups) {
                    GroupInformation groupInformation = protocolManagerSession.identityDelegate.getGroupInformation(protocolManagerSession.session, this.getOwnedIdentity(), group.getGroupOwnerAndUid());
                    UID protocolInstanceUid = groupInformation.computeProtocolUid();
                    if (group.getGroupOwner() == null) {
                        SendChannelInfo[] sendChannelInfos;
                        if (group.getGroupMembers().length > 0) {
                            SendChannelInfo[] sendChannelInfos2;
                            for (SendChannelInfo sendChannelInfo : sendChannelInfos2 = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(group.getGroupMembers(), this.getOwnedIdentity())) {
                                try {
                                    CoreProtocolMessage coreProtocolMessage5 = new CoreProtocolMessage(sendChannelInfo, 9, protocolInstanceUid);
                                    ChannelProtocolMessageToSend messageToSend4 = new GroupManagementProtocol.KickFromGroupMessage(coreProtocolMessage5, groupInformation).generateChannelProtocolMessageToSend();
                                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend4, this.getPrng());
                                }
                                catch (Exception coreProtocolMessage5) {
                                    // empty catch block
                                }
                            }
                        }
                        if (group.getPendingGroupMembers().length <= 0) continue;
                        Identity[] pendingMemberIdentities = new Identity[group.getPendingGroupMembers().length];
                        for (int i = 0; i < pendingMemberIdentities.length; ++i) {
                            pendingMemberIdentities[i] = group.getPendingGroupMembers()[i].identity;
                        }
                        for (SendChannelInfo sendChannelInfo : sendChannelInfos = SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfoForMultipleIdentities(pendingMemberIdentities, this.getOwnedIdentity())) {
                            try {
                                coreProtocolMessage42 = new CoreProtocolMessage(sendChannelInfo, 9, protocolInstanceUid);
                                messageToSend3 = new GroupManagementProtocol.KickFromGroupMessage(coreProtocolMessage42, groupInformation).generateChannelProtocolMessageToSend();
                                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend3, this.getPrng());
                            }
                            catch (Exception coreProtocolMessage42) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    try {
                        CoreProtocolMessage coreProtocolMessage6 = new CoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(group.getGroupOwner(), this.getOwnedIdentity()), 9, protocolInstanceUid);
                        ChannelProtocolMessageToSend message = new GroupManagementProtocol.NotifyGroupLeftMessage(coreProtocolMessage6, groupInformation).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.getPrng());
                    }
                    catch (Exception coreProtocolMessage6) {
                        // empty catch block
                    }
                }
                List<ObvGroupV2> groupsV2 = protocolManagerSession.identityDelegate.getObvGroupsV2ForOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
                for (ObvGroupV2 groupV2 : groupsV2) {
                    if (groupV2.groupIdentifier.category != 0) continue;
                    try {
                        boolean iAmTheOnlyAdmin;
                        if (groupV2.ownPermissions.contains((Object)GroupV2.Permission.GROUP_ADMIN)) {
                            iAmTheOnlyAdmin = true;
                            for (ObvGroupV2.ObvGroupV2Member member : groupV2.otherGroupMembers) {
                                if (!member.permissions.contains((Object)GroupV2.Permission.GROUP_ADMIN)) continue;
                                iAmTheOnlyAdmin = false;
                                break;
                            }
                        } else {
                            iAmTheOnlyAdmin = false;
                        }
                        if (iAmTheOnlyAdmin) {
                            GroupV2.BlobKeys blobKeys = protocolManagerSession.identityDelegate.getGroupV2BlobKeys(protocolManagerSession.session, this.getOwnedIdentity(), groupV2.groupIdentifier);
                            signature2 = Signature.sign(Constants.SignatureContext.GROUP_DELETE_ON_SERVER, blobKeys.groupAdminServerAuthenticationPrivateKey.getSignaturePrivateKey(), this.getPrng());
                            coreProtocolMessage3 = new CoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.DeleteGroupBlobQuery(groupV2.groupIdentifier, signature2)), 18, new UID(this.getPrng()));
                            messageToSend = new GroupsV2Protocol.DeleteGroupBlobFromServerMessage(coreProtocolMessage3).generateChannelServerQueryMessageToSend();
                            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                            byte[] chainPlaintext = protocolManagerSession.identityDelegate.getGroupV2AdministratorsChain(protocolManagerSession.session, this.getOwnedIdentity(), groupV2.groupIdentifier).encode().getBytes();
                            AuthEncKey encryptionKey = (AuthEncKey)Suite.getKDF("kdf_sha-256").gen(blobKeys.blobMainSeed, Suite.getDefaultAuthEnc(0).getKDFDelegate())[0];
                            EncryptedBytes encryptedChain = Suite.getAuthEnc(encryptionKey).encrypt(encryptionKey, chainPlaintext, this.getPrng());
                            GroupV2.ServerBlob serverBlob = protocolManagerSession.identityDelegate.getGroupV2ServerBlob(protocolManagerSession.session, this.getOwnedIdentity(), groupV2.groupIdentifier);
                            for (GroupV2.IdentityAndPermissionsAndDetails member : serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                                if (member.identity.equals(this.getOwnedIdentity())) continue;
                                byte[] dataToSign = new byte[encryptedChain.length + member.groupInvitationNonce.length];
                                System.arraycopy(encryptedChain.getBytes(), 0, dataToSign, 0, encryptedChain.length);
                                System.arraycopy(member.groupInvitationNonce, 0, dataToSign, encryptedChain.length, member.groupInvitationNonce.length);
                                byte[] signature3 = protocolManagerSession.identityDelegate.signBlock(protocolManagerSession.session, Constants.SignatureContext.GROUP_KICK, dataToSign, this.getOwnedIdentity(), this.getPrng());
                                coreProtocolMessage42 = new CoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(member.identity, this.getOwnedIdentity()), 18, groupV2.groupIdentifier.computeProtocolInstanceUid());
                                messageToSend3 = new GroupsV2Protocol.KickMessage(coreProtocolMessage42, groupV2.groupIdentifier, encryptedChain, signature3).generateChannelProtocolMessageToSend();
                                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend3, this.getPrng());
                            }
                            continue;
                        }
                        byte[] ownGroupInvitationNonce = protocolManagerSession.identityDelegate.getGroupV2OwnGroupInvitationNonce(protocolManagerSession.session, this.getOwnedIdentity(), groupV2.groupIdentifier);
                        if (ownGroupInvitationNonce == null) continue;
                        byte[] leaveSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_LEAVE_NONCE, groupV2.groupIdentifier, ownGroupInvitationNonce, null, this.getOwnedIdentity(), this.getPrng());
                        coreProtocolMessage3 = new CoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.PutGroupLogQuery(groupV2.groupIdentifier, leaveSignature)), 18, new UID(this.getPrng()));
                        messageToSend = new GroupsV2Protocol.PutGroupLogOnServerMessage(coreProtocolMessage3).generateChannelServerQueryMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (Exception exception) {}
                }
            }
            protocolManagerSession.engineOwnedIdentityCleanupDelegate.deleteOwnedIdentityServerSession(protocolManagerSession.session, this.getOwnedIdentity());
            protocolManagerSession.channelDelegate.deleteAllChannelsForOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            protocolManagerSession.identityDelegate.deleteOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            if (this.startState.propagated) {
                protocolManagerSession.session.addSessionCommitListener(() -> {
                    HashMap<String, Object> userInfo = new HashMap<String, Object>();
                    userInfo.put("owned_identity", this.getOwnedIdentity());
                    protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_owned_identity_deleted_from_another_device", userInfo);
                });
            }
            return new FinishedProtocolState();
        }
    }
}

