/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.PreKeyBlobOnServer;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.datatypes.containers.TrustOrigin;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.engine.protocol.databases.LinkBetweenProtocolInstances;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.ChildToParentProtocolMessageInputs;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.DeviceDiscoveryChildProtocol;
import io.olvid.engine.protocol.protocols.DeviceDiscoveryProtocol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;

public class KeycloakContactAdditionProtocol
extends ConcreteProtocol {
    public static final int WAITING_FOR_DEVICE_DISCOVERY_STATED_ID = 1;
    public static final int WAITING_FOR_CONFIRMATION_STATE_ID = 2;
    public static final int CHECKING_FOR_REVOCATION_STATE_ID = 3;
    public static final int FINISHED_STATE_ID = 4;
    static final int INITIAL_MESSAGE_ID = 0;
    static final int DEVICE_DISCOVERY_DONE_MESSAGE_ID = 1;
    static final int PROPAGATE_CONTACT_ADDITION_TO_OTHER_DEVICES_MESSAGE_ID = 2;
    static final int INVITE_KEYCLOAK_CONTACT_MESSAGE_ID = 3;
    static final int CHECK_FOR_REVOCATION_SERVER_QUERY_MESSAGE_ID = 4;
    static final int CONFIRMATION_MESSAGE_ID = 5;

    public KeycloakContactAdditionProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
        this.requiresProtocolInstanceToBeInsertedBeforeInitialStep = true;
    }

    @Override
    public int getProtocolId() {
        return 15;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{4};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return WaitingForDeviceDiscoveryState.class;
            }
            case 2: {
                return WaitingForConfirmationState.class;
            }
            case 3: {
                return CheckingForRevocationState.class;
            }
            case 4: {
                return FinishedProtocolState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return DeviceDiscoveryDoneMessage.class;
            }
            case 2: {
                return PropagateContactAdditionToOtherDevicesMessage.class;
            }
            case 3: {
                return InviteKeycloakContactMessage.class;
            }
            case 4: {
                return CheckForRevocationServerQueryMessage.class;
            }
            case 5: {
                return ConfirmationMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{VerifyContactAndStartDeviceDiscoveryStep.class, ProcessPropagatedContactAdditionStep.class, ProcessReceivedKeycloakInviteStep.class};
            }
            case 1: {
                return new Class[]{AddContactAndSendRequestStep.class};
            }
            case 2: {
                return new Class[]{ProcessConfirmationStep.class};
            }
            case 3: {
                return new Class[]{AddContactAndSendConfirmationStep.class};
            }
        }
        return new Class[0];
    }

    public static class WaitingForDeviceDiscoveryState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final String contactSerializedDetails;
        private final String keycloakServerUrl;
        private final String signedOwnedDetails;

        public WaitingForDeviceDiscoveryState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 4) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.contactSerializedDetails = list[1].decodeString();
            this.keycloakServerUrl = list[2].decodeString();
            this.signedOwnedDetails = list[3].decodeString();
        }

        public WaitingForDeviceDiscoveryState(Identity contactIdentity, String contactSerializedDetails, String keycloakServerUrl, String signedOwnedDetails) {
            super(1);
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
            this.keycloakServerUrl = keycloakServerUrl;
            this.signedOwnedDetails = signedOwnedDetails;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails), Encoded.of(this.keycloakServerUrl), Encoded.of(this.signedOwnedDetails)});
        }
    }

    public static class WaitingForConfirmationState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final String keycloakServerUrl;

        public WaitingForConfirmationState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 2) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.keycloakServerUrl = list[1].decodeString();
        }

        public WaitingForConfirmationState(Identity contactIdentity, String keycloakServerUrl) {
            super(2);
            this.contactIdentity = contactIdentity;
            this.keycloakServerUrl = keycloakServerUrl;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.keycloakServerUrl)});
        }
    }

    public static class CheckingForRevocationState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final String contactSerializedDetails;
        private final UID[] contactDeviceUids;
        private final String keycloakServerUrl;

        public CheckingForRevocationState(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 4) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.contactSerializedDetails = list[1].decodeString();
            this.contactDeviceUids = list[2].decodeUidArray();
            this.keycloakServerUrl = list[3].decodeString();
        }

        public CheckingForRevocationState(Identity contactIdentity, String contactSerializedDetails, UID[] contactDeviceUids, String keycloakServerUrl) {
            super(3);
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
            this.contactDeviceUids = contactDeviceUids;
            this.keycloakServerUrl = keycloakServerUrl;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails), Encoded.of(this.contactDeviceUids), Encoded.of(this.keycloakServerUrl)});
        }
    }

    public static class FinishedProtocolState
    extends ConcreteProtocolState {
        public FinishedProtocolState(Encoded encodedState) throws Exception {
            super(4);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public FinishedProtocolState() {
            super(4);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final String signedContactDetails;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, String signedContactDetails) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.signedContactDetails = signedContactDetails;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.signedContactDetails = receivedMessage.getInputs()[1].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.signedContactDetails)};
        }
    }

    public static class DeviceDiscoveryDoneMessage
    extends ConcreteProtocolMessage {
        private final ChildToParentProtocolMessageInputs childToParentProtocolMessageInputs;

        public DeviceDiscoveryDoneMessage(CoreProtocolMessage coreProtocolMessage, ChildToParentProtocolMessageInputs childToParentProtocolMessageInputs) {
            super(coreProtocolMessage);
            this.childToParentProtocolMessageInputs = childToParentProtocolMessageInputs;
        }

        public DeviceDiscoveryDoneMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 3) {
                throw new Exception();
            }
            this.childToParentProtocolMessageInputs = new ChildToParentProtocolMessageInputs(receivedMessage.getInputs());
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }

        public DeviceDiscoveryChildProtocol.DeviceUidsReceivedState getDeviceUidsReceivedState() {
            try {
                return new DeviceDiscoveryChildProtocol.DeviceUidsReceivedState(this.childToParentProtocolMessageInputs.getChildProtocolEncodedState());
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class PropagateContactAdditionToOtherDevicesMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final String keycloakServerUrl;
        private final String contactSerializedDetails;
        private final UID[] contactDeviceUids;
        private final long trustTimestamp;

        public PropagateContactAdditionToOtherDevicesMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, String keycloakServerUrl, String contactSerializedDetails, UID[] contactDeviceUids, long trustTimestamp) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.keycloakServerUrl = keycloakServerUrl;
            this.contactSerializedDetails = contactSerializedDetails;
            this.contactDeviceUids = contactDeviceUids;
            this.trustTimestamp = trustTimestamp;
        }

        public PropagateContactAdditionToOtherDevicesMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 5) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.keycloakServerUrl = receivedMessage.getInputs()[1].decodeString();
            this.contactSerializedDetails = receivedMessage.getInputs()[2].decodeString();
            this.contactDeviceUids = receivedMessage.getInputs()[3].decodeUidArray();
            this.trustTimestamp = receivedMessage.getInputs()[4].decodeLong();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.keycloakServerUrl), Encoded.of(this.contactSerializedDetails), Encoded.of(this.contactDeviceUids), Encoded.of(this.trustTimestamp)};
        }
    }

    public static class InviteKeycloakContactMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final String signedContactDetails;
        private final UID[] contactDeviceUids;
        private final String keycloakServerUrl;

        public InviteKeycloakContactMessage(CoreProtocolMessage coreProtocolMessage, Identity ownedIdentity, String signedOwnedDetails, UID[] ownedDeviceUids, String keycloakServerUrl) {
            super(coreProtocolMessage);
            this.contactIdentity = ownedIdentity;
            this.signedContactDetails = signedOwnedDetails;
            this.contactDeviceUids = ownedDeviceUids;
            this.keycloakServerUrl = keycloakServerUrl;
        }

        public InviteKeycloakContactMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 4) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.signedContactDetails = receivedMessage.getInputs()[1].decodeString();
            this.contactDeviceUids = receivedMessage.getInputs()[2].decodeUidArray();
            this.keycloakServerUrl = receivedMessage.getInputs()[3].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.signedContactDetails), Encoded.of(this.contactDeviceUids), Encoded.of(this.keycloakServerUrl)};
        }
    }

    public static class CheckForRevocationServerQueryMessage
    extends ConcreteProtocolMessage {
        private final boolean userNotRevoked;

        public CheckForRevocationServerQueryMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.userNotRevoked = false;
        }

        public CheckForRevocationServerQueryMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
            this.userNotRevoked = receivedMessage.getEncodedResponse().decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class ConfirmationMessage
    extends ConcreteProtocolMessage {
        private final boolean accepted;

        public ConfirmationMessage(CoreProtocolMessage coreProtocolMessage, boolean accepted) {
            super(coreProtocolMessage);
            this.accepted = accepted;
        }

        public ConfirmationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.accepted = receivedMessage.getInputs()[0].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 5;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.accepted)};
        }
    }

    public static class VerifyContactAndStartDeviceDiscoveryStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public VerifyContactAndStartDeviceDiscoveryStep(InitialProtocolState startState, InitialMessage receivedMessage, KeycloakContactAdditionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            String contactSerializedDetails;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            String keycloakServerUrl = protocolManagerSession.identityDelegate.getOwnedIdentityKeycloakServerUrl(protocolManagerSession.session, this.getOwnedIdentity());
            JsonIdentityDetailsWithVersionAndPhoto ownedIdentityDetailsWithVersionAndPhoto = protocolManagerSession.identityDelegate.getOwnedIdentityPublishedDetails(protocolManagerSession.session, this.getOwnedIdentity());
            if (keycloakServerUrl == null || ownedIdentityDetailsWithVersionAndPhoto.getIdentityDetails().getSignedUserDetails() == null) {
                return new FinishedProtocolState();
            }
            JsonKeycloakUserDetails ownUserDetails = protocolManagerSession.identityDelegate.verifyKeycloakIdentitySignature(protocolManagerSession.session, this.getOwnedIdentity(), ownedIdentityDetailsWithVersionAndPhoto.getIdentityDetails().getSignedUserDetails());
            JsonKeycloakUserDetails contactUserDetails = protocolManagerSession.identityDelegate.verifyKeycloakIdentitySignature(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.signedContactDetails);
            if (ownUserDetails == null || contactUserDetails == null) {
                return new FinishedProtocolState();
            }
            try {
                JsonIdentityDetails contactDetails = contactUserDetails.getIdentityDetails(this.receivedMessage.signedContactDetails);
                contactSerializedDetails = this.protocol.getJsonObjectMapper().writeValueAsString((Object)contactDetails);
            }
            catch (Exception e) {
                return new FinishedProtocolState();
            }
            UID childProtocolInstanceUid = new UID(this.getPrng());
            LinkBetweenProtocolInstances.create(protocolManagerSession, childProtocolInstanceUid, this.getOwnedIdentity(), 2, this.getProtocolInstanceUid(), this.getProtocolId(), 1);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 3, childProtocolInstanceUid);
            ChannelProtocolMessageToSend messageToSend = new DeviceDiscoveryChildProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.contactIdentity).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitingForDeviceDiscoveryState(this.receivedMessage.contactIdentity, contactSerializedDetails, keycloakServerUrl, ownedIdentityDetailsWithVersionAndPhoto.getIdentityDetails().getSignedUserDetails());
        }
    }

    public static class ProcessPropagatedContactAdditionStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagateContactAdditionToOtherDevicesMessage receivedMessage;

        public ProcessPropagatedContactAdditionStep(InitialProtocolState startState, PropagateContactAdditionToOtherDevicesMessage receivedMessage, KeycloakContactAdditionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!protocolManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity)) {
                protocolManagerSession.identityDelegate.addContactIdentity(protocolManagerSession.session, this.receivedMessage.contactIdentity, this.receivedMessage.contactSerializedDetails, this.getOwnedIdentity(), TrustOrigin.createKeycloakTrustOrigin(this.receivedMessage.trustTimestamp, this.receivedMessage.keycloakServerUrl), true);
            } else {
                protocolManagerSession.identityDelegate.addTrustOriginToContact(protocolManagerSession.session, this.receivedMessage.contactIdentity, this.getOwnedIdentity(), TrustOrigin.createKeycloakTrustOrigin(this.receivedMessage.trustTimestamp, this.receivedMessage.keycloakServerUrl), true);
            }
            boolean triggerDeviceDiscovery = false;
            for (UID contactDeviceUid : this.receivedMessage.contactDeviceUids) {
                triggerDeviceDiscovery |= protocolManagerSession.identityDelegate.addDeviceForContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity, contactDeviceUid, null, false);
            }
            if (triggerDeviceDiscovery) {
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 0, new UID(this.getPrng()));
                ChannelProtocolMessageToSend messageToSend = new DeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.contactIdentity).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new FinishedProtocolState();
        }
    }

    public static class ProcessReceivedKeycloakInviteStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InviteKeycloakContactMessage receivedMessage;

        public ProcessReceivedKeycloakInviteStep(InitialProtocolState startState, InviteKeycloakContactMessage receivedMessage, KeycloakContactAdditionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            String contactSerializedDetails;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            JsonKeycloakUserDetails contactUserDetails = protocolManagerSession.identityDelegate.verifyKeycloakIdentitySignature(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.signedContactDetails);
            if (contactUserDetails == null) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity(), this.receivedMessage.contactDeviceUids));
                ChannelProtocolMessageToSend messageToSend = new ConfirmationMessage(coreProtocolMessage, false).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new FinishedProtocolState();
            }
            try {
                JsonIdentityDetails contactDetails = contactUserDetails.getIdentityDetails(this.receivedMessage.signedContactDetails);
                contactSerializedDetails = this.protocol.getJsonObjectMapper().writeValueAsString((Object)contactDetails);
            }
            catch (Exception e) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity(), this.receivedMessage.contactDeviceUids));
                ChannelProtocolMessageToSend messageToSend = new ConfirmationMessage(coreProtocolMessage, false).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new FinishedProtocolState();
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.CheckKeycloakRevocationQuery(this.receivedMessage.keycloakServerUrl, this.receivedMessage.signedContactDetails)));
            ChannelServerQueryMessageToSend messageToSend = new CheckForRevocationServerQueryMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new CheckingForRevocationState(this.receivedMessage.contactIdentity, contactSerializedDetails, this.receivedMessage.contactDeviceUids, this.receivedMessage.keycloakServerUrl);
        }
    }

    public static class AddContactAndSendRequestStep
    extends ProtocolStep {
        private final WaitingForDeviceDiscoveryState startState;
        private final DeviceDiscoveryDoneMessage receivedMessage;

        public AddContactAndSendRequestStep(WaitingForDeviceDiscoveryState startState, DeviceDiscoveryDoneMessage receivedMessage, KeycloakContactAdditionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ChannelProtocolMessageToSend messageToSend;
            boolean contactCreated;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            DeviceDiscoveryChildProtocol.DeviceUidsReceivedState deviceUidsReceivedState = this.receivedMessage.getDeviceUidsReceivedState();
            if (deviceUidsReceivedState.getDeviceUidsAndPreKeys().length == 0 && deviceUidsReceivedState.getServerTimestamp() == 0L) {
                return new FinishedProtocolState();
            }
            ArrayList<UID> contactDeviceUidList = new ArrayList<UID>();
            long trustTimestamp = System.currentTimeMillis();
            if (!protocolManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity)) {
                contactCreated = true;
                protocolManagerSession.identityDelegate.addContactIdentity(protocolManagerSession.session, this.startState.contactIdentity, this.startState.contactSerializedDetails, this.getOwnedIdentity(), TrustOrigin.createKeycloakTrustOrigin(trustTimestamp, this.startState.keycloakServerUrl), true);
                protocolManagerSession.identityDelegate.setContactRecentlyOnline(protocolManagerSession.session, this.startState.contactIdentity, this.getOwnedIdentity(), deviceUidsReceivedState.isRecentlyOnline());
                for (HashMap<DictionaryKey, Encoded> deviceUidAndPreKey : deviceUidsReceivedState.getDeviceUidsAndPreKeys()) {
                    Encoded encodedDeviceUid = deviceUidAndPreKey.get(new DictionaryKey("uid"));
                    Encoded encodedSignedPreKey = deviceUidAndPreKey.get(new DictionaryKey("prk"));
                    if (encodedDeviceUid == null) continue;
                    UID deviceUid = encodedDeviceUid.decodeUid();
                    contactDeviceUidList.add(deviceUid);
                    PreKeyBlobOnServer preKeyBlob = PreKeyBlobOnServer.verifySignatureAndDecode(encodedSignedPreKey, this.startState.contactIdentity, deviceUid, deviceUidsReceivedState.getServerTimestamp());
                    protocolManagerSession.identityDelegate.addDeviceForContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity, deviceUid, preKeyBlob, false);
                }
            } else {
                contactCreated = false;
                protocolManagerSession.identityDelegate.addTrustOriginToContact(protocolManagerSession.session, this.startState.contactIdentity, this.getOwnedIdentity(), TrustOrigin.createKeycloakTrustOrigin(trustTimestamp, this.startState.keycloakServerUrl), true);
                protocolManagerSession.identityDelegate.setContactRecentlyOnline(protocolManagerSession.session, this.startState.contactIdentity, this.getOwnedIdentity(), deviceUidsReceivedState.isRecentlyOnline());
                for (HashMap<DictionaryKey, Encoded> deviceUidAndPreKey : deviceUidsReceivedState.getDeviceUidsAndPreKeys()) {
                    Encoded encodedDeviceUid = deviceUidAndPreKey.get(new DictionaryKey("uid"));
                    if (encodedDeviceUid == null) continue;
                    contactDeviceUidList.add(encodedDeviceUid.decodeUid());
                }
            }
            UID[] contactDeviceUids = contactDeviceUidList.toArray(new UID[0]);
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    messageToSend = new PropagateContactAdditionToOtherDevicesMessage(coreProtocolMessage, this.startState.contactIdentity, this.startState.keycloakServerUrl, this.startState.contactSerializedDetails, contactDeviceUids, trustTimestamp).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            UID[] ownedDeviceUids = protocolManagerSession.identityDelegate.getDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.startState.contactIdentity, this.getOwnedIdentity(), contactDeviceUids));
            messageToSend = new InviteKeycloakContactMessage(coreProtocolMessage, this.getOwnedIdentity(), this.startState.signedOwnedDetails, ownedDeviceUids, this.startState.keycloakServerUrl).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            if (contactCreated) {
                return new WaitingForConfirmationState(this.startState.contactIdentity, this.startState.keycloakServerUrl);
            }
            return new FinishedProtocolState();
        }
    }

    public static class ProcessConfirmationStep
    extends ProtocolStep {
        private final WaitingForConfirmationState startState;
        private final ConfirmationMessage receivedMessage;

        public ProcessConfirmationStep(WaitingForConfirmationState startState, ConfirmationMessage receivedMessage, KeycloakContactAdditionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.accepted) {
                TrustOrigin[] trustOrigins;
                for (TrustOrigin trustOrigin : trustOrigins = protocolManagerSession.identityDelegate.getTrustOriginsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity)) {
                    if (trustOrigin.getType() == TrustOrigin.TYPE.KEYCLOAK && Objects.equals(trustOrigin.getKeycloakServer(), this.startState.keycloakServerUrl)) continue;
                    return new FinishedProtocolState();
                }
                protocolManagerSession.identityDelegate.deleteContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity, false);
            }
            return new FinishedProtocolState();
        }
    }

    public static class AddContactAndSendConfirmationStep
    extends ProtocolStep {
        private final CheckingForRevocationState startState;
        private final CheckForRevocationServerQueryMessage receivedMessage;

        public AddContactAndSendConfirmationStep(CheckingForRevocationState startState, CheckForRevocationServerQueryMessage receivedMessage, KeycloakContactAdditionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            CoreProtocolMessage coreProtocolMessage;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.userNotRevoked) {
                CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.startState.contactIdentity, this.getOwnedIdentity(), this.startState.contactDeviceUids));
                ChannelProtocolMessageToSend messageToSend = new ConfirmationMessage(coreProtocolMessage2, false).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new FinishedProtocolState();
            }
            if (!protocolManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity)) {
                protocolManagerSession.identityDelegate.addContactIdentity(protocolManagerSession.session, this.startState.contactIdentity, this.startState.contactSerializedDetails, this.getOwnedIdentity(), TrustOrigin.createKeycloakTrustOrigin(System.currentTimeMillis(), this.startState.keycloakServerUrl), true);
            } else {
                protocolManagerSession.identityDelegate.addTrustOriginToContact(protocolManagerSession.session, this.startState.contactIdentity, this.getOwnedIdentity(), TrustOrigin.createKeycloakTrustOrigin(System.currentTimeMillis(), this.startState.keycloakServerUrl), true);
            }
            boolean triggerDeviceDiscovery = false;
            for (UID contactDeviceUid : this.startState.contactDeviceUids) {
                triggerDeviceDiscovery |= protocolManagerSession.identityDelegate.addDeviceForContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity, contactDeviceUid, null, false);
            }
            if (triggerDeviceDiscovery) {
                coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 0, new UID(this.getPrng()));
                ChannelProtocolMessageToSend messageToSend = new DeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage, this.startState.contactIdentity).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.startState.contactIdentity, this.getOwnedIdentity(), this.startState.contactDeviceUids));
            ChannelProtocolMessageToSend messageToSend = new ConfirmationMessage(coreProtocolMessage, true).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinishedProtocolState();
        }
    }
}

