/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelServerQueryMessageToSend;
import io.olvid.engine.datatypes.containers.DialogType;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.containers.KeycloakGroupV2UpdateOutput;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.datatypes.key.asymmetric.KeyPair;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPublicKey;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.engine.identity.datatypes.KeycloakGroupBlob;
import io.olvid.engine.identity.datatypes.KeycloakGroupMemberAndPermissions;
import io.olvid.engine.protocol.databases.GroupV2SignatureReceived;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.EmptyProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.OneWayDialogProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.DownloadGroupV2PhotoProtocol;
import io.olvid.engine.secure_io.SecureFile;
import java.security.InvalidKeyException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class GroupsV2Protocol
extends ConcreteProtocol {
    private static final int UPLOADING_CREATED_GROUP_DATA_STATE_ID = 1;
    private static final int DOWNLOADING_GROUP_BLOB_STATE_ID = 2;
    private static final int I_NEED_MORE_SEEDS_STATE_ID = 3;
    private static final int INVITATION_RECEIVED_STATE_ID = 4;
    private static final int REJECTING_INVITATION_OR_LEAVING_GROUP_STATE_ID = 5;
    private static final int WAITING_FOR_LOCK_STATE_ID = 6;
    private static final int UPLOADING_UPDATED_GROUP_BLOB_STATE_ID = 7;
    private static final int UPLOADING_UPDATED_GROUP_PHOTO_STATE_ID = 8;
    private static final int DISBANDING_GROUP_STATE_ID = 9;
    private static final int FINAL_STATE_ID = 99;
    private static final int GROUP_CREATION_INITIAL_MESSAGE_ID = 0;
    private static final int UPLOAD_GROUP_PHOTO_MESSAGE_ID = 1;
    private static final int UPLOAD_GROUP_BLOB_MESSAGE_ID = 2;
    private static final int FINALIZE_GROUP_CREATION_MESSAGE_ID = 3;
    private static final int INVITATION_OR_MEMBERS_UPDATE_MESSAGE_ID = 4;
    private static final int INVITATION_OR_MEMBERS_UPDATE_BROADCAST_MESSAGE_ID = 5;
    private static final int INVITATION_OR_MEMBERS_UPDATE_PROPAGATED_MESSAGE_ID = 6;
    private static final int DOWNLOAD_GROUP_BLOB_MESSAGE_ID = 7;
    private static final int FINALIZE_GROUP_UPDATE_MESSAGE_ID = 8;
    private static final int DELETE_GROUP_BLOB_FROM_SERVER_MESSAGE_ID = 9;
    private static final int DIALOG_ACCEPT_GROUP_INVITATION_MESSAGE_ID = 10;
    private static final int PING_MESSAGE_ID = 11;
    private static final int PROPAGATED_PING_MESSAGE_ID = 12;
    private static final int KICK_MESSAGE_ID = 13;
    private static final int PROPAGATE_INVITATION_DIALOG_RESPONSE_MESSAGE_ID = 14;
    private static final int PUT_GROUP_LOG_ON_SERVER_MESSAGE_ID = 15;
    private static final int INVITATION_REJECTED_BROADCAST_MESSAGE_ID = 16;
    private static final int PROPAGATE_INVITATION_REJECTED_MESSAGE_ID = 17;
    private static final int GROUP_UPDATE_INITIAL_MESSAGE_ID = 18;
    private static final int REQUEST_LOCK_MESSAGE_ID = 19;
    private static final int GROUP_LEAVE_INITIAL_MESSAGE_ID = 20;
    private static final int PROPAGATED_GROUP_LEAVE_MESSAGE_ID = 21;
    private static final int GROUP_DISBAND_INITIAL_MESSAGE_ID = 22;
    private static final int PROPAGATED_GROUP_DISBAND_MESSAGE_ID = 23;
    private static final int PROPAGATED_KICK_MESSAGE_ID = 24;
    private static final int GROUP_RE_DOWNLOAD_INITIAL_MESSAGE_ID = 25;
    private static final int INITIATE_BATCH_KEYS_RESEND_MESSAGE_ID = 26;
    private static final int BLOB_KEYS_BATCH_AFTER_CHANNEL_CREATION_MESSAGE_ID = 27;
    private static final int BLOB_KEYS_AFTER_CHANNEL_CREATION_MESSAGE_ID = 28;
    private static final int CREATE_OR_UPDATE_KEYCLOAK_GROUP_MESSAGE_ID = 29;
    private static final int INITIATE_TARGETED_PING_MESSAGE_ID = 30;
    private static final int AUTO_ACCEPT_INVITATION_MESSAGE = 400;

    public GroupsV2Protocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
        this.eraseReceivedMessagesAfterReachingAFinalState = false;
    }

    @Override
    public int getProtocolId() {
        return 18;
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return UploadingCreatedGroupDataState.class;
            }
            case 2: {
                return DownloadingGroupBlobState.class;
            }
            case 3: {
                return INeedMoreSeedsState.class;
            }
            case 4: {
                return InvitationReceivedState.class;
            }
            case 5: {
                return RejectingInvitationOrLeavingGroupState.class;
            }
            case 6: {
                return WaitingForLockState.class;
            }
            case 7: {
                return UploadingUpdatedGroupBlobState.class;
            }
            case 8: {
                return UploadingUpdatedGroupPhotoState.class;
            }
            case 9: {
                return DisbandingGroupState.class;
            }
            case 99: {
                return FinalState.class;
            }
        }
        return null;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{99};
    }

    public static Encoded encodeMembersToKick(HashMap<Identity, byte[]> membersToKick) {
        Encoded[] encodeds = new Encoded[2 * membersToKick.size()];
        int i = 0;
        for (Map.Entry<Identity, byte[]> entry : membersToKick.entrySet()) {
            encodeds[i] = Encoded.of(entry.getKey());
            encodeds[i + 1] = Encoded.of(entry.getValue());
            i += 2;
        }
        return Encoded.of(encodeds);
    }

    public static HashMap<Identity, byte[]> decodeMembersToKick(Encoded encoded) throws DecodingException {
        HashMap<Identity, byte[]> membersToKick = new HashMap<Identity, byte[]>();
        Encoded[] encodeds = encoded.decodeList();
        for (int i = 0; i < encodeds.length; i += 2) {
            membersToKick.put(encodeds[i].decodeIdentity(), encodeds[i + 1].decodeBytes());
        }
        return membersToKick;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return GroupCreationInitialMessage.class;
            }
            case 1: {
                return UploadGroupPhotoMessage.class;
            }
            case 2: {
                return UploadGroupBlobMessage.class;
            }
            case 3: {
                return FinalizeGroupCreationMessage.class;
            }
            case 4: {
                return InvitationOrMembersUpdateMessage.class;
            }
            case 5: {
                return InvitationOrMembersUpdateBroadcastMessage.class;
            }
            case 6: {
                return InvitationOrMembersUpdatePropagatedMessage.class;
            }
            case 7: {
                return DownloadGroupBlobMessage.class;
            }
            case 8: {
                return FinalizeGroupUpdateMessage.class;
            }
            case 9: {
                return DeleteGroupBlobFromServerMessage.class;
            }
            case 10: {
                return DialogAcceptGroupInvitationMessage.class;
            }
            case 11: {
                return PingMessage.class;
            }
            case 12: {
                return PropagatedPingMessage.class;
            }
            case 13: {
                return KickMessage.class;
            }
            case 14: {
                return PropagateInvitationDialogResponseMessage.class;
            }
            case 15: {
                return PutGroupLogOnServerMessage.class;
            }
            case 16: {
                return InvitationRejectedBroadcastMessage.class;
            }
            case 17: {
                return PropagateInvitationRejectedMessage.class;
            }
            case 18: {
                return GroupUpdateInitialMessage.class;
            }
            case 19: {
                return RequestLockMessage.class;
            }
            case 20: {
                return GroupLeaveInitialMessage.class;
            }
            case 21: {
                return PropagatedGroupLeaveMessage.class;
            }
            case 22: {
                return GroupDisbandInitialMessage.class;
            }
            case 23: {
                return PropagatedGroupDisbandMessage.class;
            }
            case 24: {
                return PropagatedKickMessage.class;
            }
            case 25: {
                return GroupReDownloadInitialMessage.class;
            }
            case 26: {
                return InitiateBatchKeysResendMessage.class;
            }
            case 27: {
                return BlobKeysBatchAfterChannelCreationMessage.class;
            }
            case 28: {
                return BlobKeysAfterChannelCreationMessage.class;
            }
            case 29: {
                return CreateOrUpdateKeycloakGroupMessage.class;
            }
            case 30: {
                return InitiateTargetedPingMessage.class;
            }
            case 400: {
                return AutoAcceptInvitationMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{InitiateGroupCreationStep.class, ProcessInvitationOrMembersUpdateStep.class, DoNothingAfterServerQueryStep.class, ProcessPingStep.class, InitiateBlobReDownloadStep.class, InitiateGroupUpdateStep.class, GetKickedStep.class, LeaveGroupStep.class, DisbandGroupStep.class, PrepareBatchKeysMessageStep.class, ProcessBatchKeysMessageStep.class, ProcessCreateOrUpdateKeycloakGroupMessage.class, SendKeycloakGroupTargetedPingStep.class};
            }
            case 1: {
                return new Class[]{CheckIfGroupCreationCanBeFinalizedStep.class, FinalizeGroupCreationStep.class};
            }
            case 2: {
                return new Class[]{ProcessDownloadedGroupDataStep.class, ProcessInvitationDialogResponseStep.class, LeaveGroupStep.class, GetKickedStep.class, DisbandGroupStep.class};
            }
            case 3: {
                return new Class[]{ProcessInvitationOrMembersUpdateStep.class, ProcessInvitationDialogResponseStep.class, LeaveGroupStep.class, GetKickedStep.class, DisbandGroupStep.class};
            }
            case 4: {
                return new Class[]{ProcessInvitationOrMembersUpdateStep.class, ProcessInvitationDialogResponseStep.class, InitiateBlobReDownloadStep.class, GetKickedStep.class, DisbandGroupStep.class};
            }
            case 5: {
                return new Class[]{NotifyMembersOfRejectionOrGroupLeftStep.class};
            }
            case 6: {
                return new Class[]{PrepareBlobForGroupUpdateStep.class, GetKickedStep.class, LeaveGroupStep.class, DisbandGroupStep.class};
            }
            case 7: {
                return new Class[]{ProcessGroupUpdateBlobUploadResponseStep.class, DisbandGroupStep.class};
            }
            case 8: {
                return new Class[]{ProcessGroupUpdatePhotoUploadResponseStep.class, FinalizeGroupUpdateStep.class, DisbandGroupStep.class};
            }
            case 9: {
                return new Class[]{FinalizeGroupDisbandStep.class};
            }
        }
        return new Class[0];
    }

    public static class UploadingCreatedGroupDataState
    extends ConcreteProtocolState {
        private final GroupV2.Identifier groupIdentifier;
        private final int groupVersion;
        private final boolean waitingForBlobUpload;
        private final boolean waitingForPhotoUpload;

        public UploadingCreatedGroupDataState(GroupV2.Identifier groupIdentifier, int groupVersion, boolean waitingForBlobUpload, boolean waitingForPhotoUpload) {
            super(1);
            this.groupIdentifier = groupIdentifier;
            this.groupVersion = groupVersion;
            this.waitingForBlobUpload = waitingForBlobUpload;
            this.waitingForPhotoUpload = waitingForPhotoUpload;
        }

        public UploadingCreatedGroupDataState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 4) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.groupVersion = (int)list[1].decodeLong();
            this.waitingForBlobUpload = list[2].decodeBoolean();
            this.waitingForPhotoUpload = list[3].decodeBoolean();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.groupVersion), Encoded.of(this.waitingForBlobUpload), Encoded.of(this.waitingForPhotoUpload)});
        }
    }

    public static class DownloadingGroupBlobState
    extends CollectingSeedsAbstractState {
        private final byte[] serverQueryNonce;

        protected DownloadingGroupBlobState(GroupV2.Identifier groupIdentifier, UUID dialogUuid, GroupV2.InvitationCollectedData invitationCollectedData, byte[][] ownInvitationNoncesAcceptedOnOtherDevices, byte[] lastKnownOwnInvitationNonce, Identity[] lastKnownOtherGroupMemberIdentities, byte[] serverQueryNonce) {
            super(2, groupIdentifier, dialogUuid, invitationCollectedData, ownInvitationNoncesAcceptedOnOtherDevices, lastKnownOwnInvitationNonce, lastKnownOtherGroupMemberIdentities);
            this.serverQueryNonce = serverQueryNonce;
        }

        public DownloadingGroupBlobState(Encoded encodedState) throws Exception {
            super(2, encodedState.decodeList()[0]);
            this.serverQueryNonce = encodedState.decodeList()[1].decodeBytes();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{super.encode(), Encoded.of(this.serverQueryNonce)});
        }
    }

    public static class INeedMoreSeedsState
    extends CollectingSeedsAbstractState {
        protected INeedMoreSeedsState(GroupV2.Identifier groupIdentifier, UUID dialogUuid, GroupV2.InvitationCollectedData invitationCollectedData, byte[][] ownInvitationNoncesAcceptedOnOtherDevices, byte[] lastKnownOwnInvitationNonce, Identity[] lastKnownOtherGroupMemberIdentities) {
            super(3, groupIdentifier, dialogUuid, invitationCollectedData, ownInvitationNoncesAcceptedOnOtherDevices, lastKnownOwnInvitationNonce, lastKnownOtherGroupMemberIdentities);
        }

        public INeedMoreSeedsState(Encoded encodedState) throws Exception {
            super(3, encodedState);
        }
    }

    public static class InvitationReceivedState
    extends ConcreteProtocolState {
        private final GroupV2.Identifier groupIdentifier;
        private final UUID dialogUuid;
        private final Identity inviterIdentity;
        private final GroupV2.ServerBlob serverBlob;
        private final GroupV2.BlobKeys blobKeys;
        private final Long groupUpdateTimestamp;

        public InvitationReceivedState(GroupV2.Identifier groupIdentifier, UUID dialogUuid, Identity inviterIdentity, GroupV2.ServerBlob serverBlob, GroupV2.BlobKeys blobKeys, Long groupUpdateTimestamp) {
            super(4);
            this.groupIdentifier = groupIdentifier;
            this.dialogUuid = dialogUuid;
            this.inviterIdentity = inviterIdentity;
            this.serverBlob = serverBlob;
            this.blobKeys = blobKeys;
            this.groupUpdateTimestamp = groupUpdateTimestamp;
        }

        public InvitationReceivedState(Encoded encodedState) throws Exception {
            super(4);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 5 && list.length != 6) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.dialogUuid = list[1].decodeUuid();
            this.inviterIdentity = list[2].decodeIdentity();
            this.serverBlob = GroupV2.ServerBlob.of(list[3]);
            this.blobKeys = GroupV2.BlobKeys.of(list[4]);
            this.groupUpdateTimestamp = list.length == 6 ? Long.valueOf(list[5].decodeLong()) : null;
        }

        @Override
        public Encoded encode() {
            if (this.groupUpdateTimestamp == null) {
                return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.dialogUuid), Encoded.of(this.inviterIdentity), this.serverBlob.encode(), this.blobKeys.encode()});
            }
            return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.dialogUuid), Encoded.of(this.inviterIdentity), this.serverBlob.encode(), this.blobKeys.encode(), Encoded.of(this.groupUpdateTimestamp)});
        }
    }

    public static class RejectingInvitationOrLeavingGroupState
    extends ConcreteProtocolState {
        private final GroupV2.Identifier groupIdentifier;
        private final List<Identity> groupMembersToNotify;

        public RejectingInvitationOrLeavingGroupState(GroupV2.Identifier groupIdentifier, List<Identity> groupMembersToNotify) {
            super(5);
            this.groupIdentifier = groupIdentifier;
            this.groupMembersToNotify = groupMembersToNotify;
        }

        public RejectingInvitationOrLeavingGroupState(Encoded encodedState) throws Exception {
            super(5);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 2) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.groupMembersToNotify = Arrays.asList(list[1].decodeIdentityArray());
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.groupMembersToNotify.toArray(new Identity[0]))});
        }
    }

    public static class WaitingForLockState
    extends ConcreteProtocolState {
        private final GroupV2.Identifier groupIdentifier;
        private final ObvGroupV2.ObvGroupV2ChangeSet changeSet;
        private final byte[] lockNonce;
        private final long failedUploadCounter;

        public WaitingForLockState(GroupV2.Identifier groupIdentifier, ObvGroupV2.ObvGroupV2ChangeSet changeSet, byte[] lockNonce, long failedUploadCounter) {
            super(6);
            this.groupIdentifier = groupIdentifier;
            this.changeSet = changeSet;
            this.lockNonce = lockNonce;
            this.failedUploadCounter = failedUploadCounter;
        }

        public WaitingForLockState(Encoded encodedState) throws Exception {
            super(6);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 4) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.changeSet = ObvGroupV2.ObvGroupV2ChangeSet.of(list[1]);
            this.lockNonce = list[2].decodeBytes();
            this.failedUploadCounter = list[3].decodeLong();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), this.changeSet.encode(), Encoded.of(this.lockNonce), Encoded.of(this.failedUploadCounter)});
        }
    }

    public static class UploadingUpdatedGroupBlobState
    extends ConcreteProtocolState {
        private final GroupV2.Identifier groupIdentifier;
        private final ObvGroupV2.ObvGroupV2ChangeSet changeSet;
        private final GroupV2.ServerBlob updatedBlob;
        private final GroupV2.BlobKeys updatedBlobKeys;
        private final HashMap<Identity, byte[]> membersToKick;
        private final String absolutePhotoUrlToUpload;
        private final long failedUploadCounter;

        public UploadingUpdatedGroupBlobState(GroupV2.Identifier groupIdentifier, ObvGroupV2.ObvGroupV2ChangeSet changeSet, GroupV2.ServerBlob updatedBlob, GroupV2.BlobKeys updatedBlobKeys, HashMap<Identity, byte[]> membersToKick, String absolutePhotoUrlToUpload, long failedUploadCounter) {
            super(7);
            this.groupIdentifier = groupIdentifier;
            this.changeSet = changeSet;
            this.updatedBlob = updatedBlob;
            this.updatedBlobKeys = updatedBlobKeys;
            this.membersToKick = membersToKick;
            this.absolutePhotoUrlToUpload = absolutePhotoUrlToUpload;
            this.failedUploadCounter = failedUploadCounter;
        }

        public UploadingUpdatedGroupBlobState(Encoded encodedState) throws Exception {
            super(7);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 7) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.changeSet = ObvGroupV2.ObvGroupV2ChangeSet.of(list[1]);
            this.updatedBlob = GroupV2.ServerBlob.of(list[2]);
            this.updatedBlobKeys = GroupV2.BlobKeys.of(list[3]);
            this.membersToKick = GroupsV2Protocol.decodeMembersToKick(list[4]);
            String decoded = list[5].decodeString();
            this.absolutePhotoUrlToUpload = decoded.isEmpty() ? null : decoded;
            this.failedUploadCounter = list[6].decodeLong();
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), this.changeSet.encode(), this.updatedBlob.encode(), this.updatedBlobKeys.encode(), GroupsV2Protocol.encodeMembersToKick(this.membersToKick), Encoded.of(this.absolutePhotoUrlToUpload == null ? "" : this.absolutePhotoUrlToUpload), Encoded.of(this.failedUploadCounter)});
        }
    }

    public static class UploadingUpdatedGroupPhotoState
    extends ConcreteProtocolState {
        private final GroupV2.Identifier groupIdentifier;
        private final ObvGroupV2.ObvGroupV2ChangeSet changeSet;
        private final GroupV2.ServerBlob updatedBlob;
        private final GroupV2.BlobKeys updatedBlobKeys;
        private final HashMap<Identity, byte[]> membersToKick;
        private final String absolutePhotoUrlToUpload;

        public UploadingUpdatedGroupPhotoState(GroupV2.Identifier groupIdentifier, ObvGroupV2.ObvGroupV2ChangeSet changeSet, GroupV2.ServerBlob updatedBlob, GroupV2.BlobKeys updatedBlobKeys, HashMap<Identity, byte[]> membersToKick, String absolutePhotoUrlToUpload) {
            super(8);
            this.groupIdentifier = groupIdentifier;
            this.changeSet = changeSet;
            this.updatedBlob = updatedBlob;
            this.updatedBlobKeys = updatedBlobKeys;
            this.membersToKick = membersToKick;
            this.absolutePhotoUrlToUpload = absolutePhotoUrlToUpload;
        }

        public UploadingUpdatedGroupPhotoState(Encoded encodedState) throws Exception {
            super(8);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 6) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.changeSet = ObvGroupV2.ObvGroupV2ChangeSet.of(list[1]);
            this.updatedBlob = GroupV2.ServerBlob.of(list[2]);
            this.updatedBlobKeys = GroupV2.BlobKeys.of(list[3]);
            this.membersToKick = GroupsV2Protocol.decodeMembersToKick(list[4]);
            String decoded = list[5].decodeString();
            this.absolutePhotoUrlToUpload = decoded.isEmpty() ? null : decoded;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), this.changeSet.encode(), this.updatedBlob.encode(), this.updatedBlobKeys.encode(), GroupsV2Protocol.encodeMembersToKick(this.membersToKick), Encoded.of(this.absolutePhotoUrlToUpload == null ? "" : this.absolutePhotoUrlToUpload)});
        }
    }

    public static class DisbandingGroupState
    extends ConcreteProtocolState {
        private final GroupV2.Identifier groupIdentifier;
        private final GroupV2.BlobKeys blobKeys;

        public DisbandingGroupState(GroupV2.Identifier groupIdentifier, GroupV2.BlobKeys blobKeys) {
            super(9);
            this.groupIdentifier = groupIdentifier;
            this.blobKeys = blobKeys;
        }

        public DisbandingGroupState(Encoded encodedState) throws Exception {
            super(9);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 2) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.blobKeys = GroupV2.BlobKeys.of(list[1]);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), this.blobKeys.encode()});
        }
    }

    public static class FinalState
    extends ConcreteProtocolState {
        protected FinalState() {
            super(99);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class GroupCreationInitialMessage
    extends ConcreteProtocolMessage {
        private final HashSet<GroupV2.Permission> ownPermissions;
        private final HashSet<GroupV2.IdentityAndPermissions> otherGroupMembers;
        private final String serializedGroupDetails;
        private final String absolutePhotoUrl;
        private final String serializedGroupType;

        public GroupCreationInitialMessage(CoreProtocolMessage coreProtocolMessage, HashSet<GroupV2.Permission> ownPermissions, HashSet<GroupV2.IdentityAndPermissions> otherGroupMembers, String serializedGroupDetails, String absolutePhotoUrl, String serializedGroupType) {
            super(coreProtocolMessage);
            this.ownPermissions = ownPermissions;
            this.otherGroupMembers = otherGroupMembers;
            this.serializedGroupDetails = serializedGroupDetails;
            this.absolutePhotoUrl = absolutePhotoUrl;
            this.serializedGroupType = serializedGroupType;
        }

        public GroupCreationInitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] inputs = receivedMessage.getInputs();
            if (inputs.length == 5) {
                this.ownPermissions = GroupV2.Permission.deserializeKnownPermissions(inputs[0].decodeBytes());
                this.otherGroupMembers = new HashSet();
                for (Encoded encodedGroupMember : inputs[1].decodeList()) {
                    this.otherGroupMembers.add(GroupV2.IdentityAndPermissions.of(encodedGroupMember));
                }
                this.serializedGroupDetails = inputs[2].decodeString();
                String url = inputs[3].decodeString();
                this.absolutePhotoUrl = url.isEmpty() ? null : url;
                this.serializedGroupType = inputs[4].decodeString();
            } else if (inputs.length == 4) {
                this.ownPermissions = GroupV2.Permission.deserializeKnownPermissions(inputs[0].decodeBytes());
                this.otherGroupMembers = new HashSet();
                for (Encoded encodedGroupMember : inputs[1].decodeList()) {
                    this.otherGroupMembers.add(GroupV2.IdentityAndPermissions.of(encodedGroupMember));
                }
                this.serializedGroupDetails = inputs[2].decodeString();
                String url = inputs[3].decodeString();
                this.absolutePhotoUrl = url.isEmpty() ? null : url;
                this.serializedGroupType = null;
            } else {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            ArrayList<Encoded> encodedGroupMembers = new ArrayList<Encoded>();
            for (GroupV2.IdentityAndPermissions groupMember : this.otherGroupMembers) {
                encodedGroupMembers.add(groupMember.encode());
            }
            if (this.serializedGroupType == null) {
                return new Encoded[]{Encoded.of(GroupV2.Permission.serializePermissions(this.ownPermissions)), Encoded.of(encodedGroupMembers.toArray(new Encoded[0])), Encoded.of(this.serializedGroupDetails), Encoded.of(this.absolutePhotoUrl == null ? "" : this.absolutePhotoUrl)};
            }
            return new Encoded[]{Encoded.of(GroupV2.Permission.serializePermissions(this.ownPermissions)), Encoded.of(encodedGroupMembers.toArray(new Encoded[0])), Encoded.of(this.serializedGroupDetails), Encoded.of(this.absolutePhotoUrl == null ? "" : this.absolutePhotoUrl), Encoded.of(this.serializedGroupType)};
        }
    }

    public static class UploadGroupPhotoMessage
    extends ConcreteProtocolMessage {
        private UploadGroupPhotoMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public UploadGroupPhotoMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() != null) {
                throw new Exception();
            }
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class UploadGroupBlobMessage
    extends ConcreteProtocolMessage {
        private final int uploadResult;

        private UploadGroupBlobMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.uploadResult = 2;
        }

        public UploadGroupBlobMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                throw new Exception();
            }
            this.uploadResult = (int)receivedMessage.getEncodedResponse().decodeLong();
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class FinalizeGroupCreationMessage
    extends EmptyProtocolMessage {
        private FinalizeGroupCreationMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public FinalizeGroupCreationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }
    }

    public static class InvitationOrMembersUpdateMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;
        private final int groupVersion;
        private final GroupV2.BlobKeys blobKeys;
        private final UID[] notifiedDeviceUids;

        public InvitationOrMembersUpdateMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, int groupVersion, GroupV2.BlobKeys blobKeys, UID[] notifiedDeviceUids) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
            this.groupVersion = groupVersion;
            this.blobKeys = blobKeys;
            this.notifiedDeviceUids = notifiedDeviceUids;
        }

        public InvitationOrMembersUpdateMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 4) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.groupVersion = (int)list[1].decodeLong();
            this.blobKeys = GroupV2.BlobKeys.of(list[2]);
            this.notifiedDeviceUids = list[3].decodeUidArray();
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.groupVersion), this.blobKeys.encode(), Encoded.of(this.notifiedDeviceUids)};
        }
    }

    public static class InvitationOrMembersUpdateBroadcastMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;
        private final int groupVersion;
        private final GroupV2.BlobKeys blobKeys;

        public InvitationOrMembersUpdateBroadcastMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, int groupVersion, GroupV2.BlobKeys blobKeys) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
            this.groupVersion = groupVersion;
            this.blobKeys = blobKeys;
        }

        public InvitationOrMembersUpdateBroadcastMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 3) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.groupVersion = (int)list[1].decodeLong();
            this.blobKeys = GroupV2.BlobKeys.of(list[2]);
        }

        @Override
        public int getProtocolMessageId() {
            return 5;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.groupVersion), this.blobKeys.encode()};
        }
    }

    public static class InvitationOrMembersUpdatePropagatedMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;
        private final int groupVersion;
        private final GroupV2.BlobKeys blobKeys;
        private final Identity inviterIdentity;

        public InvitationOrMembersUpdatePropagatedMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, int groupVersion, GroupV2.BlobKeys blobKeys, Identity inviterIdentity) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
            this.groupVersion = groupVersion;
            this.blobKeys = blobKeys;
            this.inviterIdentity = inviterIdentity;
        }

        public InvitationOrMembersUpdatePropagatedMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 4 && list.length != 3) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.groupVersion = (int)list[1].decodeLong();
            this.blobKeys = GroupV2.BlobKeys.of(list[2]);
            this.inviterIdentity = list.length == 3 ? null : list[3].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 6;
        }

        @Override
        public Encoded[] getInputs() {
            if (this.inviterIdentity == null) {
                return new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.groupVersion), this.blobKeys.encode()};
            }
            return new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.groupVersion), this.blobKeys.encode(), Encoded.of(this.inviterIdentity)};
        }
    }

    public static class DownloadGroupBlobMessage
    extends ConcreteProtocolMessage {
        protected final EncryptedBytes encryptedServerBlob;
        protected final List<byte[]> logEntries;
        protected final ServerAuthenticationPublicKey groupAdminPublicKey;
        protected final byte[] serverQueryNonce;
        protected final Long groupUpdateTimestamp;
        protected final boolean deletedFromServer;

        private DownloadGroupBlobMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.encryptedServerBlob = null;
            this.logEntries = null;
            this.groupAdminPublicKey = null;
            this.serverQueryNonce = null;
            this.groupUpdateTimestamp = null;
            this.deletedFromServer = false;
        }

        public DownloadGroupBlobMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                this.encryptedServerBlob = null;
                this.logEntries = null;
                this.groupAdminPublicKey = null;
                this.serverQueryNonce = null;
                this.groupUpdateTimestamp = null;
                this.deletedFromServer = false;
            } else {
                Encoded[] list = receivedMessage.getEncodedResponse().decodeList();
                if (list.length == 1 && list[0].decodeBoolean()) {
                    this.encryptedServerBlob = null;
                    this.logEntries = null;
                    this.groupAdminPublicKey = null;
                    this.serverQueryNonce = null;
                    this.groupUpdateTimestamp = null;
                    this.deletedFromServer = true;
                } else {
                    long timestamp;
                    this.encryptedServerBlob = list[0].decodeEncryptedData();
                    this.logEntries = new ArrayList<byte[]>();
                    for (Encoded encodedLogEntry : list[1].decodeList()) {
                        this.logEntries.add(encodedLogEntry.decodeBytes());
                    }
                    this.groupAdminPublicKey = (ServerAuthenticationPublicKey)list[2].decodePublicKey();
                    this.serverQueryNonce = list[3].decodeBytes();
                    this.groupUpdateTimestamp = list.length == 5 ? ((timestamp = list[4].decodeLong()) == 0L ? null : Long.valueOf(timestamp)) : null;
                    this.deletedFromServer = false;
                }
            }
            if (receivedMessage.getInputs().length != 0) {
                throw new Exception();
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 7;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class FinalizeGroupUpdateMessage
    extends EmptyProtocolMessage {
        private FinalizeGroupUpdateMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public FinalizeGroupUpdateMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 8;
        }
    }

    public static class DeleteGroupBlobFromServerMessage
    extends EmptyProtocolMessage {
        private final boolean success;

        public DeleteGroupBlobFromServerMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.success = false;
        }

        public DeleteGroupBlobFromServerMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
            this.success = receivedMessage.getEncodedResponse() == null ? false : receivedMessage.getEncodedResponse().decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 9;
        }
    }

    public static class DialogAcceptGroupInvitationMessage
    extends ConcreteProtocolMessage {
        private final boolean invitationAccepted;
        private final UUID dialogUuid;

        DialogAcceptGroupInvitationMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.invitationAccepted = false;
            this.dialogUuid = null;
        }

        public DialogAcceptGroupInvitationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                throw new Exception();
            }
            this.invitationAccepted = receivedMessage.getEncodedResponse().decodeBoolean();
            this.dialogUuid = receivedMessage.getUserDialogUuid();
        }

        @Override
        public int getProtocolMessageId() {
            return 10;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class PingMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;
        private final byte[] groupMemberInvitationNonce;
        private final byte[] signature;
        private final boolean isResponse;

        public PingMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, byte[] groupMemberInvitationNonce, byte[] signature, boolean isResponse) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
            this.groupMemberInvitationNonce = groupMemberInvitationNonce;
            this.signature = signature;
            this.isResponse = isResponse;
        }

        public PingMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 4) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.groupMemberInvitationNonce = list[1].decodeBytes();
            this.signature = list[2].decodeBytes();
            this.isResponse = list[3].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 11;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.groupMemberInvitationNonce), Encoded.of(this.signature), Encoded.of(this.isResponse)};
        }
    }

    public static class PropagatedPingMessage
    extends PingMessage {
        public PropagatedPingMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, byte[] groupMemberInvitationNonce, byte[] signature, boolean isResponse) {
            super(coreProtocolMessage, groupIdentifier, groupMemberInvitationNonce, signature, isResponse);
        }

        public PropagatedPingMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 12;
        }
    }

    public static class KickMessage
    extends ConcreteProtocolMessage {
        protected final GroupV2.Identifier groupIdentifier;
        protected final EncryptedBytes encryptedAdministratorsChain;
        protected final byte[] signature;

        public KickMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, EncryptedBytes encryptedAdministratorsChain, byte[] signature) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
            this.encryptedAdministratorsChain = encryptedAdministratorsChain;
            this.signature = signature;
        }

        public KickMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 3) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.encryptedAdministratorsChain = list[1].decodeEncryptedData();
            this.signature = list[2].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 13;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.encryptedAdministratorsChain), Encoded.of(this.signature)};
        }
    }

    public static class PropagateInvitationDialogResponseMessage
    extends ConcreteProtocolMessage {
        private final boolean invitationAccepted;
        private final byte[] ownGroupInvitationNonce;

        PropagateInvitationDialogResponseMessage(CoreProtocolMessage coreProtocolMessage, boolean invitationAccepted, byte[] ownGroupInvitationNonce) {
            super(coreProtocolMessage);
            this.invitationAccepted = invitationAccepted;
            this.ownGroupInvitationNonce = ownGroupInvitationNonce;
        }

        public PropagateInvitationDialogResponseMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 2) {
                throw new Exception();
            }
            this.invitationAccepted = list[0].decodeBoolean();
            this.ownGroupInvitationNonce = list[1].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 14;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.invitationAccepted), Encoded.of(this.ownGroupInvitationNonce)};
        }
    }

    public static class PutGroupLogOnServerMessage
    extends EmptyProtocolMessage {
        public PutGroupLogOnServerMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public PutGroupLogOnServerMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 15;
        }
    }

    public static class InvitationRejectedBroadcastMessage
    extends ConcreteProtocolMessage {
        protected final GroupV2.Identifier groupIdentifier;

        public InvitationRejectedBroadcastMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
        }

        public InvitationRejectedBroadcastMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 1) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
        }

        @Override
        public int getProtocolMessageId() {
            return 16;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode()};
        }
    }

    public static class PropagateInvitationRejectedMessage
    extends InvitationRejectedBroadcastMessage {
        public PropagateInvitationRejectedMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier) {
            super(coreProtocolMessage, groupIdentifier);
        }

        public PropagateInvitationRejectedMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 17;
        }
    }

    public static class GroupUpdateInitialMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;
        private final ObvGroupV2.ObvGroupV2ChangeSet changeSet;

        public GroupUpdateInitialMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, ObvGroupV2.ObvGroupV2ChangeSet changeSet) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
            this.changeSet = changeSet;
        }

        public GroupUpdateInitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] inputs = receivedMessage.getInputs();
            if (inputs.length != 2) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(inputs[0]);
            this.changeSet = ObvGroupV2.ObvGroupV2ChangeSet.of(inputs[1]);
        }

        @Override
        public int getProtocolMessageId() {
            return 18;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode(), this.changeSet.encode()};
        }
    }

    public static class RequestLockMessage
    extends DownloadGroupBlobMessage {
        private RequestLockMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public RequestLockMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 19;
        }
    }

    public static class GroupLeaveInitialMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;

        public GroupLeaveInitialMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
        }

        public GroupLeaveInitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] inputs = receivedMessage.getInputs();
            if (inputs.length != 1) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(inputs[0]);
        }

        @Override
        public int getProtocolMessageId() {
            return 20;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode()};
        }
    }

    public static class PropagatedGroupLeaveMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;
        private final byte[] ownInvitationNonce;

        public PropagatedGroupLeaveMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, byte[] ownInvitationNonce) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
            this.ownInvitationNonce = ownInvitationNonce;
        }

        public PropagatedGroupLeaveMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] inputs = receivedMessage.getInputs();
            if (inputs.length != 2) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(inputs[0]);
            this.ownInvitationNonce = inputs[1].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 21;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.ownInvitationNonce)};
        }
    }

    public static class GroupDisbandInitialMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;

        public GroupDisbandInitialMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
        }

        public GroupDisbandInitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] inputs = receivedMessage.getInputs();
            if (inputs.length != 1) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(inputs[0]);
        }

        @Override
        public int getProtocolMessageId() {
            return 22;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode()};
        }
    }

    public static class PropagatedGroupDisbandMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;

        public PropagatedGroupDisbandMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
        }

        public PropagatedGroupDisbandMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] inputs = receivedMessage.getInputs();
            if (inputs.length != 1) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(inputs[0]);
        }

        @Override
        public int getProtocolMessageId() {
            return 23;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode()};
        }
    }

    public static class PropagatedKickMessage
    extends KickMessage {
        public PropagatedKickMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, EncryptedBytes encryptedAdministratorsChain, byte[] signature) {
            super(coreProtocolMessage, groupIdentifier, encryptedAdministratorsChain, signature);
        }

        public PropagatedKickMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 24;
        }
    }

    public static class GroupReDownloadInitialMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;

        public GroupReDownloadInitialMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
        }

        public GroupReDownloadInitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] inputs = receivedMessage.getInputs();
            if (inputs.length != 1) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(inputs[0]);
        }

        @Override
        public int getProtocolMessageId() {
            return 25;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode()};
        }
    }

    public static class InitiateBatchKeysResendMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final UID contactDeviceUid;

        public InitiateBatchKeysResendMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, UID contactDeviceUid) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.contactDeviceUid = contactDeviceUid;
        }

        public InitiateBatchKeysResendMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] inputs = receivedMessage.getInputs();
            if (inputs.length != 2) {
                throw new Exception();
            }
            this.contactIdentity = inputs[0].decodeIdentity();
            this.contactDeviceUid = inputs[1].decodeUid();
        }

        @Override
        public int getProtocolMessageId() {
            return 26;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactDeviceUid)};
        }
    }

    public static class BlobKeysBatchAfterChannelCreationMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.IdentifierVersionAndKeys[] groupInfos;

        public BlobKeysBatchAfterChannelCreationMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.IdentifierVersionAndKeys[] groupInfos) {
            super(coreProtocolMessage);
            this.groupInfos = groupInfos;
        }

        public BlobKeysBatchAfterChannelCreationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] inputs = receivedMessage.getInputs();
            if (inputs.length != 1) {
                throw new Exception();
            }
            Encoded[] encodeds = inputs[0].decodeList();
            this.groupInfos = new GroupV2.IdentifierVersionAndKeys[encodeds.length];
            for (int i = 0; i < encodeds.length; ++i) {
                this.groupInfos[i] = new GroupV2.IdentifierVersionAndKeys(encodeds[i]);
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 27;
        }

        @Override
        public Encoded[] getInputs() {
            Encoded[] encodeds = new Encoded[this.groupInfos.length];
            for (int i = 0; i < this.groupInfos.length; ++i) {
                encodeds[i] = this.groupInfos[i].encode();
            }
            return new Encoded[]{Encoded.of(encodeds)};
        }
    }

    public static class BlobKeysAfterChannelCreationMessage
    extends ConcreteProtocolMessage {
        private final Identity groupInviter;
        private final GroupV2.Identifier groupIdentifier;
        private final int groupVersion;
        private final GroupV2.BlobKeys blobKeys;

        public BlobKeysAfterChannelCreationMessage(CoreProtocolMessage coreProtocolMessage, Identity groupInviter, GroupV2.Identifier groupIdentifier, int groupVersion, GroupV2.BlobKeys blobKeys) {
            super(coreProtocolMessage);
            this.groupInviter = groupInviter;
            this.groupIdentifier = groupIdentifier;
            this.groupVersion = groupVersion;
            this.blobKeys = blobKeys;
        }

        public BlobKeysAfterChannelCreationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 4) {
                throw new Exception();
            }
            this.groupInviter = list[0].decodeIdentity();
            this.groupIdentifier = GroupV2.Identifier.of(list[1]);
            this.groupVersion = (int)list[2].decodeLong();
            this.blobKeys = GroupV2.BlobKeys.of(list[3]);
        }

        @Override
        public int getProtocolMessageId() {
            return 28;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.groupInviter), this.groupIdentifier.encode(), Encoded.of(this.groupVersion), this.blobKeys.encode()};
        }
    }

    public static class CreateOrUpdateKeycloakGroupMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;
        private final String serializedKeycloakGroupBlob;

        public CreateOrUpdateKeycloakGroupMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, String serializedKeycloakGroupBlob) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
            this.serializedKeycloakGroupBlob = serializedKeycloakGroupBlob;
        }

        public CreateOrUpdateKeycloakGroupMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 2) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.serializedKeycloakGroupBlob = list[1].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 29;
        }

        @Override
        public Encoded[] getInputs() {
            ObjectMapper jsonObjectMapper = new ObjectMapper();
            jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.serializedKeycloakGroupBlob)};
        }
    }

    public static class InitiateTargetedPingMessage
    extends ConcreteProtocolMessage {
        private final GroupV2.Identifier groupIdentifier;
        private final Identity pendingMemberIdentity;

        public InitiateTargetedPingMessage(CoreProtocolMessage coreProtocolMessage, GroupV2.Identifier groupIdentifier, Identity pendingMemberIdentity) {
            super(coreProtocolMessage);
            this.groupIdentifier = groupIdentifier;
            this.pendingMemberIdentity = pendingMemberIdentity;
        }

        public InitiateTargetedPingMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            Encoded[] list = receivedMessage.getInputs();
            if (list.length != 2) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.pendingMemberIdentity = list[1].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 30;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.pendingMemberIdentity)};
        }
    }

    public static class AutoAcceptInvitationMessage
    extends EmptyProtocolMessage {
        public AutoAcceptInvitationMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public AutoAcceptInvitationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 400;
        }
    }

    public static class InitiateGroupCreationStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final GroupCreationInitialMessage receivedMessage;

        public InitiateGroupCreationStep(InitialProtocolState startState, GroupCreationInitialMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            String string;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            ArrayList<Identity> otherAdmins = new ArrayList<Identity>();
            for (GroupV2.IdentityAndPermissions groupMember : this.receivedMessage.otherGroupMembers) {
                if (!groupMember.isAdmin()) continue;
                otherAdmins.add(groupMember.identity);
            }
            GroupV2.AdministratorsChain chain = GroupV2.AdministratorsChain.startNewChain(protocolManagerSession.session, protocolManagerSession.identityDelegate, this.getOwnedIdentity(), otherAdmins.toArray(new Identity[0]), this.getPrng());
            byte[] verifiedAdministratorsChain = chain.encode().getBytes();
            GroupV2.Identifier groupIdentifier = new GroupV2.Identifier(chain.groupUid, this.getOwnedIdentity().getServer(), 0);
            GroupV2.ServerPhotoInfo serverPhotoInfo = this.receivedMessage.absolutePhotoUrl == null ? null : new GroupV2.ServerPhotoInfo(this.getOwnedIdentity(), new UID(this.getPrng()), Suite.getDefaultAuthEnc(0).generateKey(this.getPrng()));
            Seed blobMainSeed = new Seed(this.getPrng());
            Seed blobVersionSeed = new Seed(this.getPrng());
            KeyPair groupAdminServerAuthenticationKeyPair = Suite.generateServerAuthenticationKeyPair(null, this.getPrng());
            byte[] ownGroupInvitationNonce = this.getPrng().bytes(16);
            HashSet<GroupV2.IdentityAndPermissionsAndDetails> otherGroupMembers = new HashSet<GroupV2.IdentityAndPermissionsAndDetails>();
            for (GroupV2.IdentityAndPermissions identityAndPermissions : this.receivedMessage.otherGroupMembers) {
                ArrayList<String> permissionStrings = new ArrayList<String>();
                for (GroupV2.Permission permission : identityAndPermissions.permissions) {
                    permissionStrings.add(permission.getString());
                }
                String serializedContactDetails = protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), identityAndPermissions.identity);
                otherGroupMembers.add(new GroupV2.IdentityAndPermissionsAndDetails(identityAndPermissions.identity, permissionStrings, serializedContactDetails, this.getPrng().bytes(16)));
            }
            ArrayList<String> ownPermissionStrings = new ArrayList<String>();
            for (GroupV2.Permission permission : this.receivedMessage.ownPermissions) {
                ownPermissionStrings.add(permission.getString());
            }
            protocolManagerSession.identityDelegate.createNewGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), groupIdentifier, this.receivedMessage.serializedGroupDetails, this.receivedMessage.absolutePhotoUrl, serverPhotoInfo, verifiedAdministratorsChain, new GroupV2.BlobKeys(blobMainSeed, blobVersionSeed, (ServerAuthenticationPrivateKey)groupAdminServerAuthenticationKeyPair.getPrivateKey()), ownGroupInvitationNonce, ownPermissionStrings, otherGroupMembers, this.receivedMessage.serializedGroupType);
            GroupV2.ServerBlob serverBlob = protocolManagerSession.identityDelegate.getGroupV2ServerBlob(protocolManagerSession.session, this.getOwnedIdentity(), groupIdentifier);
            if (serverBlob == null) {
                throw new Exception("Failed to retrieve serverBlob from a just created group");
            }
            Encoded encoded = serverBlob.encode();
            byte[] signature = protocolManagerSession.identityDelegate.signBlock(protocolManagerSession.session, Constants.SignatureContext.GROUP_BLOB, encoded.getBytes(), this.getOwnedIdentity(), this.getPrng());
            Encoded encodedSignedBlob = Encoded.of(new Encoded[]{encoded, Encoded.of(this.getOwnedIdentity()), Encoded.of(signature)});
            int unpaddedLength = encodedSignedBlob.getBytes().length;
            int paddedLength = 1 + (unpaddedLength - 1 >> 12) << 12;
            byte[] paddedBlobPlaintext = new byte[paddedLength];
            System.arraycopy(encodedSignedBlob.getBytes(), 0, paddedBlobPlaintext, 0, unpaddedLength);
            AuthEncKey blobEncryptionKey = GroupV2.getSharedBlobSecretKey(blobMainSeed, blobVersionSeed);
            EncryptedBytes encryptedBlob = Suite.getAuthEnc(blobEncryptionKey).encrypt(blobEncryptionKey, paddedBlobPlaintext, this.getPrng());
            if (serverBlob.serverPhotoInfo != null && (string = protocolManagerSession.identityDelegate.getGroupV2PhotoUrl(protocolManagerSession.session, this.getOwnedIdentity(), groupIdentifier)) != null) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.PutUserDataQuery(this.getOwnedIdentity(), serverBlob.serverPhotoInfo.serverPhotoLabel, string, serverBlob.serverPhotoInfo.serverPhotoKey)));
                ChannelServerQueryMessageToSend messageToSend = new UploadGroupPhotoMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.CreateGroupBlobQuery(groupIdentifier, Encoded.of(groupAdminServerAuthenticationKeyPair.getPublicKey()), encryptedBlob)));
            ChannelServerQueryMessageToSend messageToSend = new UploadGroupBlobMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new UploadingCreatedGroupDataState(groupIdentifier, serverBlob.version, true, serverBlob.serverPhotoInfo != null);
        }
    }

    public static class ProcessInvitationOrMembersUpdateStep
    extends ProtocolStep {
        private final Identity obliviousChannelContactIdentity;
        private final ConcreteProtocolState startState;
        private final GroupV2.InvitationCollectedData invitationCollectedData;
        private final UUID dialogUuid;
        private final byte[][] ownInvitationNoncesAcceptedOnOtherDevices;
        private final byte[] lastKnownOwnInvitationNonce;
        private final Identity[] lastKnownOtherGroupMemberIdentities;
        private final GroupV2.Identifier groupIdentifier;
        private final int groupVersion;
        private final GroupV2.BlobKeys blobKeys;
        private final UID[] notifiedDeviceUids;
        private final boolean propagateIfNeeded;

        public ProcessInvitationOrMembersUpdateStep(InitialProtocolState startState, InvitationOrMembersUpdateMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = receivedMessage.getReceptionChannelInfo().getRemoteIdentity();
            this.startState = null;
            this.invitationCollectedData = new GroupV2.InvitationCollectedData();
            this.dialogUuid = UUID.randomUUID();
            this.ownInvitationNoncesAcceptedOnOtherDevices = new byte[0][];
            this.lastKnownOwnInvitationNonce = null;
            this.lastKnownOtherGroupMemberIdentities = null;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = receivedMessage.blobKeys;
            this.notifiedDeviceUids = receivedMessage.notifiedDeviceUids;
            this.propagateIfNeeded = true;
        }

        public ProcessInvitationOrMembersUpdateStep(InitialProtocolState startState, InvitationOrMembersUpdateBroadcastMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = null;
            this.startState = null;
            this.invitationCollectedData = new GroupV2.InvitationCollectedData();
            this.dialogUuid = UUID.randomUUID();
            this.ownInvitationNoncesAcceptedOnOtherDevices = new byte[0][];
            this.lastKnownOwnInvitationNonce = null;
            this.lastKnownOtherGroupMemberIdentities = null;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = new GroupV2.BlobKeys(null, receivedMessage.blobKeys.blobVersionSeed, receivedMessage.blobKeys.groupAdminServerAuthenticationPrivateKey);
            this.notifiedDeviceUids = new UID[0];
            this.propagateIfNeeded = true;
        }

        public ProcessInvitationOrMembersUpdateStep(InitialProtocolState startState, InvitationOrMembersUpdatePropagatedMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = receivedMessage.inviterIdentity;
            this.startState = null;
            this.invitationCollectedData = new GroupV2.InvitationCollectedData();
            this.dialogUuid = UUID.randomUUID();
            this.ownInvitationNoncesAcceptedOnOtherDevices = new byte[0][];
            this.lastKnownOwnInvitationNonce = null;
            this.lastKnownOtherGroupMemberIdentities = null;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = receivedMessage.blobKeys;
            this.notifiedDeviceUids = new UID[0];
            this.propagateIfNeeded = false;
        }

        public ProcessInvitationOrMembersUpdateStep(InitialProtocolState startState, BlobKeysAfterChannelCreationMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = receivedMessage.groupInviter;
            this.startState = null;
            this.invitationCollectedData = new GroupV2.InvitationCollectedData();
            this.dialogUuid = UUID.randomUUID();
            this.ownInvitationNoncesAcceptedOnOtherDevices = new byte[0][];
            this.lastKnownOwnInvitationNonce = null;
            this.lastKnownOtherGroupMemberIdentities = null;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = receivedMessage.blobKeys;
            this.notifiedDeviceUids = new UID[0];
            this.propagateIfNeeded = false;
        }

        public ProcessInvitationOrMembersUpdateStep(INeedMoreSeedsState startState, InvitationOrMembersUpdateMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = receivedMessage.getReceptionChannelInfo().getRemoteIdentity();
            this.startState = startState;
            this.invitationCollectedData = startState.invitationCollectedData;
            this.dialogUuid = startState.dialogUuid;
            this.ownInvitationNoncesAcceptedOnOtherDevices = startState.ownInvitationNoncesAcceptedOnOtherDevices;
            this.lastKnownOwnInvitationNonce = startState.lastKnownOwnInvitationNonce;
            this.lastKnownOtherGroupMemberIdentities = startState.lastKnownOtherGroupMemberIdentities;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = receivedMessage.blobKeys;
            this.notifiedDeviceUids = receivedMessage.notifiedDeviceUids;
            this.propagateIfNeeded = true;
        }

        public ProcessInvitationOrMembersUpdateStep(INeedMoreSeedsState startState, InvitationOrMembersUpdateBroadcastMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = null;
            this.startState = startState;
            this.invitationCollectedData = startState.invitationCollectedData;
            this.dialogUuid = startState.dialogUuid;
            this.ownInvitationNoncesAcceptedOnOtherDevices = startState.ownInvitationNoncesAcceptedOnOtherDevices;
            this.lastKnownOwnInvitationNonce = startState.lastKnownOwnInvitationNonce;
            this.lastKnownOtherGroupMemberIdentities = startState.lastKnownOtherGroupMemberIdentities;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = new GroupV2.BlobKeys(null, receivedMessage.blobKeys.blobVersionSeed, receivedMessage.blobKeys.groupAdminServerAuthenticationPrivateKey);
            this.notifiedDeviceUids = new UID[0];
            this.propagateIfNeeded = true;
        }

        public ProcessInvitationOrMembersUpdateStep(INeedMoreSeedsState startState, InvitationOrMembersUpdatePropagatedMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = receivedMessage.inviterIdentity;
            this.startState = startState;
            this.invitationCollectedData = startState.invitationCollectedData;
            this.dialogUuid = startState.dialogUuid;
            this.ownInvitationNoncesAcceptedOnOtherDevices = startState.ownInvitationNoncesAcceptedOnOtherDevices;
            this.lastKnownOwnInvitationNonce = startState.lastKnownOwnInvitationNonce;
            this.lastKnownOtherGroupMemberIdentities = startState.lastKnownOtherGroupMemberIdentities;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = receivedMessage.blobKeys;
            this.notifiedDeviceUids = new UID[0];
            this.propagateIfNeeded = false;
        }

        public ProcessInvitationOrMembersUpdateStep(INeedMoreSeedsState startState, BlobKeysAfterChannelCreationMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = receivedMessage.groupInviter;
            this.startState = startState;
            this.invitationCollectedData = startState.invitationCollectedData;
            this.dialogUuid = startState.dialogUuid;
            this.ownInvitationNoncesAcceptedOnOtherDevices = startState.ownInvitationNoncesAcceptedOnOtherDevices;
            this.lastKnownOwnInvitationNonce = startState.lastKnownOwnInvitationNonce;
            this.lastKnownOtherGroupMemberIdentities = startState.lastKnownOtherGroupMemberIdentities;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = receivedMessage.blobKeys;
            this.notifiedDeviceUids = new UID[0];
            this.propagateIfNeeded = false;
        }

        public ProcessInvitationOrMembersUpdateStep(InvitationReceivedState startState, InvitationOrMembersUpdateMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = receivedMessage.getReceptionChannelInfo().getRemoteIdentity();
            this.startState = startState;
            this.invitationCollectedData = new GroupV2.InvitationCollectedData();
            this.invitationCollectedData.addBlobKeysCandidates(startState.inviterIdentity, startState.blobKeys);
            this.dialogUuid = startState.dialogUuid;
            byte[] nonce = null;
            ArrayList<Identity> identities = new ArrayList<Identity>();
            for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : startState.serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                if (Objects.equals(identityAndPermissionsAndDetails.identity, this.getOwnedIdentity())) {
                    nonce = identityAndPermissionsAndDetails.groupInvitationNonce;
                    continue;
                }
                identities.add(identityAndPermissionsAndDetails.identity);
            }
            this.ownInvitationNoncesAcceptedOnOtherDevices = new byte[0][];
            this.lastKnownOwnInvitationNonce = nonce;
            this.lastKnownOtherGroupMemberIdentities = identities.toArray(new Identity[0]);
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = receivedMessage.blobKeys;
            this.notifiedDeviceUids = receivedMessage.notifiedDeviceUids;
            this.propagateIfNeeded = true;
        }

        public ProcessInvitationOrMembersUpdateStep(InvitationReceivedState startState, InvitationOrMembersUpdateBroadcastMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = null;
            this.startState = startState;
            this.invitationCollectedData = new GroupV2.InvitationCollectedData();
            this.invitationCollectedData.addBlobKeysCandidates(startState.inviterIdentity, startState.blobKeys);
            this.dialogUuid = startState.dialogUuid;
            byte[] nonce = null;
            ArrayList<Identity> identities = new ArrayList<Identity>();
            for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : startState.serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                if (Objects.equals(identityAndPermissionsAndDetails.identity, this.getOwnedIdentity())) {
                    nonce = identityAndPermissionsAndDetails.groupInvitationNonce;
                    continue;
                }
                identities.add(identityAndPermissionsAndDetails.identity);
            }
            this.ownInvitationNoncesAcceptedOnOtherDevices = new byte[0][];
            this.lastKnownOwnInvitationNonce = nonce;
            this.lastKnownOtherGroupMemberIdentities = identities.toArray(new Identity[0]);
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = new GroupV2.BlobKeys(null, receivedMessage.blobKeys.blobVersionSeed, receivedMessage.blobKeys.groupAdminServerAuthenticationPrivateKey);
            this.notifiedDeviceUids = new UID[0];
            this.propagateIfNeeded = true;
        }

        public ProcessInvitationOrMembersUpdateStep(InvitationReceivedState startState, InvitationOrMembersUpdatePropagatedMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = receivedMessage.inviterIdentity;
            this.startState = startState;
            this.invitationCollectedData = new GroupV2.InvitationCollectedData();
            this.invitationCollectedData.addBlobKeysCandidates(startState.inviterIdentity, startState.blobKeys);
            this.dialogUuid = startState.dialogUuid;
            byte[] nonce = null;
            ArrayList<Identity> identities = new ArrayList<Identity>();
            for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : startState.serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                if (Objects.equals(identityAndPermissionsAndDetails.identity, this.getOwnedIdentity())) {
                    nonce = identityAndPermissionsAndDetails.groupInvitationNonce;
                    continue;
                }
                identities.add(identityAndPermissionsAndDetails.identity);
            }
            this.ownInvitationNoncesAcceptedOnOtherDevices = new byte[0][];
            this.lastKnownOwnInvitationNonce = nonce;
            this.lastKnownOtherGroupMemberIdentities = identities.toArray(new Identity[0]);
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = receivedMessage.blobKeys;
            this.notifiedDeviceUids = new UID[0];
            this.propagateIfNeeded = false;
        }

        public ProcessInvitationOrMembersUpdateStep(InvitationReceivedState startState, BlobKeysAfterChannelCreationMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.obliviousChannelContactIdentity = receivedMessage.groupInviter;
            this.startState = startState;
            this.invitationCollectedData = new GroupV2.InvitationCollectedData();
            this.invitationCollectedData.addBlobKeysCandidates(startState.inviterIdentity, startState.blobKeys);
            this.dialogUuid = startState.dialogUuid;
            byte[] nonce = null;
            ArrayList<Identity> identities = new ArrayList<Identity>();
            for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : startState.serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                if (Objects.equals(identityAndPermissionsAndDetails.identity, this.getOwnedIdentity())) {
                    nonce = identityAndPermissionsAndDetails.groupInvitationNonce;
                    continue;
                }
                identities.add(identityAndPermissionsAndDetails.identity);
            }
            this.ownInvitationNoncesAcceptedOnOtherDevices = new byte[0][];
            this.lastKnownOwnInvitationNonce = nonce;
            this.lastKnownOtherGroupMemberIdentities = identities.toArray(new Identity[0]);
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.groupVersion = receivedMessage.groupVersion;
            this.blobKeys = receivedMessage.blobKeys;
            this.notifiedDeviceUids = new UID[0];
            this.propagateIfNeeded = false;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            Integer dbGroupVersion;
            Object coreProtocolMessage2;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.getProtocolInstanceUid().equals(this.groupIdentifier.computeProtocolInstanceUid())) {
                if (this.startState != null) {
                    return this.startState;
                }
                return new FinalState();
            }
            if (this.propagateIfNeeded) {
                UID[] otherOwnedDeviceUids = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
                HashSet<UID> notNotifiedUids = new HashSet<UID>(Arrays.asList(otherOwnedDeviceUids));
                for (UID deviceUid : this.notifiedDeviceUids) {
                    notNotifiedUids.remove(deviceUid);
                }
                if (!notNotifiedUids.isEmpty()) {
                    try {
                        coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createObliviousChannelOrPreKeyInfo(this.getOwnedIdentity(), this.getOwnedIdentity(), notNotifiedUids.toArray(new UID[0]), true));
                        ChannelProtocolMessageToSend messageToSend = new InvitationOrMembersUpdatePropagatedMessage((CoreProtocolMessage)coreProtocolMessage2, this.groupIdentifier, this.groupVersion, this.blobKeys, this.obliviousChannelContactIdentity).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (NoAcceptableChannelException coreProtocolMessage2) {
                        // empty catch block
                    }
                }
            }
            if (this.startState instanceof InvitationReceivedState) {
                if (((InvitationReceivedState)this.startState).serverBlob.version > this.groupVersion || ((InvitationReceivedState)this.startState).serverBlob.version == this.groupVersion && !Objects.equals(this.obliviousChannelContactIdentity, this.getOwnedIdentity())) {
                    return this.startState;
                }
                HashSet<ObvGroupV2.ObvGroupV2PendingMember> groupV2PendingMembers = new HashSet<ObvGroupV2.ObvGroupV2PendingMember>();
                HashSet<GroupV2.Permission> ownPermissions = new HashSet();
                for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : ((InvitationReceivedState)this.startState).serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                    if (Objects.equals(identityAndPermissionsAndDetails.identity, this.getOwnedIdentity())) {
                        ownPermissions = GroupV2.Permission.fromStrings(identityAndPermissionsAndDetails.permissionStrings);
                        continue;
                    }
                    groupV2PendingMembers.add(new ObvGroupV2.ObvGroupV2PendingMember(identityAndPermissionsAndDetails.identity.getBytes(), GroupV2.Permission.fromStrings(identityAndPermissionsAndDetails.permissionStrings), identityAndPermissionsAndDetails.serializedIdentityDetails));
                }
                coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createGroupV2FrozenInvitationDialog(((InvitationReceivedState)this.startState).inviterIdentity, new ObvGroupV2(this.getOwnedIdentity().getBytes(), ((InvitationReceivedState)this.startState).groupIdentifier, ownPermissions, null, groupV2PendingMembers, ((InvitationReceivedState)this.startState).serverBlob.serializedGroupDetails, null, null, null, 0L)), ((InvitationReceivedState)this.startState).dialogUuid));
                ChannelDialogMessageToSend messageToSend = new DialogAcceptGroupInvitationMessage((CoreProtocolMessage)coreProtocolMessage2).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            if ((dbGroupVersion = protocolManagerSession.identityDelegate.getGroupV2Version(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier)) != null) {
                byte[] ownGroupInvitationNonce;
                if (dbGroupVersion <= this.groupVersion && this.obliviousChannelContactIdentity != null && protocolManagerSession.identityDelegate.isIdentityAPendingGroupV2Member(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier, this.obliviousChannelContactIdentity) && (ownGroupInvitationNonce = protocolManagerSession.identityDelegate.getGroupV2OwnGroupInvitationNonce(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier)) != null) {
                    byte[] pingSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_JOIN_NONCE, this.groupIdentifier, ownGroupInvitationNonce, this.obliviousChannelContactIdentity, this.getOwnedIdentity(), this.getPrng());
                    CoreProtocolMessage coreProtocolMessage3 = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(this.obliviousChannelContactIdentity, this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PingMessage(coreProtocolMessage3, this.groupIdentifier, ownGroupInvitationNonce, pingSignature, false).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                if (dbGroupVersion >= this.groupVersion) {
                    if (this.startState != null) {
                        return this.startState;
                    }
                    return new FinalState();
                }
            }
            if (dbGroupVersion != null) {
                GroupV2.BlobKeys blobKeys = protocolManagerSession.identityDelegate.getGroupV2BlobKeys(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier);
                this.invitationCollectedData.addBlobKeysCandidates(this.getOwnedIdentity(), blobKeys);
                protocolManagerSession.identityDelegate.freezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier);
            }
            this.invitationCollectedData.addBlobKeysCandidates(this.obliviousChannelContactIdentity, this.blobKeys);
            byte[] serverQueryNonce = this.getPrng().bytes(16);
            coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.GetGroupBlobQuery(this.groupIdentifier, serverQueryNonce)));
            ChannelServerQueryMessageToSend messageToSend = new DownloadGroupBlobMessage((CoreProtocolMessage)coreProtocolMessage2).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new DownloadingGroupBlobState(this.groupIdentifier, this.dialogUuid, this.invitationCollectedData, this.ownInvitationNoncesAcceptedOnOtherDevices, this.lastKnownOwnInvitationNonce, this.lastKnownOtherGroupMemberIdentities, serverQueryNonce);
        }
    }

    public static class DoNothingAfterServerQueryStep
    extends ProtocolStep {
        public DoNothingAfterServerQueryStep(InitialProtocolState startState, DeleteGroupBlobFromServerMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            return new FinalState();
        }
    }

    public static class ProcessPingStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PingMessage receivedMessage;
        private final boolean propagationNeeded;

        public ProcessPingStep(InitialProtocolState startState, PingMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagationNeeded = true;
        }

        public ProcessPingStep(InitialProtocolState startState, PropagatedPingMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagationNeeded = false;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            byte[] ownGroupInvitationNonce;
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.getProtocolInstanceUid().equals(this.receivedMessage.groupIdentifier.computeProtocolInstanceUid())) {
                return new FinalState();
            }
            if (GroupV2SignatureReceived.exists(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature)) {
                if (this.propagationNeeded) {
                    Logger.i("Received a group join ping with a known signature");
                }
                return new FinalState();
            }
            if (this.propagationNeeded && (numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagatedPingMessage(coreProtocolMessage, this.receivedMessage.groupIdentifier, this.receivedMessage.groupMemberInvitationNonce, this.receivedMessage.signature, this.receivedMessage.isResponse).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            if ((ownGroupInvitationNonce = protocolManagerSession.identityDelegate.getGroupV2OwnGroupInvitationNonce(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier)) == null) {
                return new FinalState();
            }
            Identity pingSenderIdentity = null;
            List<Identity> pingSenderCandidates = protocolManagerSession.identityDelegate.getGroupV2MembersAndPendingMembersFromNonce(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier, this.receivedMessage.groupMemberInvitationNonce);
            if (pingSenderCandidates != null) {
                for (Identity pingSenderCandidate : pingSenderCandidates) {
                    if (!Signature.verify(Constants.SignatureContext.GROUP_JOIN_NONCE, this.receivedMessage.groupIdentifier, this.receivedMessage.groupMemberInvitationNonce, this.getOwnedIdentity(), pingSenderCandidate, this.receivedMessage.signature)) continue;
                    pingSenderIdentity = pingSenderCandidate;
                    break;
                }
            }
            if (pingSenderIdentity == null) {
                return new FinalState();
            }
            if (!this.receivedMessage.isResponse) {
                byte[] pingSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_JOIN_NONCE, this.receivedMessage.groupIdentifier, ownGroupInvitationNonce, pingSenderIdentity, this.getOwnedIdentity(), this.getPrng());
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(pingSenderIdentity, this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new PingMessage(coreProtocolMessage, this.receivedMessage.groupIdentifier, ownGroupInvitationNonce, pingSignature, true).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            GroupV2SignatureReceived.create(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature);
            protocolManagerSession.identityDelegate.moveGroupV2PendingMemberToMembers(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier, pingSenderIdentity);
            return new FinalState();
        }
    }

    public static class InitiateBlobReDownloadStep
    extends ProtocolStep {
        private final ConcreteProtocolState startState;
        private final GroupV2.Identifier groupIdentifier;
        private final UUID dialogUuid;
        private final GroupV2.InvitationCollectedData invitationCollectedData;
        private final boolean propagationNeeded;
        private final boolean repingAllGroupMembers;

        public InitiateBlobReDownloadStep(InitialProtocolState startState, GroupReDownloadInitialMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = null;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.dialogUuid = UUID.randomUUID();
            this.invitationCollectedData = null;
            this.propagationNeeded = true;
            this.repingAllGroupMembers = true;
        }

        public InitiateBlobReDownloadStep(InitialProtocolState startState, InvitationRejectedBroadcastMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = null;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.dialogUuid = UUID.randomUUID();
            this.invitationCollectedData = null;
            this.propagationNeeded = true;
            this.repingAllGroupMembers = false;
        }

        public InitiateBlobReDownloadStep(InitialProtocolState startState, PropagateInvitationRejectedMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = null;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.dialogUuid = UUID.randomUUID();
            this.invitationCollectedData = null;
            this.propagationNeeded = false;
            this.repingAllGroupMembers = false;
        }

        public InitiateBlobReDownloadStep(InvitationReceivedState startState, InvitationRejectedBroadcastMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.dialogUuid = startState.dialogUuid;
            this.invitationCollectedData = new GroupV2.InvitationCollectedData();
            this.invitationCollectedData.addBlobKeysCandidates(startState.inviterIdentity, startState.blobKeys);
            this.propagationNeeded = true;
            this.repingAllGroupMembers = false;
        }

        public InitiateBlobReDownloadStep(InvitationReceivedState startState, PropagateInvitationRejectedMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.dialogUuid = startState.dialogUuid;
            this.invitationCollectedData = new GroupV2.InvitationCollectedData();
            this.invitationCollectedData.addBlobKeysCandidates(startState.inviterIdentity, startState.blobKeys);
            this.propagationNeeded = false;
            this.repingAllGroupMembers = false;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.getProtocolInstanceUid().equals(this.groupIdentifier.computeProtocolInstanceUid())) {
                if (this.startState != null) {
                    return this.startState;
                }
                return new FinalState();
            }
            if (this.propagationNeeded && (numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagateInvitationRejectedMessage(coreProtocolMessage, this.groupIdentifier).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            if (this.invitationCollectedData == null) {
                GroupV2.BlobKeys blobKeys = protocolManagerSession.identityDelegate.getGroupV2BlobKeys(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier);
                if (blobKeys == null) {
                    if (this.startState != null) {
                        return this.startState;
                    }
                    return new FinalState();
                }
                if (this.repingAllGroupMembers) {
                    try {
                        byte[] ownGroupInvitationNonce = protocolManagerSession.identityDelegate.getGroupV2OwnGroupInvitationNonce(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier);
                        if (ownGroupInvitationNonce != null) {
                            for (GroupV2.IdentityAndPermissions groupMember : protocolManagerSession.identityDelegate.getGroupV2OtherMembersAndPermissions(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier)) {
                                byte[] pingSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_JOIN_NONCE, this.groupIdentifier, ownGroupInvitationNonce, groupMember.identity, this.getOwnedIdentity(), this.getPrng());
                                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(groupMember.identity, this.getOwnedIdentity()));
                                ChannelProtocolMessageToSend messageToSend = new PingMessage(coreProtocolMessage, this.groupIdentifier, ownGroupInvitationNonce, pingSignature, false).generateChannelProtocolMessageToSend();
                                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                }
                protocolManagerSession.identityDelegate.freezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier);
                byte[] serverQueryNonce = this.getPrng().bytes(16);
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.GetGroupBlobQuery(this.groupIdentifier, serverQueryNonce)));
                ChannelServerQueryMessageToSend messageToSend = new DownloadGroupBlobMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                GroupV2.InvitationCollectedData invitationCollectedData = new GroupV2.InvitationCollectedData();
                invitationCollectedData.addBlobKeysCandidates(this.getOwnedIdentity(), blobKeys);
                return new DownloadingGroupBlobState(this.groupIdentifier, this.dialogUuid, invitationCollectedData, new byte[0][], null, null, serverQueryNonce);
            }
            if (this.startState instanceof InvitationReceivedState) {
                byte[] ownInvitationNonce = null;
                ArrayList<Identity> otherGroupMemberIdentities = new ArrayList<Identity>();
                HashSet<ObvGroupV2.ObvGroupV2PendingMember> groupV2PendingMembers = new HashSet<ObvGroupV2.ObvGroupV2PendingMember>();
                HashSet<GroupV2.Permission> ownPermissions = new HashSet();
                for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : ((InvitationReceivedState)this.startState).serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                    if (Objects.equals(identityAndPermissionsAndDetails.identity, this.getOwnedIdentity())) {
                        ownPermissions = GroupV2.Permission.fromStrings(identityAndPermissionsAndDetails.permissionStrings);
                        ownInvitationNonce = identityAndPermissionsAndDetails.groupInvitationNonce;
                        continue;
                    }
                    otherGroupMemberIdentities.add(identityAndPermissionsAndDetails.identity);
                    groupV2PendingMembers.add(new ObvGroupV2.ObvGroupV2PendingMember(identityAndPermissionsAndDetails.identity.getBytes(), GroupV2.Permission.fromStrings(identityAndPermissionsAndDetails.permissionStrings), identityAndPermissionsAndDetails.serializedIdentityDetails));
                }
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createGroupV2FrozenInvitationDialog(((InvitationReceivedState)this.startState).inviterIdentity, new ObvGroupV2(this.getOwnedIdentity().getBytes(), ((InvitationReceivedState)this.startState).groupIdentifier, ownPermissions, null, groupV2PendingMembers, ((InvitationReceivedState)this.startState).serverBlob.serializedGroupDetails, null, null, null, 0L)), ((InvitationReceivedState)this.startState).dialogUuid));
                ChannelDialogMessageToSend messageToSend = new DialogAcceptGroupInvitationMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                byte[] serverQueryNonce = this.getPrng().bytes(16);
                CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.GetGroupBlobQuery(this.groupIdentifier, serverQueryNonce)));
                ChannelServerQueryMessageToSend messageToSend2 = new DownloadGroupBlobMessage(coreProtocolMessage2).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                return new DownloadingGroupBlobState(this.groupIdentifier, this.dialogUuid, this.invitationCollectedData, new byte[0][], ownInvitationNonce, otherGroupMemberIdentities.toArray(new Identity[0]), serverQueryNonce);
            }
            return new FinalState();
        }
    }

    public static class InitiateGroupUpdateStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final GroupUpdateInitialMessage receivedMessage;

        public InitiateGroupUpdateStep(InitialProtocolState startState, GroupUpdateInitialMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            boolean removedOurAdminPermission;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            GroupV2.BlobKeys blobKeys = protocolManagerSession.identityDelegate.getGroupV2BlobKeys(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier);
            boolean adminKeyIsMissing = blobKeys == null || blobKeys.groupAdminServerAuthenticationPrivateKey == null;
            boolean removedOurself = this.receivedMessage.changeSet.removedMembers.contains(this.getOwnedIdentity().getBytes());
            HashSet<GroupV2.Permission> ownPermissions = this.receivedMessage.changeSet.permissionChanges.get(new ObvBytesKey(this.getOwnedIdentity().getBytes()));
            boolean bl = removedOurAdminPermission = ownPermissions != null && !ownPermissions.contains((Object)GroupV2.Permission.GROUP_ADMIN);
            if (adminKeyIsMissing || removedOurself || removedOurAdminPermission) {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", this.getOwnedIdentity());
                userInfo.put("group_identifier", this.receivedMessage.groupIdentifier);
                userInfo.put("error", true);
                protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_group_v2_update_failed", userInfo);
                return new FinalState();
            }
            if (this.receivedMessage.changeSet.isEmpty()) {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", this.getOwnedIdentity());
                userInfo.put("group_identifier", this.receivedMessage.groupIdentifier);
                userInfo.put("error", false);
                protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_group_v2_update_failed", userInfo);
                return new FinalState();
            }
            protocolManagerSession.identityDelegate.freezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier);
            byte[] lockNonce = this.getPrng().bytes(32);
            byte[] signature = Signature.sign(Constants.SignatureContext.GROUP_LOCK_ON_SERVER, lockNonce, blobKeys.groupAdminServerAuthenticationPrivateKey.getSignaturePrivateKey(), this.getPrng());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.LockGroupBlobQuery(this.receivedMessage.groupIdentifier, lockNonce, signature)));
            ChannelServerQueryMessageToSend messageToSend = new RequestLockMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitingForLockState(this.receivedMessage.groupIdentifier, this.receivedMessage.changeSet, lockNonce, 0L);
        }
    }

    public static class GetKickedStep
    extends ProtocolStep {
        private final ConcreteProtocolState startState;
        private final KickMessage receivedMessage;
        private final boolean propagated;

        public GetKickedStep(InitialProtocolState startState, KickMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagated = false;
        }

        public GetKickedStep(InvitationReceivedState startState, KickMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagated = false;
        }

        public GetKickedStep(DownloadingGroupBlobState startState, KickMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagated = false;
        }

        public GetKickedStep(INeedMoreSeedsState startState, KickMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagated = false;
        }

        public GetKickedStep(WaitingForLockState startState, KickMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagated = false;
        }

        public GetKickedStep(InitialProtocolState startState, PropagatedKickMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagated = true;
        }

        public GetKickedStep(InvitationReceivedState startState, PropagatedKickMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagated = true;
        }

        public GetKickedStep(DownloadingGroupBlobState startState, PropagatedKickMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagated = true;
        }

        public GetKickedStep(INeedMoreSeedsState startState, PropagatedKickMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagated = true;
        }

        public GetKickedStep(WaitingForLockState startState, PropagatedKickMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
            this.propagated = true;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            GroupV2.AdministratorsChain knownAdministratorsChain;
            GroupV2.BlobKeys blobKeys;
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.getProtocolInstanceUid().equals(this.receivedMessage.groupIdentifier.computeProtocolInstanceUid())) {
                return this.startState;
            }
            if (!this.propagated && (numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagatedKickMessage(coreProtocolMessage, this.receivedMessage.groupIdentifier, this.receivedMessage.encryptedAdministratorsChain, this.receivedMessage.signature).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            byte[] invitationNonce = null;
            if (this.startState instanceof InvitationReceivedState) {
                blobKeys = ((InvitationReceivedState)this.startState).blobKeys;
                knownAdministratorsChain = ((InvitationReceivedState)this.startState).serverBlob.administratorsChain;
                GroupV2.IdentityAndPermissionsAndDetails ownIdentityAndPermissionsAndDetails = null;
                for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : ((InvitationReceivedState)this.startState).serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                    if (!identityAndPermissionsAndDetails.identity.equals(this.getOwnedIdentity())) continue;
                    ownIdentityAndPermissionsAndDetails = identityAndPermissionsAndDetails;
                    break;
                }
                if (ownIdentityAndPermissionsAndDetails != null) {
                    invitationNonce = ownIdentityAndPermissionsAndDetails.groupInvitationNonce;
                }
            } else {
                blobKeys = protocolManagerSession.identityDelegate.getGroupV2BlobKeys(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier);
                knownAdministratorsChain = protocolManagerSession.identityDelegate.getGroupV2AdministratorsChain(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier);
                invitationNonce = protocolManagerSession.identityDelegate.getGroupV2OwnGroupInvitationNonce(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier);
            }
            if (invitationNonce != null && blobKeys != null && blobKeys.blobMainSeed != null) {
                AuthEncKey encryptionKey = (AuthEncKey)Suite.getKDF("kdf_sha-256").gen(blobKeys.blobMainSeed, Suite.getDefaultAuthEnc(0).getKDFDelegate())[0];
                byte[] chainPlaintext = Suite.getAuthEnc(encryptionKey).decrypt(encryptionKey, this.receivedMessage.encryptedAdministratorsChain);
                GroupV2.AdministratorsChain administratorsChain = GroupV2.AdministratorsChain.of(new Encoded(chainPlaintext));
                try {
                    administratorsChain.withCheckedIntegrity(this.receivedMessage.groupIdentifier.groupUid, null, knownAdministratorsChain);
                }
                catch (Exception ignored) {
                    return this.startState;
                }
                byte[] dataToSign = new byte[this.receivedMessage.encryptedAdministratorsChain.length + invitationNonce.length];
                System.arraycopy(this.receivedMessage.encryptedAdministratorsChain.getBytes(), 0, dataToSign, 0, this.receivedMessage.encryptedAdministratorsChain.length);
                System.arraycopy(invitationNonce, 0, dataToSign, this.receivedMessage.encryptedAdministratorsChain.length, invitationNonce.length);
                boolean valid = false;
                Identity kicker = null;
                for (Identity identity : administratorsChain.getAdminIdentities()) {
                    if (!Signature.verify(Constants.SignatureContext.GROUP_KICK, dataToSign, identity, this.receivedMessage.signature)) continue;
                    valid = true;
                    kicker = identity;
                    break;
                }
                if (valid) {
                    if (this.startState instanceof InvitationReceivedState) {
                        CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), ((InvitationReceivedState)this.startState).dialogUuid));
                        ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    protocolManagerSession.identityDelegate.deleteGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier, kicker);
                    if (this.startState instanceof DownloadingGroupBlobState || this.startState instanceof INeedMoreSeedsState) {
                        return this.startState;
                    }
                    return new FinalState();
                }
            }
            return this.startState;
        }
    }

    public static class LeaveGroupStep
    extends ProtocolStep {
        private final ConcreteProtocolState startState;
        private final GroupV2.Identifier groupIdentifier;
        private final boolean propagated;
        private final byte[] ownGroupInvitationNonce;

        public LeaveGroupStep(InitialProtocolState startState, GroupLeaveInitialMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = false;
            this.ownGroupInvitationNonce = null;
        }

        public LeaveGroupStep(DownloadingGroupBlobState startState, GroupLeaveInitialMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = false;
            this.ownGroupInvitationNonce = null;
        }

        public LeaveGroupStep(INeedMoreSeedsState startState, GroupLeaveInitialMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = false;
            this.ownGroupInvitationNonce = null;
        }

        public LeaveGroupStep(WaitingForLockState startState, GroupLeaveInitialMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = false;
            this.ownGroupInvitationNonce = null;
        }

        public LeaveGroupStep(InitialProtocolState startState, PropagatedGroupLeaveMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = true;
            this.ownGroupInvitationNonce = receivedMessage.ownInvitationNonce;
        }

        public LeaveGroupStep(DownloadingGroupBlobState startState, PropagatedGroupLeaveMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = true;
            this.ownGroupInvitationNonce = receivedMessage.ownInvitationNonce;
        }

        public LeaveGroupStep(INeedMoreSeedsState startState, PropagatedGroupLeaveMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = true;
            this.ownGroupInvitationNonce = receivedMessage.ownInvitationNonce;
        }

        public LeaveGroupStep(WaitingForLockState startState, PropagatedGroupLeaveMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = true;
            this.ownGroupInvitationNonce = receivedMessage.ownInvitationNonce;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            boolean admin;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.getProtocolInstanceUid().equals(this.groupIdentifier.computeProtocolInstanceUid())) {
                return this.startState;
            }
            byte[] ownGroupInvitationNonce = protocolManagerSession.identityDelegate.getGroupV2OwnGroupInvitationNonce(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier);
            if (ownGroupInvitationNonce == null) {
                return this.startState;
            }
            if (this.propagated && !Arrays.equals(this.ownGroupInvitationNonce, ownGroupInvitationNonce)) {
                return this.startState;
            }
            boolean frozen = protocolManagerSession.identityDelegate.isGroupV2Frozen(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier);
            if (!frozen && (admin = protocolManagerSession.identityDelegate.getGroupV2AdminStatus(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier)) && !protocolManagerSession.identityDelegate.getGroupV2HasOtherAdminMember(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier)) {
                return this.startState;
            }
            ArrayList<Identity> groupMembersToNotify = new ArrayList<Identity>();
            if (!this.propagated) {
                int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
                if (numberOfOtherDevices > 0) {
                    try {
                        CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                        ChannelProtocolMessageToSend messageToSend = new PropagatedGroupLeaveMessage(coreProtocolMessage, this.groupIdentifier, ownGroupInvitationNonce).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (NoAcceptableChannelException coreProtocolMessage) {
                        // empty catch block
                    }
                }
                byte[] leaveSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_LEAVE_NONCE, this.groupIdentifier, ownGroupInvitationNonce, null, this.getOwnedIdentity(), this.getPrng());
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.PutGroupLogQuery(this.groupIdentifier, leaveSignature)));
                ChannelServerQueryMessageToSend messageToSend = new PutGroupLogOnServerMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                for (GroupV2.IdentityAndPermissions groupMember : protocolManagerSession.identityDelegate.getGroupV2OtherMembersAndPermissions(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier)) {
                    groupMembersToNotify.add(groupMember.identity);
                }
            }
            protocolManagerSession.identityDelegate.deleteGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier, this.getOwnedIdentity());
            if (this.propagated) {
                return new FinalState();
            }
            return new RejectingInvitationOrLeavingGroupState(this.groupIdentifier, groupMembersToNotify);
        }
    }

    public static class DisbandGroupStep
    extends ProtocolStep {
        private final ConcreteProtocolState startState;
        private final GroupV2.Identifier groupIdentifier;
        private final boolean propagated;

        public DisbandGroupStep(InitialProtocolState startState, GroupDisbandInitialMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = false;
        }

        public DisbandGroupStep(WaitingForLockState startState, GroupDisbandInitialMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = false;
        }

        public DisbandGroupStep(UploadingUpdatedGroupBlobState startState, GroupDisbandInitialMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = false;
        }

        public DisbandGroupStep(UploadingUpdatedGroupPhotoState startState, GroupDisbandInitialMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = false;
        }

        public DisbandGroupStep(InitialProtocolState startState, PropagatedGroupDisbandMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = true;
        }

        public DisbandGroupStep(DownloadingGroupBlobState startState, PropagatedGroupDisbandMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = true;
        }

        public DisbandGroupStep(INeedMoreSeedsState startState, PropagatedGroupDisbandMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = true;
        }

        public DisbandGroupStep(InvitationReceivedState startState, PropagatedGroupDisbandMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = true;
        }

        public DisbandGroupStep(WaitingForLockState startState, PropagatedGroupDisbandMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = true;
        }

        public DisbandGroupStep(UploadingUpdatedGroupBlobState startState, PropagatedGroupDisbandMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = true;
        }

        public DisbandGroupStep(UploadingUpdatedGroupPhotoState startState, PropagatedGroupDisbandMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.groupIdentifier = receivedMessage.groupIdentifier;
            this.propagated = true;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.getProtocolInstanceUid().equals(this.groupIdentifier.computeProtocolInstanceUid())) {
                return this.startState;
            }
            boolean admin = protocolManagerSession.identityDelegate.getGroupV2AdminStatus(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier);
            GroupV2.BlobKeys blobKeys = protocolManagerSession.identityDelegate.getGroupV2BlobKeys(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier);
            if (!admin || blobKeys == null || blobKeys.groupAdminServerAuthenticationPrivateKey == null) {
                return new FinalState();
            }
            if (!this.propagated) {
                byte[] signature = Signature.sign(Constants.SignatureContext.GROUP_DELETE_ON_SERVER, blobKeys.groupAdminServerAuthenticationPrivateKey.getSignaturePrivateKey(), this.getPrng());
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.DeleteGroupBlobQuery(this.groupIdentifier, signature)));
                ChannelServerQueryMessageToSend messageToSend = new DeleteGroupBlobFromServerMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                protocolManagerSession.identityDelegate.freezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier);
                return new DisbandingGroupState(this.groupIdentifier, blobKeys);
            }
            protocolManagerSession.identityDelegate.deleteGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier, this.getOwnedIdentity());
            return new FinalState();
        }
    }

    public static class PrepareBatchKeysMessageStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitiateBatchKeysResendMessage receivedMessage;

        public PrepareBatchKeysMessageStep(InitialProtocolState startState, InitiateBatchKeysResendMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            GroupV2.IdentifierVersionAndKeys[] identifierVersionAndKeys = Objects.equals(this.receivedMessage.contactIdentity, this.getOwnedIdentity()) ? protocolManagerSession.identityDelegate.getAllServerGroupsV2IdentifierVersionAndKeys(protocolManagerSession.session, this.getOwnedIdentity()) : protocolManagerSession.identityDelegate.getServerGroupsV2IdentifierVersionAndKeysForContact(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity);
            if (identifierVersionAndKeys.length > 0) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createObliviousChannelOrPreKeyInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity(), new UID[]{this.receivedMessage.contactDeviceUid}, false));
                ChannelProtocolMessageToSend messageToSend = new BlobKeysBatchAfterChannelCreationMessage(coreProtocolMessage, identifierVersionAndKeys).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new FinalState();
        }
    }

    public static class ProcessBatchKeysMessageStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final BlobKeysBatchAfterChannelCreationMessage receivedMessage;

        public ProcessBatchKeysMessageStep(InitialProtocolState startState, BlobKeysBatchAfterChannelCreationMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            for (GroupV2.IdentifierVersionAndKeys identifierVersionAndKeys : this.receivedMessage.groupInfos) {
                UID protocolInstanceUid = identifierVersionAndKeys.groupIdentifier.computeProtocolInstanceUid();
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 18, protocolInstanceUid);
                ChannelProtocolMessageToSend messageToSend = new BlobKeysAfterChannelCreationMessage(coreProtocolMessage, this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity(), identifierVersionAndKeys.groupIdentifier, identifierVersionAndKeys.groupVersion, identifierVersionAndKeys.blobKeys).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new FinalState();
        }
    }

    public static class ProcessCreateOrUpdateKeycloakGroupMessage
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final CreateOrUpdateKeycloakGroupMessage receivedMessage;

        public ProcessCreateOrUpdateKeycloakGroupMessage(InitialProtocolState startState, CreateOrUpdateKeycloakGroupMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            KeycloakGroupBlob keycloakGroupBlob;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.getProtocolInstanceUid().equals(this.receivedMessage.groupIdentifier.computeProtocolInstanceUid())) {
                return new FinalState();
            }
            try {
                keycloakGroupBlob = (KeycloakGroupBlob)this.protocol.getJsonObjectMapper().readValue(this.receivedMessage.serializedKeycloakGroupBlob, KeycloakGroupBlob.class);
            }
            catch (JsonProcessingException e) {
                Logger.x(e);
                return new FinalState();
            }
            Long existingGroupTimestamp = protocolManagerSession.identityDelegate.getGroupV2LastModificationTimestamp(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier);
            if (existingGroupTimestamp == null) {
                byte[] ownGroupInvitationNonce = protocolManagerSession.identityDelegate.createKeycloakGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier, keycloakGroupBlob);
                if (ownGroupInvitationNonce == null) {
                    return null;
                }
                if (keycloakGroupBlob.photoUid != null && keycloakGroupBlob.encodedPhotoKey != null) {
                    try {
                        UID photoUid = new UID(keycloakGroupBlob.photoUid);
                        AuthEncKey photoKey = (AuthEncKey)new Encoded(keycloakGroupBlob.encodedPhotoKey).decodeSymmetricKey();
                        GroupV2.ServerPhotoInfo serverPhotoInfo = new GroupV2.ServerPhotoInfo(null, photoUid, photoKey);
                        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 19, new UID(this.getPrng()));
                        ChannelProtocolMessageToSend messageToSend = new DownloadGroupV2PhotoProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.groupIdentifier, serverPhotoInfo).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                }
                for (KeycloakGroupMemberAndPermissions groupMemberAndPermissions : keycloakGroupBlob.groupMembersAndPermissions) {
                    Identity groupMemberIdentity = Identity.of(groupMemberAndPermissions.identity);
                    if (this.getOwnedIdentity().equals(groupMemberIdentity)) continue;
                    byte[] pingSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_JOIN_NONCE, this.receivedMessage.groupIdentifier, ownGroupInvitationNonce, groupMemberIdentity, this.getOwnedIdentity(), this.getPrng());
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(groupMemberIdentity, this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PingMessage(coreProtocolMessage, this.receivedMessage.groupIdentifier, ownGroupInvitationNonce, pingSignature, false).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
            } else if (existingGroupTimestamp < keycloakGroupBlob.timestamp) {
                ChannelProtocolMessageToSend messageToSend;
                CoreProtocolMessage coreProtocolMessage;
                KeycloakGroupV2UpdateOutput updateOutput = protocolManagerSession.identityDelegate.updateKeycloakGroupV2WithNewBlob(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier, keycloakGroupBlob);
                if (updateOutput == null) {
                    return null;
                }
                if (updateOutput.photoNeedsToBeDownloaded) {
                    try {
                        UID photoUid = new UID(keycloakGroupBlob.photoUid);
                        AuthEncKey photoKey = (AuthEncKey)new Encoded(keycloakGroupBlob.encodedPhotoKey).decodeSymmetricKey();
                        GroupV2.ServerPhotoInfo serverPhotoInfo = new GroupV2.ServerPhotoInfo(null, photoUid, photoKey);
                        coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 19, new UID(this.getPrng()));
                        messageToSend = new DownloadGroupV2PhotoProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.groupIdentifier, serverPhotoInfo).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                }
                for (Identity groupMemberIdentity : updateOutput.membersWithNewInvitationNonce) {
                    byte[] pingSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_JOIN_NONCE, this.receivedMessage.groupIdentifier, updateOutput.ownInvitationNonce, groupMemberIdentity, this.getOwnedIdentity(), this.getPrng());
                    coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(groupMemberIdentity, this.getOwnedIdentity()));
                    messageToSend = new PingMessage(coreProtocolMessage, this.receivedMessage.groupIdentifier, updateOutput.ownInvitationNonce, pingSignature, false).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
            } else if (existingGroupTimestamp > keycloakGroupBlob.timestamp) {
                Logger.i("Received a keycloak group blob with an older timestamp than our current group");
            } else {
                Logger.d("Received a keycloak blob we already received. Nothing wrong about that.");
            }
            return new FinalState();
        }
    }

    public static class SendKeycloakGroupTargetedPingStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitiateTargetedPingMessage receivedMessage;

        public SendKeycloakGroupTargetedPingStep(InitialProtocolState startState, InitiateTargetedPingMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.getProtocolInstanceUid().equals(this.receivedMessage.groupIdentifier.computeProtocolInstanceUid())) {
                return new FinalState();
            }
            byte[] ownInvitationNonce = protocolManagerSession.identityDelegate.getGroupV2OwnGroupInvitationNonce(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupIdentifier);
            byte[] pingSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_JOIN_NONCE, this.receivedMessage.groupIdentifier, ownInvitationNonce, this.receivedMessage.pendingMemberIdentity, this.getOwnedIdentity(), this.getPrng());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(this.receivedMessage.pendingMemberIdentity, this.getOwnedIdentity()));
            ChannelProtocolMessageToSend messageToSend = new PingMessage(coreProtocolMessage, this.receivedMessage.groupIdentifier, ownInvitationNonce, pingSignature, false).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new FinalState();
        }
    }

    public static class CheckIfGroupCreationCanBeFinalizedStep
    extends ProtocolStep {
        private final UploadingCreatedGroupDataState startState;
        private final UploadType uploadType;
        private final int uploadResult;

        public CheckIfGroupCreationCanBeFinalizedStep(UploadingCreatedGroupDataState startState, UploadGroupPhotoMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.uploadType = UploadType.PHOTO;
            this.uploadResult = 0;
        }

        public CheckIfGroupCreationCanBeFinalizedStep(UploadingCreatedGroupDataState startState, UploadGroupBlobMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.uploadType = UploadType.BLOB;
            this.uploadResult = receivedMessage.uploadResult;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            GroupV2.Identifier groupIdentifier = this.startState.groupIdentifier;
            boolean waitingForBlobUpload = this.startState.waitingForBlobUpload;
            boolean waitingForPhotoUpload = this.startState.waitingForPhotoUpload;
            switch (this.uploadType.ordinal()) {
                case 0: {
                    if (this.uploadResult == 0) {
                        waitingForBlobUpload = false;
                        break;
                    }
                    protocolManagerSession.identityDelegate.deleteGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), groupIdentifier, null);
                    return new FinalState();
                }
                case 1: {
                    waitingForPhotoUpload = false;
                }
            }
            if (!waitingForBlobUpload && !waitingForPhotoUpload) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new FinalizeGroupCreationMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new UploadingCreatedGroupDataState(groupIdentifier, this.startState.groupVersion, waitingForBlobUpload, waitingForPhotoUpload);
        }

        private static enum UploadType {
            BLOB,
            PHOTO;

        }
    }

    public static class FinalizeGroupCreationStep
    extends ProtocolStep {
        private final UploadingCreatedGroupDataState startState;
        private final FinalizeGroupCreationMessage receivedMessage;

        public FinalizeGroupCreationStep(UploadingCreatedGroupDataState startState, FinalizeGroupCreationMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            GroupV2.BlobKeys blobKeys = protocolManagerSession.identityDelegate.getGroupV2BlobKeys(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
            HashSet<GroupV2.IdentityAndPermissions> groupMembersAndPermissions = protocolManagerSession.identityDelegate.getGroupV2OtherMembersAndPermissions(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
            if (blobKeys == null || blobKeys.groupAdminServerAuthenticationPrivateKey == null || groupMembersAndPermissions == null) {
                protocolManagerSession.identityDelegate.deleteGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier, null);
                return new FinalState();
            }
            UID invitationProtocolInstanceUid = this.startState.groupIdentifier.computeProtocolInstanceUid();
            for (GroupV2.IdentityAndPermissions groupMembersAndPermission : groupMembersAndPermissions) {
                ChannelMessageToSend messageToSend;
                CoreProtocolMessage coreProtocolMessage;
                UID[] contactDeviceUidsWithChannel = protocolManagerSession.channelDelegate.getConfirmedObliviousChannelOrPreKeyDeviceUids(protocolManagerSession.session, this.getOwnedIdentity(), groupMembersAndPermission.identity);
                if (contactDeviceUidsWithChannel.length > 0) {
                    GroupV2.BlobKeys keysToSend = new GroupV2.BlobKeys(blobKeys.blobMainSeed, blobKeys.blobVersionSeed, groupMembersAndPermission.isAdmin() ? blobKeys.groupAdminServerAuthenticationPrivateKey : null);
                    coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(groupMembersAndPermission.identity, this.getOwnedIdentity()), this.getProtocolId(), invitationProtocolInstanceUid);
                    messageToSend = new InvitationOrMembersUpdateMessage(coreProtocolMessage, this.startState.groupIdentifier, this.startState.groupVersion, keysToSend, contactDeviceUidsWithChannel).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    continue;
                }
                protocolManagerSession.session.rollback();
                protocolManagerSession.session.startTransaction();
                protocolManagerSession.identityDelegate.deleteGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier, null);
                byte[] signature = Signature.sign(Constants.SignatureContext.GROUP_DELETE_ON_SERVER, blobKeys.groupAdminServerAuthenticationPrivateKey.getSignaturePrivateKey(), this.getPrng());
                coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.DeleteGroupBlobQuery(this.startState.groupIdentifier, signature)));
                messageToSend = new DeleteGroupBlobFromServerMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new FinalState();
            }
            UID[] allOwnedDeviceUids = protocolManagerSession.identityDelegate.getDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            if (allOwnedDeviceUids.length > 1) {
                try {
                    GroupV2.BlobKeys keysToSend = new GroupV2.BlobKeys(blobKeys.blobMainSeed, blobKeys.blobVersionSeed, blobKeys.groupAdminServerAuthenticationPrivateKey);
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity(), this.getOwnedIdentity()), this.getProtocolId(), invitationProtocolInstanceUid);
                    ChannelProtocolMessageToSend messageToSend = new InvitationOrMembersUpdateMessage(coreProtocolMessage, this.startState.groupIdentifier, this.startState.groupVersion, keysToSend, allOwnedDeviceUids).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            protocolManagerSession.identityDelegate.unfreezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
            return new FinalState();
        }
    }

    public static class ProcessDownloadedGroupDataStep
    extends ProtocolStep {
        private final DownloadingGroupBlobState startState;
        private final DownloadGroupBlobMessage receivedMessage;

        public ProcessDownloadedGroupDataStep(DownloadingGroupBlobState startState, DownloadGroupBlobMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.serverQueryNonce != null && !Arrays.equals(this.receivedMessage.serverQueryNonce, this.startState.serverQueryNonce)) {
                return this.startState;
            }
            if (this.receivedMessage.encryptedServerBlob == null || this.receivedMessage.logEntries == null || this.receivedMessage.groupAdminPublicKey == null) {
                if (this.receivedMessage.deletedFromServer) {
                    protocolManagerSession.identityDelegate.deleteGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier, null);
                }
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
                ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                protocolManagerSession.identityDelegate.unfreezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
                return new FinalState();
            }
            for (Map.Entry<Identity, Seed> inviterIdentityAndBlobMainSeedCandidate : this.startState.invitationCollectedData.inviterIdentityAndBlobMainSeedCandidates.entrySet()) {
                for (Seed blobVersionSeed : this.startState.invitationCollectedData.blobVersionSeedCandidates) {
                    AuthEncKey authEncKey = GroupV2.getSharedBlobSecretKey(inviterIdentityAndBlobMainSeedCandidate.getValue(), blobVersionSeed);
                    try {
                        Object coreProtocolMessage;
                        byte[] paddedBlobPlaintext = Suite.getAuthEnc(authEncKey).decrypt(authEncKey, this.receivedMessage.encryptedServerBlob);
                        Encoded[] encodeds = new Encoded(paddedBlobPlaintext).decodeListWithPadding();
                        GroupV2.ServerBlob serverBlob = GroupV2.ServerBlob.of(encodeds[0]);
                        Identity signerIdentity = encodeds[1].decodeIdentity();
                        byte[] signature = encodeds[2].decodeBytes();
                        try {
                            serverBlob.administratorsChain.withCheckedIntegrity(serverBlob.administratorsChain.groupUid, signerIdentity, protocolManagerSession.identityDelegate.getGroupV2AdministratorsChain(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier));
                        }
                        catch (Exception e) {
                            Logger.w("Downloaded a group blob with invalid administratorsChain");
                            throw new DecodingException();
                        }
                        if (!Signature.verify(Constants.SignatureContext.GROUP_BLOB, encodeds[0].getBytes(), signerIdentity, signature)) {
                            Logger.w("Downloaded a group blob with invalid signature");
                            throw new DecodingException();
                        }
                        HashSet<Identity> blobAdmins = new HashSet<Identity>();
                        for (GroupV2.IdentityAndPermissionsAndDetails member : serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                            if (!member.permissionStrings.contains(GroupV2.Permission.GROUP_ADMIN.getString())) continue;
                            blobAdmins.add(member.identity);
                        }
                        HashSet<Identity> chainAdmins = serverBlob.administratorsChain.getAdminIdentities();
                        if (!Objects.equals(blobAdmins, chainAdmins)) {
                            Logger.w("Downloaded a group blob with non-matching admins in AdministratorsChain");
                            throw new DecodingException();
                        }
                        List<Identity> leavers = serverBlob.consolidateWithLogEntries(this.startState.groupIdentifier, this.receivedMessage.logEntries);
                        GroupV2.IdentityAndPermissionsAndDetails ownIdentityAndPermissions = null;
                        boolean admin = false;
                        block8: for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                            if (!this.getOwnedIdentity().equals(identityAndPermissionsAndDetails.identity)) continue;
                            ownIdentityAndPermissions = identityAndPermissionsAndDetails;
                            for (String permissionString : identityAndPermissionsAndDetails.permissionStrings) {
                                if (GroupV2.Permission.fromString(permissionString) != GroupV2.Permission.GROUP_ADMIN) continue;
                                admin = true;
                                break block8;
                            }
                        }
                        if (ownIdentityAndPermissions == null) {
                            Logger.w("Downloaded a group blob for a group I am not part of");
                            throw new DecodingException();
                        }
                        ServerAuthenticationPrivateKey groupAdminServerAuthenticationPrivateKey = null;
                        if (admin) {
                            for (ServerAuthenticationPrivateKey serverAuthenticationPrivateKey : this.startState.invitationCollectedData.groupAdminServerAuthenticationPrivateKeyCandidates) {
                                if (!KeyPair.areKeysMatching(this.receivedMessage.groupAdminPublicKey, serverAuthenticationPrivateKey)) continue;
                                groupAdminServerAuthenticationPrivateKey = serverAuthenticationPrivateKey;
                                break;
                            }
                            if (groupAdminServerAuthenticationPrivateKey == null) {
                                Logger.d("We were able to decrypt a blob, we are admin, but we do not yet have the groupAdminServerAuthenticationPrivateKey");
                                throw new DecryptionException();
                            }
                        }
                        GroupV2.BlobKeys blobKeys = new GroupV2.BlobKeys(inviterIdentityAndBlobMainSeedCandidate.getValue(), blobVersionSeed, groupAdminServerAuthenticationPrivateKey);
                        if (protocolManagerSession.identityDelegate.getGroupV2Version(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier) != null) {
                            List<Identity> newGroupMembers = protocolManagerSession.identityDelegate.updateGroupV2WithNewBlob(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier, serverBlob, blobKeys, false, signerIdentity, leavers, this.receivedMessage.groupUpdateTimestamp);
                            if (newGroupMembers == null) {
                                return null;
                            }
                            if (Objects.equals(signerIdentity, this.getOwnedIdentity())) {
                                protocolManagerSession.identityDelegate.trustGroupV2PublishedDetails(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
                            }
                            protocolManagerSession.identityDelegate.unfreezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
                            if (serverBlob.serverPhotoInfo != null && protocolManagerSession.identityDelegate.getGroupV2PhotoUrl(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier) == null) {
                                coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 19, new UID(this.getPrng()));
                                ChannelProtocolMessageToSend messageToSend = new DownloadGroupV2PhotoProtocol.InitialMessage((CoreProtocolMessage)coreProtocolMessage, this.startState.groupIdentifier, serverBlob.serverPhotoInfo).generateChannelProtocolMessageToSend();
                                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                            }
                            if (!newGroupMembers.isEmpty()) {
                                coreProtocolMessage = newGroupMembers.iterator();
                                while (coreProtocolMessage.hasNext()) {
                                    Identity groupMemberIdentity = (Identity)coreProtocolMessage.next();
                                    byte[] pingSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_JOIN_NONCE, this.startState.groupIdentifier, ownIdentityAndPermissions.groupInvitationNonce, groupMemberIdentity, this.getOwnedIdentity(), this.getPrng());
                                    CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(groupMemberIdentity, this.getOwnedIdentity()));
                                    ChannelProtocolMessageToSend messageToSend = new PingMessage(coreProtocolMessage2, this.startState.groupIdentifier, ownIdentityAndPermissions.groupInvitationNonce, pingSignature, false).generateChannelProtocolMessageToSend();
                                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                                }
                            }
                            return new FinalState();
                        }
                        if (this.startState.invitationCollectedData.inviterIdentityAndBlobMainSeedCandidates.containsKey(this.getOwnedIdentity())) {
                            boolean success = protocolManagerSession.identityDelegate.createJoinedGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier, blobKeys, serverBlob, true, null, this.receivedMessage.groupUpdateTimestamp);
                            if (success) {
                                coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
                                ChannelMessageToSend messageToSend = new OneWayDialogProtocolMessage((CoreProtocolMessage)coreProtocolMessage).generateChannelDialogMessageToSend();
                                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                                if (serverBlob.serverPhotoInfo != null && protocolManagerSession.identityDelegate.getGroupV2PhotoUrl(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier) == null) {
                                    coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 19, new UID(this.getPrng()));
                                    messageToSend = new DownloadGroupV2PhotoProtocol.InitialMessage((CoreProtocolMessage)coreProtocolMessage, this.startState.groupIdentifier, serverBlob.serverPhotoInfo).generateChannelProtocolMessageToSend();
                                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                                }
                                for (GroupV2.IdentityAndPermissionsAndDetails groupMember : serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                                    if (groupMember.identity.equals(this.getOwnedIdentity())) continue;
                                    byte[] pingSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_JOIN_NONCE, this.startState.groupIdentifier, ownIdentityAndPermissions.groupInvitationNonce, groupMember.identity, this.getOwnedIdentity(), this.getPrng());
                                    CoreProtocolMessage coreProtocolMessage3 = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(groupMember.identity, this.getOwnedIdentity()));
                                    ChannelProtocolMessageToSend messageToSend2 = new PingMessage(coreProtocolMessage3, this.startState.groupIdentifier, ownIdentityAndPermissions.groupInvitationNonce, pingSignature, false).generateChannelProtocolMessageToSend();
                                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                                }
                            }
                            return new FinalState();
                        }
                        boolean autoAccept = false;
                        for (byte[] alreadyAcceptedNonce : this.startState.ownInvitationNoncesAcceptedOnOtherDevices) {
                            if (!Arrays.equals(alreadyAcceptedNonce, ownIdentityAndPermissions.groupInvitationNonce)) continue;
                            autoAccept = true;
                            break;
                        }
                        if (autoAccept) {
                            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()));
                            ChannelProtocolMessageToSend messageToSend = new AutoAcceptInvitationMessage((CoreProtocolMessage)coreProtocolMessage).generateChannelProtocolMessageToSend();
                            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                        } else {
                            HashSet<ObvGroupV2.ObvGroupV2PendingMember> groupV2PendingMembers = new HashSet<ObvGroupV2.ObvGroupV2PendingMember>();
                            for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                                if (identityAndPermissionsAndDetails.identity.equals(this.getOwnedIdentity())) continue;
                                groupV2PendingMembers.add(new ObvGroupV2.ObvGroupV2PendingMember(identityAndPermissionsAndDetails.identity.getBytes(), GroupV2.Permission.fromStrings(identityAndPermissionsAndDetails.permissionStrings), identityAndPermissionsAndDetails.serializedIdentityDetails));
                            }
                            CoreProtocolMessage coreProtocolMessage4 = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createGroupV2InvitationDialog(inviterIdentityAndBlobMainSeedCandidate.getKey(), new ObvGroupV2(this.getOwnedIdentity().getBytes(), this.startState.groupIdentifier, GroupV2.Permission.fromStrings(ownIdentityAndPermissions.permissionStrings), null, groupV2PendingMembers, serverBlob.serializedGroupDetails, null, null, null, 0L)), this.startState.dialogUuid));
                            ChannelDialogMessageToSend messageToSend = new DialogAcceptGroupInvitationMessage(coreProtocolMessage4).generateChannelDialogMessageToSend();
                            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                        }
                        return new InvitationReceivedState(this.startState.groupIdentifier, this.startState.dialogUuid, inviterIdentityAndBlobMainSeedCandidate.getKey(), serverBlob, blobKeys, this.receivedMessage.groupUpdateTimestamp);
                    }
                    catch (DecryptionException | InvalidKeyException paddedBlobPlaintext) {
                    }
                    catch (DecodingException e) {
                        protocolManagerSession.identityDelegate.deleteGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier, null);
                        CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
                        ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                        return new FinalState();
                    }
                }
            }
            return new INeedMoreSeedsState(this.startState.groupIdentifier, this.startState.dialogUuid, this.startState.invitationCollectedData, this.startState.ownInvitationNoncesAcceptedOnOtherDevices, this.startState.lastKnownOwnInvitationNonce, this.startState.lastKnownOtherGroupMemberIdentities);
        }
    }

    public static class ProcessInvitationDialogResponseStep
    extends ProtocolStep {
        private final ConcreteProtocolState startState;
        private final UUID startDialogUuid;
        private final GroupV2.Identifier groupIdentifier;
        private final boolean propagated;
        private final boolean invitationAccepted;
        private final UUID receivedDialogUuid;
        private final byte[] ownGroupInvitationNonce;
        private final byte[] propagatedOwnGroupInvitationNonce;
        private final List<Identity> groupMembersToNotify;
        private final boolean autoAccept;

        public ProcessInvitationDialogResponseStep(InvitationReceivedState startState, DialogAcceptGroupInvitationMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.startDialogUuid = startState.dialogUuid;
            this.groupIdentifier = startState.groupIdentifier;
            this.propagated = false;
            this.invitationAccepted = receivedMessage.invitationAccepted;
            this.receivedDialogUuid = receivedMessage.dialogUuid;
            this.propagatedOwnGroupInvitationNonce = null;
            this.groupMembersToNotify = new ArrayList<Identity>();
            byte[] ownGroupInvitationNonce = null;
            for (GroupV2.IdentityAndPermissionsAndDetails groupMember : startState.serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                if (groupMember.identity.equals(this.getOwnedIdentity())) {
                    ownGroupInvitationNonce = groupMember.groupInvitationNonce;
                    continue;
                }
                this.groupMembersToNotify.add(groupMember.identity);
            }
            this.ownGroupInvitationNonce = ownGroupInvitationNonce;
            this.autoAccept = false;
        }

        public ProcessInvitationDialogResponseStep(InvitationReceivedState startState, PropagateInvitationDialogResponseMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.startDialogUuid = startState.dialogUuid;
            this.groupIdentifier = startState.groupIdentifier;
            this.propagated = true;
            this.invitationAccepted = receivedMessage.invitationAccepted;
            this.receivedDialogUuid = null;
            this.propagatedOwnGroupInvitationNonce = receivedMessage.ownGroupInvitationNonce;
            this.groupMembersToNotify = new ArrayList<Identity>();
            byte[] ownGroupInvitationNonce = null;
            for (GroupV2.IdentityAndPermissionsAndDetails groupMember : startState.serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                if (groupMember.identity.equals(this.getOwnedIdentity())) {
                    ownGroupInvitationNonce = groupMember.groupInvitationNonce;
                    continue;
                }
                this.groupMembersToNotify.add(groupMember.identity);
            }
            this.ownGroupInvitationNonce = ownGroupInvitationNonce;
            this.autoAccept = false;
        }

        public ProcessInvitationDialogResponseStep(InvitationReceivedState startState, AutoAcceptInvitationMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.startDialogUuid = startState.dialogUuid;
            this.groupIdentifier = startState.groupIdentifier;
            this.propagated = false;
            this.invitationAccepted = true;
            this.receivedDialogUuid = null;
            this.propagatedOwnGroupInvitationNonce = null;
            this.groupMembersToNotify = new ArrayList<Identity>();
            byte[] ownGroupInvitationNonce = null;
            for (GroupV2.IdentityAndPermissionsAndDetails groupMember : startState.serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                if (groupMember.identity.equals(this.getOwnedIdentity())) {
                    ownGroupInvitationNonce = groupMember.groupInvitationNonce;
                    continue;
                }
                this.groupMembersToNotify.add(groupMember.identity);
            }
            this.ownGroupInvitationNonce = ownGroupInvitationNonce;
            this.autoAccept = true;
        }

        public ProcessInvitationDialogResponseStep(DownloadingGroupBlobState startState, DialogAcceptGroupInvitationMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.startDialogUuid = startState.dialogUuid;
            this.groupIdentifier = startState.groupIdentifier;
            this.propagated = false;
            this.invitationAccepted = receivedMessage.invitationAccepted;
            this.receivedDialogUuid = receivedMessage.dialogUuid;
            this.propagatedOwnGroupInvitationNonce = null;
            this.ownGroupInvitationNonce = startState.lastKnownOwnInvitationNonce;
            this.groupMembersToNotify = startState.lastKnownOtherGroupMemberIdentities == null ? null : Arrays.asList(startState.lastKnownOtherGroupMemberIdentities);
            this.autoAccept = false;
        }

        public ProcessInvitationDialogResponseStep(DownloadingGroupBlobState startState, PropagateInvitationDialogResponseMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.startDialogUuid = startState.dialogUuid;
            this.groupIdentifier = startState.groupIdentifier;
            this.propagated = true;
            this.invitationAccepted = receivedMessage.invitationAccepted;
            this.receivedDialogUuid = null;
            this.propagatedOwnGroupInvitationNonce = receivedMessage.ownGroupInvitationNonce;
            this.ownGroupInvitationNonce = startState.lastKnownOwnInvitationNonce;
            this.groupMembersToNotify = startState.lastKnownOtherGroupMemberIdentities == null ? null : Arrays.asList(startState.lastKnownOtherGroupMemberIdentities);
            this.autoAccept = false;
        }

        public ProcessInvitationDialogResponseStep(INeedMoreSeedsState startState, DialogAcceptGroupInvitationMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.startDialogUuid = startState.dialogUuid;
            this.groupIdentifier = startState.groupIdentifier;
            this.propagated = false;
            this.invitationAccepted = receivedMessage.invitationAccepted;
            this.receivedDialogUuid = receivedMessage.dialogUuid;
            this.propagatedOwnGroupInvitationNonce = null;
            this.ownGroupInvitationNonce = startState.lastKnownOwnInvitationNonce;
            this.groupMembersToNotify = startState.lastKnownOtherGroupMemberIdentities == null ? null : Arrays.asList(startState.lastKnownOtherGroupMemberIdentities);
            this.autoAccept = false;
        }

        public ProcessInvitationDialogResponseStep(INeedMoreSeedsState startState, PropagateInvitationDialogResponseMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.startDialogUuid = startState.dialogUuid;
            this.groupIdentifier = startState.groupIdentifier;
            this.propagated = true;
            this.invitationAccepted = receivedMessage.invitationAccepted;
            this.receivedDialogUuid = null;
            this.propagatedOwnGroupInvitationNonce = receivedMessage.ownGroupInvitationNonce;
            this.ownGroupInvitationNonce = startState.lastKnownOwnInvitationNonce;
            this.groupMembersToNotify = startState.lastKnownOtherGroupMemberIdentities == null ? null : Arrays.asList(startState.lastKnownOtherGroupMemberIdentities);
            this.autoAccept = false;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ChannelMessageToSend messageToSend;
            Object coreProtocolMessage3;
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!(this.propagated || Objects.equals(this.startDialogUuid, this.receivedDialogUuid) || this.autoAccept)) {
                return this.startState;
            }
            if (this.startState instanceof DownloadingGroupBlobState) {
                if (this.invitationAccepted) {
                    if (this.propagatedOwnGroupInvitationNonce == null) {
                        return this.startState;
                    }
                    byte[][] nonces = new byte[((DownloadingGroupBlobState)this.startState).ownInvitationNoncesAcceptedOnOtherDevices.length + 1][];
                    System.arraycopy(((DownloadingGroupBlobState)this.startState).ownInvitationNoncesAcceptedOnOtherDevices, 0, nonces, 0, nonces.length - 1);
                    nonces[nonces.length - 1] = this.propagatedOwnGroupInvitationNonce;
                    return new DownloadingGroupBlobState(((DownloadingGroupBlobState)this.startState).groupIdentifier, ((DownloadingGroupBlobState)this.startState).dialogUuid, ((DownloadingGroupBlobState)this.startState).invitationCollectedData, nonces, ((DownloadingGroupBlobState)this.startState).lastKnownOwnInvitationNonce, ((DownloadingGroupBlobState)this.startState).lastKnownOtherGroupMemberIdentities, ((DownloadingGroupBlobState)this.startState).serverQueryNonce);
                }
            } else if (this.startState instanceof INeedMoreSeedsState && this.invitationAccepted) {
                if (this.propagatedOwnGroupInvitationNonce == null) {
                    return this.startState;
                }
                byte[][] nonces = new byte[((INeedMoreSeedsState)this.startState).ownInvitationNoncesAcceptedOnOtherDevices.length + 1][];
                System.arraycopy(((INeedMoreSeedsState)this.startState).ownInvitationNoncesAcceptedOnOtherDevices, 0, nonces, 0, nonces.length - 1);
                nonces[nonces.length - 1] = this.propagatedOwnGroupInvitationNonce;
                return new INeedMoreSeedsState(((INeedMoreSeedsState)this.startState).groupIdentifier, ((INeedMoreSeedsState)this.startState).dialogUuid, ((INeedMoreSeedsState)this.startState).invitationCollectedData, nonces, ((INeedMoreSeedsState)this.startState).lastKnownOwnInvitationNonce, ((INeedMoreSeedsState)this.startState).lastKnownOtherGroupMemberIdentities);
            }
            if (this.ownGroupInvitationNonce == null) {
                CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startDialogUuid));
                ChannelDialogMessageToSend messageToSend2 = new OneWayDialogProtocolMessage(coreProtocolMessage2).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                return new FinalState();
            }
            if (this.propagated && !Arrays.equals(this.propagatedOwnGroupInvitationNonce, this.ownGroupInvitationNonce)) {
                return this.startState;
            }
            if (!this.propagated && !this.autoAccept && (numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    coreProtocolMessage3 = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    messageToSend = new PropagateInvitationDialogResponseMessage((CoreProtocolMessage)coreProtocolMessage3, this.invitationAccepted, this.ownGroupInvitationNonce).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage3) {
                    // empty catch block
                }
            }
            if (this.startState instanceof InvitationReceivedState && this.invitationAccepted) {
                ((InvitationReceivedState)this.startState).serverBlob.administratorsChain.integrityWasChecked = true;
                boolean success = protocolManagerSession.identityDelegate.createJoinedGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier, ((InvitationReceivedState)this.startState).blobKeys, ((InvitationReceivedState)this.startState).serverBlob, false, ((InvitationReceivedState)this.startState).inviterIdentity, ((InvitationReceivedState)this.startState).groupUpdateTimestamp);
                if (success) {
                    if (((InvitationReceivedState)this.startState).serverBlob.serverPhotoInfo != null && protocolManagerSession.identityDelegate.getGroupV2PhotoUrl(protocolManagerSession.session, this.getOwnedIdentity(), this.groupIdentifier) == null) {
                        coreProtocolMessage3 = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 19, new UID(this.getPrng()));
                        messageToSend = new DownloadGroupV2PhotoProtocol.InitialMessage((CoreProtocolMessage)coreProtocolMessage3, this.groupIdentifier, ((InvitationReceivedState)this.startState).serverBlob.serverPhotoInfo).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    }
                    for (GroupV2.IdentityAndPermissionsAndDetails groupMember : ((InvitationReceivedState)this.startState).serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                        if (groupMember.identity.equals(this.getOwnedIdentity())) continue;
                        byte[] pingSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_JOIN_NONCE, this.groupIdentifier, this.ownGroupInvitationNonce, groupMember.identity, this.getOwnedIdentity(), this.getPrng());
                        CoreProtocolMessage coreProtocolMessage4 = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(groupMember.identity, this.getOwnedIdentity()));
                        ChannelProtocolMessageToSend messageToSend3 = new PingMessage(coreProtocolMessage4, this.groupIdentifier, this.ownGroupInvitationNonce, pingSignature, false).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend3, this.getPrng());
                    }
                }
                coreProtocolMessage3 = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startDialogUuid));
                messageToSend = new OneWayDialogProtocolMessage((CoreProtocolMessage)coreProtocolMessage3).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new FinalState();
            }
            CoreProtocolMessage coreProtocolMessage5 = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startDialogUuid));
            ChannelDialogMessageToSend messageToSend4 = new OneWayDialogProtocolMessage(coreProtocolMessage5).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend4, this.getPrng());
            if (this.propagated) {
                return new FinalState();
            }
            if (this.groupMembersToNotify != null) {
                byte[] leaveSignature = protocolManagerSession.identityDelegate.signGroupInvitationNonce(protocolManagerSession.session, Constants.SignatureContext.GROUP_LEAVE_NONCE, this.groupIdentifier, this.ownGroupInvitationNonce, null, this.getOwnedIdentity(), this.getPrng());
                coreProtocolMessage3 = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.PutGroupLogQuery(this.groupIdentifier, leaveSignature)));
                messageToSend = new PutGroupLogOnServerMessage((CoreProtocolMessage)coreProtocolMessage3).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new RejectingInvitationOrLeavingGroupState(this.groupIdentifier, this.groupMembersToNotify);
            }
            return this.startState;
        }
    }

    public static class NotifyMembersOfRejectionOrGroupLeftStep
    extends ProtocolStep {
        private final RejectingInvitationOrLeavingGroupState startState;
        private final PutGroupLogOnServerMessage receivedMessage;

        public NotifyMembersOfRejectionOrGroupLeftStep(RejectingInvitationOrLeavingGroupState startState, PutGroupLogOnServerMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            for (Identity groupMember : this.startState.groupMembersToNotify) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(groupMember, this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new InvitationRejectedBroadcastMessage(coreProtocolMessage, this.startState.groupIdentifier).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new FinalState();
        }
    }

    public static class PrepareBlobForGroupUpdateStep
    extends ProtocolStep {
        private final WaitingForLockState startState;
        private final RequestLockMessage receivedMessage;

        public PrepareBlobForGroupUpdateStep(WaitingForLockState startState, RequestLockMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        private void unfreezeAndNotifyUpdateFailed(ProtocolManagerSession protocolManagerSession, boolean error) throws SQLException {
            protocolManagerSession.identityDelegate.unfreezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("owned_identity", this.getOwnedIdentity());
            userInfo.put("group_identifier", this.startState.groupIdentifier);
            userInfo.put("error", error);
            protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_group_v2_update_failed", userInfo);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            void var9_27;
            KeyPair groupAdminServerAuthenticationKeyPair;
            void var13_61;
            GroupV2.ServerPhotoInfo updatedServerPhotoInfo;
            boolean bl;
            GroupV2.AdministratorsChain updatedAdministratorsChain;
            GroupV2.ServerBlob initialServerBlob;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.serverQueryNonce != null && !Arrays.equals(this.receivedMessage.serverQueryNonce, this.startState.lockNonce)) {
                return this.startState;
            }
            if (this.receivedMessage.encryptedServerBlob == null || this.receivedMessage.logEntries == null || this.receivedMessage.groupAdminPublicKey == null) {
                this.unfreezeAndNotifyUpdateFailed(protocolManagerSession, true);
                return new FinalState();
            }
            GroupV2.BlobKeys blobKeys = protocolManagerSession.identityDelegate.getGroupV2BlobKeys(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
            if (blobKeys == null) {
                this.unfreezeAndNotifyUpdateFailed(protocolManagerSession, true);
                return new FinalState();
            }
            try {
                AuthEncKey authEncKey = GroupV2.getSharedBlobSecretKey(blobKeys.blobMainSeed, blobKeys.blobVersionSeed);
                byte[] paddedBlobPlaintext = Suite.getAuthEnc(authEncKey).decrypt(authEncKey, this.receivedMessage.encryptedServerBlob);
                Encoded[] encodeds = new Encoded(paddedBlobPlaintext).decodeListWithPadding();
                initialServerBlob = GroupV2.ServerBlob.of(encodeds[0]);
                Identity signerIdentity = encodeds[1].decodeIdentity();
                byte[] signature = encodeds[2].decodeBytes();
                try {
                    initialServerBlob.administratorsChain.withCheckedIntegrity(initialServerBlob.administratorsChain.groupUid, signerIdentity, protocolManagerSession.identityDelegate.getGroupV2AdministratorsChain(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier));
                }
                catch (Exception exception) {
                    Logger.w("Downloaded a group blob with invalid administratorsChain");
                    throw new DecodingException();
                }
                if (!Signature.verify(Constants.SignatureContext.GROUP_BLOB, encodeds[0].getBytes(), signerIdentity, signature)) {
                    Logger.w("Downloaded a group blob with invalid signature");
                    throw new DecodingException();
                }
                HashSet<Identity> hashSet = new HashSet<Identity>();
                for (GroupV2.IdentityAndPermissionsAndDetails member2 : initialServerBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                    if (!member2.permissionStrings.contains(GroupV2.Permission.GROUP_ADMIN.getString())) continue;
                    hashSet.add(member2.identity);
                }
                HashSet<Identity> hashSet2 = initialServerBlob.administratorsChain.getAdminIdentities();
                if (!Objects.equals(hashSet, hashSet2)) {
                    Logger.w("Downloaded a group blob with non-matching admins in AdministratorsChain");
                    throw new DecodingException();
                }
                if (!hashSet.contains(this.getOwnedIdentity())) {
                    Logger.w("We are no longer admin of a group we wanted to update --> aborting");
                    throw new DecodingException();
                }
            }
            catch (Exception e) {
                Logger.w("Failed to decrypt/verify server blob during update");
                Logger.x(e);
                this.unfreezeAndNotifyUpdateFailed(protocolManagerSession, true);
                return new FinalState();
            }
            initialServerBlob.consolidateWithLogEntries(this.startState.groupIdentifier, this.receivedMessage.logEntries);
            boolean changed = false;
            HashSet<GroupV2.IdentityAndPermissionsAndDetails> members = new HashSet<GroupV2.IdentityAndPermissionsAndDetails>(initialServerBlob.groupMemberIdentityAndPermissionsAndDetailsList);
            HashSet<Identity> membersToInvite = new HashSet<Identity>();
            HashMap<Identity, byte[]> membersToKick = new HashMap<Identity, byte[]>();
            if (!this.startState.changeSet.removedMembers.isEmpty()) {
                HashSet removedMembersSet = new HashSet();
                for (byte[] byArray : this.startState.changeSet.removedMembers) {
                    try {
                        removedMembersSet.add(Identity.of(byArray));
                    }
                    catch (DecodingException member2) {}
                }
                ArrayList<GroupV2.IdentityAndPermissionsAndDetails> arrayList = new ArrayList<GroupV2.IdentityAndPermissionsAndDetails>();
                for (GroupV2.IdentityAndPermissionsAndDetails member : members) {
                    if (!removedMembersSet.contains(member.identity)) continue;
                    arrayList.add(member);
                }
                for (GroupV2.IdentityAndPermissionsAndDetails member : arrayList) {
                    changed = true;
                    members.remove(member);
                    membersToKick.put(member.identity, member.groupInvitationNonce);
                }
            }
            if (!this.startState.changeSet.permissionChanges.isEmpty()) {
                for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : members) {
                    try {
                        HashSet<GroupV2.Permission> hashSet = this.startState.changeSet.permissionChanges.get(new ObvBytesKey(identityAndPermissionsAndDetails.identity.getBytes()));
                        if (hashSet == null) continue;
                        HashSet<GroupV2.Permission> initialPermissions = new HashSet<GroupV2.Permission>();
                        for (String string : identityAndPermissionsAndDetails.permissionStrings) {
                            GroupV2.Permission permission = GroupV2.Permission.fromString(string);
                            if (permission == null) continue;
                            initialPermissions.add(permission);
                        }
                        if (Objects.equals(hashSet, initialPermissions)) continue;
                        changed = true;
                        identityAndPermissionsAndDetails.permissionStrings.clear();
                        for (GroupV2.Permission permission : hashSet) {
                            identityAndPermissionsAndDetails.permissionStrings.add(permission.getString());
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            }
            HashSet updatedMembers = new HashSet();
            for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : members) {
                String serializedDetails = Objects.equals(identityAndPermissionsAndDetails.identity, this.getOwnedIdentity()) ? protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()) : protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), identityAndPermissionsAndDetails.identity);
                if (serializedDetails == null || Objects.equals(identityAndPermissionsAndDetails.serializedIdentityDetails, serializedDetails)) continue;
                GroupV2.IdentityAndPermissionsAndDetails updatedMember = new GroupV2.IdentityAndPermissionsAndDetails(identityAndPermissionsAndDetails.identity, identityAndPermissionsAndDetails.permissionStrings, serializedDetails, identityAndPermissionsAndDetails.groupInvitationNonce);
                updatedMembers.add(updatedMember);
            }
            Iterator iterator = updatedMembers.iterator();
            while (iterator.hasNext()) {
                GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails = (GroupV2.IdentityAndPermissionsAndDetails)iterator.next();
                members.remove(identityAndPermissionsAndDetails);
                members.add(identityAndPermissionsAndDetails);
            }
            for (Map.Entry<ObvBytesKey, HashSet<GroupV2.Permission>> entry : this.startState.changeSet.addedMembersWithPermissions.entrySet()) {
                try {
                    GroupV2.IdentityAndPermissionsAndDetails newMember;
                    Identity memberIdentity = Identity.of(entry.getKey().getBytes());
                    ArrayList<String> permissionStrings = new ArrayList<String>();
                    for (GroupV2.Permission permission : entry.getValue()) {
                        permissionStrings.add(permission.getString());
                    }
                    String string = protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), memberIdentity);
                    if (string == null || members.contains(newMember = new GroupV2.IdentityAndPermissionsAndDetails(memberIdentity, permissionStrings, string, this.getPrng().bytes(16)))) continue;
                    changed = true;
                    members.add(newMember);
                    membersToInvite.add(memberIdentity);
                }
                catch (Exception memberIdentity) {}
            }
            if (this.startState.changeSet.updatedSerializedGroupDetails != null && !Objects.equals(this.startState.changeSet.updatedSerializedGroupDetails, initialServerBlob.serializedGroupDetails)) {
                changed = true;
            }
            if (this.startState.changeSet.updatedJsonGroupType != null && !Objects.equals(this.startState.changeSet.updatedJsonGroupType, initialServerBlob.serializedGroupType)) {
                changed = true;
            }
            if (!(this.startState.changeSet.updatedPhotoUrl == null || initialServerBlob.serverPhotoInfo == null && this.startState.changeSet.updatedPhotoUrl.isEmpty())) {
                changed = true;
            }
            if (!changed) {
                Logger.d("Nothing change in group");
                this.unfreezeAndNotifyUpdateFailed(protocolManagerSession, false);
                return new FinalState();
            }
            for (Identity identity : membersToInvite) {
                if (protocolManagerSession.channelDelegate.getConfirmedObliviousChannelOrPreKeyDeviceUids(protocolManagerSession.session, this.getOwnedIdentity(), identity).length != 0) continue;
                this.unfreezeAndNotifyUpdateFailed(protocolManagerSession, true);
                return new FinalState();
            }
            Object var9_23 = null;
            boolean bl2 = false;
            HashSet<Identity> blobAdmins = new HashSet<Identity>();
            for (GroupV2.IdentityAndPermissionsAndDetails member5 : members) {
                if (!member5.permissionStrings.contains(GroupV2.Permission.GROUP_ADMIN.getString())) continue;
                blobAdmins.add(member5.identity);
            }
            HashSet<Identity> hashSet = initialServerBlob.administratorsChain.getAdminIdentities();
            if (Objects.equals(blobAdmins, hashSet)) {
                updatedAdministratorsChain = initialServerBlob.administratorsChain;
            } else {
                if (!blobAdmins.containsAll(hashSet)) {
                    bl = true;
                }
                blobAdmins.remove(this.getOwnedIdentity());
                updatedAdministratorsChain = initialServerBlob.administratorsChain.buildNewChainByAppendingABlock(protocolManagerSession.session, protocolManagerSession.identityDelegate, this.getOwnedIdentity(), blobAdmins.toArray(new Identity[0]), this.getPrng());
            }
            String updatedSerializedGroupDetails = this.startState.changeSet.updatedSerializedGroupDetails != null ? this.startState.changeSet.updatedSerializedGroupDetails : initialServerBlob.serializedGroupDetails;
            if (this.startState.changeSet.updatedJsonGroupType != null) {
                String string = this.startState.changeSet.updatedJsonGroupType;
            } else {
                String string = initialServerBlob.serializedGroupType;
            }
            if (this.startState.changeSet.updatedPhotoUrl != null && this.startState.changeSet.updatedPhotoUrl.isEmpty()) {
                updatedServerPhotoInfo = null;
            } else if (this.startState.changeSet.updatedPhotoUrl != null) {
                String string = this.startState.changeSet.updatedPhotoUrl;
                updatedServerPhotoInfo = new GroupV2.ServerPhotoInfo(this.getOwnedIdentity(), new UID(this.getPrng()), Suite.getDefaultAuthEnc(0).generateKey(this.getPrng()));
            } else if (initialServerBlob.serverPhotoInfo == null) {
                updatedServerPhotoInfo = null;
            } else if (Objects.equals(initialServerBlob.serverPhotoInfo.serverPhotoIdentity, this.getOwnedIdentity())) {
                updatedServerPhotoInfo = initialServerBlob.serverPhotoInfo;
            } else {
                String string = protocolManagerSession.identityDelegate.getGroupV2PhotoUrl(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
                if (string == null) {
                    updatedServerPhotoInfo = null;
                } else {
                    String string2 = new SecureFile(protocolManagerSession.engineBaseDirectory, string).getPlainNameFile().getPath();
                    updatedServerPhotoInfo = new GroupV2.ServerPhotoInfo(this.getOwnedIdentity(), new UID(this.getPrng()), Suite.getDefaultAuthEnc(0).generateKey(this.getPrng()));
                }
            }
            GroupV2.ServerBlob updatedServerBlob = new GroupV2.ServerBlob(updatedAdministratorsChain, members, initialServerBlob.version + 1, updatedSerializedGroupDetails, updatedServerPhotoInfo, (String)var13_61);
            if (bl) {
                groupAdminServerAuthenticationKeyPair = Suite.generateServerAuthenticationKeyPair(null, this.getPrng());
                if (groupAdminServerAuthenticationKeyPair == null) {
                    throw new Exception();
                }
            } else {
                groupAdminServerAuthenticationKeyPair = new KeyPair(this.receivedMessage.groupAdminPublicKey, blobKeys.groupAdminServerAuthenticationPrivateKey);
            }
            GroupV2.BlobKeys updatedBlobKeys = new GroupV2.BlobKeys(blobKeys.blobMainSeed, new Seed(this.getPrng()), (ServerAuthenticationPrivateKey)groupAdminServerAuthenticationKeyPair.getPrivateKey());
            Encoded encodedServerBlob = updatedServerBlob.encode();
            byte[] signature = protocolManagerSession.identityDelegate.signBlock(protocolManagerSession.session, Constants.SignatureContext.GROUP_BLOB, encodedServerBlob.getBytes(), this.getOwnedIdentity(), this.getPrng());
            Encoded encodedSignedBlob = Encoded.of(new Encoded[]{encodedServerBlob, Encoded.of(this.getOwnedIdentity()), Encoded.of(signature)});
            int unpaddedLength = encodedSignedBlob.getBytes().length;
            int paddedLength = 1 + (unpaddedLength - 1 >> 12) << 12;
            byte[] paddedBlobPlaintext = new byte[paddedLength];
            System.arraycopy(encodedSignedBlob.getBytes(), 0, paddedBlobPlaintext, 0, unpaddedLength);
            AuthEncKey blobEncryptionKey = GroupV2.getSharedBlobSecretKey(updatedBlobKeys.blobMainSeed, updatedBlobKeys.blobVersionSeed);
            EncryptedBytes encryptedBytes = Suite.getAuthEnc(blobEncryptionKey).encrypt(blobEncryptionKey, paddedBlobPlaintext, this.getPrng());
            Encoded encodedPublicKey = Encoded.of(groupAdminServerAuthenticationKeyPair.getPublicKey());
            byte[] dataToSign = new byte[this.startState.lockNonce.length + encryptedBytes.length + encodedPublicKey.getBytes().length];
            System.arraycopy(this.startState.lockNonce, 0, dataToSign, 0, this.startState.lockNonce.length);
            System.arraycopy(encryptedBytes.getBytes(), 0, dataToSign, this.startState.lockNonce.length, encryptedBytes.length);
            System.arraycopy(encodedPublicKey.getBytes(), 0, dataToSign, this.startState.lockNonce.length + encryptedBytes.length, encodedPublicKey.getBytes().length);
            byte[] signature2 = Signature.sign(Constants.SignatureContext.GROUP_UPDATE_ON_SERVER, dataToSign, blobKeys.groupAdminServerAuthenticationPrivateKey.getSignaturePrivateKey(), this.getPrng());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.UpdateGroupBlobQuery(this.startState.groupIdentifier, this.startState.lockNonce, encryptedBytes, encodedPublicKey, signature2)));
            ChannelServerQueryMessageToSend messageToSend = new UploadGroupBlobMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new UploadingUpdatedGroupBlobState(this.startState.groupIdentifier, this.startState.changeSet, updatedServerBlob, updatedBlobKeys, membersToKick, (String)var9_27, this.startState.failedUploadCounter);
        }
    }

    public static class ProcessGroupUpdateBlobUploadResponseStep
    extends ProtocolStep {
        private final UploadingUpdatedGroupBlobState startState;
        private final int uploadResult;

        public ProcessGroupUpdateBlobUploadResponseStep(UploadingUpdatedGroupBlobState startState, UploadGroupBlobMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.uploadResult = receivedMessage.uploadResult;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.uploadResult == 2 || this.uploadResult == 1 && this.startState.failedUploadCounter > 9L) {
                protocolManagerSession.identityDelegate.unfreezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", this.getOwnedIdentity());
                userInfo.put("group_identifier", this.startState.groupIdentifier);
                userInfo.put("error", true);
                protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_group_v2_update_failed", userInfo);
                return new FinalState();
            }
            if (this.uploadResult == 1) {
                GroupV2.BlobKeys blobKeys = protocolManagerSession.identityDelegate.getGroupV2BlobKeys(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
                if (blobKeys == null || blobKeys.groupAdminServerAuthenticationPrivateKey == null) {
                    HashMap<String, Object> userInfo = new HashMap<String, Object>();
                    userInfo.put("owned_identity", this.getOwnedIdentity());
                    userInfo.put("group_identifier", this.startState.groupIdentifier);
                    userInfo.put("error", true);
                    protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_group_v2_update_failed", userInfo);
                    protocolManagerSession.identityDelegate.unfreezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
                    return new FinalState();
                }
                byte[] lockNonce = this.getPrng().bytes(32);
                byte[] signature = Signature.sign(Constants.SignatureContext.GROUP_LOCK_ON_SERVER, lockNonce, blobKeys.groupAdminServerAuthenticationPrivateKey.getSignaturePrivateKey(), this.getPrng());
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.LockGroupBlobQuery(this.startState.groupIdentifier, lockNonce, signature)));
                ChannelServerQueryMessageToSend messageToSend = new RequestLockMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new WaitingForLockState(this.startState.groupIdentifier, this.startState.changeSet, lockNonce, this.startState.failedUploadCounter + 1L);
            }
            if (this.startState.absolutePhotoUrlToUpload == null) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new FinalizeGroupUpdateMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            } else {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createServerQueryChannelInfo(this.getOwnedIdentity(), new ServerQuery.PutUserDataQuery(this.getOwnedIdentity(), this.startState.updatedBlob.serverPhotoInfo.serverPhotoLabel, this.startState.absolutePhotoUrlToUpload, this.startState.updatedBlob.serverPhotoInfo.serverPhotoKey)));
                ChannelServerQueryMessageToSend messageToSend = new UploadGroupPhotoMessage(coreProtocolMessage).generateChannelServerQueryMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new UploadingUpdatedGroupPhotoState(this.startState.groupIdentifier, this.startState.changeSet, this.startState.updatedBlob, this.startState.updatedBlobKeys, this.startState.membersToKick, this.startState.absolutePhotoUrlToUpload);
        }
    }

    public static class ProcessGroupUpdatePhotoUploadResponseStep
    extends ProtocolStep {
        private final UploadingUpdatedGroupPhotoState startState;

        public ProcessGroupUpdatePhotoUploadResponseStep(UploadingUpdatedGroupPhotoState startState, UploadGroupPhotoMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()));
            ChannelProtocolMessageToSend messageToSend = new FinalizeGroupUpdateMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return this.startState;
        }
    }

    public static class FinalizeGroupUpdateStep
    extends ProtocolStep {
        private final UploadingUpdatedGroupPhotoState startState;
        private final FinalizeGroupUpdateMessage receivedMessage;

        public FinalizeGroupUpdateStep(UploadingUpdatedGroupPhotoState startState, FinalizeGroupUpdateMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            this.startState.updatedBlob.administratorsChain.withCheckedIntegrity(this.startState.groupIdentifier.groupUid, null, protocolManagerSession.identityDelegate.getGroupV2AdministratorsChain(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier));
            List<Identity> updateOutput = protocolManagerSession.identityDelegate.updateGroupV2WithNewBlob(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier, this.startState.updatedBlob, this.startState.updatedBlobKeys, true, null, null, System.currentTimeMillis());
            if (updateOutput == null) {
                return null;
            }
            protocolManagerSession.identityDelegate.unfreezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
            for (GroupV2.IdentityAndPermissionsAndDetails groupMember : this.startState.updatedBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                ChannelProtocolMessageToSend messageToSend;
                CoreProtocolMessage coreProtocolMessage;
                GroupV2.BlobKeys keysToSend;
                UID[] contactOrOwnedDeviceUidsWithChannel = protocolManagerSession.channelDelegate.getConfirmedObliviousChannelOrPreKeyDeviceUids(protocolManagerSession.session, this.getOwnedIdentity(), groupMember.identity);
                boolean isAdmin = groupMember.permissionStrings.contains(GroupV2.Permission.GROUP_ADMIN.getString());
                if (contactOrOwnedDeviceUidsWithChannel.length > 0) {
                    keysToSend = isAdmin ? this.startState.updatedBlobKeys : new GroupV2.BlobKeys(this.startState.updatedBlobKeys.blobMainSeed, this.startState.updatedBlobKeys.blobVersionSeed, null);
                    coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(groupMember.identity, this.getOwnedIdentity()));
                    messageToSend = new InvitationOrMembersUpdateMessage(coreProtocolMessage, this.startState.groupIdentifier, this.startState.updatedBlob.version, keysToSend, contactOrOwnedDeviceUidsWithChannel).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    continue;
                }
                if (Objects.equals(groupMember.identity, this.getOwnedIdentity())) continue;
                keysToSend = new GroupV2.BlobKeys(null, this.startState.updatedBlobKeys.blobVersionSeed, isAdmin ? this.startState.updatedBlobKeys.groupAdminServerAuthenticationPrivateKey : null);
                coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(groupMember.identity, this.getOwnedIdentity()));
                messageToSend = new InvitationOrMembersUpdateBroadcastMessage(coreProtocolMessage, this.startState.groupIdentifier, this.startState.updatedBlob.version, keysToSend).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            if (!this.startState.membersToKick.isEmpty()) {
                byte[] chainPlaintext = this.startState.updatedBlob.administratorsChain.encode().getBytes();
                AuthEncKey encryptionKey = (AuthEncKey)Suite.getKDF("kdf_sha-256").gen(this.startState.updatedBlobKeys.blobMainSeed, Suite.getDefaultAuthEnc(0).getKDFDelegate())[0];
                EncryptedBytes encryptedChain = Suite.getAuthEnc(encryptionKey).encrypt(encryptionKey, chainPlaintext, this.getPrng());
                for (Map.Entry<Identity, byte[]> entry : this.startState.membersToKick.entrySet()) {
                    byte[] dataToSign = new byte[encryptedChain.length + entry.getValue().length];
                    System.arraycopy(encryptedChain.getBytes(), 0, dataToSign, 0, encryptedChain.length);
                    System.arraycopy(entry.getValue(), 0, dataToSign, encryptedChain.length, entry.getValue().length);
                    byte[] signature = protocolManagerSession.identityDelegate.signBlock(protocolManagerSession.session, Constants.SignatureContext.GROUP_KICK, dataToSign, this.getOwnedIdentity(), this.getPrng());
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(entry.getKey(), this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new KickMessage(coreProtocolMessage, this.startState.groupIdentifier, encryptedChain, signature).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
            }
            if (this.startState.absolutePhotoUrlToUpload != null) {
                protocolManagerSession.identityDelegate.setUpdatedGroupV2PhotoUrl(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier, this.startState.updatedBlob.version, this.startState.absolutePhotoUrlToUpload);
            }
            return new FinalState();
        }
    }

    public static class FinalizeGroupDisbandStep
    extends ProtocolStep {
        private final DisbandingGroupState startState;
        private final DeleteGroupBlobFromServerMessage receivedMessage;

        public FinalizeGroupDisbandStep(DisbandingGroupState startState, DeleteGroupBlobFromServerMessage receivedMessage, GroupsV2Protocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.success) {
                Logger.e("Failed to delete groupV2 blob on the server following a disband request");
                protocolManagerSession.identityDelegate.unfreezeGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
                return new FinalState();
            }
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagatedGroupDisbandMessage(coreProtocolMessage, this.startState.groupIdentifier).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            byte[] chainPlaintext = protocolManagerSession.identityDelegate.getGroupV2AdministratorsChain(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier).encode().getBytes();
            AuthEncKey encryptionKey = (AuthEncKey)Suite.getKDF("kdf_sha-256").gen(this.startState.blobKeys.blobMainSeed, Suite.getDefaultAuthEnc(0).getKDFDelegate())[0];
            EncryptedBytes encryptedChain = Suite.getAuthEnc(encryptionKey).encrypt(encryptionKey, chainPlaintext, this.getPrng());
            GroupV2.ServerBlob serverBlob = protocolManagerSession.identityDelegate.getGroupV2ServerBlob(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier);
            for (GroupV2.IdentityAndPermissionsAndDetails member : serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
                if (member.identity.equals(this.getOwnedIdentity())) continue;
                byte[] dataToSign = new byte[encryptedChain.length + member.groupInvitationNonce.length];
                System.arraycopy(encryptedChain.getBytes(), 0, dataToSign, 0, encryptedChain.length);
                System.arraycopy(member.groupInvitationNonce, 0, dataToSign, encryptedChain.length, member.groupInvitationNonce.length);
                byte[] signature = protocolManagerSession.identityDelegate.signBlock(protocolManagerSession.session, Constants.SignatureContext.GROUP_KICK, dataToSign, this.getOwnedIdentity(), this.getPrng());
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(member.identity, this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new KickMessage(coreProtocolMessage, this.startState.groupIdentifier, encryptedChain, signature).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            protocolManagerSession.identityDelegate.deleteGroupV2(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupIdentifier, this.getOwnedIdentity());
            return new FinalState();
        }
    }

    public static abstract class CollectingSeedsAbstractState
    extends ConcreteProtocolState {
        protected final GroupV2.Identifier groupIdentifier;
        protected final UUID dialogUuid;
        protected final GroupV2.InvitationCollectedData invitationCollectedData;
        protected final byte[][] ownInvitationNoncesAcceptedOnOtherDevices;
        protected final byte[] lastKnownOwnInvitationNonce;
        protected final Identity[] lastKnownOtherGroupMemberIdentities;

        protected CollectingSeedsAbstractState(int stateId, GroupV2.Identifier groupIdentifier, UUID dialogUuid, GroupV2.InvitationCollectedData invitationCollectedData, byte[][] ownInvitationNoncesAcceptedOnOtherDevices, byte[] lastKnownOwnInvitationNonce, Identity[] lastKnownOtherGroupMemberIdentities) {
            super(stateId);
            this.groupIdentifier = groupIdentifier;
            this.invitationCollectedData = invitationCollectedData;
            this.dialogUuid = dialogUuid;
            this.ownInvitationNoncesAcceptedOnOtherDevices = ownInvitationNoncesAcceptedOnOtherDevices;
            this.lastKnownOwnInvitationNonce = lastKnownOwnInvitationNonce;
            this.lastKnownOtherGroupMemberIdentities = lastKnownOtherGroupMemberIdentities;
        }

        public CollectingSeedsAbstractState(int stateId, Encoded encodedState) throws Exception {
            super(stateId);
            Encoded[] list = encodedState.decodeList();
            if (list.length < 3 || list.length > 6) {
                throw new Exception();
            }
            this.groupIdentifier = GroupV2.Identifier.of(list[0]);
            this.dialogUuid = list[1].decodeUuid();
            this.invitationCollectedData = GroupV2.InvitationCollectedData.of(list[2]);
            if ((list.length & 1) == 0) {
                Encoded[] encodeds = list[3].decodeList();
                this.ownInvitationNoncesAcceptedOnOtherDevices = new byte[encodeds.length][];
                for (int i = 0; i < encodeds.length; ++i) {
                    this.ownInvitationNoncesAcceptedOnOtherDevices[i] = encodeds[i].decodeBytes();
                }
            } else {
                this.ownInvitationNoncesAcceptedOnOtherDevices = new byte[0][];
            }
            this.lastKnownOwnInvitationNonce = list.length >= 5 ? list[list.length - 2].decodeBytes() : null;
            this.lastKnownOtherGroupMemberIdentities = list.length >= 5 ? list[list.length - 1].decodeIdentityArray() : null;
        }

        @Override
        public Encoded encode() {
            Encoded[] encodedNonces = new Encoded[this.ownInvitationNoncesAcceptedOnOtherDevices.length];
            for (int i = 0; i < encodedNonces.length; ++i) {
                encodedNonces[i] = Encoded.of(this.ownInvitationNoncesAcceptedOnOtherDevices[i]);
            }
            if (this.lastKnownOwnInvitationNonce == null || this.lastKnownOtherGroupMemberIdentities == null) {
                return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.dialogUuid), this.invitationCollectedData.encode(), Encoded.of(encodedNonces)});
            }
            return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.dialogUuid), this.invitationCollectedData.encode(), Encoded.of(encodedNonces), Encoded.of(this.lastKnownOwnInvitationNonce), Encoded.of(this.lastKnownOtherGroupMemberIdentities)});
        }
    }
}

