/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.GroupMembersChangedCallback;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.DialogType;
import io.olvid.engine.datatypes.containers.Group;
import io.olvid.engine.datatypes.containers.GroupInformation;
import io.olvid.engine.datatypes.containers.IdentityWithSerializedDetails;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.OneWayDialogProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.GroupManagementProtocol;
import java.util.HashSet;
import java.util.UUID;

public class GroupInvitationProtocol
extends ConcreteProtocol {
    private static final int INVITATION_SENT_STATE_ID = 1;
    private static final int INVITATION_RECEIVED_STATE_ID = 2;
    private static final int RESPONSE_SENT_STATE_ID = 3;
    private static final int RESPONSE_RECEIVED_STATE_ID = 4;
    private static final int INITIAL_MESSAGE_ID = 0;
    private static final int GROUP_INVITATION_MESSAGE_ID = 1;
    private static final int DIALOG_ACCEPT_GROUP_INVITATION_MESSAGE_ID = 2;
    private static final int ACCEPT_INVITATION_MESSAGE_ID = 3;
    private static final int PROPAGATE_INVITATION_RESPONSE_MESSAGE_ID = 4;

    public GroupInvitationProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    @Override
    public int getProtocolId() {
        return 8;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{1, 3, 4};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return InvitationSentState.class;
            }
            case 2: {
                return InvitationReceivedState.class;
            }
            case 3: {
                return ResponseSentState.class;
            }
            case 4: {
                return ResponseReceivedState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return GroupInvitationMessage.class;
            }
            case 2: {
                return DialogAcceptGroupInvitationMessage.class;
            }
            case 3: {
                return InvitationResponseMessage.class;
            }
            case 4: {
                return PropagateInvitationResponseMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{SendInvitationStep.class, ProcessInvitationStep.class, ProcessResponseStep.class};
            }
            case 2: {
                return new Class[]{ProcessInvitationDialogResponseStep.class, ProcessPropagatedInvitationResponseStep.class};
            }
        }
        return new Class[0];
    }

    public static class InvitationSentState
    extends ConcreteProtocolState {
        InvitationSentState() {
            super(1);
        }

        public InvitationSentState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InvitationReceivedState
    extends ConcreteProtocolState {
        private final GroupInformation groupInformation;
        private final UUID dialogUuid;
        private final HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails;

        InvitationReceivedState(GroupInformation groupInformation, UUID dialogUuid, HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails) {
            super(2);
            this.groupInformation = groupInformation;
            this.dialogUuid = dialogUuid;
            this.groupMemberIdentitiesAndSerializedDetails = groupMemberIdentitiesAndSerializedDetails;
        }

        public InvitationReceivedState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 3) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(list[0]);
            this.dialogUuid = list[1].decodeUuid();
            this.groupMemberIdentitiesAndSerializedDetails = new HashSet();
            for (Encoded encodedIdentityAndDisplayName : list[2].decodeList()) {
                this.groupMemberIdentitiesAndSerializedDetails.add(IdentityWithSerializedDetails.of(encodedIdentityAndDisplayName));
            }
        }

        @Override
        public Encoded encode() {
            Encoded[] encodedGroupMembers = new Encoded[this.groupMemberIdentitiesAndSerializedDetails.size()];
            int i = 0;
            for (IdentityWithSerializedDetails identityWithSerializedDetails : this.groupMemberIdentitiesAndSerializedDetails) {
                encodedGroupMembers[i] = identityWithSerializedDetails.encode();
                ++i;
            }
            return Encoded.of(new Encoded[]{this.groupInformation.encode(), Encoded.of(this.dialogUuid), Encoded.of(encodedGroupMembers)});
        }
    }

    public static class ResponseSentState
    extends ConcreteProtocolState {
        ResponseSentState() {
            super(3);
        }

        public ResponseSentState(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class ResponseReceivedState
    extends ConcreteProtocolState {
        ResponseReceivedState() {
            super(4);
        }

        public ResponseReceivedState(Encoded encodedState) throws Exception {
            super(4);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final GroupInformation groupInformation;
        private final HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, GroupInformation groupInformation, HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.groupInformation = groupInformation;
            this.groupMemberIdentitiesAndSerializedDetails = groupMemberIdentitiesAndSerializedDetails;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 3) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[1]);
            this.groupMemberIdentitiesAndSerializedDetails = new HashSet();
            for (Encoded encodedIdentityAndDisplayName : receivedMessage.getInputs()[2].decodeList()) {
                this.groupMemberIdentitiesAndSerializedDetails.add(IdentityWithSerializedDetails.of(encodedIdentityAndDisplayName));
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            Encoded[] encodeds = new Encoded[this.groupMemberIdentitiesAndSerializedDetails.size()];
            int i = 0;
            for (IdentityWithSerializedDetails identityWithSerializedDetails : this.groupMemberIdentitiesAndSerializedDetails) {
                encodeds[i] = identityWithSerializedDetails.encode();
                ++i;
            }
            return new Encoded[]{Encoded.of(this.contactIdentity), this.groupInformation.encode(), Encoded.of(encodeds)};
        }
    }

    public static class GroupInvitationMessage
    extends ConcreteProtocolMessage {
        private final GroupInformation groupInformation;
        private final HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails;

        GroupInvitationMessage(CoreProtocolMessage coreProtocolMessage, GroupInformation groupInformation, HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails) {
            super(coreProtocolMessage);
            this.groupInformation = groupInformation;
            this.groupMemberIdentitiesAndSerializedDetails = groupMemberIdentitiesAndSerializedDetails;
        }

        public GroupInvitationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.groupInformation = GroupInformation.of(receivedMessage.getInputs()[0]);
            this.groupMemberIdentitiesAndSerializedDetails = new HashSet();
            for (Encoded encodedIdentityAndDisplayName : receivedMessage.getInputs()[1].decodeList()) {
                this.groupMemberIdentitiesAndSerializedDetails.add(IdentityWithSerializedDetails.of(encodedIdentityAndDisplayName));
            }
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            Encoded[] encodedGroupMembers = new Encoded[this.groupMemberIdentitiesAndSerializedDetails.size()];
            int i = 0;
            for (IdentityWithSerializedDetails identityWithSerializedDetails : this.groupMemberIdentitiesAndSerializedDetails) {
                encodedGroupMembers[i] = identityWithSerializedDetails.encode();
                ++i;
            }
            return new Encoded[]{this.groupInformation.encode(), Encoded.of(encodedGroupMembers)};
        }
    }

    public static class DialogAcceptGroupInvitationMessage
    extends ConcreteProtocolMessage {
        private final boolean invitationAccepted;
        private final UUID dialogUuid;

        DialogAcceptGroupInvitationMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.invitationAccepted = false;
            this.dialogUuid = null;
        }

        public DialogAcceptGroupInvitationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                throw new Exception();
            }
            this.invitationAccepted = receivedMessage.getEncodedResponse().decodeBoolean();
            this.dialogUuid = receivedMessage.getUserDialogUuid();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class InvitationResponseMessage
    extends ConcreteProtocolMessage {
        private final UID groupUid;
        private final boolean invitationAccepted;

        InvitationResponseMessage(CoreProtocolMessage coreProtocolMessage, UID groupUid, boolean invitationAccepted) {
            super(coreProtocolMessage);
            this.groupUid = groupUid;
            this.invitationAccepted = invitationAccepted;
        }

        public InvitationResponseMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.groupUid = receivedMessage.getInputs()[0].decodeUid();
            this.invitationAccepted = receivedMessage.getInputs()[1].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.groupUid), Encoded.of(this.invitationAccepted)};
        }
    }

    public static class PropagateInvitationResponseMessage
    extends ConcreteProtocolMessage {
        private final boolean invitationAccepted;

        PropagateInvitationResponseMessage(CoreProtocolMessage coreProtocolMessage, boolean invitationAccepted) {
            super(coreProtocolMessage);
            this.invitationAccepted = invitationAccepted;
        }

        public PropagateInvitationResponseMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.invitationAccepted = receivedMessage.getInputs()[0].decodeBoolean();
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.invitationAccepted)};
        }
    }

    public static class SendInvitationStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public SendInvitationStep(InitialProtocolState startState, InitialMessage receivedMessage, GroupInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (this.receivedMessage.groupMemberIdentitiesAndSerializedDetails.contains(new IdentityWithSerializedDetails(this.getOwnedIdentity(), ""))) {
                Logger.w("Error: the groupMemberIdentitiesAndSerializedDetails contains the ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(this.getOwnedIdentity())) {
                Logger.w("Error: the groupInformation contains a different Identity than ownedIdentity");
                return null;
            }
            if (!this.receivedMessage.groupMemberIdentitiesAndSerializedDetails.contains(new IdentityWithSerializedDetails(this.receivedMessage.contactIdentity, ""))) {
                Logger.w("Error: the groupMemberIdentitiesAndSerializedDetails does not contain the contactIdentity");
                return null;
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity()));
            ChannelProtocolMessageToSend messageToSend = new GroupInvitationMessage(coreProtocolMessage, this.receivedMessage.groupInformation, this.receivedMessage.groupMemberIdentitiesAndSerializedDetails).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new InvitationSentState();
        }
    }

    public static class ProcessInvitationStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final GroupInvitationMessage receivedMessage;

        public ProcessInvitationStep(InitialProtocolState startState, GroupInvitationMessage receivedMessage, GroupInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.receivedMessage.groupMemberIdentitiesAndSerializedDetails.contains(new IdentityWithSerializedDetails(this.getOwnedIdentity(), ""))) {
                Logger.w("Error: you received an invitation to a group without being part of groupMemberIdentitiesAndSerializedDetails");
                return null;
            }
            Identity groupOwnerIdentity = this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity();
            if (!this.receivedMessage.groupInformation.groupOwnerIdentity.equals(groupOwnerIdentity)) {
                Logger.w("Error: you received an invitation to a group from someone who is not the group owner");
                return null;
            }
            if (protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation.getGroupOwnerAndUid()) != null) {
                Logger.w("Received an invitation to a group you already belong to: accepting it :)");
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(groupOwnerIdentity, this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new InvitationResponseMessage(coreProtocolMessage, this.receivedMessage.groupInformation.groupUid, true).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
                if (numberOfOtherDevices > 0) {
                    try {
                        CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                        ChannelProtocolMessageToSend messageToSend2 = new PropagateInvitationResponseMessage(coreProtocolMessage2, true).generateChannelProtocolMessageToSend();
                        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                    }
                    catch (NoAcceptableChannelException coreProtocolMessage2) {
                        // empty catch block
                    }
                }
                protocolManagerSession.identityDelegate.resetGroupMembersAndPublishedDetailsVersions(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.groupInformation);
                return new ResponseSentState();
            }
            JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto = (JsonGroupDetailsWithVersionAndPhoto)this.protocol.getJsonObjectMapper().readValue(this.receivedMessage.groupInformation.serializedGroupDetailsWithVersionAndPhoto, JsonGroupDetailsWithVersionAndPhoto.class);
            JsonGroupDetails jsonGroupDetails = jsonGroupDetailsWithVersionAndPhoto.getGroupDetails();
            String serializedGroupDetails = this.protocol.getJsonObjectMapper().writeValueAsString((Object)jsonGroupDetails);
            UUID dialogUuid = UUID.randomUUID();
            Identity[] identities = new Identity[this.receivedMessage.groupMemberIdentitiesAndSerializedDetails.size()];
            String[] serializedDetails = new String[identities.length];
            int i = 0;
            for (IdentityWithSerializedDetails identityWithSerializedDetails : this.receivedMessage.groupMemberIdentitiesAndSerializedDetails) {
                if (identityWithSerializedDetails.identity.equals(this.getOwnedIdentity())) {
                    identities[i] = groupOwnerIdentity;
                    serializedDetails[i] = protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), groupOwnerIdentity);
                } else {
                    identities[i] = identityWithSerializedDetails.identity;
                    serializedDetails[i] = identityWithSerializedDetails.serializedDetails;
                }
                ++i;
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createAcceptGroupInviteDialog(serializedGroupDetails, this.receivedMessage.groupInformation.groupUid, this.receivedMessage.groupInformation.groupOwnerIdentity, identities, serializedDetails, this.receivedMessage.getServerTimestamp()), dialogUuid));
            ChannelDialogMessageToSend messageToSend = new DialogAcceptGroupInvitationMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new InvitationReceivedState(this.receivedMessage.groupInformation, dialogUuid, this.receivedMessage.groupMemberIdentitiesAndSerializedDetails);
        }
    }

    public static class ProcessResponseStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InvitationResponseMessage receivedMessage;

        public ProcessResponseStep(InitialProtocolState startState, InvitationResponseMessage receivedMessage, GroupInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            final ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            Identity contactIdentity = this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity();
            final byte[] groupOwnerAndUid = new byte[this.getOwnedIdentity().getBytes().length + 32];
            System.arraycopy(this.getOwnedIdentity().getBytes(), 0, groupOwnerAndUid, 0, this.getOwnedIdentity().getBytes().length);
            System.arraycopy(this.receivedMessage.groupUid.getBytes(), 0, groupOwnerAndUid, this.getOwnedIdentity().getBytes().length, 32);
            GroupMembersChangedCallback groupMembersChangedCallback = new GroupMembersChangedCallback(){
                private final GroupInformation groupInformation;
                {
                    this.groupInformation = protocolManagerSession.identityDelegate.getGroupInformation(protocolManagerSession.session, this.getOwnedIdentity(), groupOwnerAndUid);
                }

                @Override
                public void callback() throws Exception {
                    UID childProtocolUid = this.groupInformation.computeProtocolUid();
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 9, childProtocolUid);
                    ChannelProtocolMessageToSend messageToSend = new GroupManagementProtocol.GroupMembersOrDetailsChangedTriggerMessage(coreProtocolMessage, this.groupInformation).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
            };
            Group group = protocolManagerSession.identityDelegate.getGroup(protocolManagerSession.session, this.getOwnedIdentity(), groupOwnerAndUid);
            if (group == null || !group.isPendingMember(contactIdentity)) {
                if (this.receivedMessage.invitationAccepted && (group == null || !group.isMember(contactIdentity))) {
                    UID groupManagementProtocolUid = GroupInformation.computeProtocolUid(this.getOwnedIdentity().getBytes(), this.receivedMessage.groupUid.getBytes());
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(contactIdentity, this.getOwnedIdentity()), 9, groupManagementProtocolUid);
                    ChannelProtocolMessageToSend messageToSend = new GroupManagementProtocol.KickFromGroupMessage(coreProtocolMessage, new GroupInformation(this.getOwnedIdentity(), this.receivedMessage.groupUid, "{\"details\":{\"name\":\"dummy\"}, \"version\": 0}")).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                } else if (!this.receivedMessage.invitationAccepted && group != null && group.isMember(contactIdentity)) {
                    protocolManagerSession.identityDelegate.demoteGroupMemberToDeclinedPendingMember(protocolManagerSession.session, groupOwnerAndUid, this.getOwnedIdentity(), contactIdentity, groupMembersChangedCallback);
                    UID groupManagementProtocolUid = GroupInformation.computeProtocolUid(this.getOwnedIdentity().getBytes(), this.receivedMessage.groupUid.getBytes());
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(contactIdentity, this.getOwnedIdentity()), 9, groupManagementProtocolUid);
                    ChannelProtocolMessageToSend messageToSend = new GroupManagementProtocol.KickFromGroupMessage(coreProtocolMessage, new GroupInformation(this.getOwnedIdentity(), this.receivedMessage.groupUid, "{\"details\":{\"name\":\"dummy\"}, \"version\": 0}")).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                } else if (this.receivedMessage.invitationAccepted && group.isMember(contactIdentity)) {
                    UID groupManagementProtocolUid = GroupInformation.computeProtocolUid(this.getOwnedIdentity().getBytes(), this.receivedMessage.groupUid.getBytes());
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 9, groupManagementProtocolUid);
                    ChannelProtocolMessageToSend messageToSend = new GroupManagementProtocol.TriggerUpdateMembersMessage(coreProtocolMessage, protocolManagerSession.identityDelegate.getGroupInformation(protocolManagerSession.session, this.getOwnedIdentity(), groupOwnerAndUid), contactIdentity).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                return new ResponseReceivedState();
            }
            if (this.receivedMessage.invitationAccepted) {
                protocolManagerSession.identityDelegate.addGroupMemberFromPendingMember(protocolManagerSession.session, groupOwnerAndUid, this.getOwnedIdentity(), contactIdentity, groupMembersChangedCallback);
            } else {
                protocolManagerSession.identityDelegate.setPendingMemberDeclined(protocolManagerSession.session, groupOwnerAndUid, this.getOwnedIdentity(), contactIdentity, true);
            }
            return new ResponseReceivedState();
        }
    }

    public static class ProcessInvitationDialogResponseStep
    extends ProtocolStep {
        private final InvitationReceivedState startState;
        private final DialogAcceptGroupInvitationMessage receivedMessage;

        public ProcessInvitationDialogResponseStep(InvitationReceivedState startState, DialogAcceptGroupInvitationMessage receivedMessage, GroupInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ChannelMessageToSend messageToSend;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.startState.dialogUuid.equals(this.receivedMessage.dialogUuid)) {
                Logger.e("ObvDialog uuid mismatch in DialogAcceptGroupInvitationMessage.");
                return null;
            }
            boolean invitationAccepted = this.receivedMessage.invitationAccepted;
            Identity groupOwnerIdentity = this.startState.groupInformation.groupOwnerIdentity;
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend2 = new PropagateInvitationResponseMessage(coreProtocolMessage, invitationAccepted).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            if (!protocolManagerSession.identityDelegate.isIdentityAnActiveContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), groupOwnerIdentity)) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
                messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new ResponseSentState();
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(groupOwnerIdentity, this.getOwnedIdentity()));
            messageToSend = new InvitationResponseMessage(coreProtocolMessage, this.startState.groupInformation.groupUid, invitationAccepted).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            if (invitationAccepted) {
                IdentityWithSerializedDetails[] pendingGroupMembers = new IdentityWithSerializedDetails[this.startState.groupMemberIdentitiesAndSerializedDetails.size() - 1];
                int i = 0;
                for (IdentityWithSerializedDetails identityWithSerializedDetails : this.startState.groupMemberIdentitiesAndSerializedDetails) {
                    if (identityWithSerializedDetails.identity.equals(this.getOwnedIdentity())) continue;
                    pendingGroupMembers[i] = identityWithSerializedDetails;
                    ++i;
                }
                protocolManagerSession.identityDelegate.createContactGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupInformation, new Identity[]{groupOwnerIdentity}, pendingGroupMembers, false);
            }
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend2 = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
            return new ResponseSentState();
        }
    }

    public static class ProcessPropagatedInvitationResponseStep
    extends ProtocolStep {
        private final InvitationReceivedState startState;
        private final PropagateInvitationResponseMessage receivedMessage;

        public ProcessPropagatedInvitationResponseStep(InvitationReceivedState startState, PropagateInvitationResponseMessage receivedMessage, GroupInvitationProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            boolean invitationAccepted = this.receivedMessage.invitationAccepted;
            Identity groupOwnerIdentity = this.startState.groupInformation.groupOwnerIdentity;
            if (!protocolManagerSession.identityDelegate.isIdentityAnActiveContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), groupOwnerIdentity)) {
                return new ResponseSentState();
            }
            if (invitationAccepted) {
                IdentityWithSerializedDetails[] pendingGroupMembers = new IdentityWithSerializedDetails[this.startState.groupMemberIdentitiesAndSerializedDetails.size() - 1];
                int i = 0;
                for (IdentityWithSerializedDetails identityWithSerializedDetails : this.startState.groupMemberIdentitiesAndSerializedDetails) {
                    if (identityWithSerializedDetails.identity.equals(this.getOwnedIdentity())) continue;
                    pendingGroupMembers[i] = identityWithSerializedDetails;
                    ++i;
                }
                protocolManagerSession.identityDelegate.createContactGroup(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.groupInformation, new Identity[]{groupOwnerIdentity}, pendingGroupMembers, false);
            }
            return new ResponseSentState();
        }
    }
}

