/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.PreKeyBlobOnServer;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.UidAndPreKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.databases.LinkBetweenProtocolInstances;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.ChildToParentProtocolMessageInputs;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.DeviceDiscoveryChildProtocol;
import java.util.HashMap;
import java.util.Map;

public class DeviceDiscoveryProtocol
extends ConcreteProtocol {
    public static final int WAITING_FOR_CHILD_PROTOCOL_STATE_ID = 1;
    public static final int CHILD_PROTOCOL_OUTPUT_PROCESSED_STATE_ID = 2;
    public static final int CANCELLED_STATE_ID = 3;
    public static final int INITIAL_MESSAGE_ID = 0;
    public static final int CHILD_PROTOCOL_REACHED_EXPECTED_STATE_MESSAGE_ID = 1;

    public DeviceDiscoveryProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
        this.requiresProtocolInstanceToBeInsertedBeforeInitialStep = true;
    }

    @Override
    public int getProtocolId() {
        return 0;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{3, 2};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return WaitingForChildProtocolState.class;
            }
            case 2: {
                return ChildProtocolStateProcessedState.class;
            }
            case 3: {
                return CancelledState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return ChildProtocolReachedExpectedStateMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{StartChildProtocolStep.class};
            }
            case 1: {
                return new Class[]{ProcessChildProtocolStateStep.class};
            }
        }
        return new Class[0];
    }

    public static class WaitingForChildProtocolState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;

        public WaitingForChildProtocolState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 1) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
        }

        public WaitingForChildProtocolState(Identity contactIdentity) {
            super(1);
            this.contactIdentity = contactIdentity;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity)});
        }
    }

    public static class ChildProtocolStateProcessedState
    extends ConcreteProtocolState {
        public ChildProtocolStateProcessedState(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public ChildProtocolStateProcessedState() {
            super(2);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class CancelledState
    extends ConcreteProtocolState {
        public CancelledState(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        public CancelledState() {
            super(3);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity)};
        }
    }

    public static class ChildProtocolReachedExpectedStateMessage
    extends ConcreteProtocolMessage {
        private final ChildToParentProtocolMessageInputs childToParentProtocolMessageInputs;

        public ChildProtocolReachedExpectedStateMessage(CoreProtocolMessage coreProtocolMessage, ChildToParentProtocolMessageInputs childToParentProtocolMessageInputs) {
            super(coreProtocolMessage);
            this.childToParentProtocolMessageInputs = childToParentProtocolMessageInputs;
        }

        public ChildProtocolReachedExpectedStateMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 3) {
                throw new Exception();
            }
            this.childToParentProtocolMessageInputs = new ChildToParentProtocolMessageInputs(receivedMessage.getInputs());
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }

        public DeviceDiscoveryChildProtocol.DeviceUidsReceivedState getDeviceUidsReceivedState() {
            try {
                return new DeviceDiscoveryChildProtocol.DeviceUidsReceivedState(this.childToParentProtocolMessageInputs.getChildProtocolEncodedState());
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class StartChildProtocolStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public StartChildProtocolStep(InitialProtocolState startState, InitialMessage receivedMessage, DeviceDiscoveryProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!protocolManagerSession.identityDelegate.isIdentityAnActiveContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity)) {
                Logger.i("Trying to run a DeviceDiscoveryProtocol with an unknown or revoked contactIdentity");
                return new CancelledState();
            }
            UID childProtocolInstanceUid = new UID(this.getPrng());
            LinkBetweenProtocolInstances.create(protocolManagerSession, childProtocolInstanceUid, this.getOwnedIdentity(), 2, this.getProtocolInstanceUid(), this.getProtocolId(), 1);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 3, childProtocolInstanceUid);
            ChannelProtocolMessageToSend messageToSend = new DeviceDiscoveryChildProtocol.InitialMessage(coreProtocolMessage, this.receivedMessage.contactIdentity).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitingForChildProtocolState(this.receivedMessage.contactIdentity);
        }
    }

    public static class ProcessChildProtocolStateStep
    extends ProtocolStep {
        private final WaitingForChildProtocolState startState;
        private final ChildProtocolReachedExpectedStateMessage receivedMessage;

        public ProcessChildProtocolStateStep(WaitingForChildProtocolState startState, ChildProtocolReachedExpectedStateMessage receivedMessage, DeviceDiscoveryProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            DeviceDiscoveryChildProtocol.DeviceUidsReceivedState deviceUidsReceivedState = this.receivedMessage.getDeviceUidsReceivedState();
            Identity receivedContactIdentity = deviceUidsReceivedState.getRemoteIdentity();
            if (!receivedContactIdentity.equals(this.startState.contactIdentity)) {
                Logger.w("Received UID from another remoteIdentity!");
                return new CancelledState();
            }
            if (deviceUidsReceivedState.getDeviceUidsAndPreKeys().length == 0 && deviceUidsReceivedState.getServerTimestamp() == 0L) {
                Logger.w("Device discovery query expired.");
                return new CancelledState();
            }
            HashMap<UID, Encoded> newContactDevicesAndPreKeys = new HashMap<UID, Encoded>();
            for (HashMap<DictionaryKey, Encoded> deviceUidAndPreKey : deviceUidsReceivedState.getDeviceUidsAndPreKeys()) {
                try {
                    Encoded encodedDeviceUid = deviceUidAndPreKey.get(new DictionaryKey("uid"));
                    Encoded encodedSignedPreKey = deviceUidAndPreKey.get(new DictionaryKey("prk"));
                    if (encodedDeviceUid == null) continue;
                    UID deviceUid = encodedDeviceUid.decodeUid();
                    newContactDevicesAndPreKeys.put(deviceUid, encodedSignedPreKey);
                }
                catch (Exception e) {
                    Logger.i("Malformed server response id device discovery");
                    Logger.x(e);
                }
            }
            for (UidAndPreKey uidAndPreKey : protocolManagerSession.identityDelegate.getDeviceUidsAndPreKeysOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), receivedContactIdentity)) {
                boolean stillExists = newContactDevicesAndPreKeys.containsKey(uidAndPreKey.uid);
                Encoded encodedSignedPreKey = (Encoded)newContactDevicesAndPreKeys.remove(uidAndPreKey.uid);
                if (stillExists) {
                    boolean preKeyChanged;
                    PreKeyBlobOnServer newPreKey;
                    if (encodedSignedPreKey != null) {
                        PreKeyBlobOnServer preKeyBlob = PreKeyBlobOnServer.verifySignatureAndDecode(encodedSignedPreKey, receivedContactIdentity, uidAndPreKey.uid, deviceUidsReceivedState.getServerTimestamp());
                        if (preKeyBlob != null && (uidAndPreKey.preKey == null || !preKeyBlob.preKey.keyId.equals(uidAndPreKey.preKey.keyId) && uidAndPreKey.preKey.expirationTimestamp < preKeyBlob.preKey.expirationTimestamp)) {
                            newPreKey = preKeyBlob;
                            preKeyChanged = true;
                        } else {
                            newPreKey = null;
                            preKeyChanged = false;
                        }
                    } else if (uidAndPreKey.preKey != null) {
                        Logger.w("A contact preKey was removed from the server, this should never happen...");
                        newPreKey = null;
                        preKeyChanged = true;
                    } else {
                        newPreKey = null;
                        preKeyChanged = false;
                    }
                    if (!preKeyChanged) continue;
                    protocolManagerSession.identityDelegate.updateContactDevicePreKey(protocolManagerSession.session, this.getOwnedIdentity(), receivedContactIdentity, uidAndPreKey.uid, newPreKey);
                    continue;
                }
                protocolManagerSession.channelDelegate.deleteObliviousChannelIfItExists(protocolManagerSession.session, this.getOwnedIdentity(), uidAndPreKey.uid, receivedContactIdentity);
                protocolManagerSession.identityDelegate.removeDeviceForContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), receivedContactIdentity, uidAndPreKey.uid);
            }
            for (Map.Entry entry : newContactDevicesAndPreKeys.entrySet()) {
                PreKeyBlobOnServer preKeyBlob = entry.getValue() == null ? null : PreKeyBlobOnServer.verifySignatureAndDecode((Encoded)entry.getValue(), receivedContactIdentity, (UID)entry.getKey(), deviceUidsReceivedState.getServerTimestamp());
                protocolManagerSession.identityDelegate.addDeviceForContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), receivedContactIdentity, (UID)entry.getKey(), preKeyBlob, false);
            }
            protocolManagerSession.identityDelegate.setContactRecentlyOnline(protocolManagerSession.session, this.getOwnedIdentity(), receivedContactIdentity, deviceUidsReceivedState.isRecentlyOnline());
            if (deviceUidsReceivedState.getServerTimestamp() != 0L) {
                protocolManagerSession.identityDelegate.expireContactAndOwnedPreKeys(protocolManagerSession.session, this.getOwnedIdentity(), receivedContactIdentity.getServer(), deviceUidsReceivedState.getServerTimestamp());
            }
            return new ChildProtocolStateProcessedState();
        }
    }
}

