/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoAcceptableChannelException;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.DialogType;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.containers.TrustOrigin;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.databases.WaitingForOneToOneContactProtocolInstance;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.EmptyProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.OneWayDialogProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.DeviceDiscoveryProtocol;
import java.util.HashMap;
import java.util.UUID;

public class ContactMutualIntroductionProtocol
extends ConcreteProtocol {
    private static final int ACCEPT_TYPE_ALREADY_TRUSTED = 0;
    private static final int ACCEPT_TYPE_MANUAL = 2;
    private static final int CONTACTS_INTRODUCED_STATE_ID = 1;
    private static final int INVITATION_RECEIVED_STATE_ID = 2;
    private static final int INVITATION_ACCEPTED_STATE_ID = 3;
    private static final int INVITATION_REJECTED_STATE_ID = 4;
    private static final int WAITING_FOR_ACK_STATE_ID = 5;
    private static final int MUTUAL_TRUST_ESTABLISHED_STATE_ID = 6;
    private static final int INITIAL_MESSAGE_ID = 0;
    private static final int MEDIATOR_INVITATION_MESSAGE_ID = 1;
    private static final int DIALOG_ACCEPT_MEDIATOR_INVITE_MESSAGE_ID = 2;
    private static final int PROPAGATE_CONFIRMATION_MESSAGE_ID = 3;
    private static final int NOTIFY_CONTACT_OF_ACCEPTED_INVITATION_MESSAGE_ID = 4;
    private static final int PROPAGATE_NOTIFICATION_MESSAGE_ID = 5;
    private static final int ACK_MESSAGE_ID = 6;
    private static final int TRUST_LEVEL_INCREASED_MESSAGE_ID = 7;
    private static final int PROPAGATED_INITIAL_MESSAGE = 9;

    public ContactMutualIntroductionProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
        this.requiresProtocolInstanceToBeInsertedBeforeInitialStep = true;
    }

    @Override
    public int getProtocolId() {
        return 4;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{1, 4, 6};
    }

    @Override
    protected Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return ContactsIntroducedState.class;
            }
            case 2: {
                return InvitationReceivedState.class;
            }
            case 3: {
                return InvitationAcceptedState.class;
            }
            case 4: {
                return InvitationRejectedState.class;
            }
            case 5: {
                return WaitingForAckState.class;
            }
            case 6: {
                return MutualTrustEstablishedState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return MediatorInvitationMessage.class;
            }
            case 2: {
                return DialogAcceptMediatorInviteMessage.class;
            }
            case 3: {
                return PropagateConfirmationMessage.class;
            }
            case 4: {
                return NotifyContactOfAcceptedInvitationMessage.class;
            }
            case 5: {
                return PropagateNotificationMessage.class;
            }
            case 6: {
                return AckMessage.class;
            }
            case 7: {
                return TrustLevelIncreasedMessage.class;
            }
            case 9: {
                return PropagatedInitialMessage.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{IntroduceContactsStep.class, ProcessPropagatedInitialMessageStep.class, CheckTrustLevelsAndShowDialogStep.class};
            }
            case 2: {
                return new Class[]{PropagateInviteResponseStep.class, ProcessPropagatedInviteResponseStep.class, ReCheckTrustLevelsAfterTrustLevelIncreaseStep.class};
            }
            case 3: {
                return new Class[]{PropagateNotificationAddTrustAndSendAckStep.class, ProcessPropagatedNotificationAndAddTrustStep.class};
            }
            case 5: {
                return new Class[]{NotifyMutualTrustEstablishedStep.class};
            }
        }
        return new Class[0];
    }

    public static class ContactsIntroducedState
    extends ConcreteProtocolState {
        public ContactsIntroducedState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        ContactsIntroducedState() {
            super(1);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InvitationReceivedState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final String contactSerializedDetails;
        private final Identity mediatorIdentity;
        private final UUID dialogUuid;

        public InvitationReceivedState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 4) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.contactSerializedDetails = list[1].decodeString();
            this.mediatorIdentity = list[2].decodeIdentity();
            this.dialogUuid = list[3].decodeUuid();
        }

        InvitationReceivedState(Identity contactIdentity, String contactSerializedDetails, Identity mediatorIdentity, UUID dialogUuid) {
            super(2);
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
            this.mediatorIdentity = mediatorIdentity;
            this.dialogUuid = dialogUuid;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails), Encoded.of(this.mediatorIdentity), Encoded.of(this.dialogUuid)});
        }
    }

    public static class InvitationAcceptedState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final String contactSerializedDetails;
        private final Identity mediatorIdentity;
        private final UUID dialogUuid;
        private final int acceptType;

        public InvitationAcceptedState(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 5) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.contactSerializedDetails = list[1].decodeString();
            this.mediatorIdentity = list[2].decodeIdentity();
            this.dialogUuid = list[3].decodeUuid();
            this.acceptType = (int)list[4].decodeLong();
        }

        InvitationAcceptedState(Identity contactIdentity, String contactSerializedDetails, Identity mediatorIdentity, UUID dialogUuid, int acceptType) {
            super(3);
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
            this.mediatorIdentity = mediatorIdentity;
            this.dialogUuid = dialogUuid;
            this.acceptType = acceptType;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails), Encoded.of(this.mediatorIdentity), Encoded.of(this.dialogUuid), Encoded.of(this.acceptType)});
        }
    }

    public static class InvitationRejectedState
    extends ConcreteProtocolState {
        public InvitationRejectedState(Encoded encodedState) throws Exception {
            super(4);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        InvitationRejectedState() {
            super(4);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class WaitingForAckState
    extends ConcreteProtocolState {
        private final Identity contactIdentity;
        private final String contactSerializedDetails;
        private final Identity mediatorIdentity;
        private final UUID dialogUuid;
        private final int acceptType;

        public WaitingForAckState(Encoded encodedState) throws Exception {
            super(5);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 5) {
                throw new Exception();
            }
            this.contactIdentity = list[0].decodeIdentity();
            this.contactSerializedDetails = list[1].decodeString();
            this.mediatorIdentity = list[2].decodeIdentity();
            this.dialogUuid = list[3].decodeUuid();
            this.acceptType = (int)list[4].decodeLong();
        }

        WaitingForAckState(Identity contactIdentity, String contactSerializedDetails, Identity mediatorIdentity, UUID dialogUuid, int acceptType) {
            super(5);
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
            this.mediatorIdentity = mediatorIdentity;
            this.dialogUuid = dialogUuid;
            this.acceptType = acceptType;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails), Encoded.of(this.mediatorIdentity), Encoded.of(this.dialogUuid), Encoded.of(this.acceptType)});
        }
    }

    public static class MutualTrustEstablishedState
    extends ConcreteProtocolState {
        public MutualTrustEstablishedState(Encoded encodedState) throws Exception {
            super(6);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        MutualTrustEstablishedState() {
            super(6);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        protected final Identity contactIdentityA;
        protected final Identity contactIdentityB;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentityA, Identity contactIdentityB) {
            super(coreProtocolMessage);
            this.contactIdentityA = contactIdentityA;
            this.contactIdentityB = contactIdentityB;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.contactIdentityA = receivedMessage.getInputs()[0].decodeIdentity();
            this.contactIdentityB = receivedMessage.getInputs()[1].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentityA), Encoded.of(this.contactIdentityB)};
        }
    }

    public static class MediatorInvitationMessage
    extends ConcreteProtocolMessage {
        private final Identity contactIdentity;
        private final String contactSerializedDetails;

        MediatorInvitationMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentity, String contactSerializedDetails) {
            super(coreProtocolMessage);
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
        }

        public MediatorInvitationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.contactIdentity = receivedMessage.getInputs()[0].decodeIdentity();
            this.contactSerializedDetails = receivedMessage.getInputs()[1].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails)};
        }
    }

    public static class DialogAcceptMediatorInviteMessage
    extends ConcreteProtocolMessage {
        private final boolean invitationAccepted;
        private final UUID dialogUuid;

        DialogAcceptMediatorInviteMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
            this.invitationAccepted = false;
            this.dialogUuid = null;
        }

        public DialogAcceptMediatorInviteMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getEncodedResponse() == null) {
                throw new Exception();
            }
            this.invitationAccepted = receivedMessage.getEncodedResponse().decodeBoolean();
            this.dialogUuid = receivedMessage.getUserDialogUuid();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class PropagateConfirmationMessage
    extends ConcreteProtocolMessage {
        private final boolean invitationAccepted;
        private final Identity contactIdentity;
        private final String contactSerializedDetails;
        private final Identity mediatorIdentity;

        PropagateConfirmationMessage(CoreProtocolMessage coreProtocolMessage, boolean invitationAccepted, Identity contactIdentity, String contactSerializedDetails, Identity mediatorIdentity) {
            super(coreProtocolMessage);
            this.invitationAccepted = invitationAccepted;
            this.contactIdentity = contactIdentity;
            this.contactSerializedDetails = contactSerializedDetails;
            this.mediatorIdentity = mediatorIdentity;
        }

        public PropagateConfirmationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 4) {
                throw new Exception();
            }
            this.invitationAccepted = receivedMessage.getInputs()[0].decodeBoolean();
            this.contactIdentity = receivedMessage.getInputs()[1].decodeIdentity();
            this.contactSerializedDetails = receivedMessage.getInputs()[2].decodeString();
            this.mediatorIdentity = receivedMessage.getInputs()[3].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.invitationAccepted), Encoded.of(this.contactIdentity), Encoded.of(this.contactSerializedDetails), Encoded.of(this.mediatorIdentity)};
        }
    }

    public static class NotifyContactOfAcceptedInvitationMessage
    extends ConcreteProtocolMessage {
        private final UID[] contactDeviceUids;
        private final byte[] signature;

        NotifyContactOfAcceptedInvitationMessage(CoreProtocolMessage coreProtocolMessage, UID[] contactDeviceUids, byte[] signature) {
            super(coreProtocolMessage);
            this.contactDeviceUids = contactDeviceUids;
            this.signature = signature;
        }

        public NotifyContactOfAcceptedInvitationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.contactDeviceUids = receivedMessage.getInputs()[0].decodeUidArray();
            this.signature = receivedMessage.getInputs()[1].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactDeviceUids), Encoded.of(this.signature)};
        }
    }

    public static class PropagateNotificationMessage
    extends ConcreteProtocolMessage {
        private final UID[] contactDeviceUids;

        PropagateNotificationMessage(CoreProtocolMessage coreProtocolMessage, UID[] contactDeviceUids) {
            super(coreProtocolMessage);
            this.contactDeviceUids = contactDeviceUids;
        }

        public PropagateNotificationMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.contactDeviceUids = receivedMessage.getInputs()[0].decodeUidArray();
        }

        @Override
        public int getProtocolMessageId() {
            return 5;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.contactDeviceUids)};
        }
    }

    public static class AckMessage
    extends EmptyProtocolMessage {
        AckMessage(CoreProtocolMessage coreProtocolMessage) {
            super(coreProtocolMessage);
        }

        public AckMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 6;
        }
    }

    public static class TrustLevelIncreasedMessage
    extends ConcreteProtocolMessage {
        Identity trustLevelIncreasedIdentity;

        public TrustLevelIncreasedMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.trustLevelIncreasedIdentity = receivedMessage.getInputs()[0].decodeIdentity();
        }

        @Override
        public int getProtocolMessageId() {
            return 7;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[0];
        }
    }

    public static class PropagatedInitialMessage
    extends InitialMessage {
        public PropagatedInitialMessage(CoreProtocolMessage coreProtocolMessage, Identity contactIdentityA, Identity contactIdentityB) {
            super(coreProtocolMessage, contactIdentityA, contactIdentityB);
        }

        public PropagatedInitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(receivedMessage);
        }

        @Override
        public int getProtocolMessageId() {
            return 9;
        }
    }

    public static class IntroduceContactsStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public IntroduceContactsStep(InitialProtocolState startState, InitialMessage receivedMessage, ContactMutualIntroductionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!(protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentityA) && protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentityB) && protocolManagerSession.identityDelegate.isIdentityAnActiveContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentityA) && protocolManagerSession.identityDelegate.isIdentityAnActiveContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentityA))) {
                return new ContactsIntroducedState();
            }
            String serializedDetailsB = protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentityB);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.contactIdentityA, this.getOwnedIdentity()), this.getProtocolId(), this.getProtocolInstanceUid(), true);
            ChannelProtocolMessageToSend messageToSend = new MediatorInvitationMessage(coreProtocolMessage, this.receivedMessage.contactIdentityB, serializedDetailsB).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            String serializedDetailsA = protocolManagerSession.identityDelegate.getSerializedPublishedDetailsOfContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentityA);
            coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createAllConfirmedObliviousChannelsOrPreKeysInfo(this.receivedMessage.contactIdentityB, this.getOwnedIdentity()), this.getProtocolId(), this.getProtocolInstanceUid(), true);
            messageToSend = new MediatorInvitationMessage(coreProtocolMessage, this.receivedMessage.contactIdentityA, serializedDetailsA).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    messageToSend = new PropagatedInitialMessage(coreProtocolMessage, this.receivedMessage.contactIdentityA, this.receivedMessage.contactIdentityB).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException noAcceptableChannelException) {
                    // empty catch block
                }
            }
            protocolManagerSession.session.addSessionCommitListener(() -> {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", this.getOwnedIdentity());
                userInfo.put("contact_identity_a", this.receivedMessage.contactIdentityA);
                userInfo.put("contact_identity_b", this.receivedMessage.contactIdentityB);
                protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_contact_introduction_invitation_sent", userInfo);
            });
            return new ContactsIntroducedState();
        }
    }

    public static class ProcessPropagatedInitialMessageStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PropagatedInitialMessage receivedMessage;

        public ProcessPropagatedInitialMessageStep(InitialProtocolState startState, PropagatedInitialMessage receivedMessage, ContactMutualIntroductionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            protocolManagerSession.session.addSessionCommitListener(() -> {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", this.getOwnedIdentity());
                userInfo.put("contact_identity_a", this.receivedMessage.contactIdentityA);
                userInfo.put("contact_identity_b", this.receivedMessage.contactIdentityB);
                protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_contact_introduction_invitation_sent", userInfo);
            });
            return new ContactsIntroducedState();
        }
    }

    public static class CheckTrustLevelsAndShowDialogStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final MediatorInvitationMessage receivedMessage;

        public CheckTrustLevelsAndShowDialogStep(InitialProtocolState startState, MediatorInvitationMessage receivedMessage, ContactMutualIntroductionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            Identity mediatorIdentity = this.receivedMessage.getReceptionChannelInfo().getRemoteIdentity();
            if (!protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), mediatorIdentity)) {
                return new InvitationRejectedState();
            }
            boolean contactAlreadyOneToOne = protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.contactIdentity);
            if (contactAlreadyOneToOne) {
                UID[] deviceUids = protocolManagerSession.identityDelegate.getDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
                byte[] signature = protocolManagerSession.identityDelegate.signIdentities(protocolManagerSession.session, Constants.SignatureContext.MUTUAL_INTRODUCTION, new Identity[]{mediatorIdentity, this.receivedMessage.contactIdentity, this.getOwnedIdentity()}, this.getOwnedIdentity(), this.getPrng());
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(this.receivedMessage.contactIdentity, this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new NotifyContactOfAcceptedInvitationMessage(coreProtocolMessage, deviceUids, signature).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                UUID dialogUuid = UUID.randomUUID();
                return new InvitationAcceptedState(this.receivedMessage.contactIdentity, this.receivedMessage.contactSerializedDetails, mediatorIdentity, dialogUuid, 0);
            }
            UUID dialogUuid = UUID.randomUUID();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createAcceptMediatorInviteDialog(this.receivedMessage.contactSerializedDetails, this.receivedMessage.contactIdentity, mediatorIdentity, this.receivedMessage.getServerTimestamp()), dialogUuid));
            ChannelDialogMessageToSend messageToSend = new DialogAcceptMediatorInviteMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            WaitingForOneToOneContactProtocolInstance.create(protocolManagerSession, this.getProtocolInstanceUid(), this.getOwnedIdentity(), this.receivedMessage.contactIdentity, this.getProtocolId(), 7);
            return new InvitationReceivedState(this.receivedMessage.contactIdentity, this.receivedMessage.contactSerializedDetails, mediatorIdentity, dialogUuid);
        }
    }

    public static class PropagateInviteResponseStep
    extends ProtocolStep {
        private final InvitationReceivedState startState;
        private final DialogAcceptMediatorInviteMessage receivedMessage;

        public PropagateInviteResponseStep(InvitationReceivedState startState, DialogAcceptMediatorInviteMessage receivedMessage, ContactMutualIntroductionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ChannelDialogMessageToSend messageToSend;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!this.startState.dialogUuid.equals(this.receivedMessage.dialogUuid)) {
                Logger.e("ObvDialog uuid mismatch in DialogAcceptMediatorInviteMessage.");
                return null;
            }
            int numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length;
            if (numberOfOtherDevices > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend2 = new PropagateConfirmationMessage(coreProtocolMessage, this.receivedMessage.invitationAccepted, this.startState.contactIdentity, this.startState.contactSerializedDetails, this.startState.mediatorIdentity).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            protocolManagerSession.session.addSessionCommitListener(() -> {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", this.getOwnedIdentity());
                userInfo.put("mediator_identity", this.startState.mediatorIdentity);
                userInfo.put("contact_identity", this.startState.contactIdentity);
                userInfo.put("contact_serialized_details", this.startState.contactSerializedDetails);
                userInfo.put("accepted", this.receivedMessage.invitationAccepted);
                protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_contact_introduction_invitation_response", userInfo);
            });
            if (this.receivedMessage.invitationAccepted) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createMediatorInviteAcceptedDialog(this.startState.contactSerializedDetails, this.startState.contactIdentity, this.startState.mediatorIdentity), this.startState.dialogUuid));
                messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                UID[] deviceUids = protocolManagerSession.identityDelegate.getDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
                byte[] signature = protocolManagerSession.identityDelegate.signIdentities(protocolManagerSession.session, Constants.SignatureContext.MUTUAL_INTRODUCTION, new Identity[]{this.startState.mediatorIdentity, this.startState.contactIdentity, this.getOwnedIdentity()}, this.getOwnedIdentity(), this.getPrng());
                CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(this.startState.contactIdentity, this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend3 = new NotifyContactOfAcceptedInvitationMessage(coreProtocolMessage2, deviceUids, signature).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend3, this.getPrng());
                return new InvitationAcceptedState(this.startState.contactIdentity, this.startState.contactSerializedDetails, this.startState.mediatorIdentity, this.startState.dialogUuid, 2);
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
            messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new InvitationRejectedState();
        }
    }

    public static class ProcessPropagatedInviteResponseStep
    extends ProtocolStep {
        private final InvitationReceivedState startState;
        private final PropagateConfirmationMessage receivedMessage;

        public ProcessPropagatedInviteResponseStep(InvitationReceivedState startState, PropagateConfirmationMessage receivedMessage, ContactMutualIntroductionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            protocolManagerSession.session.addSessionCommitListener(() -> {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put("owned_identity", this.getOwnedIdentity());
                userInfo.put("mediator_identity", this.startState.mediatorIdentity);
                userInfo.put("contact_identity", this.startState.contactIdentity);
                userInfo.put("contact_serialized_details", this.startState.contactSerializedDetails);
                userInfo.put("accepted", this.receivedMessage.invitationAccepted);
                protocolManagerSession.notificationPostingDelegate.postNotification("protocol_manager_notification_contact_introduction_invitation_response", userInfo);
            });
            if (this.receivedMessage.invitationAccepted) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createMediatorInviteAcceptedDialog(this.receivedMessage.contactSerializedDetails, this.receivedMessage.contactIdentity, this.receivedMessage.mediatorIdentity), this.startState.dialogUuid));
                ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new InvitationAcceptedState(this.receivedMessage.contactIdentity, this.receivedMessage.contactSerializedDetails, this.receivedMessage.mediatorIdentity, this.startState.dialogUuid, 2);
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new InvitationRejectedState();
        }
    }

    public static class ReCheckTrustLevelsAfterTrustLevelIncreaseStep
    extends ProtocolStep {
        private final InvitationReceivedState startState;
        private final TrustLevelIncreasedMessage receivedMessage;

        public ReCheckTrustLevelsAfterTrustLevelIncreaseStep(InvitationReceivedState startState, TrustLevelIncreasedMessage receivedMessage, ContactMutualIntroductionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            boolean contactAlreadyTrusted = protocolManagerSession.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity);
            if (contactAlreadyTrusted) {
                UID[] deviceUids = protocolManagerSession.identityDelegate.getDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
                byte[] signature = protocolManagerSession.identityDelegate.signIdentities(protocolManagerSession.session, Constants.SignatureContext.MUTUAL_INTRODUCTION, new Identity[]{this.startState.mediatorIdentity, this.startState.contactIdentity, this.getOwnedIdentity()}, this.getOwnedIdentity(), this.getPrng());
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricBroadcastChannelInfo(this.startState.contactIdentity, this.getOwnedIdentity()));
                ChannelProtocolMessageToSend messageToSend = new NotifyContactOfAcceptedInvitationMessage(coreProtocolMessage, deviceUids, signature).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
                ChannelDialogMessageToSend messageToSend2 = new OneWayDialogProtocolMessage(coreProtocolMessage2).generateChannelDialogMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend2, this.getPrng());
                return new InvitationAcceptedState(this.startState.contactIdentity, this.startState.contactSerializedDetails, this.startState.mediatorIdentity, this.startState.dialogUuid, 0);
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createAcceptMediatorInviteDialog(this.startState.contactSerializedDetails, this.startState.contactIdentity, this.startState.mediatorIdentity, System.currentTimeMillis()), this.startState.dialogUuid));
            ChannelDialogMessageToSend messageToSend = new DialogAcceptMediatorInviteMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            WaitingForOneToOneContactProtocolInstance instance = WaitingForOneToOneContactProtocolInstance.get(protocolManagerSession, this.getProtocolInstanceUid(), this.getOwnedIdentity(), this.receivedMessage.trustLevelIncreasedIdentity);
            if (instance != null) {
                instance.delete();
            }
            WaitingForOneToOneContactProtocolInstance.create(protocolManagerSession, this.getProtocolInstanceUid(), this.getOwnedIdentity(), this.startState.contactIdentity, this.getProtocolId(), 7);
            return this.startState;
        }
    }

    public static class PropagateNotificationAddTrustAndSendAckStep
    extends ProtocolStep {
        private final InvitationAcceptedState startState;
        private final NotifyContactOfAcceptedInvitationMessage receivedMessage;

        public PropagateNotificationAddTrustAndSendAckStep(InvitationAcceptedState startState, NotifyContactOfAcceptedInvitationMessage receivedMessage, ContactMutualIntroductionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            int numberOfOtherDevices;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            boolean signatureIsValid = Signature.verify(Constants.SignatureContext.MUTUAL_INTRODUCTION, new Identity[]{this.startState.mediatorIdentity, this.getOwnedIdentity(), this.startState.contactIdentity}, this.startState.contactIdentity, this.receivedMessage.signature);
            if (!signatureIsValid) {
                Logger.w("Received a NotifyContactOfAcceptedInvitationMessage with an invalid signature");
                return null;
            }
            if (!protocolManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity)) {
                protocolManagerSession.identityDelegate.addContactIdentity(protocolManagerSession.session, this.startState.contactIdentity, this.startState.contactSerializedDetails, this.getOwnedIdentity(), TrustOrigin.createIntroductionTrustOrigin(System.currentTimeMillis(), this.startState.mediatorIdentity), true);
            } else {
                protocolManagerSession.identityDelegate.addTrustOriginToContact(protocolManagerSession.session, this.startState.contactIdentity, this.getOwnedIdentity(), TrustOrigin.createIntroductionTrustOrigin(System.currentTimeMillis(), this.startState.mediatorIdentity), true);
            }
            boolean triggerDeviceDiscovery = false;
            for (UID contactDeviceUid : this.receivedMessage.contactDeviceUids) {
                triggerDeviceDiscovery |= protocolManagerSession.identityDelegate.addDeviceForContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity, contactDeviceUid, null, false);
            }
            if (triggerDeviceDiscovery) {
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 0, new UID(this.getPrng()));
                ChannelProtocolMessageToSend messageToSend = new DeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage, this.startState.contactIdentity).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            if ((numberOfOtherDevices = protocolManagerSession.identityDelegate.getOtherDeviceUidsOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity()).length) > 0) {
                try {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAllOwnedConfirmedObliviousChannelsOrPreKeysInfo(this.getOwnedIdentity()));
                    ChannelProtocolMessageToSend messageToSend = new PropagateNotificationMessage(coreProtocolMessage, this.receivedMessage.contactDeviceUids).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
                catch (NoAcceptableChannelException coreProtocolMessage) {
                    // empty catch block
                }
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.startState.contactIdentity, this.getOwnedIdentity(), this.receivedMessage.contactDeviceUids));
            ChannelProtocolMessageToSend messageToSend = new AckMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitingForAckState(this.startState.contactIdentity, this.startState.contactSerializedDetails, this.startState.mediatorIdentity, this.startState.dialogUuid, this.startState.acceptType);
        }
    }

    public static class ProcessPropagatedNotificationAndAddTrustStep
    extends ProtocolStep {
        private final InvitationAcceptedState startState;
        private final PropagateNotificationMessage receivedMessage;

        public ProcessPropagatedNotificationAndAddTrustStep(InvitationAcceptedState startState, PropagateNotificationMessage receivedMessage, ContactMutualIntroductionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            if (!protocolManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity)) {
                protocolManagerSession.identityDelegate.addContactIdentity(protocolManagerSession.session, this.startState.contactIdentity, this.startState.contactSerializedDetails, this.getOwnedIdentity(), TrustOrigin.createIntroductionTrustOrigin(System.currentTimeMillis(), this.startState.mediatorIdentity), true);
            } else {
                protocolManagerSession.identityDelegate.addTrustOriginToContact(protocolManagerSession.session, this.startState.contactIdentity, this.getOwnedIdentity(), TrustOrigin.createIntroductionTrustOrigin(System.currentTimeMillis(), this.startState.mediatorIdentity), true);
            }
            boolean triggerDeviceDiscovery = false;
            for (UID contactDeviceUid : this.receivedMessage.contactDeviceUids) {
                triggerDeviceDiscovery |= protocolManagerSession.identityDelegate.addDeviceForContactIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.contactIdentity, contactDeviceUid, null, false);
            }
            if (triggerDeviceDiscovery) {
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 0, new UID(this.getPrng()));
                ChannelProtocolMessageToSend messageToSend = new DeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage, this.startState.contactIdentity).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            }
            return new WaitingForAckState(this.startState.contactIdentity, this.startState.contactSerializedDetails, this.startState.mediatorIdentity, this.startState.dialogUuid, this.startState.acceptType);
        }
    }

    public static class NotifyMutualTrustEstablishedStep
    extends ProtocolStep {
        private final WaitingForAckState startState;
        private final AckMessage receivedMessage;

        public NotifyMutualTrustEstablishedStep(WaitingForAckState startState, AckMessage receivedMessage, ContactMutualIntroductionProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            switch (this.startState.acceptType) {
                case 2: {
                    CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(this.getOwnedIdentity(), DialogType.createDeleteDialog(), this.startState.dialogUuid));
                    ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                    break;
                }
            }
            return new MutualTrustEstablishedState();
        }
    }
}

