/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocols;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.PublicKeyEncryption;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.CiphertextAndKey;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.KeyPair;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.protocol.databases.ChannelCreationPingSignatureReceived;
import io.olvid.engine.protocol.databases.ChannelCreationProtocolInstance;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocol;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.InitialProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.DeviceCapabilitiesDiscoveryProtocol;
import io.olvid.engine.protocol.protocols.DownloadIdentityPhotoChildProtocol;
import io.olvid.engine.protocol.protocols.OwnedDeviceDiscoveryProtocol;
import java.sql.SQLException;
import java.util.Objects;

public class ChannelCreationWithOwnedDeviceProtocol
extends ConcreteProtocol {
    static final int CANCELLED_STATE_ID = 1;
    static final int PING_SENT_STATE_ID = 2;
    static final int WAITING_FOR_K1_STATE_ID = 3;
    static final int WAITING_FOR_K2_STATE_ID = 4;
    static final int WAIT_FOR_FIRST_ACK_STATE_ID = 5;
    static final int WAIT_FOR_SECOND_ACK_STATE_ID = 7;
    static final int CHANNEL_CONFIRMED_STATE_ID = 8;
    static final int INITIAL_MESSAGE_ID = 0;
    static final int PING_MESSAGE_ID = 1;
    static final int ALICE_IDENTITY_AND_EPHEMERAL_KEY_MESSAGE_ID = 2;
    static final int BOB_EPHEMERAL_KEY_AND_K1_MESSAGE_ID = 3;
    static final int K2_MESSAGE_ID = 4;
    static final int FIRST_ACK_MESSAGE_ID = 5;
    static final int SECOND_ACK_MESSAGE_ID = 6;

    public ChannelCreationWithOwnedDeviceProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        super(protocolManagerSession, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
        this.requiresProtocolInstanceToBeInsertedBeforeInitialStep = true;
    }

    @Override
    public int getProtocolId() {
        return 22;
    }

    @Override
    public int[] getFinalStateIds() {
        return new int[]{1, 8, 2};
    }

    @Override
    public Class<?> getStateClass(int stateId) {
        switch (stateId) {
            case 0: {
                return InitialProtocolState.class;
            }
            case 1: {
                return CancelledState.class;
            }
            case 2: {
                return PingSentState.class;
            }
            case 3: {
                return WaitingForK1State.class;
            }
            case 4: {
                return WaitingForK2State.class;
            }
            case 5: {
                return WaitForFirstAckState.class;
            }
            case 7: {
                return WaitForSecondAckState.class;
            }
            case 8: {
                return ChannelConfirmedState.class;
            }
        }
        return null;
    }

    @Override
    protected Class<?> getMessageClass(int protocolMessageId) {
        switch (protocolMessageId) {
            case 0: {
                return InitialMessage.class;
            }
            case 1: {
                return PingMessage.class;
            }
            case 2: {
                return AliceIdentityAndEphemeralKeyMessage.class;
            }
            case 3: {
                return BobEphemeralKeyAndK1Message.class;
            }
            case 4: {
                return K2Message.class;
            }
            case 5: {
                return FirstAckMessage.class;
            }
            case 6: {
                return SecondAckMessage.class;
            }
        }
        return null;
    }

    @Override
    public Class<?>[] getPossibleStepClasses(int stateId) {
        switch (stateId) {
            case 0: {
                return new Class[]{SendPingStep.class, SendPingOrEphemeralKeyStep.class, SendEphemeralKeyAndK1Step.class};
            }
            case 3: {
                return new Class[]{RecoverK1AndSendK2AndCreateChannelStep.class};
            }
            case 4: {
                return new Class[]{RecoverK2CreateChannelAndSendAckStep.class};
            }
            case 5: {
                return new Class[]{ConfirmChannelAndSendAckStep.class};
            }
            case 7: {
                return new Class[]{ConfirmChannelStep.class};
            }
        }
        return new Class[0];
    }

    public static class CancelledState
    extends ConcreteProtocolState {
        public CancelledState(Encoded encodedState) throws Exception {
            super(1);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        CancelledState() {
            super(1);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class PingSentState
    extends ConcreteProtocolState {
        public PingSentState(Encoded encodedState) throws Exception {
            super(2);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        PingSentState() {
            super(2);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class WaitingForK1State
    extends ConcreteProtocolState {
        private final UID remoteDeviceUid;
        private final EncryptionPrivateKey ephemeralPrivateKey;

        public WaitingForK1State(Encoded encodedState) throws Exception {
            super(3);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 2) {
                throw new Exception();
            }
            this.remoteDeviceUid = list[0].decodeUid();
            this.ephemeralPrivateKey = (EncryptionPrivateKey)list[1].decodePrivateKey();
        }

        WaitingForK1State(UID remoteDeviceUid, EncryptionPrivateKey ephemeralPrivateKey) {
            super(3);
            this.remoteDeviceUid = remoteDeviceUid;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.remoteDeviceUid), Encoded.of(this.ephemeralPrivateKey)});
        }
    }

    public static class WaitingForK2State
    extends ConcreteProtocolState {
        private final UID remoteDeviceUid;
        private final EncryptionPrivateKey ephemeralPrivateKey;
        private final AuthEncKey k1;

        public WaitingForK2State(Encoded encodedState) throws Exception {
            super(4);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 3) {
                throw new Exception();
            }
            this.remoteDeviceUid = list[0].decodeUid();
            this.ephemeralPrivateKey = (EncryptionPrivateKey)list[1].decodePrivateKey();
            this.k1 = (AuthEncKey)list[2].decodeSymmetricKey();
        }

        WaitingForK2State(UID remoteDeviceUid, EncryptionPrivateKey ephemeralPrivateKey, AuthEncKey k1) {
            super(4);
            this.remoteDeviceUid = remoteDeviceUid;
            this.ephemeralPrivateKey = ephemeralPrivateKey;
            this.k1 = k1;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.remoteDeviceUid), Encoded.of(this.ephemeralPrivateKey), Encoded.of(this.k1)});
        }
    }

    public static class WaitForFirstAckState
    extends ConcreteProtocolState {
        private final UID remoteDeviceUid;

        public WaitForFirstAckState(Encoded encodedState) throws Exception {
            super(5);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 1) {
                throw new Exception();
            }
            this.remoteDeviceUid = list[0].decodeUid();
        }

        WaitForFirstAckState(UID remoteDeviceUid) {
            super(5);
            this.remoteDeviceUid = remoteDeviceUid;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.remoteDeviceUid)});
        }
    }

    public static class WaitForSecondAckState
    extends ConcreteProtocolState {
        private final UID remoteDeviceUid;

        public WaitForSecondAckState(Encoded encodedState) throws Exception {
            super(7);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 1) {
                throw new Exception();
            }
            this.remoteDeviceUid = list[0].decodeUid();
        }

        WaitForSecondAckState(UID remoteDeviceUid) {
            super(7);
            this.remoteDeviceUid = remoteDeviceUid;
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.remoteDeviceUid)});
        }
    }

    public static class ChannelConfirmedState
    extends ConcreteProtocolState {
        public ChannelConfirmedState(Encoded encodedState) throws Exception {
            super(8);
            Encoded[] list = encodedState.decodeList();
            if (list.length != 0) {
                throw new Exception();
            }
        }

        ChannelConfirmedState() {
            super(8);
        }

        @Override
        public Encoded encode() {
            return Encoded.of(new Encoded[0]);
        }
    }

    public static class InitialMessage
    extends ConcreteProtocolMessage {
        private final UID remoteDeviceUid;

        public InitialMessage(CoreProtocolMessage coreProtocolMessage, UID remoteDeviceUid) {
            super(coreProtocolMessage);
            this.remoteDeviceUid = remoteDeviceUid;
        }

        public InitialMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.remoteDeviceUid = receivedMessage.getInputs()[0].decodeUid();
        }

        @Override
        public int getProtocolMessageId() {
            return 0;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.remoteDeviceUid)};
        }
    }

    public static class PingMessage
    extends ConcreteProtocolMessage {
        private final UID remoteDeviceUid;
        private final byte[] signature;

        public PingMessage(CoreProtocolMessage coreProtocolMessage, UID remoteDeviceUid, byte[] signature) {
            super(coreProtocolMessage);
            this.remoteDeviceUid = remoteDeviceUid;
            this.signature = signature;
        }

        public PingMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.remoteDeviceUid = receivedMessage.getInputs()[0].decodeUid();
            this.signature = receivedMessage.getInputs()[1].decodeBytes();
        }

        @Override
        public int getProtocolMessageId() {
            return 1;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.remoteDeviceUid), Encoded.of(this.signature)};
        }
    }

    public static class AliceIdentityAndEphemeralKeyMessage
    extends ConcreteProtocolMessage {
        private final UID remoteDeviceUid;
        private final byte[] signature;
        private final EncryptionPublicKey remoteEphemeralPublicKey;

        public AliceIdentityAndEphemeralKeyMessage(CoreProtocolMessage coreProtocolMessage, UID remoteDeviceUid, byte[] signature, EncryptionPublicKey remoteEphemeralPublicKey) {
            super(coreProtocolMessage);
            this.remoteDeviceUid = remoteDeviceUid;
            this.signature = signature;
            this.remoteEphemeralPublicKey = remoteEphemeralPublicKey;
        }

        public AliceIdentityAndEphemeralKeyMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 3) {
                throw new Exception();
            }
            this.remoteDeviceUid = receivedMessage.getInputs()[0].decodeUid();
            this.signature = receivedMessage.getInputs()[1].decodeBytes();
            this.remoteEphemeralPublicKey = (EncryptionPublicKey)receivedMessage.getInputs()[2].decodePublicKey();
        }

        @Override
        public int getProtocolMessageId() {
            return 2;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.remoteDeviceUid), Encoded.of(this.signature), Encoded.of(this.remoteEphemeralPublicKey)};
        }
    }

    public static class BobEphemeralKeyAndK1Message
    extends ConcreteProtocolMessage {
        private final EncryptionPublicKey remoteEphemeralPublicKey;
        private final EncryptedBytes c1;

        BobEphemeralKeyAndK1Message(CoreProtocolMessage coreProtocolMessage, EncryptionPublicKey remoteEphemeralPublicKey, EncryptedBytes c1) {
            super(coreProtocolMessage);
            this.remoteEphemeralPublicKey = remoteEphemeralPublicKey;
            this.c1 = c1;
        }

        public BobEphemeralKeyAndK1Message(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 2) {
                throw new Exception();
            }
            this.remoteEphemeralPublicKey = (EncryptionPublicKey)receivedMessage.getInputs()[0].decodePublicKey();
            this.c1 = receivedMessage.getInputs()[1].decodeEncryptedData();
        }

        @Override
        public int getProtocolMessageId() {
            return 3;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.remoteEphemeralPublicKey), Encoded.of(this.c1)};
        }
    }

    public static class K2Message
    extends ConcreteProtocolMessage {
        private final EncryptedBytes c2;

        K2Message(CoreProtocolMessage coreProtocolMessage, EncryptedBytes c2) {
            super(coreProtocolMessage);
            this.c2 = c2;
        }

        public K2Message(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.c2 = receivedMessage.getInputs()[0].decodeEncryptedData();
        }

        @Override
        public int getProtocolMessageId() {
            return 4;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.c2)};
        }
    }

    public static class FirstAckMessage
    extends ConcreteProtocolMessage {
        private final String remoteSerializedIdentityWithVersionAndPhoto;

        FirstAckMessage(CoreProtocolMessage coreProtocolMessage, String remoteSerializedIdentityWithVersionAndPhoto) {
            super(coreProtocolMessage);
            this.remoteSerializedIdentityWithVersionAndPhoto = remoteSerializedIdentityWithVersionAndPhoto;
        }

        public FirstAckMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.remoteSerializedIdentityWithVersionAndPhoto = receivedMessage.getInputs()[0].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 5;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.remoteSerializedIdentityWithVersionAndPhoto)};
        }
    }

    public static class SecondAckMessage
    extends ConcreteProtocolMessage {
        private final String remoteSerializedIdentityWithVersionAndPhoto;

        SecondAckMessage(CoreProtocolMessage coreProtocolMessage, String remoteSerializedIdentityWithVersionAndPhoto) {
            super(coreProtocolMessage);
            this.remoteSerializedIdentityWithVersionAndPhoto = remoteSerializedIdentityWithVersionAndPhoto;
        }

        public SecondAckMessage(ReceivedMessage receivedMessage) throws Exception {
            super(new CoreProtocolMessage(receivedMessage));
            if (receivedMessage.getInputs().length != 1) {
                throw new Exception();
            }
            this.remoteSerializedIdentityWithVersionAndPhoto = receivedMessage.getInputs()[0].decodeString();
        }

        @Override
        public int getProtocolMessageId() {
            return 6;
        }

        @Override
        public Encoded[] getInputs() {
            return new Encoded[]{Encoded.of(this.remoteSerializedIdentityWithVersionAndPhoto)};
        }
    }

    public static class SendPingStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final InitialMessage receivedMessage;

        public SendPingStep(InitialProtocolState startState, InitialMessage receivedMessage, ChannelCreationWithOwnedDeviceProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createLocalChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UID currentDeviceUid = protocolManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            if (currentDeviceUid == null) {
                return new CancelledState();
            }
            if (Objects.equals(currentDeviceUid, this.receivedMessage.remoteDeviceUid)) {
                Logger.w("Trying to run a ChannelCreationWithOwnedDeviceProtocol with our currentDeviceUid");
                return new CancelledState();
            }
            ChannelCreationProtocolInstance channelCreationProtocolInstance = null;
            try {
                channelCreationProtocolInstance = ChannelCreationProtocolInstance.get(protocolManagerSession, this.receivedMessage.remoteDeviceUid, this.getOwnedIdentity(), this.getOwnedIdentity());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (channelCreationProtocolInstance != null) {
                channelCreationProtocolInstance.delete();
                protocolManagerSession.protocolDelegate.abortProtocol(protocolManagerSession.session, channelCreationProtocolInstance.getProtocolInstanceUid(), this.getOwnedIdentity());
            }
            protocolManagerSession.channelDelegate.deleteObliviousChannelIfItExists(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.remoteDeviceUid, this.getOwnedIdentity());
            byte[] signature = protocolManagerSession.identityDelegate.signChannel(protocolManagerSession.session, Constants.SignatureContext.CHANNEL_CREATION, this.getOwnedIdentity(), this.receivedMessage.remoteDeviceUid, this.getOwnedIdentity(), currentDeviceUid, this.getPrng());
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.getOwnedIdentity(), this.getOwnedIdentity(), new UID[]{this.receivedMessage.remoteDeviceUid}));
            ChannelProtocolMessageToSend messageToSend = new PingMessage(coreProtocolMessage, currentDeviceUid, signature).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            protocolManagerSession.identityDelegate.setLatestChannelCreationPingTimestampForOwnedDevice(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.remoteDeviceUid, System.currentTimeMillis());
            return new PingSentState();
        }
    }

    public static class SendPingOrEphemeralKeyStep
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final PingMessage receivedMessage;

        public SendPingOrEphemeralKeyStep(InitialProtocolState startState, PingMessage receivedMessage, ChannelCreationWithOwnedDeviceProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UID currentDeviceUid = protocolManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            if (currentDeviceUid == null) {
                return new CancelledState();
            }
            if (Objects.equals(currentDeviceUid, this.receivedMessage.remoteDeviceUid)) {
                Logger.w("Received a ping for a ChannelCreationWithOwnedDeviceProtocol with our currentDeviceUid");
                return new CancelledState();
            }
            boolean signatureIsValid = Signature.verify(Constants.SignatureContext.CHANNEL_CREATION, currentDeviceUid, this.receivedMessage.remoteDeviceUid, this.getOwnedIdentity(), this.getOwnedIdentity(), this.getOwnedIdentity(), this.receivedMessage.signature);
            if (!signatureIsValid) {
                return new CancelledState();
            }
            if (ChannelCreationPingSignatureReceived.exists(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature)) {
                return new CancelledState();
            }
            ChannelCreationPingSignatureReceived.create(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature);
            ChannelCreationProtocolInstance channelCreationProtocolInstance = null;
            try {
                channelCreationProtocolInstance = ChannelCreationProtocolInstance.get(protocolManagerSession, this.receivedMessage.remoteDeviceUid, this.getOwnedIdentity(), this.getOwnedIdentity());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (channelCreationProtocolInstance != null) {
                channelCreationProtocolInstance.delete();
                protocolManagerSession.protocolDelegate.abortProtocol(protocolManagerSession.session, channelCreationProtocolInstance.getProtocolInstanceUid(), this.getOwnedIdentity());
            }
            protocolManagerSession.channelDelegate.deleteObliviousChannelIfItExists(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.remoteDeviceUid, this.getOwnedIdentity());
            byte[] signature = protocolManagerSession.identityDelegate.signChannel(protocolManagerSession.session, Constants.SignatureContext.CHANNEL_CREATION, this.getOwnedIdentity(), this.receivedMessage.remoteDeviceUid, this.getOwnedIdentity(), currentDeviceUid, this.getPrng());
            int compare = currentDeviceUid.compareTo(this.receivedMessage.remoteDeviceUid);
            if (compare >= 0) {
                CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.getOwnedIdentity(), this.getOwnedIdentity(), new UID[]{this.receivedMessage.remoteDeviceUid}));
                ChannelProtocolMessageToSend messageToSend = new PingMessage(coreProtocolMessage, currentDeviceUid, signature).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                protocolManagerSession.identityDelegate.setLatestChannelCreationPingTimestampForOwnedDevice(protocolManagerSession.session, this.getOwnedIdentity(), this.receivedMessage.remoteDeviceUid, System.currentTimeMillis());
                return new PingSentState();
            }
            ChannelCreationProtocolInstance channelCreationProtocolInstance2 = ChannelCreationProtocolInstance.create(protocolManagerSession, this.receivedMessage.remoteDeviceUid, this.getOwnedIdentity(), this.getOwnedIdentity(), this.getProtocolInstanceUid());
            if (channelCreationProtocolInstance2 == null) {
                throw new Exception();
            }
            KeyPair keyPair = Suite.generateEncryptionKeyPair(this.getOwnedIdentity().getEncryptionPublicKey().getAlgorithmImplementation(), this.getPrng());
            if (keyPair == null) {
                throw new Exception();
            }
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.getOwnedIdentity(), this.getOwnedIdentity(), new UID[]{this.receivedMessage.remoteDeviceUid}));
            ChannelProtocolMessageToSend messageToSend = new AliceIdentityAndEphemeralKeyMessage(coreProtocolMessage, currentDeviceUid, signature, (EncryptionPublicKey)keyPair.getPublicKey()).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitingForK1State(this.receivedMessage.remoteDeviceUid, (EncryptionPrivateKey)keyPair.getPrivateKey());
        }
    }

    public static class SendEphemeralKeyAndK1Step
    extends ProtocolStep {
        private final InitialProtocolState startState;
        private final AliceIdentityAndEphemeralKeyMessage receivedMessage;

        public SendEphemeralKeyAndK1Step(InitialProtocolState startState, AliceIdentityAndEphemeralKeyMessage receivedMessage, ChannelCreationWithOwnedDeviceProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            UID currentDeviceUid = protocolManagerSession.identityDelegate.getCurrentDeviceUidOfOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity());
            if (currentDeviceUid == null) {
                return new CancelledState();
            }
            if (Objects.equals(currentDeviceUid, this.receivedMessage.remoteDeviceUid)) {
                Logger.w("Received a ping for a ChannelCreationWithOwnedDeviceProtocol with our currentDeviceUid");
                return new CancelledState();
            }
            boolean signatureIsValid22 = Signature.verify(Constants.SignatureContext.CHANNEL_CREATION, currentDeviceUid, this.receivedMessage.remoteDeviceUid, this.getOwnedIdentity(), this.getOwnedIdentity(), this.getOwnedIdentity(), this.receivedMessage.signature);
            if (!signatureIsValid22) {
                return new CancelledState();
            }
            if (ChannelCreationPingSignatureReceived.exists(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature)) {
                return new CancelledState();
            }
            ChannelCreationPingSignatureReceived.create(protocolManagerSession, this.getOwnedIdentity(), this.receivedMessage.signature);
            ChannelCreationProtocolInstance channelCreationProtocolInstance = null;
            try {
                channelCreationProtocolInstance = ChannelCreationProtocolInstance.get(protocolManagerSession, this.receivedMessage.remoteDeviceUid, this.getOwnedIdentity(), this.getOwnedIdentity());
            }
            catch (SQLException signatureIsValid22) {
                // empty catch block
            }
            if (channelCreationProtocolInstance != null) {
                channelCreationProtocolInstance.delete();
                protocolManagerSession.protocolDelegate.abortProtocol(protocolManagerSession.session, channelCreationProtocolInstance.getProtocolInstanceUid(), this.getOwnedIdentity());
                UID childProtocolInstanceUid = new UID(this.getPrng());
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 22, childProtocolInstanceUid);
                ChannelProtocolMessageToSend messageToSend = new InitialMessage(coreProtocolMessage, this.receivedMessage.remoteDeviceUid).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new CancelledState();
            }
            channelCreationProtocolInstance = ChannelCreationProtocolInstance.create(protocolManagerSession, this.receivedMessage.remoteDeviceUid, this.getOwnedIdentity(), this.getOwnedIdentity(), this.getProtocolInstanceUid());
            if (channelCreationProtocolInstance == null) {
                throw new Exception();
            }
            KeyPair keyPair = Suite.generateEncryptionKeyPair(this.getOwnedIdentity().getEncryptionPublicKey().getAlgorithmImplementation(), this.getPrng());
            if (keyPair == null) {
                throw new Exception();
            }
            PublicKeyEncryption publicKeyEncryption = Suite.getPublicKeyEncryption(this.receivedMessage.remoteEphemeralPublicKey);
            CiphertextAndKey ciphertextAndKey = publicKeyEncryption.kemEncrypt(this.receivedMessage.remoteEphemeralPublicKey, this.getPrng());
            AuthEncKey k1 = ciphertextAndKey.getKey();
            EncryptedBytes c1 = ciphertextAndKey.getCiphertext();
            CoreProtocolMessage coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.getOwnedIdentity(), this.getOwnedIdentity(), new UID[]{this.receivedMessage.remoteDeviceUid}));
            ChannelProtocolMessageToSend messageToSend = new BobEphemeralKeyAndK1Message(coreProtocolMessage, (EncryptionPublicKey)keyPair.getPublicKey(), c1).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitingForK2State(this.receivedMessage.remoteDeviceUid, (EncryptionPrivateKey)keyPair.getPrivateKey(), k1);
        }
    }

    public static class RecoverK1AndSendK2AndCreateChannelStep
    extends ProtocolStep {
        private final WaitingForK1State startState;
        private final BobEphemeralKeyAndK1Message receivedMessage;

        public RecoverK1AndSendK2AndCreateChannelStep(WaitingForK1State startState, BobEphemeralKeyAndK1Message receivedMessage, ChannelCreationWithOwnedDeviceProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            CoreProtocolMessage coreProtocolMessage;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            PublicKeyEncryption publicKeyEncryption = Suite.getPublicKeyEncryption(this.startState.ephemeralPrivateKey);
            AuthEncKey k1 = publicKeyEncryption.kemDecrypt(this.startState.ephemeralPrivateKey, this.receivedMessage.c1);
            if (k1 == null) {
                Logger.e("Could not recover k1.");
                return new CancelledState();
            }
            publicKeyEncryption = Suite.getPublicKeyEncryption(this.receivedMessage.remoteEphemeralPublicKey);
            CiphertextAndKey ciphertextAndKey = publicKeyEncryption.kemEncrypt(this.receivedMessage.remoteEphemeralPublicKey, this.getPrng());
            AuthEncKey k2 = ciphertextAndKey.getKey();
            EncryptedBytes c2 = ciphertextAndKey.getCiphertext();
            Seed seed = Seed.of(k1, k2);
            try {
                protocolManagerSession.identityDelegate.addDeviceForOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.remoteDeviceUid, null, null, null, null, true);
                UID protocolInstanceUid = new UID(this.getPrng());
                coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 21, protocolInstanceUid);
                ChannelProtocolMessageToSend message = new OwnedDeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.getPrng());
            }
            catch (Exception e) {
                Logger.w("Exception when adding an owned device");
            }
            if (protocolManagerSession.channelDelegate.checkIfObliviousChannelExists(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.remoteDeviceUid, this.getOwnedIdentity())) {
                UID childProtocolInstanceUid = new UID(this.getPrng());
                coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 22, childProtocolInstanceUid);
                ChannelProtocolMessageToSend messageToSend = new InitialMessage(coreProtocolMessage, this.startState.remoteDeviceUid).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new CancelledState();
            }
            protocolManagerSession.channelDelegate.createObliviousChannel(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.remoteDeviceUid, this.getOwnedIdentity(), seed, 0);
            CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createAsymmetricChannelInfo(this.getOwnedIdentity(), this.getOwnedIdentity(), new UID[]{this.startState.remoteDeviceUid}));
            ChannelProtocolMessageToSend messageToSend = new K2Message(coreProtocolMessage2, c2).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitForFirstAckState(this.startState.remoteDeviceUid);
        }
    }

    public static class RecoverK2CreateChannelAndSendAckStep
    extends ProtocolStep {
        private final WaitingForK2State startState;
        private final K2Message receivedMessage;

        public RecoverK2CreateChannelAndSendAckStep(WaitingForK2State startState, K2Message receivedMessage, ChannelCreationWithOwnedDeviceProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createAsymmetricChannelInfo(), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            CoreProtocolMessage coreProtocolMessage;
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            PublicKeyEncryption publicKeyEncryption = Suite.getPublicKeyEncryption(this.startState.ephemeralPrivateKey);
            AuthEncKey k2 = publicKeyEncryption.kemDecrypt(this.startState.ephemeralPrivateKey, this.receivedMessage.c2);
            if (k2 == null) {
                Logger.e("Could not recover k2.");
                return new CancelledState();
            }
            try {
                protocolManagerSession.identityDelegate.addDeviceForOwnedIdentity(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.remoteDeviceUid, null, null, null, null, true);
                UID protocolInstanceUid = new UID(this.getPrng());
                coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 21, protocolInstanceUid);
                ChannelProtocolMessageToSend message = new OwnedDeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.getPrng());
            }
            catch (Exception e) {
                Logger.w("Exception when adding an owned device");
            }
            if (protocolManagerSession.channelDelegate.checkIfObliviousChannelExists(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.remoteDeviceUid, this.getOwnedIdentity())) {
                UID childProtocolInstanceUid = new UID(this.getPrng());
                coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 22, childProtocolInstanceUid);
                ChannelProtocolMessageToSend messageToSend = new InitialMessage(coreProtocolMessage, this.startState.remoteDeviceUid).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                return new CancelledState();
            }
            Seed seed = Seed.of(this.startState.k1, k2);
            protocolManagerSession.channelDelegate.createObliviousChannel(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.remoteDeviceUid, this.getOwnedIdentity(), seed, 0);
            String serializedDetailsWithVersionAndPhoto = "";
            try {
                JsonIdentityDetailsWithVersionAndPhoto ownedDetailsWithVersionAndPhoto = protocolManagerSession.identityDelegate.getOwnedIdentityPublishedAndLatestDetails(protocolManagerSession.session, this.getOwnedIdentity())[0];
                serializedDetailsWithVersionAndPhoto = this.protocol.getJsonObjectMapper().writeValueAsString((Object)ownedDetailsWithVersionAndPhoto);
            }
            catch (Exception e) {
                Logger.x(e);
            }
            CoreProtocolMessage coreProtocolMessage2 = this.buildCoreProtocolMessage(SendChannelInfo.createObliviousChannelInfo(this.getOwnedIdentity(), this.getOwnedIdentity(), new UID[]{this.startState.remoteDeviceUid}, false));
            ChannelProtocolMessageToSend messageToSend = new FirstAckMessage(coreProtocolMessage2, serializedDetailsWithVersionAndPhoto).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new WaitForSecondAckState(this.startState.remoteDeviceUid);
        }
    }

    public static class ConfirmChannelAndSendAckStep
    extends ProtocolStep {
        private final WaitForFirstAckState startState;
        private final FirstAckMessage receivedMessage;

        public ConfirmChannelAndSendAckStep(WaitForFirstAckState startState, FirstAckMessage receivedMessage, ChannelCreationWithOwnedDeviceProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createObliviousChannelInfo(startState.remoteDeviceUid, protocol.ownedIdentity), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            try {
                boolean photoDownloadNeeded;
                JsonIdentityDetailsWithVersionAndPhoto ownDetailsWithVersionAndPhoto = (JsonIdentityDetailsWithVersionAndPhoto)this.protocol.getJsonObjectMapper().readValue(this.receivedMessage.remoteSerializedIdentityWithVersionAndPhoto, JsonIdentityDetailsWithVersionAndPhoto.class);
                if (ownDetailsWithVersionAndPhoto != null && (photoDownloadNeeded = protocolManagerSession.identityDelegate.setOwnedIdentityDetailsFromOtherDevice(protocolManagerSession.session, this.getOwnedIdentity(), ownDetailsWithVersionAndPhoto))) {
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 7, new UID(this.getPrng()));
                    ChannelProtocolMessageToSend messageToSend = new DownloadIdentityPhotoChildProtocol.InitialMessage(coreProtocolMessage, this.getOwnedIdentity(), this.receivedMessage.remoteSerializedIdentityWithVersionAndPhoto).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
            protocolManagerSession.channelDelegate.confirmObliviousChannel(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.remoteDeviceUid, this.getOwnedIdentity());
            UID childProtocolInstanceUid = new UID(this.getPrng());
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 16, childProtocolInstanceUid);
            ChannelProtocolMessageToSend messageToSend = new DeviceCapabilitiesDiscoveryProtocol.InitialSingleOwnedDeviceMessage(coreProtocolMessage, this.startState.remoteDeviceUid, false).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            try {
                ChannelCreationProtocolInstance channelCreationProtocolInstance = ChannelCreationProtocolInstance.get(protocolManagerSession, this.startState.remoteDeviceUid, this.getOwnedIdentity(), this.getOwnedIdentity());
                channelCreationProtocolInstance.delete();
            }
            catch (Exception e) {
                Logger.w("Exception when deleting a ChannelCreationProtocolInstance");
            }
            String serializedDetailsWithVersionAndPhoto = "";
            try {
                JsonIdentityDetailsWithVersionAndPhoto ownedDetailsWithVersionAndPhoto = protocolManagerSession.identityDelegate.getOwnedIdentityPublishedAndLatestDetails(protocolManagerSession.session, this.getOwnedIdentity())[0];
                serializedDetailsWithVersionAndPhoto = this.protocol.getJsonObjectMapper().writeValueAsString((Object)ownedDetailsWithVersionAndPhoto);
            }
            catch (Exception e) {
                Logger.x(e);
            }
            coreProtocolMessage = this.buildCoreProtocolMessage(SendChannelInfo.createObliviousChannelInfo(this.getOwnedIdentity(), this.getOwnedIdentity(), new UID[]{this.startState.remoteDeviceUid}, true));
            messageToSend = new SecondAckMessage(coreProtocolMessage, serializedDetailsWithVersionAndPhoto).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            return new ChannelConfirmedState();
        }
    }

    public static class ConfirmChannelStep
    extends ProtocolStep {
        private final WaitForSecondAckState startState;
        private final SecondAckMessage receivedMessage;

        public ConfirmChannelStep(WaitForSecondAckState startState, SecondAckMessage receivedMessage, ChannelCreationWithOwnedDeviceProtocol protocol) throws Exception {
            super(ReceptionChannelInfo.createObliviousChannelInfo(startState.remoteDeviceUid, protocol.ownedIdentity), receivedMessage, protocol);
            this.startState = startState;
            this.receivedMessage = receivedMessage;
        }

        @Override
        public ConcreteProtocolState executeStep() throws Exception {
            ProtocolManagerSession protocolManagerSession = this.getProtocolManagerSession();
            try {
                boolean photoDownloadNeeded;
                JsonIdentityDetailsWithVersionAndPhoto ownDetailsWithVersionAndPhoto = (JsonIdentityDetailsWithVersionAndPhoto)this.protocol.getJsonObjectMapper().readValue(this.receivedMessage.remoteSerializedIdentityWithVersionAndPhoto, JsonIdentityDetailsWithVersionAndPhoto.class);
                if (ownDetailsWithVersionAndPhoto != null && (photoDownloadNeeded = protocolManagerSession.identityDelegate.setOwnedIdentityDetailsFromOtherDevice(protocolManagerSession.session, this.getOwnedIdentity(), ownDetailsWithVersionAndPhoto))) {
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 7, new UID(this.getPrng()));
                    ChannelProtocolMessageToSend messageToSend = new DownloadIdentityPhotoChildProtocol.InitialMessage(coreProtocolMessage, this.getOwnedIdentity(), this.receivedMessage.remoteSerializedIdentityWithVersionAndPhoto).generateChannelProtocolMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
            protocolManagerSession.channelDelegate.confirmObliviousChannel(protocolManagerSession.session, this.getOwnedIdentity(), this.startState.remoteDeviceUid, this.getOwnedIdentity());
            UID childProtocolInstanceUid = new UID(this.getPrng());
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(this.getOwnedIdentity()), 16, childProtocolInstanceUid);
            ChannelProtocolMessageToSend messageToSend = new DeviceCapabilitiesDiscoveryProtocol.InitialSingleOwnedDeviceMessage(coreProtocolMessage, this.startState.remoteDeviceUid, false).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.getPrng());
            try {
                ChannelCreationProtocolInstance channelCreationProtocolInstance = ChannelCreationProtocolInstance.get(protocolManagerSession, this.startState.remoteDeviceUid, this.getOwnedIdentity(), this.getOwnedIdentity());
                channelCreationProtocolInstance.delete();
            }
            catch (Exception e) {
                Logger.w("Exception when deleting a ChannelCreationProtocolInstance");
            }
            return new ChannelConfirmedState();
        }
    }
}

