/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.protocol_engine;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.databases.ProtocolInstance;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ConcreteProtocolState;
import io.olvid.engine.protocol.protocol_engine.ProtocolStep;
import io.olvid.engine.protocol.protocols.ChannelCreationWithContactDeviceProtocol;
import io.olvid.engine.protocol.protocols.ChannelCreationWithOwnedDeviceProtocol;
import io.olvid.engine.protocol.protocols.ContactManagementProtocol;
import io.olvid.engine.protocol.protocols.ContactMutualIntroductionProtocol;
import io.olvid.engine.protocol.protocols.DeviceCapabilitiesDiscoveryProtocol;
import io.olvid.engine.protocol.protocols.DeviceDiscoveryChildProtocol;
import io.olvid.engine.protocol.protocols.DeviceDiscoveryProtocol;
import io.olvid.engine.protocol.protocols.DownloadGroupPhotoChildProtocol;
import io.olvid.engine.protocol.protocols.DownloadGroupV2PhotoProtocol;
import io.olvid.engine.protocol.protocols.DownloadIdentityPhotoChildProtocol;
import io.olvid.engine.protocol.protocols.FullRatchetProtocol;
import io.olvid.engine.protocol.protocols.GroupInvitationProtocol;
import io.olvid.engine.protocol.protocols.GroupManagementProtocol;
import io.olvid.engine.protocol.protocols.GroupsV2Protocol;
import io.olvid.engine.protocol.protocols.IdentityDetailsPublicationProtocol;
import io.olvid.engine.protocol.protocols.KeycloakBindingAndUnbindingProtocol;
import io.olvid.engine.protocol.protocols.KeycloakContactAdditionProtocol;
import io.olvid.engine.protocol.protocols.OneToOneContactInvitationProtocol;
import io.olvid.engine.protocol.protocols.OwnedDeviceDiscoveryProtocol;
import io.olvid.engine.protocol.protocols.OwnedDeviceManagementProtocol;
import io.olvid.engine.protocol.protocols.OwnedIdentityDeletionProtocol;
import io.olvid.engine.protocol.protocols.OwnedIdentityTransferProtocol;
import io.olvid.engine.protocol.protocols.SynchronizationProtocol;
import io.olvid.engine.protocol.protocols.TrustEstablishmentWithMutualScanProtocol;
import io.olvid.engine.protocol.protocols.TrustEstablishmentWithSasProtocol;
import java.lang.reflect.Constructor;

public abstract class ConcreteProtocol {
    public static final int INITIAL_STATE_ID = 0;
    public static final int DEVICE_DISCOVERY_PROTOCOL_ID = 0;
    public static final int TRUST_ESTABLISHMENT_PROTOCOL_ID = 1;
    public static final int CHANNEL_CREATION_WITH_CONTACT_DEVICE_PROTOCOL_ID = 2;
    public static final int DEVICE_DISCOVERY_CHILD_PROTOCOL_ID = 3;
    public static final int CONTACT_MUTUAL_INTRODUCTION_PROTOCOL_ID = 4;
    public static final int GROUP_CREATION_PROTOCOL_ID = 5;
    public static final int IDENTITY_DETAILS_PUBLICATION_PROTOCOL_ID = 6;
    public static final int DOWNLOAD_IDENTITY_PHOTO_CHILD_PROTOCOL_ID = 7;
    public static final int GROUP_INVITATION_PROTOCOL_ID = 8;
    public static final int GROUP_MANAGEMENT_PROTOCOL_ID = 9;
    public static final int CONTACT_MANAGEMENT_PROTOCOL_ID = 10;
    public static final int TRUST_ESTABLISHMENT_WITH_SAS_PROTOCOL_ID = 11;
    public static final int TRUST_ESTABLISHMENT_WITH_MUTUAL_SCAN_PROTOCOL_ID = 12;
    public static final int FULL_RATCHET_PROTOCOL_ID = 13;
    public static final int DOWNLOAD_GROUP_PHOTO_CHILD_PROTOCOL_ID = 14;
    public static final int KEYCLOAK_CONTACT_ADDITION_PROTOCOL_ID = 15;
    public static final int DEVICE_CAPABILITIES_DISCOVERY_PROTOCOL_ID = 16;
    public static final int ONE_TO_ONE_CONTACT_INVITATION_PROTOCOL_ID = 17;
    public static final int GROUPS_V2_PROTOCOL_ID = 18;
    public static final int DOWNLOAD_GROUPS_V2_PHOTO_PROTOCOL_ID = 19;
    public static final int OWNED_IDENTITY_DELETION_PROTOCOL_ID = 20;
    public static final int OWNED_DEVICE_DISCOVERY_PROTOCOL_ID = 21;
    public static final int CHANNEL_CREATION_WITH_OWNED_DEVICE_PROTOCOL_ID = 22;
    public static final int KEYCLOAK_BINDING_AND_UNBINDING_PROTOCOL_ID = 23;
    public static final int OWNED_DEVICE_MANAGEMENT_PROTOCOL_ID = 24;
    public static final int SYNCHRONIZATION_PROTOCOL_ID = 25;
    public static final int OWNED_IDENTITY_TRANSFER_PROTOCOL_ID = 26;
    public static final int LEGACY_KEYCLOAK_BINDING_AND_UNBINDING_PROTOCOL_ID = 1000;
    protected final ProtocolManagerSession protocolManagerSession;
    protected final UID protocolInstanceUid;
    protected final Identity ownedIdentity;
    protected final PRNGService prng;
    protected final ObjectMapper jsonObjectMapper;
    protected ConcreteProtocolState currentState;
    public boolean eraseReceivedMessagesAfterReachingAFinalState = true;
    public boolean mayBeRunAsLinkedChildProtocol = false;
    public boolean requiresProtocolInstanceToBeInsertedBeforeInitialStep = false;

    public UID getProtocolInstanceUid() {
        return this.protocolInstanceUid;
    }

    public ConcreteProtocolState getCurrentState() {
        return this.currentState;
    }

    public void updateCurrentState(ConcreteProtocolState newState) {
        this.currentState = newState;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public ProtocolManagerSession getProtocolManagerSession() {
        return this.protocolManagerSession;
    }

    public PRNGService getPrng() {
        return this.prng;
    }

    public ObjectMapper getJsonObjectMapper() {
        return this.jsonObjectMapper;
    }

    public ConcreteProtocol(ProtocolManagerSession protocolManagerSession, UID protocolInstanceUid, int currentStateId, Encoded encodedCurrentState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        this.protocolManagerSession = protocolManagerSession;
        this.protocolInstanceUid = protocolInstanceUid;
        this.ownedIdentity = ownedIdentity;
        this.prng = prng;
        this.jsonObjectMapper = jsonObjectMapper;
        this.currentState = this.getProtocolState(this.getStateClass(currentStateId), encodedCurrentState);
    }

    public static ConcreteProtocol getConcreteProtocol(ProtocolInstance protocolInstance, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        if (protocolInstance == null) {
            return null;
        }
        ProtocolManagerSession protocolManagerSession = protocolInstance.getProtocolManagerSession();
        int protocolId = protocolInstance.getProtocolId();
        UID protocolInstanceUid = protocolInstance.getUid();
        int currentStateId = protocolInstance.getCurrentStateId();
        Encoded encodedCurrentState = protocolInstance.getEncodedCurrentState();
        Identity ownedIdentity = protocolInstance.getOwnedIdentity();
        return ConcreteProtocol.getConcreteProtocol(protocolManagerSession, protocolId, protocolInstanceUid, currentStateId, encodedCurrentState, ownedIdentity, prng, jsonObjectMapper);
    }

    public static ConcreteProtocol getConcreteProtocolInInitialState(ProtocolManagerSession protocolManagerSession, int protocolId, UID protocolInstanceUid, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        return ConcreteProtocol.getConcreteProtocol(protocolManagerSession, protocolId, protocolInstanceUid, 0, Encoded.of(new Encoded[0]), ownedIdentity, prng, jsonObjectMapper);
    }

    private static ConcreteProtocol getConcreteProtocol(ProtocolManagerSession protocolManagerSession, int protocolId, UID protocolInstanceUid, int stateId, Encoded encodedState, Identity ownedIdentity, PRNGService prng, ObjectMapper jsonObjectMapper) throws Exception {
        switch (protocolId) {
            case 0: {
                return new DeviceDiscoveryProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 2: {
                return new ChannelCreationWithContactDeviceProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 3: {
                return new DeviceDiscoveryChildProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 4: {
                return new ContactMutualIntroductionProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 6: {
                return new IdentityDetailsPublicationProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 7: {
                return new DownloadIdentityPhotoChildProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 8: {
                return new GroupInvitationProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 9: {
                return new GroupManagementProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 10: {
                return new ContactManagementProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 11: {
                return new TrustEstablishmentWithSasProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 12: {
                return new TrustEstablishmentWithMutualScanProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 13: {
                return new FullRatchetProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 14: {
                return new DownloadGroupPhotoChildProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 15: {
                return new KeycloakContactAdditionProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 16: {
                return new DeviceCapabilitiesDiscoveryProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 23: 
            case 1000: {
                return new KeycloakBindingAndUnbindingProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 17: {
                return new OneToOneContactInvitationProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 18: {
                return new GroupsV2Protocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 19: {
                return new DownloadGroupV2PhotoProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 20: {
                return new OwnedIdentityDeletionProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 21: {
                return new OwnedDeviceDiscoveryProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 22: {
                return new ChannelCreationWithOwnedDeviceProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 24: {
                return new OwnedDeviceManagementProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 25: {
                return new SynchronizationProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
            case 26: {
                return new OwnedIdentityTransferProtocol(protocolManagerSession, protocolInstanceUid, stateId, encodedState, ownedIdentity, prng, jsonObjectMapper);
            }
        }
        Logger.w("Unknown protocol id: " + protocolId);
        return null;
    }

    public static long getProtocolPriority(int protocolId) {
        switch (protocolId) {
            case 0: {
                return 599L;
            }
            case 2: {
                return 300L;
            }
            case 3: {
                return 600L;
            }
            case 4: {
                return 13L;
            }
            case 6: {
                return 150L;
            }
            case 7: {
                return 200L;
            }
            case 8: {
                return 101L;
            }
            case 9: {
                return 102L;
            }
            case 10: {
                return 12L;
            }
            case 11: {
                return 9L;
            }
            case 12: {
                return 8L;
            }
            case 13: {
                return 1023L;
            }
            case 14: {
                return 202L;
            }
            case 15: {
                return 11L;
            }
            case 16: {
                return 500L;
            }
            case 23: 
            case 1000: {
                return 5L;
            }
            case 17: {
                return 10L;
            }
            case 18: {
                return 100L;
            }
            case 19: {
                return 201L;
            }
            case 20: {
                return 1L;
            }
            case 21: {
                return 50L;
            }
            case 22: {
                return 51L;
            }
            case 24: {
                return 20L;
            }
            case 25: {
                return 900L;
            }
            case 26: {
                return 0L;
            }
        }
        throw new RuntimeException("Unknown protocol type!!!");
    }

    public abstract int getProtocolId();

    protected abstract Class<?> getStateClass(int var1);

    protected final ConcreteProtocolState getProtocolState(Class<?> currentState, Encoded encodedCurrentState) throws Exception {
        Constructor<?> constructor = currentState.getConstructor(Encoded.class);
        return (ConcreteProtocolState)constructor.newInstance(encodedCurrentState);
    }

    public abstract int[] getFinalStateIds();

    public final boolean hasReachedFinalState() {
        for (int finalStateId : this.getFinalStateIds()) {
            if (this.currentState.id != finalStateId) continue;
            return true;
        }
        return false;
    }

    protected abstract Class<?> getMessageClass(int var1);

    public final ConcreteProtocolMessage getConcreteProtocolMessage(ReceivedMessage receivedMessage) {
        try {
            Class<?> messageClass = this.getMessageClass(receivedMessage.getProtocolMessageId());
            if (messageClass == null) {
                return null;
            }
            Constructor<?> constructor = messageClass.getConstructor(ReceivedMessage.class);
            return (ConcreteProtocolMessage)constructor.newInstance(receivedMessage);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    protected abstract Class<?>[] getPossibleStepClasses(int var1);

    public final ProtocolStep getStepToExecute(ConcreteProtocolMessage concreteProtocolMessage) {
        try {
            Class<?>[] classes;
            int matches = 0;
            Constructor<?> constructor = null;
            for (Class<?> clazz : classes = this.getPossibleStepClasses(this.currentState.id)) {
                try {
                    constructor = clazz.getConstructor(this.currentState.getClass(), concreteProtocolMessage.getClass(), this.getClass());
                    ++matches;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (matches != 1) {
                Logger.d("Found " + matches + " protocolStep to execute in " + String.valueOf(this.getClass()) + " for state " + String.valueOf(this.currentState.getClass()) + " and message " + String.valueOf(concreteProtocolMessage.getClass()));
                return null;
            }
            return (ProtocolStep)constructor.newInstance(this.currentState, concreteProtocolMessage, this);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }
}

