/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.datatypes;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ProtocolReceivedDialogResponse;
import io.olvid.engine.datatypes.containers.ProtocolReceivedMessage;
import io.olvid.engine.datatypes.containers.ProtocolReceivedServerResponse;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.UUID;

public class GenericReceivedProtocolMessage {
    private final Identity toIdentity;
    private final Encoded[] inputs;
    private final UUID userDialogUuid;
    private final Encoded encodedResponse;
    private final UID protocolInstanceUid;
    private final int protocolMessageId;
    private final int protocolId;
    private final ReceptionChannelInfo receptionChannelInfo;
    private final long serverTimestamp;

    public Identity getToIdentity() {
        return this.toIdentity;
    }

    public Encoded[] getInputs() {
        return this.inputs;
    }

    public Encoded getEncodedResponse() {
        return this.encodedResponse;
    }

    public UID getProtocolInstanceUid() {
        return this.protocolInstanceUid;
    }

    public int getProtocolMessageId() {
        return this.protocolMessageId;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public ReceptionChannelInfo getReceptionChannelInfo() {
        return this.receptionChannelInfo;
    }

    public UUID getUserDialogUuid() {
        return this.userDialogUuid;
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }

    private GenericReceivedProtocolMessage(Identity toIdentity, Encoded[] inputs, UUID userDialogUuid, Encoded encodedResponse, UID protocolInstanceUid, int protocolMessageId, int protocolId, ReceptionChannelInfo receptionChannelInfo, long serverTimestamp) {
        this.toIdentity = toIdentity;
        this.inputs = inputs;
        this.userDialogUuid = userDialogUuid;
        this.encodedResponse = encodedResponse;
        this.protocolInstanceUid = protocolInstanceUid;
        this.protocolMessageId = protocolMessageId;
        this.protocolId = protocolId;
        this.receptionChannelInfo = receptionChannelInfo;
        this.serverTimestamp = serverTimestamp;
    }

    public static GenericReceivedProtocolMessage of(ProtocolReceivedMessage protocolReceivedMessage) {
        try {
            Encoded[] listOfEncoded = protocolReceivedMessage.getEncodedElements().decodeList();
            if (listOfEncoded.length != 4) {
                return null;
            }
            int protocolId = (int)listOfEncoded[0].decodeLong();
            UID protocolInstanceUid = listOfEncoded[1].decodeUid();
            int protocolMessageId = (int)listOfEncoded[2].decodeLong();
            Encoded[] inputs = listOfEncoded[3].decodeList();
            return new GenericReceivedProtocolMessage(protocolReceivedMessage.getOwnedIdentity(), inputs, null, null, protocolInstanceUid, protocolMessageId, protocolId, protocolReceivedMessage.getReceptionChannelInfo(), protocolReceivedMessage.getServerTimestamp());
        }
        catch (DecodingException e) {
            return null;
        }
    }

    public static GenericReceivedProtocolMessage of(ProtocolReceivedDialogResponse protocolReceivedDialogResponse) {
        try {
            Encoded[] listOfEncoded = protocolReceivedDialogResponse.getEncodedElements().decodeList();
            if (listOfEncoded.length != 4) {
                return null;
            }
            int protocolId = (int)listOfEncoded[0].decodeLong();
            UID protocolInstanceUid = listOfEncoded[1].decodeUid();
            int protocolMessageId = (int)listOfEncoded[2].decodeLong();
            Encoded[] inputs = listOfEncoded[3].decodeList();
            return new GenericReceivedProtocolMessage(protocolReceivedDialogResponse.getToIdentity(), inputs, protocolReceivedDialogResponse.getUserDialogUuid(), protocolReceivedDialogResponse.getUserDialogResponse(), protocolInstanceUid, protocolMessageId, protocolId, protocolReceivedDialogResponse.getReceptionChannelInfo(), 0L);
        }
        catch (DecodingException e) {
            return null;
        }
    }

    public static GenericReceivedProtocolMessage of(ProtocolReceivedServerResponse protocolReceivedServerResponse) {
        try {
            Encoded[] listOfEncoded = protocolReceivedServerResponse.getEncodedElements().decodeList();
            if (listOfEncoded.length != 4) {
                return null;
            }
            int protocolId = (int)listOfEncoded[0].decodeLong();
            UID protocolInstanceUid = listOfEncoded[1].decodeUid();
            int protocolMessageId = (int)listOfEncoded[2].decodeLong();
            Encoded[] inputs = listOfEncoded[3].decodeList();
            return new GenericReceivedProtocolMessage(protocolReceivedServerResponse.getToIdentity(), inputs, null, protocolReceivedServerResponse.getServerResponse(), protocolInstanceUid, protocolMessageId, protocolId, protocolReceivedServerResponse.getReceptionChannelInfo(), 0L);
        }
        catch (DecodingException e) {
            return null;
        }
    }
}

