/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.datatypes;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.protocol.databases.ReceivedMessage;

public class CoreProtocolMessage {
    private final SendChannelInfo sendChannelInfo;
    private final ReceptionChannelInfo receptionChannelInfo;
    private final Identity toIdentity;
    private final int protocolId;
    private final UID protocolInstanceUid;
    private final boolean hasUserContent;
    private final long serverTimestamp;

    public CoreProtocolMessage(ReceivedMessage message) {
        this.sendChannelInfo = null;
        this.receptionChannelInfo = message.getReceptionChannelInfo();
        this.toIdentity = message.getToIdentity();
        this.protocolId = message.getProtocolId();
        this.protocolInstanceUid = message.getProtocolInstanceUid();
        this.hasUserContent = false;
        this.serverTimestamp = message.getServerTimestamp();
    }

    public CoreProtocolMessage(SendChannelInfo sendChannelInfo, int protocolId, UID protocolInstanceUid) {
        this.sendChannelInfo = sendChannelInfo;
        this.receptionChannelInfo = null;
        this.toIdentity = null;
        this.protocolId = protocolId;
        this.protocolInstanceUid = protocolInstanceUid;
        this.hasUserContent = false;
        this.serverTimestamp = System.currentTimeMillis();
    }

    public CoreProtocolMessage(SendChannelInfo sendChannelInfo, int protocolId, UID protocolInstanceUid, boolean hasUserContent) {
        this.sendChannelInfo = sendChannelInfo;
        this.receptionChannelInfo = null;
        this.toIdentity = null;
        this.protocolId = protocolId;
        this.protocolInstanceUid = protocolInstanceUid;
        this.hasUserContent = hasUserContent;
        this.serverTimestamp = System.currentTimeMillis();
    }

    public SendChannelInfo getSendChannelInfo() {
        return this.sendChannelInfo;
    }

    public ReceptionChannelInfo getReceptionChannelInfo() {
        return this.receptionChannelInfo;
    }

    public Identity getToIdentity() {
        return this.toIdentity;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public UID getProtocolInstanceUid() {
        return this.protocolInstanceUid;
    }

    public boolean hasUserContent() {
        return this.hasUserContent;
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }
}

