/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.protocol.datatypes.GenericProtocolMessageToSend;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class WaitingForOneToOneContactProtocolInstance
implements ObvDatabase {
    static final String TABLE_NAME = "waiting_for_one_to_one_contact_protocol_instance";
    private final ProtocolManagerSession protocolManagerSession;
    private final UID protocolUid;
    static final String PROTOCOL_UID = "protocol_uid";
    private final Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private final Identity contactIdentity;
    static final String CONTACT_IDENTITY = "contact_identity";
    private final int protocolId;
    static final String PROTOCOL_ID = "protocol_id";
    private final int messageId;
    static final String MESSAGE_ID = "message_id";

    public UID getProtocolUid() {
        return this.protocolUid;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public Identity getContactIdentity() {
        return this.contactIdentity;
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS waiting_for_one_to_one_contact_protocol_instance (protocol_uid BLOB NOT NULL, owned_identity BLOB NOT NULL, contact_identity BLOB NOT NULL, protocol_id INTEGER NOT NULL, message_id INTEGER NOT NULL,  CONSTRAINT PK_waiting_for_one_to_one_contact_protocol_instance PRIMARY KEY(protocol_uid, owned_identity, contact_identity),  FOREIGN KEY (protocol_uid, owned_identity) REFERENCES protocol_instance(uid, owned_identity) ON DELETE CASCADE);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 11 && newVersion >= 11) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `waiting_for_trust_level_increase_protocol_instance` DATABASE FROM VERSION " + oldVersion + " TO 11");
                statement.execute("CREATE TABLE IF NOT EXISTS `waiting_for_trust_level_increase_protocol_instance` (protocol_uid BLOB NOT NULL, owned_identity BLOB NOT NULL, contact_identity BLOB NOT NULL, protocol_id INTEGER NOT NULL, message_id INTEGER NOT NULL, target_trust_level TEXT NOT NULL,  CONSTRAINT PK_waiting_for_trust_level_increase_protocol_instance PRIMARY KEY(protocol_uid, owned_identity, contact_identity),  FOREIGN KEY (protocol_uid, owned_identity) REFERENCES protocol_instance(uid, owned_identity) ON DELETE CASCADE);");
                statement.execute("DELETE FROM waiting_for_trust_level_increase_protocol_instance WHERE protocol_id = 5;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 11;
        }
        if (oldVersion < 12 && newVersion >= 12) {
            statement = session.createStatement();
            try {
                statement.execute("DELETE FROM waiting_for_trust_level_increase_protocol_instance AS p  WHERE NOT EXISTS ( SELECT 1 FROM protocol_instance  WHERE uid = p.protocol_uid AND owned_identity = p.owned_identity )");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 12;
        }
        if (oldVersion < 28 && newVersion >= 28) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `waiting_for_trust_level_increase_protocol_instance` TABLE FROM VERSION " + oldVersion + " TO 28");
                statement.execute("ALTER TABLE waiting_for_trust_level_increase_protocol_instance DROP COLUMN target_trust_level");
                statement.execute("ALTER TABLE waiting_for_trust_level_increase_protocol_instance RENAME TO waiting_for_one_to_one_contact_protocol_instance");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("WaitingForOneToOneContactProtocolInstance.insert", "INSERT INTO waiting_for_one_to_one_contact_protocol_instance VALUES (?,?,?,?,?);");){
            statement.setBytes(1, this.protocolUid.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.contactIdentity.getBytes());
            statement.setInt(4, this.protocolId);
            statement.setInt(5, this.messageId);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("WaitingForOneToOneContactProtocolInstance.delete", "DELETE FROM waiting_for_one_to_one_contact_protocol_instance WHERE protocol_uid = ?  AND owned_identity = ?  AND contact_identity = ?;");){
            statement.setBytes(1, this.protocolUid.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.contactIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public static WaitingForOneToOneContactProtocolInstance create(ProtocolManagerSession protocolManagerSession, UID protocolUid, Identity ownedIdentity, Identity contactIdentity, int protocolId, int messageId) {
        if (protocolUid == null || ownedIdentity == null || contactIdentity == null) {
            return null;
        }
        try {
            WaitingForOneToOneContactProtocolInstance instance = new WaitingForOneToOneContactProtocolInstance(protocolManagerSession, protocolUid, ownedIdentity, contactIdentity, protocolId, messageId);
            instance.insert();
            return instance;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private WaitingForOneToOneContactProtocolInstance(ProtocolManagerSession protocolManagerSession, UID protocolUid, Identity ownedIdentity, Identity contactIdentity, int protocolId, int messageId) {
        this.protocolManagerSession = protocolManagerSession;
        this.protocolUid = protocolUid;
        this.ownedIdentity = ownedIdentity;
        this.contactIdentity = contactIdentity;
        this.protocolId = protocolId;
        this.messageId = messageId;
    }

    private WaitingForOneToOneContactProtocolInstance(ProtocolManagerSession protocolManagerSession, ResultSet res) throws SQLException {
        this.protocolManagerSession = protocolManagerSession;
        this.protocolUid = new UID(res.getBytes(PROTOCOL_UID));
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
            this.contactIdentity = Identity.of(res.getBytes(CONTACT_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.protocolId = res.getInt(PROTOCOL_ID);
        this.messageId = res.getInt(MESSAGE_ID);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static WaitingForOneToOneContactProtocolInstance get(ProtocolManagerSession protocolManagerSession, UID protocolUid, Identity ownedIdentity, Identity contactIdentity) {
        if (protocolUid == null || ownedIdentity == null || contactIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("WaitingForOneToOneContactProtocolInstance.get", "SELECT * FROM waiting_for_one_to_one_contact_protocol_instance WHERE protocol_uid = ?  AND owned_identity = ?  AND contact_identity = ?;");){
            WaitingForOneToOneContactProtocolInstance waitingForOneToOneContactProtocolInstance;
            block19: {
                ResultSet res;
                block17: {
                    WaitingForOneToOneContactProtocolInstance waitingForOneToOneContactProtocolInstance2;
                    block18: {
                        statement.setBytes(1, protocolUid.getBytes());
                        statement.setBytes(2, ownedIdentity.getBytes());
                        statement.setBytes(3, contactIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block17;
                            waitingForOneToOneContactProtocolInstance2 = new WaitingForOneToOneContactProtocolInstance(protocolManagerSession, res);
                            if (res == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return waitingForOneToOneContactProtocolInstance2;
                }
                waitingForOneToOneContactProtocolInstance = null;
                if (res == null) break block19;
                res.close();
            }
            return waitingForOneToOneContactProtocolInstance;
        }
        catch (SQLException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static WaitingForOneToOneContactProtocolInstance[] getAllForContact(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity, Identity contactIdentity) {
        if (ownedIdentity == null || contactIdentity == null) {
            return new WaitingForOneToOneContactProtocolInstance[0];
        }
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("WaitingForOneToOneContactProtocolInstance.getAllForContact", "SELECT * FROM waiting_for_one_to_one_contact_protocol_instance WHERE owned_identity = ?  AND contact_identity = ?;");){
            WaitingForOneToOneContactProtocolInstance[] waitingForOneToOneContactProtocolInstanceArray;
            block16: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, contactIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<WaitingForOneToOneContactProtocolInstance> list = new ArrayList<WaitingForOneToOneContactProtocolInstance>();
                    while (res.next()) {
                        list.add(new WaitingForOneToOneContactProtocolInstance(protocolManagerSession, res));
                    }
                    waitingForOneToOneContactProtocolInstanceArray = list.toArray(new WaitingForOneToOneContactProtocolInstance[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return waitingForOneToOneContactProtocolInstanceArray;
        }
        catch (SQLException e) {
            return new WaitingForOneToOneContactProtocolInstance[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static WaitingForOneToOneContactProtocolInstance[] getAll(ProtocolManagerSession protocolManagerSession) {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("WaitingForOneToOneContactProtocolInstance.getAll", "SELECT * FROM waiting_for_one_to_one_contact_protocol_instance;");){
            WaitingForOneToOneContactProtocolInstance[] waitingForOneToOneContactProtocolInstanceArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<WaitingForOneToOneContactProtocolInstance> list = new ArrayList<WaitingForOneToOneContactProtocolInstance>();
                    while (res.next()) {
                        list.add(new WaitingForOneToOneContactProtocolInstance(protocolManagerSession, res));
                    }
                    waitingForOneToOneContactProtocolInstanceArray = list.toArray(new WaitingForOneToOneContactProtocolInstance[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return waitingForOneToOneContactProtocolInstanceArray;
        }
        catch (SQLException e) {
            return new WaitingForOneToOneContactProtocolInstance[0];
        }
    }

    public GenericProtocolMessageToSend getGenericProtocolMessageToSendWhenTrustLevelIncreased() {
        return new GenericProtocolMessageToSend(SendChannelInfo.createLocalChannelInfo(this.ownedIdentity), this.protocolId, this.protocolUid, this.messageId, new Encoded[]{Encoded.of(this.contactIdentity)}, false);
    }

    public static void deleteAllForOwnedIdentity(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("WaitingForOneToOneContactProtocolInstance.deleteAllForOwnedIdentity", "DELETE FROM waiting_for_one_to_one_contact_protocol_instance WHERE owned_identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }
}

