/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class MutualScanSignatureReceived
implements ObvDatabase {
    static final String TABLE_NAME = "mutual_scan_signature_received";
    private final ProtocolManagerSession protocolManagerSession;
    private final Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private final byte[] signature;
    static final String SIGNATURE = "signature";

    public static MutualScanSignatureReceived create(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity, byte[] signature) {
        if (ownedIdentity == null || signature == null) {
            return null;
        }
        try {
            MutualScanSignatureReceived mutualScanSignatureReceived = new MutualScanSignatureReceived(protocolManagerSession, ownedIdentity, signature);
            mutualScanSignatureReceived.insert();
            return mutualScanSignatureReceived;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private MutualScanSignatureReceived(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity, byte[] signature) {
        this.protocolManagerSession = protocolManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.signature = signature;
    }

    private MutualScanSignatureReceived(ProtocolManagerSession protocolManagerSession, ResultSet res) throws SQLException {
        this.protocolManagerSession = protocolManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.signature = res.getBytes(SIGNATURE);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS mutual_scan_signature_received (owned_identity BLOB NOT NULL, signature BLOB NOT NULL, CONSTRAINT PK_mutual_scan_signature_received PRIMARY KEY (owned_identity, signature));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 23 && newVersion >= 23) {
            Logger.d("CREATING `mutual_scan_signature_received` TABLE AS PART OF VERSION 23");
            try (Statement statement = session.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS mutual_scan_signature_received ( owned_identity BLOB NOT NULL,  signature BLOB NOT NULL, CONSTRAINT PK_mutual_scan_signature_received PRIMARY KEY (owned_identity, signature));");
            }
            oldVersion = 23;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("MutualScanSignatureReceived.insert", "INSERT INTO mutual_scan_signature_received VALUES (?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.signature);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("MutualScanSignatureReceived.delete", "DELETE FROM mutual_scan_signature_received WHERE owned_identity = ? AND signature = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.signature);
            statement.executeUpdate();
        }
    }

    public static boolean exists(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity, byte[] commitment) throws SQLException {
        if (ownedIdentity == null || commitment == null) {
            return false;
        }
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("MutualScanSignatureReceived.exists", "SELECT 1 FROM mutual_scan_signature_received WHERE owned_identity = ? AND signature = ?;");){
            boolean bl;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, commitment);
                ResultSet res = statement.executeQuery();
                try {
                    bl = res.next();
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return bl;
        }
    }

    public static void deleteAllForOwnedIdentity(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("MutualScanSignatureReceived.deleteAllForOwnedIdentity", "DELETE FROM mutual_scan_signature_received WHERE owned_identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }
}

