/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ChannelCreationPingSignatureReceived
implements ObvDatabase {
    static final String TABLE_NAME = "channel_creation_ping_signature_received";
    private final ProtocolManagerSession protocolManagerSession;
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private byte[] signature;
    static final String SIGNATURE = "signature";

    public static ChannelCreationPingSignatureReceived create(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity, byte[] signature) {
        if (ownedIdentity == null || signature == null) {
            return null;
        }
        try {
            ChannelCreationPingSignatureReceived channelCreationPingSignatureReceived = new ChannelCreationPingSignatureReceived(protocolManagerSession, ownedIdentity, signature);
            channelCreationPingSignatureReceived.insert();
            return channelCreationPingSignatureReceived;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    public ChannelCreationPingSignatureReceived(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity, byte[] signature) {
        this.protocolManagerSession = protocolManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.signature = signature;
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS channel_creation_ping_signature_received (owned_identity BLOB NOT NULL, signature BLOB NOT NULL, CONSTRAINT PK_channel_creation_ping_signature_received PRIMARY KEY (owned_identity, signature));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 30 && newVersion >= 30) {
            try (Statement statement = session.createStatement();){
                Logger.d("MIGRATING channel_creation_ping_signature_received DATABASE FROM VERSION " + oldVersion + " TO 30");
                statement.execute("ALTER TABLE channel_creation_ping_signature_received RENAME TO channel_creation_ping_signature_received_old");
                statement.execute("CREATE TABLE channel_creation_ping_signature_received ( owned_identity BLOB NOT NULL,  signature BLOB NOT NULL,  CONSTRAINT PK_channel_creation_ping_signature_received PRIMARY KEY (owned_identity, signature))");
                statement.execute("INSERT INTO channel_creation_ping_signature_received SELECT owned_identity, signature FROM channel_creation_ping_signature_received_old");
                statement.execute("DROP TABLE channel_creation_ping_signature_received_old");
            }
            oldVersion = 30;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("ChannelCreationPingSignatureReceived.insert", "INSERT INTO channel_creation_ping_signature_received VALUES (?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.signature);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.protocolManagerSession.session.prepareStatement("ChannelCreationPingSignatureReceived.delete", "DELETE FROM channel_creation_ping_signature_received WHERE owned_identity = ? AND signature = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.signature);
            statement.executeUpdate();
        }
    }

    public static boolean exists(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity, byte[] signature) throws SQLException {
        if (ownedIdentity == null || signature == null) {
            return false;
        }
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ChannelCreationPingSignatureReceived.exists", "SELECT 1 FROM channel_creation_ping_signature_received WHERE owned_identity = ? AND signature = ?;");){
            boolean bl;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, signature);
                ResultSet res = statement.executeQuery();
                try {
                    bl = res.next();
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return bl;
        }
    }

    public static void deleteAllForOwnedIdentity(ProtocolManagerSession protocolManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = protocolManagerSession.session.prepareStatement("ChannelCreationPingSignatureReceived.deleteAllForOwnedIdentity", "DELETE FROM channel_creation_ping_signature_received WHERE owned_identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }
}

