/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol.coordinators;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicatePriorityOperationQueue;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.DialogType;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSessionFactory;
import io.olvid.engine.protocol.datatypes.ProtocolReceivedMessageProcessorDelegate;
import io.olvid.engine.protocol.protocol_engine.OneWayDialogProtocolMessage;
import io.olvid.engine.protocol.protocol_engine.ProtocolOperation;
import java.sql.SQLException;
import java.util.HashMap;

public class ProtocolStepCoordinator
implements ProtocolReceivedMessageProcessorDelegate,
Operation.OnFinishCallback,
Operation.OnCancelCallback {
    private final ProtocolManagerSessionFactory protocolManagerSessionFactory;
    private final PRNGService prng;
    private final ObjectMapper jsonObjectMapper;
    private final NoDuplicatePriorityOperationQueue protocolOperationQueue;
    private final HashMap<UID, Integer> stepFailedAttemptCount;

    public ProtocolStepCoordinator(ProtocolManagerSessionFactory protocolManagerSessionFactory, PRNGService prng, ObjectMapper jsonObjectMapper) {
        this.protocolManagerSessionFactory = protocolManagerSessionFactory;
        this.prng = prng;
        this.jsonObjectMapper = jsonObjectMapper;
        this.protocolOperationQueue = new NoDuplicatePriorityOperationQueue();
        this.stepFailedAttemptCount = new HashMap();
    }

    public void startProcessing() {
        this.protocolOperationQueue.execute(1, "Engine-ProtocolStepCoordinator");
    }

    private void queueNewProtocolOperation(UID receivedMessageUid, int protocolId, int failedAttemptsCount) {
        ProtocolOperation op = new ProtocolOperation(this.protocolManagerSessionFactory, receivedMessageUid, protocolId, failedAttemptsCount, this.prng, this.jsonObjectMapper, this, this);
        this.protocolOperationQueue.queue(op);
    }

    public void initialQueueing() {
        try (ProtocolManagerSession protocolManagerSession = this.protocolManagerSessionFactory.getSession();){
            ReceivedMessage.deleteExpiredMessagesWithNoProtocol(protocolManagerSession);
            ReceivedMessage.deleteAllTransfer(protocolManagerSession);
            ReceivedMessage[] receivedMessages = ReceivedMessage.getAll(protocolManagerSession);
            if (receivedMessages.length > 0) {
                Logger.i("Found " + receivedMessages.length + " ReceivedMessage to (attempt to) process.");
                for (ReceivedMessage receivedMessage : receivedMessages) {
                    this.queueNewProtocolOperation(receivedMessage.getUid(), receivedMessage.getProtocolId(), 0);
                }
            }
            protocolManagerSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void processReceivedMessage(UID messageUid, int protocolId) {
        this.queueNewProtocolOperation(messageUid, protocolId, 0);
    }

    @Override
    public void onFinishCallback(Operation operation) {
        Logger.d("Running onFinishCallback for " + String.valueOf(operation.getClass()));
        ProtocolOperation protocolOperation = (ProtocolOperation)operation;
        UID protocolInstanceUid = protocolOperation.getProtocolInstanceUid();
        Identity protocolOwnedIdentity = protocolOperation.getProtocolOwnedIdentity();
        if (protocolInstanceUid == null || protocolOwnedIdentity == null) {
            Logger.w("The ProtocolOperation finished, but either the protocolInstanceUid or the protocolOwnedIdentity is not properly set.");
            return;
        }
        try (ProtocolManagerSession protocolManagerSession = this.protocolManagerSessionFactory.getSession();){
            for (ReceivedMessage receivedMessage : ReceivedMessage.getAll(protocolManagerSession, protocolInstanceUid, protocolOwnedIdentity)) {
                protocolManagerSession.protocolReceivedMessageProcessorDelegate.processReceivedMessage(receivedMessage.getUid(), receivedMessage.getProtocolId());
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void onCancelCallback(Operation operation) {
        Logger.d("Running onCancelCallback for " + String.valueOf(operation.getClass()));
        if (operation.hasNoReasonForCancel()) {
            return;
        }
        Logger.d("ProtocolOperation cancelled for RFC " + operation.getReasonForCancel());
        switch (operation.getReasonForCancel()) {
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 6: {
                UID messageUid = ((ProtocolOperation)operation).getReceivedMessageUid();
                int protocolId = ((ProtocolOperation)operation).getProtocolId();
                Integer failedAttempts = this.stepFailedAttemptCount.get(messageUid);
                if (failedAttempts == null) {
                    failedAttempts = 0;
                }
                Integer n = failedAttempts;
                failedAttempts = failedAttempts + 1;
                if (failedAttempts >= 5) {
                    try (ProtocolManagerSession protocolManagerSession = this.protocolManagerSessionFactory.getSession();){
                        ReceivedMessage message = ReceivedMessage.get(protocolManagerSession, ((ProtocolOperation)operation).getReceivedMessageUid());
                        message.delete();
                        protocolManagerSession.session.commit();
                    }
                    catch (SQLException e) {
                        Logger.x(e);
                    }
                    break;
                }
                this.stepFailedAttemptCount.put(messageUid, failedAttempts);
                this.queueNewProtocolOperation(messageUid, protocolId, failedAttempts);
                break;
            }
            case 3: 
            case 4: {
                try (ProtocolManagerSession protocolManagerSession = this.protocolManagerSessionFactory.getSession();){
                    ReceivedMessage message = ReceivedMessage.get(protocolManagerSession, ((ProtocolOperation)operation).getReceivedMessageUid());
                    if (message != null) {
                        message.delete();
                        protocolManagerSession.session.commit();
                    }
                }
                catch (SQLException e) {
                    Logger.x(e);
                }
                break;
            }
            case 7: {
                try (ProtocolManagerSession protocolManagerSession = this.protocolManagerSessionFactory.getSession();){
                    ReceivedMessage message = ReceivedMessage.get(protocolManagerSession, ((ProtocolOperation)operation).getReceivedMessageUid());
                    message.delete();
                    CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createUserInterfaceChannelInfo(message.getToIdentity(), DialogType.createDeleteDialog(), message.getUserDialogUuid()), message.getProtocolId(), message.getProtocolInstanceUid());
                    ChannelDialogMessageToSend messageToSend = new OneWayDialogProtocolMessage(coreProtocolMessage).generateChannelDialogMessageToSend();
                    protocolManagerSession.channelDelegate.post(protocolManagerSession.session, messageToSend, this.prng);
                    protocolManagerSession.session.commit();
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            default: {
                Logger.w("Unknown RFC for ProtocolOperation: " + operation.getReasonForCancel());
            }
        }
    }
}

