/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.protocol;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelProtocolMessageToSend;
import io.olvid.engine.datatypes.containers.Group;
import io.olvid.engine.datatypes.containers.GroupInformation;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.containers.IdentityWithSerializedDetails;
import io.olvid.engine.datatypes.containers.ProtocolReceivedDialogResponse;
import io.olvid.engine.datatypes.containers.ProtocolReceivedMessage;
import io.olvid.engine.datatypes.containers.ProtocolReceivedServerResponse;
import io.olvid.engine.datatypes.containers.SendChannelInfo;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.KeyPair;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPublicKey;
import io.olvid.engine.datatypes.key.symmetric.MACKey;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.engine.types.ObvDeviceManagementRequest;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.engine.types.sync.ObvSyncAtom;
import io.olvid.engine.metamanager.ChannelDelegate;
import io.olvid.engine.metamanager.CreateSessionDelegate;
import io.olvid.engine.metamanager.EncryptionForIdentityDelegate;
import io.olvid.engine.metamanager.EngineOwnedIdentityCleanupDelegate;
import io.olvid.engine.metamanager.FullRatchetProtocolStarterDelegate;
import io.olvid.engine.metamanager.IdentityDelegate;
import io.olvid.engine.metamanager.MetaManager;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.metamanager.ObvManager;
import io.olvid.engine.metamanager.ProtocolDelegate;
import io.olvid.engine.metamanager.PushNotificationDelegate;
import io.olvid.engine.protocol.coordinators.ProtocolStepCoordinator;
import io.olvid.engine.protocol.databases.ChannelCreationPingSignatureReceived;
import io.olvid.engine.protocol.databases.ChannelCreationProtocolInstance;
import io.olvid.engine.protocol.databases.GroupV2SignatureReceived;
import io.olvid.engine.protocol.databases.IdentityDeletionSignatureReceived;
import io.olvid.engine.protocol.databases.LinkBetweenProtocolInstances;
import io.olvid.engine.protocol.databases.MutualScanSignatureReceived;
import io.olvid.engine.protocol.databases.ProtocolInstance;
import io.olvid.engine.protocol.databases.ReceivedMessage;
import io.olvid.engine.protocol.databases.TrustEstablishmentCommitmentReceived;
import io.olvid.engine.protocol.databases.WaitingForOneToOneContactProtocolInstance;
import io.olvid.engine.protocol.datatypes.CoreProtocolMessage;
import io.olvid.engine.protocol.datatypes.GenericProtocolMessageToSend;
import io.olvid.engine.protocol.datatypes.GenericReceivedProtocolMessage;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSession;
import io.olvid.engine.protocol.datatypes.ProtocolManagerSessionFactory;
import io.olvid.engine.protocol.datatypes.ProtocolStarterDelegate;
import io.olvid.engine.protocol.protocols.ChannelCreationWithContactDeviceProtocol;
import io.olvid.engine.protocol.protocols.ChannelCreationWithOwnedDeviceProtocol;
import io.olvid.engine.protocol.protocols.ContactManagementProtocol;
import io.olvid.engine.protocol.protocols.ContactMutualIntroductionProtocol;
import io.olvid.engine.protocol.protocols.DeviceCapabilitiesDiscoveryProtocol;
import io.olvid.engine.protocol.protocols.DeviceDiscoveryProtocol;
import io.olvid.engine.protocol.protocols.DownloadGroupPhotoChildProtocol;
import io.olvid.engine.protocol.protocols.DownloadGroupV2PhotoProtocol;
import io.olvid.engine.protocol.protocols.DownloadIdentityPhotoChildProtocol;
import io.olvid.engine.protocol.protocols.FullRatchetProtocol;
import io.olvid.engine.protocol.protocols.GroupManagementProtocol;
import io.olvid.engine.protocol.protocols.GroupsV2Protocol;
import io.olvid.engine.protocol.protocols.IdentityDetailsPublicationProtocol;
import io.olvid.engine.protocol.protocols.KeycloakBindingAndUnbindingProtocol;
import io.olvid.engine.protocol.protocols.KeycloakContactAdditionProtocol;
import io.olvid.engine.protocol.protocols.OneToOneContactInvitationProtocol;
import io.olvid.engine.protocol.protocols.OwnedDeviceDiscoveryProtocol;
import io.olvid.engine.protocol.protocols.OwnedDeviceManagementProtocol;
import io.olvid.engine.protocol.protocols.OwnedIdentityDeletionProtocol;
import io.olvid.engine.protocol.protocols.OwnedIdentityTransferProtocol;
import io.olvid.engine.protocol.protocols.SynchronizationProtocol;
import io.olvid.engine.protocol.protocols.TrustEstablishmentWithMutualScanProtocol;
import io.olvid.engine.protocol.protocols.TrustEstablishmentWithSasProtocol;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProtocolManager
implements ProtocolDelegate,
ProtocolStarterDelegate,
FullRatchetProtocolStarterDelegate,
ProtocolManagerSessionFactory,
ObvManager {
    private CreateSessionDelegate createSessionDelegate;
    private ChannelDelegate channelDelegate;
    private IdentityDelegate identityDelegate;
    private ObvBackupAndSyncDelegate identityBackupAndSyncDelegate;
    private EncryptionForIdentityDelegate encryptionForIdentityDelegate;
    private NotificationPostingDelegate notificationPostingDelegate;
    private NotificationListeningDelegate notificationListeningDelegate;
    private EngineOwnedIdentityCleanupDelegate engineOwnedIdentityCleanupDelegate;
    private PushNotificationDelegate pushNotificationDelegate;
    private final ProtocolStepCoordinator protocolStepCoordinator;
    private final String engineBaseDirectory;
    private final PRNGService prng;
    private final ObjectMapper jsonObjectMapper;
    private final NewDeviceListener newDeviceListener;
    private final ContactDeletedListener contactDeletedListener;
    private final ContactTrustLevelListener contactTrustLevelListener;
    private final ObvBackupAndSyncDelegate appBackupAndSyncDelegate;

    public ProtocolManager(MetaManager metaManager, ObvBackupAndSyncDelegate appBackupAndSyncDelegate, String engineBaseDirectory, PRNGService prng, ObjectMapper jsonObjectMapper) {
        this.appBackupAndSyncDelegate = appBackupAndSyncDelegate;
        this.engineBaseDirectory = engineBaseDirectory;
        this.prng = prng;
        this.jsonObjectMapper = jsonObjectMapper;
        this.protocolStepCoordinator = new ProtocolStepCoordinator(this, this.prng, this.jsonObjectMapper);
        this.newDeviceListener = new NewDeviceListener();
        this.contactDeletedListener = new ContactDeletedListener();
        this.contactTrustLevelListener = new ContactTrustLevelListener();
        metaManager.requestDelegate(this, CreateSessionDelegate.class);
        metaManager.requestDelegate(this, ChannelDelegate.class);
        metaManager.requestDelegate(this, EncryptionForIdentityDelegate.class);
        metaManager.requestDelegate(this, IdentityDelegate.class);
        metaManager.requestDelegate(this, ObvBackupAndSyncDelegate.class);
        metaManager.requestDelegate(this, NotificationListeningDelegate.class);
        metaManager.requestDelegate(this, NotificationPostingDelegate.class);
        metaManager.requestDelegate(this, EngineOwnedIdentityCleanupDelegate.class);
        metaManager.requestDelegate(this, PushNotificationDelegate.class);
        metaManager.registerImplementedDelegates(this);
    }

    @Override
    public int initialQueueingPriority() {
        return 100;
    }

    @Override
    public void initialisationComplete() {
        this.protocolStepCoordinator.initialQueueing();
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            for (WaitingForOneToOneContactProtocolInstance waitingForOneToOneContactProtocolInstance : WaitingForOneToOneContactProtocolInstance.getAll(protocolManagerSession)) {
                boolean oneToOne = this.identityDelegate.isIdentityAOneToOneContactOfOwnedIdentity(protocolManagerSession.session, waitingForOneToOneContactProtocolInstance.getOwnedIdentity(), waitingForOneToOneContactProtocolInstance.getContactIdentity());
                if (!oneToOne) continue;
                GenericProtocolMessageToSend message = waitingForOneToOneContactProtocolInstance.getGenericProtocolMessageToSendWhenTrustLevelIncreased();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message.generateChannelProtocolMessageToSend(), this.prng);
            }
            ProtocolInstance.deleteAllTransfer(protocolManagerSession);
            protocolManagerSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    public void startProcessing() {
        this.protocolStepCoordinator.startProcessing();
    }

    public void setDelegate(CreateSessionDelegate createSessionDelegate) {
        this.createSessionDelegate = createSessionDelegate;
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            ReceivedMessage.createTable(protocolManagerSession.session);
            ProtocolInstance.createTable(protocolManagerSession.session);
            LinkBetweenProtocolInstances.createTable(protocolManagerSession.session);
            ChannelCreationProtocolInstance.createTable(protocolManagerSession.session);
            WaitingForOneToOneContactProtocolInstance.createTable(protocolManagerSession.session);
            ChannelCreationPingSignatureReceived.createTable(protocolManagerSession.session);
            TrustEstablishmentCommitmentReceived.createTable(protocolManagerSession.session);
            MutualScanSignatureReceived.createTable(protocolManagerSession.session);
            GroupV2SignatureReceived.createTable(protocolManagerSession.session);
            IdentityDeletionSignatureReceived.createTable(protocolManagerSession.session);
            protocolManagerSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
            throw new RuntimeException("Unable to create protocol databases");
        }
    }

    public static void upgradeTables(Session session, int oldVersion, int newVersion) throws SQLException {
        ReceivedMessage.upgradeTable(session, oldVersion, newVersion);
        ProtocolInstance.upgradeTable(session, oldVersion, newVersion);
        LinkBetweenProtocolInstances.upgradeTable(session, oldVersion, newVersion);
        ChannelCreationProtocolInstance.upgradeTable(session, oldVersion, newVersion);
        WaitingForOneToOneContactProtocolInstance.upgradeTable(session, oldVersion, newVersion);
        ChannelCreationPingSignatureReceived.upgradeTable(session, oldVersion, newVersion);
        TrustEstablishmentCommitmentReceived.upgradeTable(session, oldVersion, newVersion);
        MutualScanSignatureReceived.upgradeTable(session, oldVersion, newVersion);
        GroupV2SignatureReceived.upgradeTable(session, oldVersion, newVersion);
        IdentityDeletionSignatureReceived.upgradeTable(session, oldVersion, newVersion);
    }

    public void setDelegate(ChannelDelegate channelDelegate) {
        this.channelDelegate = channelDelegate;
    }

    public void setDelegate(IdentityDelegate identityDelegate) {
        this.identityDelegate = identityDelegate;
    }

    public void setDelegate(ObvBackupAndSyncDelegate identityBackupAndSyncDelegate) {
        this.identityBackupAndSyncDelegate = identityBackupAndSyncDelegate;
    }

    public void setDelegate(EncryptionForIdentityDelegate encryptionForIdentityDelegate) {
        this.encryptionForIdentityDelegate = encryptionForIdentityDelegate;
    }

    public void setDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        notificationListeningDelegate.addListener("identity_manager_notification_new_contact_device", this.newDeviceListener);
        notificationListeningDelegate.addListener("identity_manager_notification_new_owned_device", this.newDeviceListener);
        notificationListeningDelegate.addListener("identity_manager_notification_contact_identity_deleted", this.contactDeletedListener);
        notificationListeningDelegate.addListener("identity_manager_notification_contact_one_to_one_changed", this.contactTrustLevelListener);
    }

    public void setDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void setDelegate(EngineOwnedIdentityCleanupDelegate engineOwnedIdentityCleanupDelegate) {
        this.engineOwnedIdentityCleanupDelegate = engineOwnedIdentityCleanupDelegate;
    }

    public void setDelegate(PushNotificationDelegate pushNotificationDelegate) {
        this.pushNotificationDelegate = pushNotificationDelegate;
    }

    public void deleteOwnedIdentity(Session session, Identity ownedIdentity, UID excludedProtocolInstanceUid) throws SQLException {
        ReceivedMessage.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
        ProtocolInstance.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity, excludedProtocolInstanceUid);
        TrustEstablishmentCommitmentReceived.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
        MutualScanSignatureReceived.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
        GroupV2SignatureReceived.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
        LinkBetweenProtocolInstances.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
        ChannelCreationProtocolInstance.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
        ChannelCreationPingSignatureReceived.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
        WaitingForOneToOneContactProtocolInstance.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
        IdentityDeletionSignatureReceived.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
    }

    @Override
    public void abortProtocol(Session session, UID protocolInstanceUid, Identity ownedIdentity) throws Exception {
        ProtocolManagerSession protocolManagerSession = this.wrapSession(session);
        Logger.w("Aborting Protocol " + String.valueOf(protocolInstanceUid));
        LinkBetweenProtocolInstances[] linksToParent = LinkBetweenProtocolInstances.getAllParentLinks(protocolManagerSession, protocolInstanceUid, ownedIdentity);
        LinkBetweenProtocolInstances[] linksToChild = LinkBetweenProtocolInstances.getAllChildLinks(protocolManagerSession, protocolInstanceUid, ownedIdentity);
        ProtocolInstance protocolInstance = ProtocolInstance.get(protocolManagerSession, protocolInstanceUid, ownedIdentity);
        if (protocolInstance != null) {
            protocolInstance.delete();
        }
        for (ReceivedMessage receivedMessage : ReceivedMessage.getAll(protocolManagerSession, protocolInstanceUid, ownedIdentity)) {
            receivedMessage.delete();
        }
        for (ObvDatabase obvDatabase : linksToParent) {
            ProtocolInstance parentProtocolInstance = ProtocolInstance.get(protocolManagerSession, protocolInstanceUid, ownedIdentity);
            if (parentProtocolInstance == null) continue;
            this.abortProtocol(session, ((LinkBetweenProtocolInstances)obvDatabase).getParentProtocolInstanceUid(), ownedIdentity);
        }
        for (ObvDatabase obvDatabase : linksToChild) {
            ProtocolInstance childProtocolInstance = ProtocolInstance.get(protocolManagerSession, protocolInstanceUid, ownedIdentity);
            if (childProtocolInstance == null) continue;
            this.abortProtocol(session, ((LinkBetweenProtocolInstances)obvDatabase).getChildProtocolInstanceUid(), ownedIdentity);
        }
    }

    @Override
    public void process(Session session, ProtocolReceivedMessage message) throws Exception {
        if (!this.identityDelegate.isOwnedIdentity(session, message.getOwnedIdentity()) && !Objects.equals(message.getOwnedIdentity().getServer(), "ephemeral_fake_server")) {
            throw new Exception();
        }
        GenericReceivedProtocolMessage genericReceivedProtocolMessage = GenericReceivedProtocolMessage.of(message);
        ReceivedMessage.create(this.wrapSession(session), genericReceivedProtocolMessage, this.prng);
    }

    @Override
    public void process(Session session, ProtocolReceivedDialogResponse message) throws Exception {
        if (!this.identityDelegate.isOwnedIdentity(session, message.getToIdentity()) && !Objects.equals(message.getToIdentity().getServer(), "ephemeral_fake_server")) {
            throw new Exception();
        }
        GenericReceivedProtocolMessage genericReceivedProtocolMessage = GenericReceivedProtocolMessage.of(message);
        ReceivedMessage.create(this.wrapSession(session), genericReceivedProtocolMessage, this.prng);
    }

    @Override
    public void process(Session session, ProtocolReceivedServerResponse message) throws Exception {
        if (!this.identityDelegate.isOwnedIdentity(session, message.getToIdentity()) && !Objects.equals(message.getToIdentity().getServer(), "ephemeral_fake_server")) {
            throw new Exception();
        }
        GenericReceivedProtocolMessage genericReceivedProtocolMessage = GenericReceivedProtocolMessage.of(message);
        ReceivedMessage.create(this.wrapSession(session), genericReceivedProtocolMessage, this.prng);
    }

    @Override
    public boolean isChannelCreationInProgress(Session session, Identity ownedIdentity, Identity contactIdentity, UID contactDeviceUid) throws Exception {
        return ChannelCreationProtocolInstance.get(this.wrapSession(session), contactDeviceUid, contactIdentity, ownedIdentity) != null;
    }

    @Override
    public ProtocolManagerSession getSession() throws SQLException {
        if (this.createSessionDelegate == null) {
            throw new SQLException("No CreateSessionDelegate was set in ChannelManager.");
        }
        return new ProtocolManagerSession(this.createSessionDelegate.getSession(), this.channelDelegate, this.identityDelegate, this.encryptionForIdentityDelegate, this.protocolStepCoordinator, this, this, this.notificationPostingDelegate, this.notificationListeningDelegate, this.engineOwnedIdentityCleanupDelegate, this.pushNotificationDelegate, this.engineBaseDirectory, this.identityBackupAndSyncDelegate, this.appBackupAndSyncDelegate);
    }

    private ProtocolManagerSession wrapSession(Session session) {
        return new ProtocolManagerSession(session, this.channelDelegate, this.identityDelegate, this.encryptionForIdentityDelegate, this.protocolStepCoordinator, this, this, this.notificationPostingDelegate, this.notificationListeningDelegate, this.engineOwnedIdentityCleanupDelegate, this.pushNotificationDelegate, this.engineBaseDirectory, this.identityBackupAndSyncDelegate, this.appBackupAndSyncDelegate);
    }

    @Override
    public void startDeviceDiscoveryProtocol(Identity ownedIdentity, Identity contactIdentity) throws Exception {
        if (contactIdentity.equals(ownedIdentity)) {
            Logger.w("Cannot start a DeviceDiscovery protocol with contactIdentity == ownedIdentity");
            return;
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 0, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new DeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage, contactIdentity).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void startDeviceDiscoveryProtocolWithinTransaction(Session session, Identity ownedIdentity, Identity contactIdentity) throws Exception {
        if (contactIdentity.equals(ownedIdentity)) {
            Logger.w("Cannot start a DeviceDiscovery protocol with contactIdentity == ownedIdentity");
            return;
        }
        ProtocolManagerSession protocolManagerSession = this.wrapSession(session);
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 0, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new DeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage, contactIdentity).generateChannelProtocolMessageToSend();
        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
    }

    @Override
    public void startOwnedDeviceDiscoveryProtocol(Identity ownedIdentity) throws Exception {
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 21, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new OwnedDeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void startOwnedDeviceDiscoveryProtocolWithinTransaction(Session session, Identity ownedIdentity) throws Exception {
        ProtocolManagerSession protocolManagerSession = this.wrapSession(session);
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 21, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new OwnedDeviceDiscoveryProtocol.InitialMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
        protocolManagerSession.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void startChannelCreationProtocolWithOwnedDevice(Session session, Identity ownedIdentity, UID ownedDeviceUid) throws Exception {
        ProtocolManagerSession protocolManagerSession = this.wrapSession(session);
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 22, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new ChannelCreationWithOwnedDeviceProtocol.InitialMessage(coreProtocolMessage, ownedDeviceUid).generateChannelProtocolMessageToSend();
        protocolManagerSession.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void startChannelCreationProtocolWithContactDevice(Session session, Identity ownedIdentity, Identity contactIdentity, UID contactDeviceUid) throws Exception {
        if (contactIdentity.equals(ownedIdentity)) {
            Logger.w("Cannot start a ChannelCreationWithContactDeviceProtocol with contactIdentity == ownedIdentity");
            return;
        }
        ProtocolManagerSession protocolManagerSession = this.wrapSession(session);
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 2, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new ChannelCreationWithContactDeviceProtocol.InitialMessage(coreProtocolMessage, contactIdentity, contactDeviceUid).generateChannelProtocolMessageToSend();
        protocolManagerSession.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void startDownloadIdentityPhotoProtocolWithinTransaction(Session session, Identity ownedIdentity, Identity contactIdentity, JsonIdentityDetailsWithVersionAndPhoto jsonIdentityDetailsWithVersionAndPhoto) throws Exception {
        if (ownedIdentity == null || contactIdentity == null || jsonIdentityDetailsWithVersionAndPhoto == null) {
            return;
        }
        ProtocolManagerSession protocolManagerSession = this.wrapSession(session);
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 7, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new DownloadIdentityPhotoChildProtocol.InitialMessage(coreProtocolMessage, contactIdentity, this.jsonObjectMapper.writeValueAsString((Object)jsonIdentityDetailsWithVersionAndPhoto)).generateChannelProtocolMessageToSend();
        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
    }

    @Override
    public void startDownloadGroupPhotoProtocolWithinTransaction(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid, JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto) throws Exception {
        if (ownedIdentity == null || groupOwnerAndUid == null || groupOwnerAndUid.length < 32 || jsonGroupDetailsWithVersionAndPhoto == null) {
            return;
        }
        GroupInformation groupInformation = new GroupInformation(Identity.of(Arrays.copyOfRange(groupOwnerAndUid, 0, groupOwnerAndUid.length - 32)), new UID(Arrays.copyOfRange(groupOwnerAndUid, groupOwnerAndUid.length - 32, groupOwnerAndUid.length)), this.jsonObjectMapper.writeValueAsString((Object)jsonGroupDetailsWithVersionAndPhoto));
        ProtocolManagerSession protocolManagerSession = this.wrapSession(session);
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 14, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new DownloadGroupPhotoChildProtocol.InitialMessage(coreProtocolMessage, groupInformation).generateChannelProtocolMessageToSend();
        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
    }

    @Override
    public void startDownloadGroupV2PhotoProtocolWithinTransaction(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, GroupV2.ServerPhotoInfo serverPhotoInfo) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null || serverPhotoInfo == null) {
            return;
        }
        ProtocolManagerSession protocolManagerSession = this.wrapSession(session);
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 19, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new DownloadGroupV2PhotoProtocol.InitialMessage(coreProtocolMessage, groupIdentifier, serverPhotoInfo).generateChannelProtocolMessageToSend();
        protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
    }

    @Override
    public void startTrustEstablishmentProtocol(Identity ownedIdentity, Identity contactIdentity, String contactDisplayName) throws Exception {
        this.startTrustEstablishmentWithSasProtocol(contactIdentity, contactDisplayName, ownedIdentity);
    }

    @Override
    public void initiateGroupV2ReDownloadWithinTransaction(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        if (session == null || ownedIdentity == null || groupIdentifier == null) {
            throw new Exception();
        }
        UID protocolInstanceUid = groupIdentifier.computeProtocolInstanceUid();
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 18, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new GroupsV2Protocol.GroupReDownloadInitialMessage(coreProtocolMessage, groupIdentifier).generateChannelProtocolMessageToSend();
        this.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void initiateKeycloakGroupV2TargetedPing(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, Identity contactIdentity) throws Exception {
        if (session == null || ownedIdentity == null || groupIdentifier == null || groupIdentifier.category != 1) {
            throw new Exception();
        }
        UID protocolInstanceUid = groupIdentifier.computeProtocolInstanceUid();
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 18, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new GroupsV2Protocol.InitiateTargetedPingMessage(coreProtocolMessage, groupIdentifier, contactIdentity).generateChannelProtocolMessageToSend();
        this.channelDelegate.post(session, message, this.prng);
    }

    private void startTrustEstablishmentWithSasProtocol(Identity contactIdentity, String contactDisplayName, Identity ownedIdentity) throws Exception {
        if (contactIdentity.equals(ownedIdentity)) {
            Logger.w("Cannot start a trust establishment protocol with contactIdentity == ownedIdentity");
            return;
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 11, protocolInstanceUid);
            String ownedIdentityDetails = this.identityDelegate.getSerializedPublishedDetailsOfOwnedIdentity(protocolManagerSession.session, ownedIdentity);
            if (ownedIdentityDetails == null) {
                Logger.e("Error finding own identity details in startTrustEstablishmentProtocol");
                return;
            }
            ChannelProtocolMessageToSend message = new TrustEstablishmentWithSasProtocol.InitialMessage(coreProtocolMessage, contactIdentity, contactDisplayName, ownedIdentityDetails).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void startMutualScanTrustEstablishmentProtocol(Identity ownedIdentity, Identity contactIdentity, byte[] signature) throws Exception {
        if (contactIdentity.equals(ownedIdentity)) {
            Logger.w("Cannot start a mutual scan protocol with contactIdentity == ownedIdentity");
            return;
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 12, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new TrustEstablishmentWithMutualScanProtocol.InitialMessage(coreProtocolMessage, contactIdentity, signature).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    private void startChannelCreationWithContactDeviceProtocol(Identity ownedIdentity, Identity contactIdentity, UID contactDeviceUid) throws Exception {
        if (contactIdentity.equals(ownedIdentity)) {
            Logger.w("Cannot start a protocol with contactIdentity == ownedIdentity");
            return;
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 2, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new ChannelCreationWithContactDeviceProtocol.InitialMessage(coreProtocolMessage, contactIdentity, contactDeviceUid).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    public void startChannelCreationWithOwnedDeviceProtocol(Identity ownedIdentity, UID ownedDeviceUid) throws Exception {
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 22, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new ChannelCreationWithOwnedDeviceProtocol.InitialMessage(coreProtocolMessage, ownedDeviceUid).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void startContactMutualIntroductionProtocol(Identity ownedIdentity, Identity contactIdentityA, Identity[] contactIdentities) throws Exception {
        if (contactIdentityA.equals(ownedIdentity)) {
            Logger.w("Cannot start a protocol with contactIdentity == ownedIdentity");
            return;
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            protocolManagerSession.session.startTransaction();
            for (Identity contactIdentityB : contactIdentities) {
                if (contactIdentityB.equals(ownedIdentity)) {
                    Logger.w("Cannot start a protocol with contactIdentity == ownedIdentity");
                    return;
                }
                UID protocolInstanceUid = new UID(this.prng);
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 4, protocolInstanceUid);
                ChannelProtocolMessageToSend message = new ContactMutualIntroductionProtocol.InitialMessage(coreProtocolMessage, contactIdentityA, contactIdentityB).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            }
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void startGroupCreationProtocol(Identity ownedIdentity, String serializedGroupDetailsWithVersionAndPhoto, String absolutePhotoUrl, HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndSerializedDetails) throws Exception {
        if (serializedGroupDetailsWithVersionAndPhoto == null || ownedIdentity == null || groupMemberIdentitiesAndSerializedDetails == null) {
            throw new Exception();
        }
        if (groupMemberIdentitiesAndSerializedDetails.contains(new IdentityWithSerializedDetails(ownedIdentity, ""))) {
            Logger.e("Error in startGroupCreationProtocol: ownedIdentity contained in groupMemberIdentitiesAndSerializedDetails");
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            GroupInformation groupInformation = GroupInformation.generate(ownedIdentity, serializedGroupDetailsWithVersionAndPhoto, this.prng);
            UID protocolInstanceUid = groupInformation.computeProtocolUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 9, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupManagementProtocol.InitiateGroupCreationMessage(coreProtocolMessage, groupInformation, absolutePhotoUrl, groupMemberIdentitiesAndSerializedDetails).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void startGroupV2CreationProtocol(Identity ownedIdentity, String serializedGroupDetails, String absolutePhotoUrl, HashSet<GroupV2.Permission> ownPermissions, HashSet<GroupV2.IdentityAndPermissions> otherGroupMembers, String serializedGroupType) throws Exception {
        if (serializedGroupDetails == null || ownedIdentity == null || ownPermissions == null || otherGroupMembers == null) {
            throw new Exception();
        }
        if (otherGroupMembers.contains(new GroupV2.IdentityAndPermissions(ownedIdentity, null))) {
            Logger.e("Error in startGroupV2CreationProtocol: ownedIdentity contained in otherGroupMembers");
            throw new Exception();
        }
        if (!ownPermissions.contains((Object)GroupV2.Permission.GROUP_ADMIN)) {
            Logger.e("Error in startGroupV2CreationProtocol: ownedPermissions do not containt GROUP_ADMIN");
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 18, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupsV2Protocol.GroupCreationInitialMessage(coreProtocolMessage, ownPermissions, otherGroupMembers, serializedGroupDetails, absolutePhotoUrl, serializedGroupType).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void initiateGroupV2Update(Identity ownedIdentity, GroupV2.Identifier groupIdentifier, ObvGroupV2.ObvGroupV2ChangeSet changeSet) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = groupIdentifier.computeProtocolInstanceUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 18, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupsV2Protocol.GroupUpdateInitialMessage(coreProtocolMessage, groupIdentifier, changeSet).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void initiateGroupV2Leave(Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category == 1) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = groupIdentifier.computeProtocolInstanceUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 18, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupsV2Protocol.GroupLeaveInitialMessage(coreProtocolMessage, groupIdentifier).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void initiateGroupV2Disband(Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category == 1) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = groupIdentifier.computeProtocolInstanceUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 18, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupsV2Protocol.GroupDisbandInitialMessage(coreProtocolMessage, groupIdentifier).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void initiateGroupV2ReDownload(Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = groupIdentifier.computeProtocolInstanceUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 18, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupsV2Protocol.GroupReDownloadInitialMessage(coreProtocolMessage, groupIdentifier).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void initiateGroupV2BatchKeysResend(Session session, Identity ownedIdentity, Identity contactIdentity, UID contactDeviceUid) throws Exception {
        if (session == null || ownedIdentity == null || contactIdentity == null) {
            throw new Exception();
        }
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 18, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new GroupsV2Protocol.InitiateBatchKeysResendMessage(coreProtocolMessage, contactIdentity, contactDeviceUid).generateChannelProtocolMessageToSend();
        this.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void createOrUpdateKeycloakGroupV2(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, String serializedKeycloakGroupBlob) throws Exception {
        if (session == null || ownedIdentity == null || groupIdentifier == null || serializedKeycloakGroupBlob == null) {
            throw new Exception();
        }
        UID protocolInstanceUid = groupIdentifier.computeProtocolInstanceUid();
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 18, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new GroupsV2Protocol.CreateOrUpdateKeycloakGroupMessage(coreProtocolMessage, groupIdentifier, serializedKeycloakGroupBlob).generateChannelProtocolMessageToSend();
        this.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void processDeviceManagementRequest(Identity ownedIdentity, ObvDeviceManagementRequest deviceManagementRequest) throws Exception {
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            this.processDeviceManagementRequest(protocolManagerSession.session, ownedIdentity, deviceManagementRequest);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void processDeviceManagementRequest(Session session, Identity ownedIdentity, ObvDeviceManagementRequest deviceManagementRequest) throws Exception {
        if (session == null || ownedIdentity == null || deviceManagementRequest == null) {
            throw new Exception();
        }
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 24, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new OwnedDeviceManagementProtocol.InitialMessage(coreProtocolMessage, deviceManagementRequest).generateChannelProtocolMessageToSend();
        this.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void startIdentityDetailsPublicationProtocol(Session session, Identity ownedIdentity, int version) throws Exception {
        if (ownedIdentity == null) {
            throw new Exception();
        }
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 6, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new IdentityDetailsPublicationProtocol.InitialMessage(coreProtocolMessage, version).generateChannelProtocolMessageToSend();
        this.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void startGroupDetailsPublicationProtocol(Session session, Identity ownedIdentity, byte[] groupUid) throws Exception {
        if (ownedIdentity == null || groupUid == null) {
            throw new Exception();
        }
        GroupInformation groupInformation = this.identityDelegate.getGroupInformation(session, ownedIdentity, groupUid);
        if (groupInformation == null) {
            throw new Exception();
        }
        UID protocolInstanceUid = groupInformation.computeProtocolUid();
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 9, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new GroupManagementProtocol.GroupMembersOrDetailsChangedTriggerMessage(coreProtocolMessage, groupInformation).generateChannelProtocolMessageToSend();
        this.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void startOneToOneInvitationProtocol(Identity ownedIdentity, Identity contactIdentity) throws Exception {
        if (ownedIdentity == null || contactIdentity == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 17, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new OneToOneContactInvitationProtocol.InitialMessage(coreProtocolMessage, contactIdentity).generateChannelProtocolMessageToSend();
            this.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void inviteContactsToGroup(byte[] groupOwnerAndUid, Identity ownedIdentity, HashSet<Identity> newMembersIdentity) throws Exception {
        if (groupOwnerAndUid == null || ownedIdentity == null || newMembersIdentity == null || newMembersIdentity.isEmpty()) {
            throw new Exception();
        }
        if (newMembersIdentity.contains(ownedIdentity)) {
            Logger.e("Error in inviteContactsToGroup: ownedIdentity contained in newMembersIdentity");
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            Group group = this.identityDelegate.getGroup(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            GroupInformation groupInformation = this.identityDelegate.getGroupInformation(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            if (group == null || groupInformation == null) {
                Logger.e("Error in inviteContactsToGroup: group not found");
                throw new Exception();
            }
            for (IdentityWithSerializedDetails identityWithSerializedDetails : group.getPendingGroupMembers()) {
                if (!newMembersIdentity.contains(identityWithSerializedDetails.identity)) continue;
                Logger.e("Error in inviteContactsToGroup: adding a member that is already pending");
                throw new Exception();
            }
            for (Comparable<IdentityWithSerializedDetails> comparable : group.getGroupMembers()) {
                if (!newMembersIdentity.contains(comparable)) continue;
                Logger.e("Error in inviteContactsToGroup: adding a member that is already in the group");
                throw new Exception();
            }
            UID protocolInstanceUid = groupInformation.computeProtocolUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 9, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupManagementProtocol.AddGroupMembersMessage(coreProtocolMessage, groupInformation, newMembersIdentity).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void reinvitePendingToGroup(byte[] groupOwnerAndUid, Identity ownedIdentity, Identity pendingMemberIdentity) throws Exception {
        if (groupOwnerAndUid == null || ownedIdentity == null || pendingMemberIdentity == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            Group group = this.identityDelegate.getGroup(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            GroupInformation groupInformation = this.identityDelegate.getGroupInformation(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            if (group == null || groupInformation == null) {
                Logger.e("Error in reinvitePendingToGroup: group not found");
                throw new Exception();
            }
            if (!group.isPendingMember(pendingMemberIdentity)) {
                Logger.e("Error in reinvitePendingToGroup: pendingMemberIdentity is not a PendingMember");
                throw new Exception();
            }
            UID protocolInstanceUid = groupInformation.computeProtocolUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 9, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupManagementProtocol.ReinvitePendingMemberMessage(coreProtocolMessage, groupInformation, pendingMemberIdentity).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void removeContactsFromGroup(byte[] groupOwnerAndUid, Identity ownedIdentity, HashSet<Identity> removedMemberIdentities) throws Exception {
        if (groupOwnerAndUid == null || ownedIdentity == null || removedMemberIdentities == null || removedMemberIdentities.isEmpty()) {
            throw new Exception();
        }
        if (removedMemberIdentities.contains(ownedIdentity)) {
            Logger.e("Error in inviteContactsToGroup: ownedIdentity contained in removedMemberIdentities");
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            Group group = this.identityDelegate.getGroup(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            GroupInformation groupInformation = this.identityDelegate.getGroupInformation(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            if (group == null || groupInformation == null) {
                Logger.e("Error in inviteContactsToGroup: group not found");
                throw new Exception();
            }
            for (Identity removedMemberIdentity : removedMemberIdentities) {
                if (group.isMember(removedMemberIdentity) || group.isPendingMember(removedMemberIdentity)) continue;
                Logger.e("Error in removedMemberIdentities: removing a member that is neither member nor pending");
                throw new Exception();
            }
            UID protocolInstanceUid = groupInformation.computeProtocolUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 9, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupManagementProtocol.RemoveGroupMembersMessage(coreProtocolMessage, groupInformation, removedMemberIdentities).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void leaveGroup(byte[] groupOwnerAndUid, Identity ownedIdentity) throws Exception {
        if (groupOwnerAndUid == null || ownedIdentity == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            Group group = this.identityDelegate.getGroup(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            GroupInformation groupInformation = this.identityDelegate.getGroupInformation(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            if (group == null || groupInformation == null) {
                Logger.e("Error in leaveGroup: group not found");
                throw new Exception();
            }
            if (group.getGroupOwner() == null) {
                Logger.e("Error in leaveGroup: trying to leave a group you own");
                throw new Exception();
            }
            UID protocolInstanceUid = groupInformation.computeProtocolUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 9, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupManagementProtocol.LeaveGroupMessage(coreProtocolMessage, groupInformation).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void disbandGroup(byte[] groupOwnerAndUid, Identity ownedIdentity) throws Exception {
        if (groupOwnerAndUid == null || ownedIdentity == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            Group group = this.identityDelegate.getGroup(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            GroupInformation groupInformation = this.identityDelegate.getGroupInformation(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            if (group == null || groupInformation == null) {
                Logger.e("Error in disbandGroup: group not found");
                throw new Exception();
            }
            if (group.getGroupOwner() != null) {
                Logger.e("Error in disbandGroup: trying to disband a group you do not own");
                throw new Exception();
            }
            UID protocolInstanceUid = groupInformation.computeProtocolUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 9, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupManagementProtocol.DisbandGroupMessage(coreProtocolMessage, groupInformation).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void queryGroupMembers(byte[] groupOwnerAndUid, Identity ownedIdentity) throws Exception {
        if (groupOwnerAndUid == null || ownedIdentity == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            Group group = this.identityDelegate.getGroup(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            GroupInformation groupInformation = this.identityDelegate.getGroupInformation(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            if (group == null || groupInformation == null) {
                Logger.e("Error in queryGroupMembers: group not found");
                throw new Exception();
            }
            if (group.getGroupOwner() == null) {
                throw new Exception();
            }
            UID protocolInstanceUid = groupInformation.computeProtocolUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 9, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupManagementProtocol.InitiateGroupMembersQueryMessage(coreProtocolMessage, groupInformation).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void reinviteAndPushMembersToContact(byte[] groupOwnerAndUid, Identity ownedIdentity, Identity contactIdentity) throws Exception {
        if (groupOwnerAndUid == null || ownedIdentity == null || contactIdentity == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            Group group = this.identityDelegate.getGroup(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            GroupInformation groupInformation = this.identityDelegate.getGroupInformation(protocolManagerSession.session, ownedIdentity, groupOwnerAndUid);
            if (group == null || groupInformation == null) {
                Logger.e("Error in reinviteAndPushMembersToContact: group not found");
                throw new Exception();
            }
            if (group.getGroupOwner() != null) {
                Logger.e("Error in reinviteAndPushMembersToContact: trying to reinvite to a group you do not own");
                throw new Exception();
            }
            UID protocolInstanceUid = groupInformation.computeProtocolUid();
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 9, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new GroupManagementProtocol.TriggerReinviteMessage(coreProtocolMessage, groupInformation, contactIdentity).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void deleteContact(Identity ownedIdentity, Identity contactIdentity) throws Exception {
        if (contactIdentity == null || ownedIdentity == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            if (!this.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, ownedIdentity, contactIdentity)) {
                Logger.e("Error in deleteContact: contact not found");
                throw new Exception();
            }
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 10, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new ContactManagementProtocol.InitiateContactDeletionMessage(coreProtocolMessage, contactIdentity).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void downgradeOneToOneContact(Identity ownedIdentity, Identity contactIdentity) throws Exception {
        if (contactIdentity == null || ownedIdentity == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            if (!this.identityDelegate.isIdentityAContactOfOwnedIdentity(protocolManagerSession.session, ownedIdentity, contactIdentity)) {
                Logger.e("Error in downgradeContact: contact not found");
                throw new Exception();
            }
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 10, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new ContactManagementProtocol.InitiateContactDowngradeMessage(coreProtocolMessage, contactIdentity).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void addKeycloakContact(Identity ownedIdentity, Identity contactIdentity, String signedContactDetails) throws Exception {
        if (contactIdentity == null || ownedIdentity == null || signedContactDetails == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 15, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new KeycloakContactAdditionProtocol.InitialMessage(coreProtocolMessage, contactIdentity, signedContactDetails).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void startProtocolForBindingOwnedIdentityToKeycloakWithinTransaction(Session session, Identity ownedIdentity, ObvKeycloakState keycloakState, String keycloakUserId) throws Exception {
        if (ownedIdentity == null || keycloakState == null || keycloakUserId == null || keycloakState.keycloakServer == null || keycloakState.jwks == null) {
            throw new Exception();
        }
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 23, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new KeycloakBindingAndUnbindingProtocol.OwnedIdentityKeycloakBindingMessage(coreProtocolMessage, keycloakState, keycloakUserId).generateChannelProtocolMessageToSend();
        this.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void updateCurrentDeviceCapabilitiesForOwnedIdentity(Session session, Identity ownedIdentity, List<ObvCapability> newOwnCapabilities) throws Exception {
        if (newOwnCapabilities == null) {
            return;
        }
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 16, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new DeviceCapabilitiesDiscoveryProtocol.InitialForAddingOwnCapabilitiesMessage(coreProtocolMessage, newOwnCapabilities).generateChannelProtocolMessageToSend();
        this.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void startProtocolForUnbindingOwnedIdentityFromKeycloak(Identity ownedIdentity) throws Exception {
        if (ownedIdentity == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 23, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new KeycloakBindingAndUnbindingProtocol.OwnedIdentityKeycloakUnbindingMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void startOwnedIdentityDeletionProtocol(Session session, Identity ownedIdentity, boolean deleteEverywhere) throws Exception {
        if (session == null || ownedIdentity == null) {
            throw new Exception();
        }
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 20, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new OwnedIdentityDeletionProtocol.InitialMessage(coreProtocolMessage, deleteEverywhere).generateChannelProtocolMessageToSend();
        this.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void initiateSingleItemSync(Session session, Identity ownedIdentity, ObvSyncAtom obvSyncAtom) throws Exception {
        if (session == null || ownedIdentity == null || obvSyncAtom == null) {
            throw new Exception();
        }
        UID protocolInstanceUid = new UID(this.prng);
        CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 25, protocolInstanceUid);
        ChannelProtocolMessageToSend message = new SynchronizationProtocol.InitiateSingleItemSyncMessage(coreProtocolMessage, obvSyncAtom).generateChannelProtocolMessageToSend();
        this.channelDelegate.post(session, message, this.prng);
    }

    @Override
    public void initiateOwnedIdentityTransferProtocolOnSourceDevice(Identity ownedIdentity) throws Exception {
        if (ownedIdentity == null) {
            throw new Exception();
        }
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 26, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new OwnedIdentityTransferProtocol.InitiateTransferOnSourceDeviceMessage(coreProtocolMessage).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void initiateOwnedIdentityTransferProtocolOnTargetDevice(String deviceName) throws Exception {
        KeyPair serverAuthKeyPair = Suite.generateServerAuthenticationKeyPair(null, this.prng);
        KeyPair encryptionKeyPair = Suite.generateEncryptionKeyPair(null, this.prng);
        if (serverAuthKeyPair == null || encryptionKeyPair == null) {
            throw new Exception();
        }
        MACKey macKey = Suite.getDefaultMAC(0).generateKey(this.prng);
        Identity ephemeralIdentity = new Identity("ephemeral_fake_server", (ServerAuthenticationPublicKey)serverAuthKeyPair.getPublicKey(), (EncryptionPublicKey)encryptionKeyPair.getPublicKey());
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            UID protocolInstanceUid = new UID(this.prng);
            CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ephemeralIdentity), 26, protocolInstanceUid);
            ChannelProtocolMessageToSend message = new OwnedIdentityTransferProtocol.InitiateTransferOnTargetDeviceMessage(coreProtocolMessage, deviceName, (ServerAuthenticationPrivateKey)serverAuthKeyPair.getPrivateKey(), (EncryptionPrivateKey)encryptionKeyPair.getPrivateKey(), macKey).generateChannelProtocolMessageToSend();
            protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
            protocolManagerSession.session.commit();
        }
    }

    @Override
    public void startFullRatchetProtocolForObliviousChannel(UID currentDeviceUid, UID remoteDeviceUid, Identity remoteIdentity) throws Exception {
        try (ProtocolManagerSession protocolManagerSession = this.getSession();){
            Identity ownedIdentity = this.identityDelegate.getOwnedIdentityForCurrentDeviceUid(protocolManagerSession.session, currentDeviceUid);
            if (ownedIdentity != null) {
                UID protocolInstanceUid = FullRatchetProtocol.computeProtocolUid(ownedIdentity, remoteIdentity, currentDeviceUid, remoteDeviceUid);
                CoreProtocolMessage coreProtocolMessage = new CoreProtocolMessage(SendChannelInfo.createLocalChannelInfo(ownedIdentity), 13, protocolInstanceUid, false);
                ChannelProtocolMessageToSend message = new FullRatchetProtocol.InitialMessage(coreProtocolMessage, remoteIdentity, remoteDeviceUid).generateChannelProtocolMessageToSend();
                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message, this.prng);
                protocolManagerSession.session.commit();
            }
        }
    }

    class NewDeviceListener
    implements NotificationListener {
        NewDeviceListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            switch (notificationName) {
                case "identity_manager_notification_new_contact_device": {
                    try {
                        UID contactDeviceUid = (UID)userInfo.get("contact_device_uid");
                        Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                        Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                        Boolean channelCreationAlreadyInProgress = (Boolean)userInfo.get("channel_creation_already_in_progress");
                        if (channelCreationAlreadyInProgress != null && channelCreationAlreadyInProgress.booleanValue()) break;
                        ProtocolManager.this.startChannelCreationWithContactDeviceProtocol(ownedIdentity, contactIdentity, contactDeviceUid);
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                    break;
                }
                case "identity_manager_notification_new_owned_device": {
                    try {
                        UID ownedDeviceUid = (UID)userInfo.get("device_uid");
                        Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                        Boolean channelCreationAlreadyInProgress = (Boolean)userInfo.get("channel_creation_already_in_progress");
                        if (channelCreationAlreadyInProgress != null && channelCreationAlreadyInProgress.booleanValue()) break;
                        ProtocolManager.this.startChannelCreationWithOwnedDeviceProtocol(ownedIdentity, ownedDeviceUid);
                        break;
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                }
            }
        }
    }

    class ContactDeletedListener
    implements NotificationListener {
        ContactDeletedListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            switch (notificationName) {
                case "identity_manager_notification_contact_identity_deleted": {
                    try {
                        Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                        Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                        try (ProtocolManagerSession protocolManagerSession = ProtocolManager.this.getSession();){
                            ChannelCreationProtocolInstance[] channelCreationProtocolInstances = ChannelCreationProtocolInstance.getAllForContact(protocolManagerSession, contactIdentity, ownedIdentity);
                            if (channelCreationProtocolInstances != null) {
                                for (ChannelCreationProtocolInstance channelCreationProtocolInstance : channelCreationProtocolInstances) {
                                    ProtocolManager.this.abortProtocol(protocolManagerSession.session, channelCreationProtocolInstance.getProtocolInstanceUid(), ownedIdentity);
                                }
                                protocolManagerSession.session.commit();
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                }
            }
        }
    }

    class ContactTrustLevelListener
    implements NotificationListener {
        ContactTrustLevelListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            switch (notificationName) {
                case "identity_manager_notification_contact_one_to_one_changed": {
                    try {
                        Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                        Identity contactIdentity = (Identity)userInfo.get("contact_identity");
                        boolean oneToOne = (Boolean)userInfo.get("one_to_one");
                        if (!oneToOne) break;
                        try (ProtocolManagerSession protocolManagerSession = ProtocolManager.this.getSession();){
                            WaitingForOneToOneContactProtocolInstance[] waitingForOneToOneContactProtocolInstances;
                            for (WaitingForOneToOneContactProtocolInstance waitingForOneToOneContactProtocolInstance : waitingForOneToOneContactProtocolInstances = WaitingForOneToOneContactProtocolInstance.getAllForContact(protocolManagerSession, ownedIdentity, contactIdentity)) {
                                GenericProtocolMessageToSend message = waitingForOneToOneContactProtocolInstance.getGenericProtocolMessageToSendWhenTrustLevelIncreased();
                                protocolManagerSession.channelDelegate.post(protocolManagerSession.session, message.generateChannelProtocolMessageToSend(), ProtocolManager.this.prng);
                            }
                            protocolManagerSession.session.commit();
                            break;
                        }
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                }
            }
        }
    }
}

