/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.PriorityOperation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.networksend.coordinators.SendAttachmentCoordinator;
import io.olvid.engine.networksend.databases.OutboxAttachment;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.TryToDeleteMessageAndAttachmentsOperation;
import io.olvid.engine.networksend.operations.UploadAttachmentOperation;
import javax.net.ssl.SSLSocketFactory;

public class UploadAttachmentCompositeOperation
extends PriorityOperation {
    public static final int RFC_ATTACHMENT_NOT_FOUND_IN_DATABASE = 1;
    public static final int RFC_NETWORK_ERROR = 3;
    public static final int RFC_MESSAGE_HAS_NO_UID_FROM_SERVER = 4;
    public static final int RFC_ATTACHMENT_FILE_NOT_READABLE = 6;
    public static final int RFC_DOES_NOT_HAVE_THE_HIGHEST_PRIORITY = 7;
    public static final int RFC_INVALID_SIGNED_URL = 8;
    public static final int RFC_IDENTITY_IS_INACTIVE = 9;
    private final Identity ownedIdentity;
    private final UID messageUid;
    private final int attachmentNumber;
    private final Operation[] suboperations;
    private final UploadAttachmentOperation uploadAttachmentOperation;

    public UploadAttachmentCompositeOperation(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, Identity ownedIdentity, UID messageUid, int attachmentNumber, long initialPriority, SendAttachmentCoordinator coordinator, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(OutboxAttachment.computeUniqueUid(ownedIdentity, messageUid, attachmentNumber), onFinishCallback, onCancelCallback);
        this.ownedIdentity = ownedIdentity;
        this.messageUid = messageUid;
        this.attachmentNumber = attachmentNumber;
        this.suboperations = new Operation[2];
        this.uploadAttachmentOperation = new UploadAttachmentOperation(sendManagerSessionFactory, sslSocketFactory, userAgentOverride, ownedIdentity, messageUid, attachmentNumber, initialPriority, coordinator);
        this.suboperations[0] = this.uploadAttachmentOperation;
        this.suboperations[1] = new TryToDeleteMessageAndAttachmentsOperation(sendManagerSessionFactory, ownedIdentity, messageUid);
        for (int i = 0; i < this.suboperations.length - 1; ++i) {
            this.suboperations[i + 1].addDependency(this.suboperations[i]);
        }
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    public int getAttachmentNumber() {
        return this.attachmentNumber;
    }

    @Override
    public long getPriority() {
        return this.uploadAttachmentOperation.getPriority();
    }

    @Override
    public void doCancel() {
        for (Operation op : this.suboperations) {
            op.cancel(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try {
            OperationQueue queue = new OperationQueue();
            for (Operation op : this.suboperations) {
                queue.queue(op);
            }
            queue.execute(1, "Engine-UploadAttachmentCompositeOperation");
            queue.join();
            if (this.cancelWasRequested()) {
                return;
            }
            for (Operation op : this.suboperations) {
                if (!op.isCancelled()) continue;
                this.cancel(op.getReasonForCancel());
                return;
            }
            finished = true;
        }
        catch (Exception e) {
            Logger.x(e);
        }
        finally {
            if (finished) {
                this.setFinished();
            } else {
                this.cancel(null);
                this.processCancel();
            }
        }
    }
}

