/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;

class RefreshOutboxAttachmentSignedUrlServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/uploadAttachment";
    private final String server;
    private final UID messageUidFromServer;
    private final byte[] nonce;
    private final int attachmentNumber;
    private final int expectedChunkCount;
    private String[] signedUrls = null;

    public String[] getSignedUrls() {
        return this.signedUrls;
    }

    public RefreshOutboxAttachmentSignedUrlServerMethod(String server, UID messageUidFromServer, byte[] nonce, int attachmentNumber, int expectedChunkCount) {
        this.server = server;
        this.messageUidFromServer = messageUidFromServer;
        this.nonce = nonce;
        this.attachmentNumber = attachmentNumber;
        this.expectedChunkCount = expectedChunkCount;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.messageUidFromServer), Encoded.of(this.attachmentNumber), Encoded.of(this.nonce)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0) {
            try {
                String[] signedUrls = receivedData[0].decodeStringArray();
                if (signedUrls.length != this.expectedChunkCount) {
                    throw new DecodingException("Attachment chunk count mismatch");
                }
                this.signedUrls = signedUrls;
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return true;
    }
}

