/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUid;
import io.olvid.engine.networksend.databases.OutboxAttachment;
import io.olvid.engine.networksend.databases.OutboxMessage;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.CancelAttachmentUploadServerMethod;
import java.sql.SQLException;
import javax.net.ssl.SSLSocketFactory;

public class CancelAttachmentUploadOperation
extends Operation {
    private final SendManagerSessionFactory sendManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final Identity ownedIdentity;
    private final UID messageUid;
    private final int attachmentNumber;

    public CancelAttachmentUploadOperation(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        super(IdentityAndUid.computeUniqueUid(ownedIdentity, messageUid), null, null);
        this.sendManagerSessionFactory = sendManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.ownedIdentity = ownedIdentity;
        this.messageUid = messageUid;
        this.attachmentNumber = attachmentNumber;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    public int getAttachmentNumber() {
        return this.attachmentNumber;
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try (SendManagerSession sendManagerSession = this.sendManagerSessionFactory.getSession();){
            try {
                OutboxMessage outboxMessage = OutboxMessage.get(sendManagerSession, this.ownedIdentity, this.messageUid);
                OutboxAttachment outboxAttachment = OutboxAttachment.get(sendManagerSession, this.ownedIdentity, this.messageUid, this.attachmentNumber);
                if (outboxMessage == null || outboxAttachment == null) {
                    this.cancel(1);
                    return;
                }
                if (outboxMessage.getUidFromServer() == null) {
                    finished = true;
                    return;
                }
                if (outboxAttachment.isAcknowledged()) {
                    finished = true;
                    return;
                }
                if (this.cancelWasRequested()) {
                    return;
                }
                CancelAttachmentUploadServerMethod serverMethod = new CancelAttachmentUploadServerMethod(outboxMessage.getServer(), outboxMessage.getUidFromServer(), outboxMessage.getNonce(), this.attachmentNumber);
                serverMethod.setSslSocketFactory(this.sslSocketFactory, this.userAgentOverride);
                byte returnStatus = serverMethod.execute(sendManagerSession.identityDelegate.isActiveOwnedIdentity(sendManagerSession.session, this.ownedIdentity));
                sendManagerSession.session.startTransaction();
                switch (returnStatus) {
                    case 12: {
                        Logger.i("Received INVALID_NONCE in CancelAttachmentUploadOperation");
                    }
                    case 0: {
                        outboxAttachment.setCancelProcessed();
                        finished = true;
                        return;
                    }
                    case -114: {
                        this.cancel(3);
                        return;
                    }
                }
                this.cancel(2);
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                sendManagerSession.session.rollback();
                return;
            }
            finally {
                if (finished) {
                    sendManagerSession.session.commit();
                    this.setFinished();
                } else {
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

