/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networksend.databases.MessageHeader;
import io.olvid.engine.networksend.operations.OutboxMessageAndHeaders;

class BatchUploadMessagesServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/batchUploadMessages";
    private final String server;
    private final OutboxMessageAndHeaders[] outboxMessageAndHeaders;

    public OutboxMessageAndHeaders[] getOutboxMessageAndHeaders() {
        return this.outboxMessageAndHeaders;
    }

    BatchUploadMessagesServerMethod(String server, OutboxMessageAndHeaders[] outboxMessageAndHeaders) {
        this.server = server;
        this.outboxMessageAndHeaders = outboxMessageAndHeaders;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        Encoded[] encodeds = new Encoded[this.outboxMessageAndHeaders.length];
        for (int i = 0; i < this.outboxMessageAndHeaders.length; ++i) {
            MessageHeader[] headers = this.outboxMessageAndHeaders[i].headers;
            Encoded[] encodedHeaders = new Encoded[headers.length * 3];
            for (int j = 0; j < headers.length; ++j) {
                encodedHeaders[3 * j] = Encoded.of(headers[j].getDeviceUid());
                encodedHeaders[3 * j + 1] = Encoded.of(headers[j].getWrappedKey());
                encodedHeaders[3 * j + 2] = Encoded.of(headers[j].getToIdentity());
            }
            encodeds[i] = Encoded.of(new Encoded[]{Encoded.of(encodedHeaders), Encoded.of(this.outboxMessageAndHeaders[i].outboxMessage.getEncryptedContent()), Encoded.of(this.outboxMessageAndHeaders[i].outboxMessage.isApplicationMessage()), Encoded.of(this.outboxMessageAndHeaders[i].outboxMessage.isVoipMessage())});
        }
        return Encoded.of(encodeds).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0) {
            if (receivedData.length != this.outboxMessageAndHeaders.length) {
                this.returnStatus = (byte)-125;
            } else {
                try {
                    for (int i = 0; i < this.outboxMessageAndHeaders.length; ++i) {
                        Encoded[] encodeds = receivedData[i].decodeList();
                        this.outboxMessageAndHeaders[i].uidFromServer = encodeds[0].decodeUid();
                        this.outboxMessageAndHeaders[i].nonce = encodeds[1].decodeBytes();
                        this.outboxMessageAndHeaders[i].timestampFromServer = encodeds[2].decodeLong();
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                    this.returnStatus = (byte)-125;
                }
            }
        }
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return true;
    }
}

