/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUid;
import io.olvid.engine.networksend.databases.OutboxMessage;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.BatchUploadMessagesServerMethod;
import io.olvid.engine.networksend.operations.OutboxMessageAndHeaders;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public class BatchUploadMessagesOperation
extends Operation {
    private final SendManagerSessionFactory sendManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final String server;
    private final IdentityAndUid[] messageIdentitiesAndUids;
    private final List<IdentityAndUid> tooManyHeadersUnsentMessageUids;
    private final List<IdentityAndUid> identityInactiveMessageUids;

    public BatchUploadMessagesOperation(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, String server, IdentityAndUid[] messageIdentitiesAndUids) {
        this.sendManagerSessionFactory = sendManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.server = server;
        this.messageIdentitiesAndUids = messageIdentitiesAndUids;
        this.tooManyHeadersUnsentMessageUids = new ArrayList<IdentityAndUid>();
        this.identityInactiveMessageUids = new ArrayList<IdentityAndUid>();
    }

    public List<IdentityAndUid> getIdentityInactiveMessageUids() {
        return this.identityInactiveMessageUids;
    }

    public List<IdentityAndUid> getTooManyHeadersUnsentMessageUids() {
        return this.tooManyHeadersUnsentMessageUids;
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        finished = false;
        try {
            sendManagerSession = this.sendManagerSessionFactory.getSession();
            try {
                try {
                    outboxMessageAndHeaders = new ArrayList<OutboxMessageAndHeaders>();
                    totalHeaders = 0;
                    Logger.d("BatchUploadMessagesOperation uploading a batch of " + this.messageIdentitiesAndUids.length);
                    messageUidsByIdentity = new HashMap<Identity, ArrayList<UID>>();
                    for (IdentityAndUid identityAndUid : this.messageIdentitiesAndUids) {
                        list = (ArrayList<UID>)messageUidsByIdentity.get(identityAndUid.identity);
                        if (list == null) {
                            list = new ArrayList<UID>();
                            messageUidsByIdentity.put(identityAndUid.identity, list);
                        }
                        list.add(identityAndUid.uid);
                    }
                    var6_10 = messageUidsByIdentity.entrySet().iterator();
                    block24: while (true) {
                        if (var6_10.hasNext()) {
                            var7_12 = (Map.Entry)var6_10.next();
                            ownedIdentity = (Identity)var7_12.getKey();
                            messageUids = (List)var7_12.getValue();
                            if (!sendManagerSession.identityDelegate.isActiveOwnedIdentity(sendManagerSession.session, ownedIdentity) && sendManagerSession.identityDelegate.isOwnedIdentity(sendManagerSession.session, ownedIdentity)) {
                                list = messageUids.iterator();
                                while (true) {
                                    if (!list.hasNext()) continue block24;
                                    var11_23 = (UID)list.next();
                                    this.identityInactiveMessageUids.add(new IdentityAndUid(ownedIdentity, var11_23));
                                }
                            }
                        } else {
                            Logger.d("Total header count for this batch: " + totalHeaders);
                            if (this.cancelWasRequested()) {
                                return;
                            }
                            serverMethod = new BatchUploadMessagesServerMethod(this.server, outboxMessageAndHeaders.toArray(new OutboxMessageAndHeaders[0]));
                            serverMethod.setSslSocketFactory(this.sslSocketFactory, this.userAgentOverride);
                            var7_13 = serverMethod.execute(true);
                            sendManagerSession.session.startTransaction();
                            switch (var7_13) {
                                case 0: {
                                    var8_16 = serverMethod.getOutboxMessageAndHeaders();
                                    messageUids = var8_16.length;
                                    var10_21 = 0;
                                    while (true) {
                                        if (var10_21 >= messageUids) {
                                            finished = true;
                                            return;
                                        }
                                        var11_26 = var8_16[var10_21];
                                        var11_26.outboxMessage.setUidFromServer(var11_26.uidFromServer, var11_26.nonce, var11_26.timestampFromServer);
                                        ++var10_21;
                                    }
                                }
                                case -125: {
                                    var8_17 = outboxMessageAndHeaders.iterator();
                                    while (true) {
                                        if (!var8_17.hasNext()) {
                                            finished = true;
                                            return;
                                        }
                                        outboxMessageAndHeader = (OutboxMessageAndHeaders)var8_17.next();
                                        outboxMessageAndHeader.outboxMessage.setUidFromServer(new UID(new byte[32]), new byte[0], 0L);
                                    }
                                }
                                case 24: {
                                    this.cancel(2);
                                    return;
                                }
                            }
                            this.cancel(3);
                            return;
                        }
                        var11_24 = outboxMessages = OutboxMessage.getManyWithoutUidFromServer(sendManagerSession, ownedIdentity, this.server, messageUids.toArray(new UID[0]));
                        var12_27 = var11_24.length;
                        var13_28 = 0;
                        while (true) {
                            if (var13_28 >= var12_27) ** break;
                            outboxMessage = var11_24[var13_28];
                            if (totalHeaders > 1000) {
                                this.tooManyHeadersUnsentMessageUids.add(new IdentityAndUid(outboxMessage.getOwnedIdentity(), outboxMessage.getUid()));
                            } else {
                                headers = outboxMessage.getHeaders();
                                outboxMessageAndHeaders.add(new OutboxMessageAndHeaders(outboxMessage, headers));
                                totalHeaders += headers.length;
                            }
                            ++var13_28;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                    sendManagerSession.session.rollback();
                    return;
                }
                finally {
                    if (finished) {
                        sendManagerSession.session.commit();
                        this.setFinished();
                    } else {
                        if (this.hasNoReasonForCancel()) {
                            this.cancel(null);
                        }
                        this.processCancel();
                    }
                }
            }
            finally {
                if (sendManagerSession != null) {
                    sendManagerSession.close();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

