/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUid;
import io.olvid.engine.datatypes.containers.StringAndBoolean;
import io.olvid.engine.networksend.coordinators.SendMessageCoordinator;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.BatchUploadMessagesOperation;
import io.olvid.engine.networksend.operations.TryToDeleteMessageAndAttachmentsOperation;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;

public class BatchUploadMessagesCompositeOperation
extends Operation {
    public static final int RFC_BATCH_TOO_LARGE = 2;
    public static final int RFC_NETWORK_ERROR = 3;
    private final SendManagerSessionFactory sendManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final String server;
    private final SendMessageCoordinator.MessageBatchProvider messageBatchProvider;
    private IdentityAndUid[] messageIdentitiesAndUids;
    private Operation[] suboperations;

    public BatchUploadMessagesCompositeOperation(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, String server, boolean userContentMessages, SendMessageCoordinator.MessageBatchProvider messageBatchProvider, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(StringAndBoolean.computeUniqueUid(server, userContentMessages), onFinishCallback, onCancelCallback);
        this.sendManagerSessionFactory = sendManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.server = server;
        this.messageBatchProvider = messageBatchProvider;
        this.messageIdentitiesAndUids = null;
        this.suboperations = null;
    }

    public String getServer() {
        return this.server;
    }

    public IdentityAndUid[] getMessageIdentitiesAndUids() {
        return this.messageIdentitiesAndUids;
    }

    public List<IdentityAndUid> getIdentityInactiveMessageUids() {
        if (this.suboperations != null && this.suboperations.length > 0) {
            return ((BatchUploadMessagesOperation)this.suboperations[0]).getIdentityInactiveMessageUids();
        }
        return Collections.emptyList();
    }

    public List<IdentityAndUid> getTooManyHeadersUnsentMessageUids() {
        if (this.suboperations != null && this.suboperations.length > 0) {
            return ((BatchUploadMessagesOperation)this.suboperations[0]).getTooManyHeadersUnsentMessageUids();
        }
        return Collections.emptyList();
    }

    @Override
    public void doCancel() {
        for (Operation op : this.suboperations) {
            op.cancel(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try {
            this.messageIdentitiesAndUids = this.messageBatchProvider.getBatchOFMessageUids();
            if (this.messageIdentitiesAndUids.length == 0) {
                this.suboperations = new Operation[0];
            } else {
                this.suboperations = new Operation[this.messageIdentitiesAndUids.length + 1];
                this.suboperations[0] = new BatchUploadMessagesOperation(this.sendManagerSessionFactory, this.sslSocketFactory, this.userAgentOverride, this.server, this.messageIdentitiesAndUids);
                for (int i = 0; i < this.messageIdentitiesAndUids.length; ++i) {
                    this.suboperations[i + 1] = new TryToDeleteMessageAndAttachmentsOperation(this.sendManagerSessionFactory, this.messageIdentitiesAndUids[i].identity, this.messageIdentitiesAndUids[i].uid);
                    this.suboperations[i + 1].addDependency(this.suboperations[0]);
                }
            }
            if (this.suboperations.length > 0) {
                OperationQueue queue = new OperationQueue();
                for (Operation op : this.suboperations) {
                    queue.queue(op);
                }
                queue.execute(1, "BatchUploadMessagesCompositeOperation");
                queue.join();
                if (this.cancelWasRequested()) {
                    return;
                }
                for (Operation op : this.suboperations) {
                    if (!op.isCancelled()) continue;
                    this.cancel(op.getReasonForCancel());
                    return;
                }
            }
            finished = true;
        }
        catch (Exception e) {
            Logger.x(e);
        }
        finally {
            if (finished) {
                this.setFinished();
            } else {
                this.cancel(null);
                this.processCancel();
            }
        }
    }

    public static UID computeUniqueUid(String server) {
        Hash sha256 = Suite.getHash("sha-256");
        return new UID(sha256.digest(server.getBytes(StandardCharsets.UTF_8)));
    }
}

