/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ReturnReceipt
implements ObvDatabase {
    static final String TABLE_NAME = "return_receipt";
    private final SendManagerSession sendManagerSession;
    private long id;
    static final String ID = "id";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private Identity contactIdentity;
    static final String CONTACT_IDENTITY = "contact_identity";
    private UID[] contactDeviceUids;
    static final String CONTACT_DEVICE_UIDS = "contact_device_uids";
    private int status;
    static final String STATUS = "status";
    private byte[] nonce;
    static final String NONCE = "nonce";
    private AuthEncKey key;
    static final String KEY = "key";
    private Integer attachmentNumber;
    static final String ATTACHMENT_NUMBER = "attachment_number";
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERT = 1L;

    public long getId() {
        return this.id;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public Identity getContactIdentity() {
        return this.contactIdentity;
    }

    public UID[] getContactDeviceUids() {
        return this.contactDeviceUids;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public AuthEncKey getKey() {
        return this.key;
    }

    public Integer getAttachmentNumber() {
        return this.attachmentNumber;
    }

    public static ReturnReceipt create(SendManagerSession sendManagerSession, Identity ownedIdentity, Identity contactIdentity, UID[] contactDeviceUids, int status, byte[] nonce, AuthEncKey key, Integer attachmentNumber) {
        if (ownedIdentity == null || contactIdentity == null || nonce == null || key == null) {
            return null;
        }
        try {
            ReturnReceipt returnReceipt = new ReturnReceipt(sendManagerSession, ownedIdentity, contactIdentity, contactDeviceUids, status, nonce, key, attachmentNumber);
            returnReceipt.insert();
            return returnReceipt;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    public ReturnReceipt(SendManagerSession sendManagerSession, Identity ownedIdentity, Identity contactIdentity, UID[] contactDeviceUids, int status, byte[] nonce, AuthEncKey key, Integer attachmentNumber) {
        this.sendManagerSession = sendManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.contactIdentity = contactIdentity;
        this.contactDeviceUids = contactDeviceUids;
        this.status = status;
        this.nonce = nonce;
        this.key = key;
        this.attachmentNumber = attachmentNumber;
    }

    private ReturnReceipt(SendManagerSession sendManagerSession, ResultSet res) throws SQLException {
        this.sendManagerSession = sendManagerSession;
        this.id = res.getLong(ID);
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
            this.contactIdentity = Identity.of(res.getBytes(CONTACT_IDENTITY));
            this.key = (AuthEncKey)new Encoded(res.getBytes(KEY)).decodeSymmetricKey();
            this.contactDeviceUids = new Encoded(res.getBytes(CONTACT_DEVICE_UIDS)).decodeUidArray();
        }
        catch (DecodingException | ClassCastException e) {
            Logger.x(e);
        }
        this.status = res.getInt(STATUS);
        this.nonce = res.getBytes(NONCE);
        this.attachmentNumber = res.getInt(ATTACHMENT_NUMBER);
        if (res.wasNull()) {
            this.attachmentNumber = null;
        }
    }

    public static ReturnReceipt get(SendManagerSession sendManagerSession, long returnReceiptId) throws SQLException {
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("ReturnReceipt.get", "SELECT * FROM return_receipt WHERE id = ?;");){
            ReturnReceipt returnReceipt;
            block16: {
                ResultSet res;
                block14: {
                    ReturnReceipt returnReceipt2;
                    block15: {
                        statement.setLong(1, returnReceiptId);
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block14;
                            returnReceipt2 = new ReturnReceipt(sendManagerSession, res);
                            if (res == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return returnReceipt2;
                }
                returnReceipt = null;
                if (res == null) break block16;
                res.close();
            }
            return returnReceipt;
        }
    }

    public static ReturnReceipt[] getMany(SendManagerSession sendManagerSession, Long[] ids) throws SQLException {
        if (ids == null) {
            return null;
        }
        int count = ids.length;
        StringBuilder sb = new StringBuilder(count * 2);
        while (count-- > 1) {
            sb.append("?,");
        }
        sb.append("?");
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("ReturnReceipt.getMany", "SELECT * FROM return_receipt WHERE id IN (" + String.valueOf(sb) + ");");){
            ReturnReceipt[] returnReceiptArray;
            block16: {
                for (int i = 0; i < ids.length; ++i) {
                    statement.setLong(i + 1, ids[i]);
                }
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ReturnReceipt> list = new ArrayList<ReturnReceipt>();
                    while (res.next()) {
                        list.add(new ReturnReceipt(sendManagerSession, res));
                    }
                    returnReceiptArray = list.toArray(new ReturnReceipt[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return returnReceiptArray;
        }
    }

    public static ReturnReceipt[] getAll(SendManagerSession sendManagerSession) throws SQLException {
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("ReturnReceipt.getAll", "SELECT * FROM return_receipt;");){
            ReturnReceipt[] returnReceiptArray;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ReturnReceipt> list = new ArrayList<ReturnReceipt>();
                    while (res.next()) {
                        list.add(new ReturnReceipt(sendManagerSession, res));
                    }
                    returnReceiptArray = list.toArray(new ReturnReceipt[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return returnReceiptArray;
        }
    }

    public static void deleteAllForOwnedIdentity(SendManagerSession sendManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("ReturnReceipt.deleteAllForOwnedIdentity", "DELETE FROM return_receipt WHERE owned_identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS return_receipt (id INTEGER PRIMARY KEY, owned_identity BLOB NOT NULL, contact_identity BLOB NOT NULL, contact_device_uids BLOB NOT NULL, status INTEGER NOT NULL, nonce BLOB NOT NULL, key BLOB NOT NULL, attachment_number INTEGER);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 26 && newVersion >= 26) {
            try (Statement statement = session.createStatement();){
                statement.execute("ALTER TABLE return_receipt ADD COLUMN attachment_number INTEGER DEFAULT NULL");
            }
            oldVersion = 26;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("ReturnReceipt.insert", "INSERT INTO return_receipt(owned_identity, contact_identity, contact_device_uids, status, nonce, key, attachment_number) VALUES (?,?,?,?,?, ?,?);", true);){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, Encoded.of(this.contactDeviceUids).getBytes());
            statement.setInt(4, this.status);
            statement.setBytes(5, this.nonce);
            statement.setBytes(6, Encoded.of(this.key).getBytes());
            if (this.attachmentNumber != null) {
                statement.setInt(7, this.attachmentNumber);
            } else {
                statement.setNull(7, 4);
            }
            statement.executeUpdate();
            try (ResultSet res = statement.getGeneratedKeys();){
                if (res.next()) {
                    this.id = res.getLong(1);
                    this.commitHookBits |= 1L;
                    this.sendManagerSession.session.addSessionCommitListener(this);
                }
            }
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("ReturnReceipt.delete", "DELETE FROM return_receipt WHERE id = ?;");){
            statement.setLong(1, this.id);
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
        if ((this.commitHookBits & 1L) != 0L && this.sendManagerSession.newReturnReceiptListener != null) {
            this.sendManagerSession.newReturnReceiptListener.newReturnReceipt(this.contactIdentity.getServer(), this.ownedIdentity, this.id);
        }
    }

    public static interface NewReturnReceiptListener {
        public void newReturnReceipt(String var1, Identity var2, long var3);
    }
}

