/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.networksend.databases.MessageHeader;
import io.olvid.engine.networksend.databases.OutboxAttachment;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class OutboxMessage
implements ObvDatabase {
    static final String TABLE_NAME = "outbox_message";
    private final SendManagerSession sendManagerSession;
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private UID uid;
    static final String UID_ = "uid";
    private UID uidFromServer;
    static final String UID_FROM_SERVER = "uid_from_server";
    private byte[] nonce;
    static final String NONCE = "nonce";
    private String server;
    static final String SERVER = "server";
    private EncryptedBytes encryptedContent;
    static final String ENCRYPTED_CONTENT = "encrypted_content";
    private boolean isApplicationMessage;
    static final String IS_APPLICATION_MESSAGE = "is_application_message";
    private boolean isVoipMessage;
    static final String IS_VOIP_MESSAGE = "is_voip_message";
    private EncryptedBytes encryptedExtendedContent;
    static final String ENCRYPTED_EXTENDED_CONTENT = "encrypted_extended_content";
    private long creationTimestamp;
    static final String CREATION_TIMESTAMP = "creation_timestamp";
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERT = 1L;
    private static final long HOOK_BIT_ACKNOWLEDGED = 2L;
    private static final long HOOK_BIT_HAS_ATTACHMENTS = 4L;
    private long acknowledgedTimestampFromSever;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getUid() {
        return this.uid;
    }

    public UID getUidFromServer() {
        return this.uidFromServer;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public String getServer() {
        return this.server;
    }

    public EncryptedBytes getEncryptedContent() {
        return this.encryptedContent;
    }

    public EncryptedBytes getEncryptedExtendedContent() {
        return this.encryptedExtendedContent;
    }

    public MessageHeader[] getHeaders() {
        return MessageHeader.getAll(this.sendManagerSession, this.ownedIdentity, this.uid);
    }

    public OutboxAttachment[] getAttachments() {
        return OutboxAttachment.getAll(this.sendManagerSession, this.ownedIdentity, this.uid);
    }

    public boolean isAcknowledged() {
        return this.uidFromServer != null;
    }

    public boolean isApplicationMessage() {
        return this.isApplicationMessage;
    }

    public boolean isVoipMessage() {
        return this.isVoipMessage;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setUidFromServer(UID uidFromServer, byte[] nonce, long timestampFromServer) {
        if (this.uidFromServer != uidFromServer) {
            try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("OutboxMessage.setUidFromServer", "UPDATE outbox_message SET uid_from_server = ?, nonce = ?  WHERE owned_identity = ?  AND uid = ?;");){
                statement.setBytes(1, uidFromServer == null ? null : uidFromServer.getBytes());
                statement.setBytes(2, nonce);
                statement.setBytes(3, this.ownedIdentity.getBytes());
                statement.setBytes(4, this.uid.getBytes());
                statement.executeUpdate();
                this.uidFromServer = uidFromServer;
                this.nonce = nonce;
                this.acknowledgedTimestampFromSever = timestampFromServer;
                if (timestampFromServer != 0L) {
                    this.commitHookBits |= 2L;
                }
                this.sendManagerSession.session.addSessionCommitListener(this);
            }
            catch (SQLException e) {
                Logger.x(e);
            }
        }
    }

    public static OutboxMessage create(SendManagerSession sendManagerSession, Identity ownedIdentity, UID uid, String server, EncryptedBytes encryptedContent, EncryptedBytes encryptedExtendedContent, boolean isApplicationMessage, boolean isVoipMessage, boolean hasAttachments) {
        if (ownedIdentity == null || uid == null || server == null || encryptedContent == null) {
            return null;
        }
        try {
            OutboxMessage outboxMessage = new OutboxMessage(sendManagerSession, ownedIdentity, uid, server, encryptedContent, encryptedExtendedContent, isApplicationMessage, isVoipMessage);
            outboxMessage.insert();
            if (hasAttachments) {
                outboxMessage.commitHookBits |= 4L;
            }
            return outboxMessage;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private OutboxMessage(SendManagerSession sendManagerSession, ResultSet res) throws SQLException {
        this.sendManagerSession = sendManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
        this.uid = new UID(res.getBytes(UID_));
        byte[] bytes = res.getBytes(UID_FROM_SERVER);
        this.uidFromServer = bytes == null ? null : new UID(bytes);
        this.nonce = res.getBytes(NONCE);
        this.server = res.getString(SERVER);
        this.encryptedContent = new EncryptedBytes(res.getBytes(ENCRYPTED_CONTENT));
        this.isApplicationMessage = res.getBoolean(IS_APPLICATION_MESSAGE);
        this.isVoipMessage = res.getBoolean(IS_VOIP_MESSAGE);
        bytes = res.getBytes(ENCRYPTED_EXTENDED_CONTENT);
        this.encryptedExtendedContent = bytes == null ? null : new EncryptedBytes(bytes);
        this.creationTimestamp = res.getLong(CREATION_TIMESTAMP);
    }

    private OutboxMessage(SendManagerSession sendManagerSession, Identity ownedIdentity, UID uid, String server, EncryptedBytes encryptedContent, EncryptedBytes encryptedExtendedContent, boolean isApplicationMessage, boolean isVoipMessage) {
        this.sendManagerSession = sendManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.uid = uid;
        this.uidFromServer = null;
        this.nonce = null;
        this.server = server;
        this.encryptedContent = encryptedContent;
        this.isApplicationMessage = isApplicationMessage;
        this.isVoipMessage = isVoipMessage;
        this.encryptedExtendedContent = encryptedExtendedContent;
        this.creationTimestamp = System.currentTimeMillis();
    }

    public static OutboxMessage get(SendManagerSession sendManagerSession, Identity ownedIdentity, UID uid) throws SQLException {
        if (ownedIdentity == null || uid == null) {
            return null;
        }
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("OutboxMessage.get", "SELECT * FROM outbox_message WHERE owned_identity = ?  AND uid = ?;");){
            OutboxMessage outboxMessage;
            block17: {
                ResultSet res;
                block15: {
                    OutboxMessage outboxMessage2;
                    block16: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        statement.setBytes(2, uid.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            outboxMessage2 = new OutboxMessage(sendManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return outboxMessage2;
                }
                outboxMessage = null;
                if (res == null) break block17;
                res.close();
            }
            return outboxMessage;
        }
    }

    public static OutboxMessage[] getManyWithoutUidFromServer(SendManagerSession sendManagerSession, Identity ownedIdentity, String server, UID[] uids) throws SQLException {
        if (uids == null) {
            return null;
        }
        int count = uids.length;
        StringBuilder sb = new StringBuilder(count * 2);
        while (count-- > 1) {
            sb.append("?,");
        }
        sb.append("?");
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("OutboxMessage.getManyWithoutUidFromServer", "SELECT * FROM outbox_message WHERE owned_identity = ?  AND server = ?  AND uid_from_server IS NULL  AND uid IN (" + String.valueOf(sb) + ");");){
            OutboxMessage[] outboxMessageArray;
            block16: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setString(2, server);
                for (int i = 0; i < uids.length; ++i) {
                    statement.setBytes(i + 3, uids[i].getBytes());
                }
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<OutboxMessage> list = new ArrayList<OutboxMessage>();
                    while (res.next()) {
                        list.add(new OutboxMessage(sendManagerSession, res));
                    }
                    outboxMessageArray = list.toArray(new OutboxMessage[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return outboxMessageArray;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static OutboxMessage[] getAll(SendManagerSession sendManagerSession) {
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("OutboxMessage.getAll", "SELECT * FROM outbox_message;");){
            OutboxMessage[] outboxMessageArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<OutboxMessage> list = new ArrayList<OutboxMessage>();
                    while (res.next()) {
                        list.add(new OutboxMessage(sendManagerSession, res));
                    }
                    outboxMessageArray = list.toArray(new OutboxMessage[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return outboxMessageArray;
        }
        catch (SQLException e) {
            Logger.x(e);
            return new OutboxMessage[0];
        }
    }

    public static OutboxMessage[] getAllForOwnedIdentity(SendManagerSession sendManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("OutboxMessage.getAllForOwnedIdentity", "SELECT * FROM outbox_message WHERE owned_identity = ?;");){
            OutboxMessage[] outboxMessageArray;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<OutboxMessage> list = new ArrayList<OutboxMessage>();
                    while (res.next()) {
                        list.add(new OutboxMessage(sendManagerSession, res));
                    }
                    outboxMessageArray = list.toArray(new OutboxMessage[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return outboxMessageArray;
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS outbox_message (owned_identity BLOB NOT NULL, uid BLOB NOT NULL, uid_from_server BLOB, nonce BLOB, server TEXT NOT NULL, encrypted_content BLOB NOT NULL, is_application_message BIT NOT NULL, is_voip_message BIT NOT NULL, encrypted_extended_content BLOB, creation_timestamp BIGINT NOT NULL, CONSTRAINT PK_outbox_message PRIMARY KEY(owned_identity, uid));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 3 && newVersion >= 3) {
            Logger.d("MIGRATING `outbox_message` DATABASE FROM VERSION " + oldVersion + " TO 3\n!!!! THIS MIGRATION IS DESTRUCTIVE !!!!");
            statement = session.createStatement();
            try {
                statement.execute("DROP TABLE IF EXISTS `outbox_message`;");
                statement.execute("CREATE TABLE IF NOT EXISTS outbox_message (uid BLOB PRIMARY KEY, uid_from_server BLOB, server TEXT NOT NULL, encrypted_content BLOB NOT NULL, proof_of_work_uid BLOB, proof_of_work_encoded_challenge BLOB, proof_of_work_encoded_solution BLOB);");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 3;
        }
        if (oldVersion < 7 && newVersion >= 7) {
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE outbox_message ADD COLUMN is_application_message BIT NOT NULL DEFAULT 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 7;
        }
        if (oldVersion < 15 && newVersion >= 15) {
            Logger.d("MIGRATING `outbox_message` DATABASE FROM VERSION " + oldVersion + " TO 15");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE outbox_message RENAME TO old_outbox_message");
                statement.execute("CREATE TABLE IF NOT EXISTS outbox_message (owned_identity BLOB NOT NULL, uid BLOB NOT NULL, uid_from_server BLOB, nonce BLOB, server TEXT NOT NULL, encrypted_content BLOB NOT NULL, proof_of_work_uid BLOB, proof_of_work_encoded_challenge BLOB, proof_of_work_encoded_solution BLOB,is_application_message BIT NOT NULL,CONSTRAINT PK_outbox_message PRIMARY KEY(owned_identity, uid));");
                statement.execute("INSERT INTO outbox_message SELECT i.identity, m.uid, m.uid_from_server, 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa', m.server, m.encrypted_content, m.proof_of_work_uid, m.proof_of_work_encoded_challenge, m.proof_of_work_encoded_solution, m.is_application_message FROM old_outbox_message AS m CROSS JOIN owned_identity AS i");
                statement.execute("DROP TABLE old_outbox_message");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 15;
        }
        if (oldVersion < 17 && newVersion >= 17) {
            Logger.d("MIGRATING `outbox_message` DATABASE FROM VERSION " + oldVersion + " TO 17");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE outbox_message RENAME TO old_outbox_message");
                statement.execute("CREATE TABLE IF NOT EXISTS outbox_message (owned_identity BLOB NOT NULL, uid BLOB NOT NULL, uid_from_server BLOB, nonce BLOB, server TEXT NOT NULL, encrypted_content BLOB NOT NULL, proof_of_work_uid BLOB, proof_of_work_encoded_challenge BLOB, proof_of_work_encoded_solution BLOB,is_application_message BIT NOT NULL,is_voip_message BIT NOT NULL,CONSTRAINT PK_outbox_message PRIMARY KEY(owned_identity, uid));");
                statement.execute("INSERT INTO outbox_message SELECT owned_identity, uid, uid_from_server, nonce, server, encrypted_content, proof_of_work_uid, proof_of_work_encoded_challenge, proof_of_work_encoded_solution, is_application_message, 0  FROM old_outbox_message");
                statement.execute("DROP TABLE old_outbox_message");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 17;
        }
        if (oldVersion < 22 && newVersion >= 22) {
            Logger.d("MIGRATING `outbox_message` DATABASE FROM VERSION " + oldVersion + " TO 22");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE outbox_message ADD COLUMN `encrypted_extended_content` BLOB DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 22;
        }
        if (oldVersion < 29 && newVersion >= 29) {
            Logger.d("MIGRATING `outbox_message` DATABASE FROM VERSION " + oldVersion + " TO 29");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE outbox_message RENAME TO old_outbox_message");
                statement.execute("CREATE TABLE outbox_message (owned_identity BLOB NOT NULL, uid BLOB NOT NULL, uid_from_server BLOB, nonce BLOB, server TEXT NOT NULL, encrypted_content BLOB NOT NULL, is_application_message BIT NOT NULL,is_voip_message BIT NOT NULL,encrypted_extended_content BLOB,creation_timestamp BIGINT NOT NULL,CONSTRAINT PK_outbox_message PRIMARY KEY(owned_identity, uid));");
                try (PreparedStatement preparedStatement = session.prepareStatement("INSERT INTO outbox_message SELECT m.owned_identity, m.uid, m.uid_from_server, m.nonce, m.server, m.encrypted_content, m.is_application_message, m.is_voip_message, m.encrypted_extended_content, ?  FROM old_outbox_message AS m");){
                    preparedStatement.setLong(1, System.currentTimeMillis());
                    preparedStatement.executeUpdate();
                }
                statement.execute("DROP TABLE old_outbox_message");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 29;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("OutboxMessage.insert", "INSERT INTO outbox_message VALUES(?,?,?,?,?, ?,?,?,?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.uid.getBytes());
            statement.setBytes(3, this.uidFromServer == null ? null : this.uidFromServer.getBytes());
            statement.setBytes(4, this.nonce);
            statement.setString(5, this.server);
            statement.setBytes(6, this.encryptedContent.getBytes());
            statement.setBoolean(7, this.isApplicationMessage);
            statement.setBoolean(8, this.isVoipMessage);
            statement.setBytes(9, this.encryptedExtendedContent == null ? null : this.encryptedExtendedContent.getBytes());
            statement.setLong(10, this.creationTimestamp);
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.sendManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        MessageHeader.deleteAll(this.sendManagerSession, this.ownedIdentity, this.uid);
        OutboxAttachment.deleteAll(this.sendManagerSession, this.ownedIdentity, this.uid);
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("OutboxMessage.delete", "DELETE FROM outbox_message WHERE owned_identity = ?  AND uid = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.uid.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
        if ((this.commitHookBits & 1L) != 0L && this.sendManagerSession.newOutboxMessageListener != null) {
            this.sendManagerSession.newOutboxMessageListener.newMessageToSend(this.server, this.ownedIdentity, this.uid, (this.commitHookBits & 4L) != 0L, this.isApplicationMessage);
        }
        if ((this.commitHookBits & 2L) != 0L) {
            for (OutboxAttachment outboxAttachment : this.getAttachments()) {
                outboxAttachment.messageIsAcknowledged();
            }
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("ownedIdentity", this.ownedIdentity);
            userInfo.put(UID_, this.uid);
            userInfo.put("timestamp_from_server", this.acknowledgedTimestampFromSever);
            if (this.sendManagerSession.notificationPostingDelegate != null) {
                this.sendManagerSession.notificationPostingDelegate.postNotification("network_send_notification_message_uploaded", userInfo);
            }
        }
        this.commitHookBits = 0L;
    }

    public static interface NewOutboxMessageListener {
        public void newMessageToSend(String var1, Identity var2, UID var3, boolean var4, boolean var5);
    }
}

