/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Chunk;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OutboxAttachment
implements ObvDatabase {
    static final String TABLE_NAME = "outbox_attachment";
    private final SendManagerSession sendManagerSession;
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private UID messageUid;
    static final String MESSAGE_UID = "message_uid";
    private int attachmentNumber;
    static final String ATTACHMENT_NUMBER = "attachment_number";
    private String url;
    static final String URL = "url";
    private boolean deleteAfterSend;
    static final String DELETE_AFTER_SEND = "delete_after_send";
    private long attachmentLength;
    static final String ATTACHMENT_LENGTH = "attachment_length";
    private AuthEncKey key;
    static final String KEY = "key";
    private int acknowledgedChunkCount;
    static final String ACKNOWLEDGED_CHUNK_COUNT = "acknowledged_chunk_count";
    private boolean acknowledged;
    static final String ACKNOWLEDGED = "acknowledged";
    private int ciphertextChunkLength;
    static final String CIPHERTEXT_CHUNK_LENGTH = "ciphertext_chunk_length";
    private boolean cancelExternallyRequested;
    static final String CANCEL_EXTERNALLY_REQUESTED = "cancel_externally_requested";
    private String chunkUploadPrivateUrls;
    static final String CHUNK_UPLOAD_PRIVATE_URLS = "chunk_upload_private_urls";
    private int attachmentChunkLength = 0;
    private int numberOfChunks = 0;
    private long ciphertextLength = 0L;
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_PROGRESS = 1L;
    private static final long HOOK_BIT_FINISHED = 2L;
    private static final long HOOK_BIT_CANCEL_REQUESTED = 4L;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    public int getAttachmentNumber() {
        return this.attachmentNumber;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean shouldBeDeletedAfterSend() {
        return this.deleteAfterSend;
    }

    public long getAttachmentLength() {
        return this.attachmentLength;
    }

    public AuthEncKey getKey() {
        return this.key;
    }

    public int getAcknowledgedChunkCount() {
        return this.acknowledgedChunkCount;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public int getCiphertextChunkLength() {
        return this.ciphertextChunkLength;
    }

    public boolean isCancelExternallyRequested() {
        return this.cancelExternallyRequested;
    }

    public String[] getChunkUploadPrivateUrls() {
        if (this.chunkUploadPrivateUrls == null) {
            return new String[0];
        }
        return this.chunkUploadPrivateUrls.split("\u00a6", -1);
    }

    public static UID computeUniqueUid(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        Hash sha256 = Suite.getHash("sha-256");
        byte[] input = new byte[ownedIdentity.getBytes().length + 32 + 8 + 5];
        System.arraycopy(ownedIdentity.getBytes(), 0, input, 0, ownedIdentity.getBytes().length);
        System.arraycopy(messageUid.getBytes(), 0, input, ownedIdentity.getBytes().length, 32);
        System.arraycopy(Encoded.of(attachmentNumber).getBytes(), 0, input, ownedIdentity.getBytes().length + 32, 13);
        return new UID(sha256.digest(input));
    }

    public int getCleartextChunkLength() {
        if (this.attachmentChunkLength == 0) {
            AuthEnc authEnc = Suite.getAuthEnc(this.key);
            this.attachmentChunkLength = Chunk.lengthOfInnerDataFromLengthOfEncodedChunk(authEnc.plaintextLengthFromCiphertextLength(this.ciphertextChunkLength));
        }
        return this.attachmentChunkLength;
    }

    public int getNumberOfChunks() {
        if (this.numberOfChunks == 0) {
            this.numberOfChunks = 1 + (int)((this.attachmentLength - 1L) / (long)this.getCleartextChunkLength());
        }
        return this.numberOfChunks;
    }

    public long getCiphertextLength() {
        if (this.ciphertextLength == 0L) {
            AuthEnc authEnc = Suite.getAuthEnc(this.key);
            int lastChunkLength = (int)(this.attachmentLength - (long)(this.getNumberOfChunks() - 1) * (long)this.getCleartextChunkLength());
            this.ciphertextLength = (long)(this.getNumberOfChunks() - 1) * (long)this.ciphertextChunkLength + (long)authEnc.ciphertextLengthFromPlaintextLength(Chunk.lengthOfEncodedChunkFromLengthOfInnerData(lastChunkLength));
        }
        return this.ciphertextLength;
    }

    public long getRemainingByteCountToSend() {
        long remaining = this.getCiphertextLength() - (long)this.ciphertextChunkLength * (long)this.acknowledgedChunkCount;
        if (remaining < 0L) {
            return 0L;
        }
        return remaining;
    }

    public long getPriority() {
        return this.getRemainingByteCountToSend();
    }

    public void setCancelExternallyRequested() throws SQLException {
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("OutboxAttachment.setCancelExternallyRequested", "UPDATE outbox_attachment SET cancel_externally_requested = 1  WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.messageUid.getBytes());
            statement.setInt(3, this.attachmentNumber);
            statement.executeUpdate();
            this.cancelExternallyRequested = true;
            this.commitHookBits |= 4L;
            this.sendManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void setCancelProcessed() throws SQLException {
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("OutboxAttachment.setCancelProcessed", "UPDATE outbox_attachment SET acknowledged = 1  WHERE cancel_externally_requested = 1  AND owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.messageUid.getBytes());
            statement.setInt(3, this.attachmentNumber);
            statement.executeUpdate();
            this.acknowledged = true;
        }
    }

    public void setAcknowledgedChunkCount(int acknowledgedChunkCount) {
        if (acknowledgedChunkCount < this.acknowledgedChunkCount) {
            return;
        }
        Object sqlQueryString = "UPDATE outbox_attachment SET ";
        if (acknowledgedChunkCount > this.acknowledgedChunkCount) {
            this.commitHookBits |= 1L;
            this.sendManagerSession.session.addSessionCommitListener(this);
        }
        if (acknowledgedChunkCount == this.getNumberOfChunks()) {
            sqlQueryString = (String)sqlQueryString + "acknowledged = 1, ";
            this.commitHookBits |= 2L;
            this.sendManagerSession.session.addSessionCommitListener(this);
        }
        sqlQueryString = (String)sqlQueryString + "acknowledged_chunk_count = ?  WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;";
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("OutboxAttachment.setAcknowledgedChunkCount", (String)sqlQueryString);){
            statement.setLong(1, acknowledgedChunkCount);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.messageUid.getBytes());
            statement.setInt(4, this.attachmentNumber);
            statement.executeUpdate();
            if (acknowledgedChunkCount == this.getNumberOfChunks()) {
                this.acknowledged = true;
            }
            this.acknowledgedChunkCount = acknowledgedChunkCount;
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    public void setChunkUploadPrivateUrls(String[] chunkUploadPrivateUrls) {
        String serialized;
        if (chunkUploadPrivateUrls == null || chunkUploadPrivateUrls.length == 0) {
            serialized = null;
        } else {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String chunkUploadPrivateUrl : chunkUploadPrivateUrls) {
                if (!first) {
                    sb.append("\u00a6");
                }
                first = false;
                sb.append(chunkUploadPrivateUrl);
            }
            serialized = sb.toString();
        }
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("OutboxAttachment.setChunkUploadPrivateUrls", "UPDATE outbox_attachment SET chunk_upload_private_urls = ?  WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");){
            statement.setString(1, serialized);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.messageUid.getBytes());
            statement.setInt(4, this.attachmentNumber);
            statement.executeUpdate();
            this.chunkUploadPrivateUrls = serialized;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static OutboxAttachment create(SendManagerSession session, Identity ownedIdentity, UID messageUid, int attachmentNumber, String url, boolean deleteAfterSend, long attachmentLength, AuthEncKey key) {
        if (ownedIdentity == null || messageUid == null || url == null || key == null) {
            return null;
        }
        try {
            OutboxAttachment outboxAttachment = new OutboxAttachment(session, ownedIdentity, messageUid, attachmentNumber, url, deleteAfterSend, attachmentLength, key);
            outboxAttachment.insert();
            return outboxAttachment;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private OutboxAttachment(SendManagerSession sendManagerSession, Identity ownedIdentity, UID messageUid, int attachmentNumber, String url, boolean deleteAfterSend, long attachmentLength, AuthEncKey key) {
        this.sendManagerSession = sendManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.messageUid = messageUid;
        this.attachmentNumber = attachmentNumber;
        this.url = url;
        this.deleteAfterSend = deleteAfterSend;
        this.attachmentLength = attachmentLength;
        this.key = key;
        this.acknowledgedChunkCount = 0;
        this.acknowledged = false;
        this.ciphertextChunkLength = 0x800000;
        this.cancelExternallyRequested = false;
        this.chunkUploadPrivateUrls = null;
    }

    private OutboxAttachment(SendManagerSession sendManagerSession, ResultSet res) throws SQLException {
        this.sendManagerSession = sendManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
        this.messageUid = new UID(res.getBytes(MESSAGE_UID));
        this.attachmentNumber = res.getInt(ATTACHMENT_NUMBER);
        this.url = res.getString(URL);
        this.deleteAfterSend = res.getBoolean(DELETE_AFTER_SEND);
        this.attachmentLength = res.getLong(ATTACHMENT_LENGTH);
        try {
            this.key = (AuthEncKey)new Encoded(res.getBytes(KEY)).decodeSymmetricKey();
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
        this.acknowledgedChunkCount = res.getInt(ACKNOWLEDGED_CHUNK_COUNT);
        this.acknowledged = res.getBoolean(ACKNOWLEDGED);
        this.ciphertextChunkLength = res.getInt(CIPHERTEXT_CHUNK_LENGTH);
        this.cancelExternallyRequested = res.getBoolean(CANCEL_EXTERNALLY_REQUESTED);
        this.chunkUploadPrivateUrls = res.getString(CHUNK_UPLOAD_PRIVATE_URLS);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS outbox_attachment (owned_identity BLOB NOT NULL, message_uid BLOB NOT NULL, attachment_number INT NOT NULL, url TEXT NOT NULL, delete_after_send BIT NOT NULL, attachment_length BIGINT NOT NULL, key BLOB NOT NULL, acknowledged_chunk_count INT NOT NULL, acknowledged BIT NOT NULL, ciphertext_chunk_length INT NOT NULL, cancel_externally_requested BIT NOT NULL, chunk_upload_private_urls TEXT, CONSTRAINT PK_outbox_attachment PRIMARY KEY(owned_identity, message_uid, attachment_number), FOREIGN KEY (owned_identity, message_uid) REFERENCES outbox_message(owned_identity, uid));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 13 && newVersion >= 13) {
            Logger.d("MIGRATING `outbox_attachment` DATABASE FROM VERSION " + oldVersion + " TO 13");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE outbox_attachment ADD COLUMN chunk_upload_private_urls TEXT DEFAULT NULL;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 13;
        }
        if (oldVersion < 15 && newVersion >= 15) {
            Logger.d("MIGRATING `outbox_attachment` DATABASE FROM VERSION " + oldVersion + " TO 15");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE outbox_attachment RENAME TO old_outbox_attachment");
                statement.execute("CREATE TABLE IF NOT EXISTS outbox_attachment (owned_identity BLOB NOT NULL, message_uid BLOB NOT NULL, attachment_number INT NOT NULL, url TEXT NOT NULL, delete_after_send BIT NOT NULL, attachment_length BIGINT NOT NULL, key BLOB NOT NULL, acknowledged_chunk_count INT NOT NULL, acknowledged BIT NOT NULL, ciphertext_chunk_length INT NOT NULL, cancel_externally_requested BIT NOT NULL, chunk_upload_private_urls TEXT, CONSTRAINT PK_outbox_attachment PRIMARY KEY(owned_identity, message_uid, attachment_number), FOREIGN KEY (owned_identity, message_uid) REFERENCES outbox_message(owned_identity, uid));");
                statement.execute("INSERT INTO outbox_attachment SELECT i.identity, a.message_uid, a.attachment_number, a.url, a.delete_after_send, a.attachment_length, a.key, a.acknowledged_chunk_count, a.acknowledged, a.ciphertext_chunk_length, a.cancel_externally_requested, a.chunk_upload_private_urls FROM old_outbox_attachment AS a CROSS JOIN owned_identity AS i");
                statement.execute("DROP TABLE old_outbox_attachment");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 15;
        }
        if (oldVersion < 16 && newVersion >= 16) {
            Logger.d("MIGRATING `outbox_attachment` DATABASE FROM VERSION " + oldVersion + " TO 16");
            Pattern pattern = Pattern.compile("^.*/(fyles/[0-9A-F]+$)");
            try (Statement statement2 = session.createStatement();
                 PreparedStatement updateStatement = session.prepareStatement("UPDATE outbox_attachment  SET url = ?  WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?");
                 ResultSet res = statement2.executeQuery("SELECT * FROM outbox_attachment");){
                while (res.next()) {
                    String oldUrl = res.getString(URL);
                    Matcher m = pattern.matcher(oldUrl);
                    String newUrl = "";
                    if (m.find()) {
                        newUrl = m.group(1);
                    }
                    updateStatement.setString(1, newUrl);
                    updateStatement.setBytes(2, res.getBytes(OWNED_IDENTITY));
                    updateStatement.setBytes(3, res.getBytes(MESSAGE_UID));
                    updateStatement.setInt(4, res.getInt(ATTACHMENT_NUMBER));
                    updateStatement.executeUpdate();
                }
            }
            oldVersion = 16;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("OutboxAttachment.insert", "INSERT INTO outbox_attachment VALUES (?,?,?,?,?, ?,?,?,?,?, ?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.messageUid.getBytes());
            statement.setInt(3, this.attachmentNumber);
            statement.setString(4, this.url);
            statement.setBoolean(5, this.deleteAfterSend);
            statement.setLong(6, this.attachmentLength);
            statement.setBytes(7, Encoded.of(this.key).getBytes());
            statement.setInt(8, this.acknowledgedChunkCount);
            statement.setBoolean(9, this.acknowledged);
            statement.setInt(10, this.ciphertextChunkLength);
            statement.setBoolean(11, this.cancelExternallyRequested);
            statement.setString(12, this.chunkUploadPrivateUrls);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.sendManagerSession.session.prepareStatement("OutboxAttachment.delete", "DELETE FROM outbox_attachment WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.messageUid.getBytes());
            statement.setInt(3, this.attachmentNumber);
            statement.executeUpdate();
        }
    }

    static void deleteAll(SendManagerSession sendManagerSession, Identity ownedIdentity, UID messageUid) throws SQLException {
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("OutboxAttachment.deleteAll", "DELETE FROM outbox_attachment WHERE owned_identity = ?  AND message_uid = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.setBytes(2, messageUid.getBytes());
            statement.executeUpdate();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static OutboxAttachment[] getAll(SendManagerSession sendManagerSession, Identity ownedIdentity, UID messageUid) {
        if (ownedIdentity == null || messageUid == null) {
            return null;
        }
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("OutboxAttachment.getAll", "SELECT * FROM outbox_attachment WHERE owned_identity = ?  AND message_uid = ?  ORDER BY attachment_number ASC;");){
            OutboxAttachment[] outboxAttachmentArray;
            block16: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, messageUid.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<OutboxAttachment> list = new ArrayList<OutboxAttachment>();
                    while (res.next()) {
                        list.add(new OutboxAttachment(sendManagerSession, res));
                    }
                    outboxAttachmentArray = list.toArray(new OutboxAttachment[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return outboxAttachmentArray;
        }
        catch (SQLException e) {
            return new OutboxAttachment[0];
        }
    }

    public static OutboxAttachment get(SendManagerSession sendManagerSession, Identity ownedIdentity, UID messageUid, int attachmentNumber) throws SQLException {
        if (ownedIdentity == null || messageUid == null) {
            return null;
        }
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("OutboxAttachment.get", "SELECT * FROM outbox_attachment WHERE owned_identity = ?  AND message_uid = ?  AND attachment_number = ?;");){
            OutboxAttachment outboxAttachment;
            block17: {
                ResultSet res;
                block15: {
                    OutboxAttachment outboxAttachment2;
                    block16: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        statement.setBytes(2, messageUid.getBytes());
                        statement.setInt(3, attachmentNumber);
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            outboxAttachment2 = new OutboxAttachment(sendManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return outboxAttachment2;
                }
                outboxAttachment = null;
                if (res == null) break block17;
                res.close();
            }
            return outboxAttachment;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static OutboxAttachment[] getAllToCancel(SendManagerSession sendManagerSession) {
        try (PreparedStatement statement = sendManagerSession.session.prepareStatement("OutboxAttachment.getAllToCancel", "SELECT * FROM outbox_attachment WHERE cancel_externally_requested = 1  AND acknowledged = 0");){
            OutboxAttachment[] outboxAttachmentArray;
            block15: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<OutboxAttachment> list = new ArrayList<OutboxAttachment>();
                    while (res.next()) {
                        list.add(new OutboxAttachment(sendManagerSession, res));
                    }
                    outboxAttachmentArray = list.toArray(new OutboxAttachment[0]);
                    if (res == null) break block15;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return outboxAttachmentArray;
        }
        catch (SQLException e) {
            return new OutboxAttachment[0];
        }
    }

    @Override
    public void wasCommitted() {
        if ((this.commitHookBits & 2L) != 0L) {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("ownedIdentity", this.ownedIdentity);
            userInfo.put("messageUid", this.messageUid);
            userInfo.put("attachmentNumber", this.attachmentNumber);
            if (this.sendManagerSession.notificationPostingDelegate != null) {
                this.sendManagerSession.notificationPostingDelegate.postNotification("network_send_notification_attachment_upload_finished", userInfo);
            }
        } else if ((this.commitHookBits & 1L) != 0L) {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("ownedIdentity", this.ownedIdentity);
            userInfo.put("messageUid", this.messageUid);
            userInfo.put("attachmentNumber", this.attachmentNumber);
            userInfo.put("progress", Float.valueOf((float)this.acknowledgedChunkCount * (float)this.ciphertextChunkLength / (float)this.getCiphertextLength()));
            if (this.sendManagerSession.notificationPostingDelegate != null) {
                this.sendManagerSession.notificationPostingDelegate.postNotification("network_send_notification_attachment_upload_progress", userInfo);
            }
        } else if ((this.commitHookBits & 4L) != 0L) {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("ownedIdentity", this.ownedIdentity);
            userInfo.put("messageUid", this.messageUid);
            userInfo.put("attachmentNumber", this.attachmentNumber);
            if (this.sendManagerSession.notificationPostingDelegate != null) {
                this.sendManagerSession.notificationPostingDelegate.postNotification("network_send_notification_attachment_upload_cancelled", userInfo);
            }
            if (this.sendManagerSession.outboxAttachmentCancelRequestedListener != null) {
                this.sendManagerSession.outboxAttachmentCancelRequestedListener.outboxAttachmentCancelRequested(this.ownedIdentity, this.messageUid, this.attachmentNumber);
            }
        }
        this.commitHookBits = 0L;
    }

    void messageIsAcknowledged() {
        if (!this.acknowledged) {
            if (this.cancelExternallyRequested) {
                if (this.sendManagerSession.outboxAttachmentCancelRequestedListener != null) {
                    this.sendManagerSession.outboxAttachmentCancelRequestedListener.outboxAttachmentCancelRequested(this.ownedIdentity, this.messageUid, this.attachmentNumber);
                }
            } else if (this.sendManagerSession.outboxAttachmentCanBeSentListener != null) {
                this.sendManagerSession.outboxAttachmentCanBeSentListener.outboxAttachmentCanBeSent(this.ownedIdentity, this.messageUid, this.attachmentNumber, this.getPriority());
            }
        }
    }

    public static interface OutboxAttachmentCancelRequestedListener {
        public void outboxAttachmentCancelRequested(Identity var1, UID var2, int var3);
    }

    public static interface OutboxAttachmentCanBeSentListener {
        public void outboxAttachmentCanBeSent(Identity var1, UID var2, int var3, long var4);
    }
}

