/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.containers.IdentityAndLong;
import io.olvid.engine.datatypes.containers.StringAndLong;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.networksend.databases.ReturnReceipt;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.UploadReturnReceiptOperation;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class SendReturnReceiptCoordinator
implements ReturnReceipt.NewReturnReceiptListener,
Operation.OnCancelCallback,
Operation.OnFinishCallback {
    private final SendManagerSessionFactory sendManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private NotificationListeningDelegate notificationListeningDelegate;
    private final PRNGService prng;
    private final HashMap<String, Queue<IdentityAndLong>> returnReceiptOwnedIdentityAndIdByServer;
    private final NoDuplicateOperationQueue sendReturnReceiptOperationQueue;
    private final ExponentialBackoffRepeatingScheduler<String> scheduler;
    private final HashMap<Identity, List<StringAndLong>> awaitingIdentityReactivationOperations;
    private final Lock awaitingIdentityReactivationOperationsLock;
    private final NotificationListener notificationListener;

    public SendReturnReceiptCoordinator(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, PRNGService prng, int threadCount) {
        this.sendManagerSessionFactory = sendManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.prng = prng;
        this.returnReceiptOwnedIdentityAndIdByServer = new HashMap();
        this.sendReturnReceiptOperationQueue = new NoDuplicateOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.awaitingIdentityReactivationOperations = new HashMap();
        this.awaitingIdentityReactivationOperationsLock = new ReentrantLock();
        this.notificationListener = new NotificationListener();
    }

    public void startProcessing() {
        this.sendReturnReceiptOperationQueue.execute(1, "Engine-SendReturnReceiptCoordinator");
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("identity_manager_notification_owned_identity_changed_active_status", this.notificationListener);
    }

    public void initialQueueing() {
        try (SendManagerSession sendManagerSession = this.sendManagerSessionFactory.getSession();){
            ReturnReceipt[] returnReceipts;
            for (ReturnReceipt returnReceipt : returnReceipts = ReturnReceipt.getAll(sendManagerSession)) {
                this.queueNewSendReturnReceiptOperation(returnReceipt.getContactIdentity().getServer(), returnReceipt.getOwnedIdentity(), returnReceipt.getId());
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNewSendReturnReceiptOperation(String server, Identity ownedIdentity, long returnReceiptId) {
        if (ownedIdentity != null) {
            HashMap<String, Queue<IdentityAndLong>> hashMap = this.returnReceiptOwnedIdentityAndIdByServer;
            synchronized (hashMap) {
                Queue<IdentityAndLong> queue = this.returnReceiptOwnedIdentityAndIdByServer.get(server);
                if (queue == null) {
                    queue = new ArrayDeque<IdentityAndLong>();
                    this.returnReceiptOwnedIdentityAndIdByServer.put(server, queue);
                }
                queue.add(new IdentityAndLong(ownedIdentity, returnReceiptId));
            }
        }
        UploadReturnReceiptOperation op = new UploadReturnReceiptOperation(this.sendManagerSessionFactory, this.sslSocketFactory, this.userAgentOverride, server, () -> {
            ArrayList<IdentityAndLong> returnReceiptOwnedIdentityAndId = new ArrayList<IdentityAndLong>();
            HashMap<String, Queue<IdentityAndLong>> hashMap = this.returnReceiptOwnedIdentityAndIdByServer;
            synchronized (hashMap) {
                Queue<IdentityAndLong> queue = this.returnReceiptOwnedIdentityAndIdByServer.get(server);
                if (queue != null && !queue.isEmpty()) {
                    do {
                        returnReceiptOwnedIdentityAndId.add(queue.remove());
                    } while (returnReceiptOwnedIdentityAndId.size() != 50 && !queue.isEmpty());
                }
            }
            return returnReceiptOwnedIdentityAndId.toArray(new IdentityAndLong[0]);
        }, this, this);
        this.sendReturnReceiptOperationQueue.queue(op);
    }

    private void scheduleNewSendReturnReceiptOperation(String server) {
        this.scheduler.schedule(server, () -> this.queueNewSendReturnReceiptOperation(server, null, 0L), "UploadReturnReceiptOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    private void waitForIdentityReactivation(Identity ownedIdentity, String server, long id) {
        this.awaitingIdentityReactivationOperationsLock.lock();
        List<StringAndLong> list = this.awaitingIdentityReactivationOperations.get(ownedIdentity);
        if (list == null) {
            list = new ArrayList<StringAndLong>();
            this.awaitingIdentityReactivationOperations.put(ownedIdentity, list);
        }
        list.add(new StringAndLong(server, id));
        this.awaitingIdentityReactivationOperationsLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFinishCallback(Operation operation) {
        String server = ((UploadReturnReceiptOperation)operation).getServer();
        List<IdentityAndLong> identityInactiveReturnReceiptIds = ((UploadReturnReceiptOperation)operation).getIdentityInactiveReturnReceiptIds();
        this.scheduler.clearFailedCount(server);
        HashMap<String, Queue<IdentityAndLong>> hashMap = this.returnReceiptOwnedIdentityAndIdByServer;
        synchronized (hashMap) {
            Queue<IdentityAndLong> queue = this.returnReceiptOwnedIdentityAndIdByServer.get(server);
            if (queue != null && !queue.isEmpty()) {
                this.queueNewSendReturnReceiptOperation(server, null, 0L);
            }
        }
        for (IdentityAndLong identityAndLong : identityInactiveReturnReceiptIds) {
            this.waitForIdentityReactivation(identityAndLong.identity, server, identityAndLong.lng);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCancelCallback(Operation operation) {
        String server = ((UploadReturnReceiptOperation)operation).getServer();
        IdentityAndLong[] returnReceiptOwnedIdentitiesAndIds = ((UploadReturnReceiptOperation)operation).getReturnReceiptOwnedIdentitiesAndIds();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("UploadReturnReceiptOperation cancelled for reason " + rfc);
        if (returnReceiptOwnedIdentitiesAndIds != null) {
            HashMap<String, Queue<IdentityAndLong>> hashMap = this.returnReceiptOwnedIdentityAndIdByServer;
            synchronized (hashMap) {
                Queue<IdentityAndLong> queue = this.returnReceiptOwnedIdentityAndIdByServer.get(server);
                if (queue == null) {
                    queue = new ArrayDeque<IdentityAndLong>();
                    this.returnReceiptOwnedIdentityAndIdByServer.put(server, queue);
                }
                queue.addAll(Arrays.asList(returnReceiptOwnedIdentitiesAndIds));
            }
        }
        this.scheduleNewSendReturnReceiptOperation(server);
    }

    @Override
    public void newReturnReceipt(String server, Identity ownedIdentity, long returnReceiptId) {
        this.queueNewSendReturnReceiptOperation(server, ownedIdentity, returnReceiptId);
    }

    class NotificationListener
    implements io.olvid.engine.datatypes.NotificationListener {
        NotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            if ("identity_manager_notification_owned_identity_changed_active_status".equals(notificationName)) {
                boolean active = (Boolean)userInfo.get("active");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (!active) {
                    return;
                }
                SendReturnReceiptCoordinator.this.awaitingIdentityReactivationOperationsLock.lock();
                List<StringAndLong> list = SendReturnReceiptCoordinator.this.awaitingIdentityReactivationOperations.get(ownedIdentity);
                if (list != null) {
                    SendReturnReceiptCoordinator.this.awaitingIdentityReactivationOperations.remove(ownedIdentity);
                    for (StringAndLong serverAndId : list) {
                        if (serverAndId == null) continue;
                        SendReturnReceiptCoordinator.this.queueNewSendReturnReceiptOperation(serverAndId.string, ownedIdentity, serverAndId.lng);
                    }
                }
                SendReturnReceiptCoordinator.this.awaitingIdentityReactivationOperationsLock.unlock();
            }
        }
    }

    public static interface ReturnReceiptBatchProvider {
        public IdentityAndLong[] getBatchOFReturnReceiptIds();
    }
}

