/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.PriorityOperation;
import io.olvid.engine.datatypes.PriorityOperationQueue;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUidAndNumber;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.networksend.coordinators.RefreshOutboxAttachmentSignedUrlCoordinator;
import io.olvid.engine.networksend.databases.OutboxAttachment;
import io.olvid.engine.networksend.databases.OutboxMessage;
import io.olvid.engine.networksend.datatypes.RefreshOutboxAttachmentSignedUrlDelegate;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.UploadAttachmentCompositeOperation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class SendAttachmentCoordinator
implements OutboxAttachment.OutboxAttachmentCanBeSentListener,
Operation.OnCancelCallback {
    private final SendManagerSessionFactory sendManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final RefreshOutboxAttachmentSignedUrlDelegate refreshOutboxAttachmentSignedUrlDelegate;
    private final PriorityOperationQueue sendAttachmentOperationQueue;
    private final ExponentialBackoffRepeatingScheduler<IdentityAndUidAndNumber> scheduler;
    private NotificationListeningDelegate notificationListeningDelegate;
    private final HashMap<IdentityAndUidAndNumber, Integer> fileFailedAttemptCounts;
    private final NotificationListener notificationListener;
    private final HashMap<IdentityAndUidAndNumber, AttachmentPriorityInfo> awaitingRefreshedUrlsOperations;
    private final Lock awaitingRefreshedUrlsLock;
    private final HashMap<Identity, List<AttachmentPriorityInfo>> awaitingIdentityReactivationOperations;
    private final Lock awaitingIdentityReactivationOperationsLock;

    public SendAttachmentCoordinator(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, RefreshOutboxAttachmentSignedUrlCoordinator refreshOutboxAttachmentSignedUrlCoordinator) {
        this.sendManagerSessionFactory = sendManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.refreshOutboxAttachmentSignedUrlDelegate = refreshOutboxAttachmentSignedUrlCoordinator;
        this.sendAttachmentOperationQueue = new PriorityOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.fileFailedAttemptCounts = new HashMap();
        this.notificationListener = new NotificationListener();
        this.awaitingRefreshedUrlsOperations = new HashMap();
        this.awaitingRefreshedUrlsLock = new ReentrantLock();
        this.awaitingIdentityReactivationOperations = new HashMap();
        this.awaitingIdentityReactivationOperationsLock = new ReentrantLock();
    }

    public void startProcessing() {
        this.sendAttachmentOperationQueue.execute(4, "Engine-SendAttachmentCoordinator");
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("netword_send_notification_signed_url_refreshed", this.notificationListener);
        this.notificationListeningDelegate.addListener("identity_manager_notification_owned_identity_changed_active_status", this.notificationListener);
    }

    public void initialQueueing() {
        try (SendManagerSession sendManagerSession = this.sendManagerSessionFactory.getSession();){
            OutboxMessage[] messages;
            for (OutboxMessage message : messages = OutboxMessage.getAll(sendManagerSession)) {
                if (message.getUidFromServer() == null) continue;
                for (OutboxAttachment attachment : message.getAttachments()) {
                    if (attachment.isAcknowledged()) continue;
                    this.queueNewSendAttachmentCompositeOperation(attachment.getOwnedIdentity(), attachment.getMessageUid(), attachment.getAttachmentNumber(), attachment.getPriority());
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    private void queueNewSendAttachmentCompositeOperation(Identity ownedIdentity, UID messageUid, int attachmentNumber, long initialPriority) {
        Logger.d("Queueing new UploadAttachmentCompositeOperation " + String.valueOf(messageUid) + "-" + attachmentNumber + " with priority " + initialPriority);
        UploadAttachmentCompositeOperation op = new UploadAttachmentCompositeOperation(this.sendManagerSessionFactory, this.sslSocketFactory, this.userAgentOverride, ownedIdentity, messageUid, attachmentNumber, initialPriority, this, null, this);
        this.sendAttachmentOperationQueue.queue(op);
        PriorityOperation lowestPriorityExecutingOperation = this.sendAttachmentOperationQueue.getExecutingOperationThatShouldBeCancelledWhenQueueingWithHigherPriority();
        if (lowestPriorityExecutingOperation != null && lowestPriorityExecutingOperation.getPriority() > initialPriority) {
            Logger.d("Canceling a UploadAttachmentCompositeOperation with lower priority " + lowestPriorityExecutingOperation.getPriority());
            lowestPriorityExecutingOperation.cancel(7);
        }
    }

    private void scheduleNewSendAttachmentCompositeOperationQueueing(Identity ownedIdentity, UID messageUid, int attachmentNumber, long initialPriority) {
        this.scheduler.schedule(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), () -> this.queueNewSendAttachmentCompositeOperation(ownedIdentity, messageUid, attachmentNumber, initialPriority), "UploadAttachmentCompositeOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    private void waitForRefreshedUrls(Identity ownedIdentity, UID messageUid, int attachmentNumber, long initialPriority) {
        this.awaitingRefreshedUrlsLock.lock();
        this.awaitingRefreshedUrlsOperations.put(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), new AttachmentPriorityInfo(ownedIdentity, messageUid, attachmentNumber, initialPriority));
        this.awaitingRefreshedUrlsLock.unlock();
    }

    public void resetFailedAttemptCount(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        this.scheduler.clearFailedCount(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
    }

    private void waitForIdentityReactivation(Identity ownedIdentity, UID messageUid, int attachmentNumber, long initialPriority) {
        this.awaitingIdentityReactivationOperationsLock.lock();
        List<AttachmentPriorityInfo> list = this.awaitingIdentityReactivationOperations.get(ownedIdentity);
        if (list == null) {
            list = new ArrayList<AttachmentPriorityInfo>();
            this.awaitingIdentityReactivationOperations.put(ownedIdentity, list);
        }
        list.add(new AttachmentPriorityInfo(ownedIdentity, messageUid, attachmentNumber, initialPriority));
        this.awaitingIdentityReactivationOperationsLock.unlock();
    }

    @Override
    public void onCancelCallback(Operation operation) {
        Identity ownedIdentity = ((UploadAttachmentCompositeOperation)operation).getOwnedIdentity();
        UID messageUid = ((UploadAttachmentCompositeOperation)operation).getMessageUid();
        int attachmentNumber = ((UploadAttachmentCompositeOperation)operation).getAttachmentNumber();
        long priority = ((UploadAttachmentCompositeOperation)operation).getPriority();
        Integer rfc = operation.getReasonForCancel();
        Logger.w("UploadAttachmentCompositeOperation cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 6: {
                Integer failedCount = this.fileFailedAttemptCounts.get(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
                if (failedCount == null) {
                    failedCount = 0;
                }
                this.fileFailedAttemptCounts.put(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), failedCount + 1);
                if (failedCount >= 8) {
                    try (SendManagerSession sendManagerSession = this.sendManagerSessionFactory.getSession();){
                        OutboxAttachment outboxAttachment = OutboxAttachment.get(sendManagerSession, ownedIdentity, messageUid, attachmentNumber);
                        if (outboxAttachment != null) {
                            outboxAttachment.setCancelExternallyRequested();
                            break;
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.scheduleNewSendAttachmentCompositeOperationQueueing(ownedIdentity, messageUid, attachmentNumber, priority);
                break;
            }
            case 8: {
                this.waitForRefreshedUrls(ownedIdentity, messageUid, attachmentNumber, priority);
                this.refreshOutboxAttachmentSignedUrlDelegate.refreshOutboxAttachmentSignedUrl(ownedIdentity, messageUid, attachmentNumber);
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 9: {
                this.waitForIdentityReactivation(ownedIdentity, messageUid, attachmentNumber, priority);
                break;
            }
            case 7: {
                this.queueNewSendAttachmentCompositeOperation(ownedIdentity, messageUid, attachmentNumber, priority);
                break;
            }
            default: {
                this.scheduleNewSendAttachmentCompositeOperationQueueing(ownedIdentity, messageUid, attachmentNumber, priority);
            }
        }
    }

    @Override
    public void outboxAttachmentCanBeSent(Identity ownedIdentity, UID messageUid, int attachmentNumber, long initialPriority) {
        this.queueNewSendAttachmentCompositeOperation(ownedIdentity, messageUid, attachmentNumber, initialPriority);
    }

    class NotificationListener
    implements io.olvid.engine.datatypes.NotificationListener {
        NotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            switch (notificationName) {
                case "netword_send_notification_signed_url_refreshed": {
                    Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                    UID messageUid = (UID)userInfo.get("message_uid");
                    int attachmentNumber = (Integer)userInfo.get("attachment_number");
                    SendAttachmentCoordinator.this.awaitingRefreshedUrlsLock.lock();
                    AttachmentPriorityInfo attachmentPriorityInfo = SendAttachmentCoordinator.this.awaitingRefreshedUrlsOperations.get(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
                    if (attachmentPriorityInfo != null) {
                        SendAttachmentCoordinator.this.awaitingRefreshedUrlsOperations.remove(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
                        SendAttachmentCoordinator.this.queueNewSendAttachmentCompositeOperation(attachmentPriorityInfo.getOwnedIdentity(), attachmentPriorityInfo.getMessageUid(), attachmentPriorityInfo.getAttachmentNumber(), attachmentPriorityInfo.getInitialPriority());
                    }
                    SendAttachmentCoordinator.this.awaitingRefreshedUrlsLock.unlock();
                    break;
                }
                case "identity_manager_notification_owned_identity_changed_active_status": {
                    boolean active = (Boolean)userInfo.get("active");
                    Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                    if (!active) break;
                    SendAttachmentCoordinator.this.awaitingIdentityReactivationOperationsLock.lock();
                    List<AttachmentPriorityInfo> list = SendAttachmentCoordinator.this.awaitingIdentityReactivationOperations.get(ownedIdentity);
                    if (list != null) {
                        SendAttachmentCoordinator.this.awaitingIdentityReactivationOperations.remove(ownedIdentity);
                        for (AttachmentPriorityInfo params : list) {
                            SendAttachmentCoordinator.this.queueNewSendAttachmentCompositeOperation(params.ownedIdentity, params.messageUid, params.attachmentNumber, params.initialPriority);
                        }
                    }
                    SendAttachmentCoordinator.this.awaitingIdentityReactivationOperationsLock.unlock();
                    break;
                }
            }
        }
    }

    private static class AttachmentPriorityInfo {
        private final Identity ownedIdentity;
        private final UID messageUid;
        private final int attachmentNumber;
        private final long initialPriority;

        public AttachmentPriorityInfo(Identity ownedIdentity, UID messageUid, int attachmentNumber, long initialPriority) {
            this.ownedIdentity = ownedIdentity;
            this.messageUid = messageUid;
            this.attachmentNumber = attachmentNumber;
            this.initialPriority = initialPriority;
        }

        public Identity getOwnedIdentity() {
            return this.ownedIdentity;
        }

        public UID getMessageUid() {
            return this.messageUid;
        }

        public int getAttachmentNumber() {
            return this.attachmentNumber;
        }

        public long getInitialPriority() {
            return this.initialPriority;
        }
    }
}

