/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUidAndNumber;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.networksend.databases.OutboxAttachment;
import io.olvid.engine.networksend.datatypes.RefreshOutboxAttachmentSignedUrlDelegate;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.RefreshOutboxAttachmentSignedUrlOperation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class RefreshOutboxAttachmentSignedUrlCoordinator
implements Operation.OnFinishCallback,
Operation.OnCancelCallback,
RefreshOutboxAttachmentSignedUrlDelegate {
    private final ExponentialBackoffRepeatingScheduler<IdentityAndUidAndNumber> scheduler;
    private final NoDuplicateOperationQueue refreshOutboxAttachmentSignedUrlOperationQueue;
    private final SendManagerSessionFactory sendManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private NotificationPostingDelegate notificationPostingDelegate;
    private final HashMap<Identity, List<IdentityAndUidAndNumber>> awaitingIdentityReactivationOperations;
    private final Lock awaitingIdentityReactivationOperationsLock;
    private final HashMap<IdentityAndUidAndNumber, Long> lastUrlRefreshTimestamps;
    private final NotificationListener notificationListener;

    public RefreshOutboxAttachmentSignedUrlCoordinator(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride) {
        this.sendManagerSessionFactory = sendManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.lastUrlRefreshTimestamps = new HashMap();
        this.refreshOutboxAttachmentSignedUrlOperationQueue = new NoDuplicateOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.awaitingIdentityReactivationOperations = new HashMap();
        this.awaitingIdentityReactivationOperationsLock = new ReentrantLock();
        this.notificationListener = new NotificationListener();
    }

    public void startProcessing() {
        this.refreshOutboxAttachmentSignedUrlOperationQueue.execute(1, "Engine-RefreshOutboxAttachmentSignedUrlCoordinator");
    }

    public void setNotificationPostingDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        notificationListeningDelegate.addListener("identity_manager_notification_owned_identity_changed_active_status", this.notificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueNewRefreshOutboxAttachmentSignedUrlOperation(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        HashMap<IdentityAndUidAndNumber, Long> hashMap = this.lastUrlRefreshTimestamps;
        synchronized (hashMap) {
            this.lastUrlRefreshTimestamps.put(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), System.currentTimeMillis());
        }
        RefreshOutboxAttachmentSignedUrlOperation op = new RefreshOutboxAttachmentSignedUrlOperation(this.sendManagerSessionFactory, this.sslSocketFactory, this.userAgentOverride, ownedIdentity, messageUid, attachmentNumber, this, this);
        this.refreshOutboxAttachmentSignedUrlOperationQueue.queue(op);
    }

    private void scheduleNewRefreshOutboxAttachmentSignedUrlOperationQueueing(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        this.scheduler.schedule(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), () -> this.queueNewRefreshOutboxAttachmentSignedUrlOperation(ownedIdentity, messageUid, attachmentNumber), "RefreshOutboxAttachmentSignedUrlOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    private void waitForIdentityReactivation(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        this.awaitingIdentityReactivationOperationsLock.lock();
        List<IdentityAndUidAndNumber> list = this.awaitingIdentityReactivationOperations.get(ownedIdentity);
        if (list == null) {
            list = new ArrayList<IdentityAndUidAndNumber>();
            this.awaitingIdentityReactivationOperations.put(ownedIdentity, list);
        }
        list.add(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
        this.awaitingIdentityReactivationOperationsLock.unlock();
    }

    @Override
    public void onFinishCallback(Operation operation) {
        Identity ownedIdentity = ((RefreshOutboxAttachmentSignedUrlOperation)operation).getOwnedIdentity();
        UID messageUid = ((RefreshOutboxAttachmentSignedUrlOperation)operation).getMessageUid();
        int attachmentNumber = ((RefreshOutboxAttachmentSignedUrlOperation)operation).getAttachmentNumber();
        this.scheduler.clearFailedCount(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("owned_identity", ownedIdentity);
        userInfo.put("message_uid", messageUid);
        userInfo.put("attachment_number", attachmentNumber);
        this.notificationPostingDelegate.postNotification("netword_send_notification_signed_url_refreshed", userInfo);
    }

    @Override
    public void onCancelCallback(Operation operation) {
        Identity ownedIdentity = ((RefreshOutboxAttachmentSignedUrlOperation)operation).getOwnedIdentity();
        UID messageUid = ((RefreshOutboxAttachmentSignedUrlOperation)operation).getMessageUid();
        int attachmentNumber = ((RefreshOutboxAttachmentSignedUrlOperation)operation).getAttachmentNumber();
        Integer rfc = operation.getReasonForCancel();
        Logger.i("RefreshOutboxAttachmentSignedUrlOperation cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 2: {
                break;
            }
            case 4: {
                this.waitForIdentityReactivation(ownedIdentity, messageUid, attachmentNumber);
                break;
            }
            case 3: 
            case 5: {
                try (SendManagerSession sendManagerSession = this.sendManagerSessionFactory.getSession();){
                    sendManagerSession.session.startTransaction();
                    OutboxAttachment attachment = OutboxAttachment.get(sendManagerSession, ownedIdentity, messageUid, attachmentNumber);
                    if (attachment != null) {
                        attachment.setAcknowledgedChunkCount(attachment.getNumberOfChunks());
                    }
                    sendManagerSession.session.commit();
                }
                catch (SQLException e) {
                    Logger.x(e);
                }
                break;
            }
            default: {
                this.scheduleNewRefreshOutboxAttachmentSignedUrlOperationQueueing(ownedIdentity, messageUid, attachmentNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshOutboxAttachmentSignedUrl(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        HashMap<IdentityAndUidAndNumber, Long> hashMap = this.lastUrlRefreshTimestamps;
        synchronized (hashMap) {
            Long timestamp = this.lastUrlRefreshTimestamps.get(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
            if (timestamp != null && System.currentTimeMillis() - timestamp < 3600000L) {
                long delay = 3600000L - (System.currentTimeMillis() - timestamp);
                this.scheduler.schedule(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), () -> this.queueNewRefreshOutboxAttachmentSignedUrlOperation(ownedIdentity, messageUid, attachmentNumber), "too frequent RefreshOutboxAttachmentSignedUrlOperation", delay);
            } else {
                this.queueNewRefreshOutboxAttachmentSignedUrlOperation(ownedIdentity, messageUid, attachmentNumber);
            }
        }
    }

    class NotificationListener
    implements io.olvid.engine.datatypes.NotificationListener {
        NotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            if ("identity_manager_notification_owned_identity_changed_active_status".equals(notificationName)) {
                boolean active = (Boolean)userInfo.get("active");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (!active) {
                    return;
                }
                RefreshOutboxAttachmentSignedUrlCoordinator.this.awaitingIdentityReactivationOperationsLock.lock();
                List<IdentityAndUidAndNumber> list = RefreshOutboxAttachmentSignedUrlCoordinator.this.awaitingIdentityReactivationOperations.get(ownedIdentity);
                if (list != null) {
                    RefreshOutboxAttachmentSignedUrlCoordinator.this.awaitingIdentityReactivationOperations.remove(ownedIdentity);
                    for (IdentityAndUidAndNumber params : list) {
                        RefreshOutboxAttachmentSignedUrlCoordinator.this.queueNewRefreshOutboxAttachmentSignedUrlOperation(params.ownedIdentity, params.uid, params.attachmentNumber);
                    }
                }
                RefreshOutboxAttachmentSignedUrlCoordinator.this.awaitingIdentityReactivationOperationsLock.unlock();
            }
        }
    }
}

