/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend.coordinators;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ExponentialBackoffRepeatingScheduler;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NoDuplicateOperationQueue;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.IdentityAndUidAndNumber;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.networksend.databases.OutboxAttachment;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import io.olvid.engine.networksend.operations.CancelAttachmentUploadCompositeOperation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;

public class CancelAttachmentUploadCoordinator
implements OutboxAttachment.OutboxAttachmentCancelRequestedListener,
Operation.OnCancelCallback,
Operation.OnFinishCallback {
    private final SendManagerSessionFactory sendManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private NotificationListeningDelegate notificationListeningDelegate;
    private final NoDuplicateOperationQueue cancelAttachmentUploadOperationQueue;
    private final ExponentialBackoffRepeatingScheduler<IdentityAndUidAndNumber> scheduler;
    private final HashMap<Identity, List<IdentityAndUidAndNumber>> awaitingIdentityReactivationOperations;
    private final Lock awaitingIdentityReactivationOperationsLock;
    private final NotificationListener notificationListener;

    public CancelAttachmentUploadCoordinator(SendManagerSessionFactory sendManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride) {
        this.sendManagerSessionFactory = sendManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.cancelAttachmentUploadOperationQueue = new NoDuplicateOperationQueue();
        this.scheduler = new ExponentialBackoffRepeatingScheduler();
        this.awaitingIdentityReactivationOperations = new HashMap();
        this.awaitingIdentityReactivationOperationsLock = new ReentrantLock();
        this.notificationListener = new NotificationListener();
    }

    public void startProcessing() {
        this.cancelAttachmentUploadOperationQueue.execute(1, "Engine-CancelAttachmentUploadCoordinator");
    }

    public void setNotificationListeningDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.notificationListeningDelegate = notificationListeningDelegate;
        this.notificationListeningDelegate.addListener("identity_manager_notification_owned_identity_changed_active_status", this.notificationListener);
    }

    public void initialQueueing() {
        try (SendManagerSession sendManagerSession = this.sendManagerSessionFactory.getSession();){
            OutboxAttachment[] outboxAttachments;
            for (OutboxAttachment attachment : outboxAttachments = OutboxAttachment.getAllToCancel(sendManagerSession)) {
                this.queueNewCancelAttachmentUploadCompositeOperation(attachment.getOwnedIdentity(), attachment.getMessageUid(), attachment.getAttachmentNumber());
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    private void queueNewCancelAttachmentUploadCompositeOperation(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        Logger.d("Queueing new CancelAttachmentUploadCompositeOperation " + String.valueOf(messageUid) + "-" + attachmentNumber);
        CancelAttachmentUploadCompositeOperation op = new CancelAttachmentUploadCompositeOperation(this.sendManagerSessionFactory, this.sslSocketFactory, this.userAgentOverride, ownedIdentity, messageUid, attachmentNumber, this, this);
        this.cancelAttachmentUploadOperationQueue.queue(op);
    }

    private void scheduleNewCancelAttachmentUploadCompositeOperationQueueing(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        this.scheduler.schedule(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber), () -> this.queueNewCancelAttachmentUploadCompositeOperation(ownedIdentity, messageUid, attachmentNumber), "CancelAttachmentUploadCompositeOperation");
    }

    public void retryScheduledNetworkTasks() {
        this.scheduler.retryScheduledRunnables();
    }

    private void waitForIdentityReactivation(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        this.awaitingIdentityReactivationOperationsLock.lock();
        List<IdentityAndUidAndNumber> list = this.awaitingIdentityReactivationOperations.get(ownedIdentity);
        if (list == null) {
            list = new ArrayList<IdentityAndUidAndNumber>();
            this.awaitingIdentityReactivationOperations.put(ownedIdentity, list);
        }
        list.add(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
        this.awaitingIdentityReactivationOperationsLock.unlock();
    }

    @Override
    public void onCancelCallback(Operation operation) {
        Identity ownedIdentity = ((CancelAttachmentUploadCompositeOperation)operation).getOwnedIdentity();
        UID messageUid = ((CancelAttachmentUploadCompositeOperation)operation).getMessageUid();
        int attachmentNumber = ((CancelAttachmentUploadCompositeOperation)operation).getAttachmentNumber();
        Integer rfc = operation.getReasonForCancel();
        Logger.w("CancelAttachmentUploadCompositeOperation cancelled for reason " + rfc);
        if (rfc == null) {
            rfc = -1;
        }
        switch (rfc) {
            case 1: {
                break;
            }
            case 3: {
                this.waitForIdentityReactivation(ownedIdentity, messageUid, attachmentNumber);
                break;
            }
            default: {
                this.scheduleNewCancelAttachmentUploadCompositeOperationQueueing(ownedIdentity, messageUid, attachmentNumber);
            }
        }
    }

    @Override
    public void onFinishCallback(Operation operation) {
        Identity ownedIdentity = ((CancelAttachmentUploadCompositeOperation)operation).getOwnedIdentity();
        UID messageUid = ((CancelAttachmentUploadCompositeOperation)operation).getMessageUid();
        int attachmentNumber = ((CancelAttachmentUploadCompositeOperation)operation).getAttachmentNumber();
        this.scheduler.clearFailedCount(new IdentityAndUidAndNumber(ownedIdentity, messageUid, attachmentNumber));
    }

    @Override
    public void outboxAttachmentCancelRequested(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        this.queueNewCancelAttachmentUploadCompositeOperation(ownedIdentity, messageUid, attachmentNumber);
    }

    class NotificationListener
    implements io.olvid.engine.datatypes.NotificationListener {
        NotificationListener() {
        }

        @Override
        public void callback(String notificationName, Map<String, Object> userInfo) {
            if ("identity_manager_notification_owned_identity_changed_active_status".equals(notificationName)) {
                boolean active = (Boolean)userInfo.get("active");
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (!active) {
                    return;
                }
                CancelAttachmentUploadCoordinator.this.awaitingIdentityReactivationOperationsLock.lock();
                List<IdentityAndUidAndNumber> list = CancelAttachmentUploadCoordinator.this.awaitingIdentityReactivationOperations.get(ownedIdentity);
                if (list != null) {
                    CancelAttachmentUploadCoordinator.this.awaitingIdentityReactivationOperations.remove(ownedIdentity);
                    for (IdentityAndUidAndNumber params : list) {
                        CancelAttachmentUploadCoordinator.this.queueNewCancelAttachmentUploadCompositeOperation(params.ownedIdentity, params.uid, params.attachmentNumber);
                    }
                }
                CancelAttachmentUploadCoordinator.this.awaitingIdentityReactivationOperationsLock.unlock();
            }
        }
    }
}

