/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networksend;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.MessageToSend;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.metamanager.CreateSessionDelegate;
import io.olvid.engine.metamanager.IdentityDelegate;
import io.olvid.engine.metamanager.MetaManager;
import io.olvid.engine.metamanager.NetworkSendDelegate;
import io.olvid.engine.metamanager.NotificationListeningDelegate;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.metamanager.ObvManager;
import io.olvid.engine.networksend.coordinators.CancelAttachmentUploadCoordinator;
import io.olvid.engine.networksend.coordinators.RefreshOutboxAttachmentSignedUrlCoordinator;
import io.olvid.engine.networksend.coordinators.SendAttachmentCoordinator;
import io.olvid.engine.networksend.coordinators.SendMessageCoordinator;
import io.olvid.engine.networksend.coordinators.SendReturnReceiptCoordinator;
import io.olvid.engine.networksend.databases.MessageHeader;
import io.olvid.engine.networksend.databases.OutboxAttachment;
import io.olvid.engine.networksend.databases.OutboxMessage;
import io.olvid.engine.networksend.databases.ReturnReceipt;
import io.olvid.engine.networksend.datatypes.SendManagerSession;
import io.olvid.engine.networksend.datatypes.SendManagerSessionFactory;
import java.sql.SQLException;
import javax.net.ssl.SSLSocketFactory;

public class SendManager
implements NetworkSendDelegate,
SendManagerSessionFactory,
ObvManager {
    private final String engineBaseDirectory;
    private final SendMessageCoordinator sendMessageCoordinator;
    private final SendAttachmentCoordinator sendAttachmentCoordinator;
    private final CancelAttachmentUploadCoordinator cancelAttachmentUploadCoordinator;
    private final RefreshOutboxAttachmentSignedUrlCoordinator refreshOutboxAttachmentSignedUrlCoordinator;
    private final SendReturnReceiptCoordinator sendReturnReceiptCoordinator;
    private CreateSessionDelegate createSessionDelegate;
    private NotificationPostingDelegate notificationPostingDelegate;
    private IdentityDelegate identityDelegate;

    public SendManager(MetaManager metaManager, SSLSocketFactory sslSocketFactory, String userAgentOverride, String engineBaseDirectory, PRNGService prng, int sendMessageThreadCount, int sendReturnReceiptThreadCount) {
        this.engineBaseDirectory = engineBaseDirectory;
        this.sendMessageCoordinator = new SendMessageCoordinator(this, sslSocketFactory, userAgentOverride, sendMessageThreadCount);
        this.refreshOutboxAttachmentSignedUrlCoordinator = new RefreshOutboxAttachmentSignedUrlCoordinator(this, sslSocketFactory, userAgentOverride);
        this.sendAttachmentCoordinator = new SendAttachmentCoordinator(this, sslSocketFactory, userAgentOverride, this.refreshOutboxAttachmentSignedUrlCoordinator);
        this.cancelAttachmentUploadCoordinator = new CancelAttachmentUploadCoordinator(this, sslSocketFactory, userAgentOverride);
        this.sendReturnReceiptCoordinator = new SendReturnReceiptCoordinator(this, sslSocketFactory, userAgentOverride, prng, sendReturnReceiptThreadCount);
        metaManager.requestDelegate(this, CreateSessionDelegate.class);
        metaManager.requestDelegate(this, NotificationPostingDelegate.class);
        metaManager.requestDelegate(this, NotificationListeningDelegate.class);
        metaManager.requestDelegate(this, IdentityDelegate.class);
        metaManager.registerImplementedDelegates(this);
    }

    @Override
    public int initialQueueingPriority() {
        return 10;
    }

    @Override
    public void initialisationComplete() {
        this.sendMessageCoordinator.initialQueueing();
        this.sendAttachmentCoordinator.initialQueueing();
        this.cancelAttachmentUploadCoordinator.initialQueueing();
        this.sendReturnReceiptCoordinator.initialQueueing();
    }

    public void startProcessing() {
        this.cancelAttachmentUploadCoordinator.startProcessing();
        this.refreshOutboxAttachmentSignedUrlCoordinator.startProcessing();
        this.sendAttachmentCoordinator.startProcessing();
        this.sendMessageCoordinator.startProcessing();
        this.sendReturnReceiptCoordinator.startProcessing();
    }

    public void setDelegate(CreateSessionDelegate createSessionDelegate) {
        this.createSessionDelegate = createSessionDelegate;
        try (SendManagerSession sendManagerSession = this.getSession();){
            OutboxMessage.createTable(sendManagerSession.session);
            OutboxAttachment.createTable(sendManagerSession.session);
            MessageHeader.createTable(sendManagerSession.session);
            ReturnReceipt.createTable(sendManagerSession.session);
            sendManagerSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
            throw new RuntimeException("Unable to create network fetch databases");
        }
    }

    public static void upgradeTables(Session session, int oldVersion, int newVersion) throws SQLException {
        OutboxMessage.upgradeTable(session, oldVersion, newVersion);
        OutboxAttachment.upgradeTable(session, oldVersion, newVersion);
        MessageHeader.upgradeTable(session, oldVersion, newVersion);
        ReturnReceipt.upgradeTable(session, oldVersion, newVersion);
    }

    public void setDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
        this.refreshOutboxAttachmentSignedUrlCoordinator.setNotificationPostingDelegate(notificationPostingDelegate);
    }

    public void setDelegate(NotificationListeningDelegate notificationListeningDelegate) {
        this.sendAttachmentCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.cancelAttachmentUploadCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.sendMessageCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.refreshOutboxAttachmentSignedUrlCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
        this.sendReturnReceiptCoordinator.setNotificationListeningDelegate(notificationListeningDelegate);
    }

    public void setDelegate(IdentityDelegate identityDelegate) {
        this.identityDelegate = identityDelegate;
    }

    public void deleteOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        OutboxMessage[] outboxMessages;
        for (OutboxMessage outboxMessage : outboxMessages = OutboxMessage.getAllForOwnedIdentity(this.wrapSession(session), ownedIdentity)) {
            outboxMessage.delete();
        }
        ReturnReceipt.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
    }

    @Override
    public void post(Session session, MessageToSend messageToSend) {
        SendManagerSession sendManagerSession = this.wrapSession(session);
        OutboxMessage.create(sendManagerSession, messageToSend.getOwnedIdentity(), messageToSend.getUid(), messageToSend.getServer(), messageToSend.getEncryptedContent(), messageToSend.getEncryptedExtendedContent(), messageToSend.isApplicationMessage(), messageToSend.isVoipMessage(), messageToSend.getAttachments() != null && messageToSend.getAttachments().length != 0);
        if (messageToSend.getHeaders() != null) {
            for (MessageToSend.Header header : messageToSend.getHeaders()) {
                MessageHeader.create(sendManagerSession, messageToSend.getOwnedIdentity(), messageToSend.getUid(), header.getDeviceUid(), header.getToIdentity(), header.getWrappedMessageKey());
            }
        }
        if (messageToSend.getAttachments() != null) {
            int attachmentNumber = 0;
            for (MessageToSend.Attachment attachment : messageToSend.getAttachments()) {
                OutboxAttachment.create(sendManagerSession, messageToSend.getOwnedIdentity(), messageToSend.getUid(), attachmentNumber, attachment.getUrl(), attachment.isDeleteAfterSend(), attachment.getAttachmentLength(), attachment.getKey());
                ++attachmentNumber;
            }
        }
    }

    @Override
    public void cancelAttachmentUpload(Session session, Identity ownedIdentity, UID messageUid, int attachmentNumber) throws SQLException {
        OutboxAttachment outboxAttachment = OutboxAttachment.get(this.wrapSession(session), ownedIdentity, messageUid, attachmentNumber);
        outboxAttachment.setCancelExternallyRequested();
    }

    @Override
    public boolean isOutboxAttachmentSent(Session session, Identity ownedIdentity, UID messageUid, int attachmentNumber) throws SQLException {
        OutboxAttachment outboxAttachment = OutboxAttachment.get(this.wrapSession(session), ownedIdentity, messageUid, attachmentNumber);
        return outboxAttachment == null || outboxAttachment.isAcknowledged();
    }

    @Override
    public boolean isOutboxMessageSent(Session session, Identity ownedIdentity, UID messageUid) throws SQLException {
        OutboxMessage outboxMessage = OutboxMessage.get(this.wrapSession(session), ownedIdentity, messageUid);
        return outboxMessage == null || outboxMessage.isAcknowledged();
    }

    @Override
    public void cancelMessageSending(Session session, Identity ownedIdentity, UID messageUid) throws SQLException {
        block4: {
            OutboxMessage outboxMessage = OutboxMessage.get(this.wrapSession(session), ownedIdentity, messageUid);
            if (outboxMessage == null) break block4;
            if (outboxMessage.isAcknowledged()) {
                for (OutboxAttachment outboxAttachment : outboxMessage.getAttachments()) {
                    outboxAttachment.setCancelExternallyRequested();
                }
            } else {
                outboxMessage.setUidFromServer(new UID(new byte[32]), new byte[0], 0L);
                for (OutboxAttachment outboxAttachment : outboxMessage.getAttachments()) {
                    outboxAttachment.setCancelExternallyRequested();
                    outboxAttachment.setCancelProcessed();
                }
            }
        }
    }

    public void sendReturnReceipt(Session session, Identity ownedIdentity, Identity contactIdentity, UID[] contactDeviceUids, int status, byte[] returnReceiptNonce, AuthEncKey returnReceiptKey, Integer attachmentNumber) {
        ReturnReceipt.create(this.wrapSession(session), ownedIdentity, contactIdentity, contactDeviceUids, status, returnReceiptNonce, returnReceiptKey, attachmentNumber);
    }

    @Override
    public void retryScheduledNetworkTasks() {
        this.cancelAttachmentUploadCoordinator.retryScheduledNetworkTasks();
        this.refreshOutboxAttachmentSignedUrlCoordinator.retryScheduledNetworkTasks();
        this.sendAttachmentCoordinator.retryScheduledNetworkTasks();
        this.sendMessageCoordinator.retryScheduledNetworkTasks();
        this.sendReturnReceiptCoordinator.retryScheduledNetworkTasks();
    }

    @Override
    public SendManagerSession getSession() throws SQLException {
        if (this.createSessionDelegate == null) {
            throw new SQLException("No CreateSessionDelegate was set in SendManager.");
        }
        return new SendManagerSession(this.createSessionDelegate.getSession(), this.sendMessageCoordinator, this.sendAttachmentCoordinator, this.cancelAttachmentUploadCoordinator, this.notificationPostingDelegate, this.sendReturnReceiptCoordinator, this.identityDelegate, this.engineBaseDirectory);
    }

    private SendManagerSession wrapSession(Session session) {
        return new SendManagerSession(session, this.sendMessageCoordinator, this.sendAttachmentCoordinator, this.cancelAttachmentUploadCoordinator, this.notificationPostingDelegate, this.sendReturnReceiptCoordinator, this.identityDelegate, this.engineBaseDirectory);
    }
}

