/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.networkfetch.coordinators.WellKnownCoordinator;
import io.olvid.engine.networkfetch.databases.CachedWellKnown;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class WellKnownDownloadOperation
extends Operation {
    public static final int RFC_NOT_FOUND = 1;
    public static final int RFC_MALFORMED_WELL_KNOWN = 2;
    public static final String WELL_KNOWN_PATH = "/.well-known/server-config.json";
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final String server;
    private final ObjectMapper objectMapper;
    private boolean updated;
    private WellKnownCoordinator.JsonWellKnown downloadedWellKnown;

    public String getServer() {
        return this.server;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public WellKnownCoordinator.JsonWellKnown getDownloadedWellKnown() {
        return this.downloadedWellKnown;
    }

    public WellKnownDownloadOperation(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, String server, ObjectMapper objectMapper, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(WellKnownDownloadOperation.computeUniqueUid(server), onFinishCallback, onCancelCallback);
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.server = server;
        this.objectMapper = objectMapper;
    }

    public static UID computeUniqueUid(String server) {
        Hash sha256 = Suite.getHash("sha-256");
        return new UID(sha256.digest(server.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            try {
                block55: {
                    String userAgentProperty;
                    CachedWellKnown cachedWellKnown = CachedWellKnown.get(fetchManagerSession, this.server);
                    URL url = new URL(this.server + WELL_KNOWN_PATH);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    if (connection instanceof HttpsURLConnection && this.sslSocketFactory != null) {
                        ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
                    }
                    String string = userAgentProperty = this.userAgentOverride != null ? this.userAgentOverride : System.getProperty("http.agent");
                    if (userAgentProperty != null) {
                        connection.setRequestProperty("User-Agent", userAgentProperty);
                    }
                    try {
                        connection.setConnectTimeout(5000);
                        connection.setRequestProperty("Cache-Control", "no-store");
                        connection.setRequestMethod("GET");
                        connection.setDoOutput(false);
                        int serverResponse = connection.getResponseCode();
                        if (serverResponse == 200) {
                            byte[] responseData;
                            try (InputStream is = connection.getInputStream();
                                 BufferedInputStream bis = new BufferedInputStream(is);
                                 ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                                int numberOfBytesRead;
                                byte[] buffer = new byte[32768];
                                while ((numberOfBytesRead = bis.read(buffer)) != -1) {
                                    byteArrayOutputStream.write(buffer, 0, numberOfBytesRead);
                                }
                                byteArrayOutputStream.flush();
                                responseData = byteArrayOutputStream.toByteArray();
                            }
                            try {
                                this.downloadedWellKnown = (WellKnownCoordinator.JsonWellKnown)this.objectMapper.readValue(responseData, WellKnownCoordinator.JsonWellKnown.class);
                            }
                            catch (Exception e) {
                                Logger.x(e);
                                this.cancel(2);
                                connection.disconnect();
                                if (finished) {
                                    fetchManagerSession.session.commit();
                                    this.setFinished();
                                } else {
                                    if (this.hasNoReasonForCancel()) {
                                        this.cancel(null);
                                    }
                                    this.processCancel();
                                }
                                if (fetchManagerSession != null) {
                                    fetchManagerSession.close();
                                }
                                return;
                            }
                            String newSerializedWellKnown = new String(responseData, StandardCharsets.UTF_8);
                            if (cachedWellKnown == null) {
                                CachedWellKnown.create(fetchManagerSession, this.server, newSerializedWellKnown);
                                this.updated = true;
                            } else if (!Objects.equals(cachedWellKnown.getSerializedWellKnown(), newSerializedWellKnown)) {
                                cachedWellKnown.update(newSerializedWellKnown);
                                this.updated = true;
                            } else {
                                this.updated = false;
                            }
                            break block55;
                        }
                        this.cancel(1);
                        return;
                    }
                    finally {
                        connection.disconnect();
                    }
                }
                finished = true;
            }
            catch (Exception e) {
                Logger.x(e);
            }
            finally {
                if (finished) {
                    fetchManagerSession.session.commit();
                    this.setFinished();
                } else {
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

