/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;

class UploadPreKeyServerMethod
extends ServerQueryServerMethod {
    private static final String SERVER_METHOD_PATH = "/uploadPreKey";
    private final String server;
    private final Identity ownedIdentity;
    private final byte[] token;
    private final UID deviceUid;
    private final byte[] preKeyBytes;

    public UploadPreKeyServerMethod(Identity ownedIdentity, byte[] token, UID deviceUid, byte[] preKeyBytes) {
        this.server = ownedIdentity.getServer();
        this.ownedIdentity = ownedIdentity;
        this.token = token;
        this.deviceUid = deviceUid;
        this.preKeyBytes = preKeyBytes;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.ownedIdentity), Encoded.of(this.token), Encoded.of(this.deviceUid), new Encoded(this.preKeyBytes)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        super.parseReceivedData(receivedData);
        if (this.returnStatus == 20 || this.returnStatus == 11) {
            this.returnStatus = 0;
        }
    }

    @Override
    public Encoded getServerResponse() {
        return null;
    }
}

