/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.metamanager.SolveChallengeDelegate;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import java.sql.SQLException;

public class SolveChallengeOperation
extends Operation {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final Identity identity;
    private final SolveChallengeDelegate solveChallengeDelegate;

    public SolveChallengeOperation(FetchManagerSessionFactory fetchManagerSessionFactory, Identity identity, SolveChallengeDelegate solveChallengeDelegate) {
        super(identity.computeUniqueUid(), null, null);
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.identity = identity;
        this.solveChallengeDelegate = solveChallengeDelegate;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            try {
                byte[] response;
                ServerSession serverSession = ServerSession.get(fetchManagerSession, this.identity);
                if (serverSession == null) {
                    this.cancel(2);
                    return;
                }
                if (serverSession.getResponse() != null || serverSession.getToken() != null) {
                    finished = true;
                    return;
                }
                if (serverSession.getChallenge() == null) {
                    this.cancel(3);
                    return;
                }
                PRNGService prng = Suite.getPRNGService("prng_hmac_sha-256");
                try {
                    response = this.solveChallengeDelegate.solveChallenge(serverSession.getChallenge(), this.identity, prng);
                }
                catch (Exception e) {
                    this.cancel(6);
                    if (finished) {
                        fetchManagerSession.session.commit();
                        this.setFinished();
                    } else {
                        this.cancel(null);
                        this.processCancel();
                    }
                    if (fetchManagerSession == null) return;
                    fetchManagerSession.close();
                    return;
                }
                fetchManagerSession.session.startTransaction();
                serverSession.setResponseForChallenge(serverSession.getChallenge(), response);
                finished = true;
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                fetchManagerSession.session.rollback();
                return;
            }
            finally {
                if (finished) {
                    fetchManagerSession.session.commit();
                    this.setFinished();
                } else {
                    this.cancel(null);
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

