/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.databases.PendingServerQuery;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.CheckKeycloakRevocationServerMethod;
import io.olvid.engine.networkfetch.operations.CreateGroupBlobServerMethod;
import io.olvid.engine.networkfetch.operations.DeleteGroupBlobServerMethod;
import io.olvid.engine.networkfetch.operations.DeviceDiscoveryServerMethod;
import io.olvid.engine.networkfetch.operations.DeviceManagementServerMethod;
import io.olvid.engine.networkfetch.operations.GetGroupBlobServerMethod;
import io.olvid.engine.networkfetch.operations.GetKeycloakDataServerMethod;
import io.olvid.engine.networkfetch.operations.GetUserDataServerMethod;
import io.olvid.engine.networkfetch.operations.LockGroupBlobServerMethod;
import io.olvid.engine.networkfetch.operations.OwnedDeviceDiscoveryServerMethod;
import io.olvid.engine.networkfetch.operations.PutGroupLogServerMethod;
import io.olvid.engine.networkfetch.operations.PutUserDataServerMethod;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;
import io.olvid.engine.networkfetch.operations.UpdateGroupBlobServerMethod;
import io.olvid.engine.networkfetch.operations.UploadPreKeyServerMethod;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileInputStream;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import javax.net.ssl.SSLSocketFactory;

public class ServerQueryOperation
extends Operation {
    public static final int RFC_NETWORK_ERROR = 1;
    public static final int RFC_BAD_ENCODED_SERVER_QUERY = 2;
    public static final int RFC_INVALID_SERVER_SESSION = 3;
    public static final int RFC_IDENTITY_IS_INACTIVE = 4;
    public static final int RFC_USER_DATA_TOO_LARGE = 5;
    public static final int RFC_DEVICE_DOES_NOT_EXIST = 6;
    public static final int RFC_DEVICE_NOT_YET_REGISTERED = 7;
    public static final int RFC_MALFORMED_URL = 8;
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final UID serverQueryUid;
    private final PRNG prng;
    private ServerQuery serverQuery;
    private Encoded serverResponse;

    public ServerQueryOperation(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, UID serverQueryUid, PRNG prng, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(serverQueryUid, onFinishCallback, onCancelCallback);
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.serverQueryUid = serverQueryUid;
        this.prng = prng;
    }

    public UID getServerQueryUid() {
        return this.serverQueryUid;
    }

    public ServerQuery getServerQuery() {
        return this.serverQuery;
    }

    public Encoded getServerResponse() {
        return this.serverResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            try {
                ServerQueryServerMethod serverMethod;
                PendingServerQuery pendingServerQuery = PendingServerQuery.get(fetchManagerSession, this.serverQueryUid);
                if (pendingServerQuery == null) {
                    this.cancel(2);
                    return;
                }
                try {
                    this.serverQuery = ServerQuery.of(pendingServerQuery.getEncodedQuery());
                }
                catch (DecodingException e) {
                    this.cancel(2);
                    if (finished) {
                        this.setFinished();
                    } else {
                        if (this.hasNoReasonForCancel()) {
                            this.cancel(null);
                        }
                        this.processCancel();
                    }
                    if (fetchManagerSession == null) return;
                    fetchManagerSession.close();
                    return;
                }
                Logger.d("?? Starting server query operation of type " + String.valueOf((Object)this.serverQuery.getType().getId()));
                ServerQuery.Type queryType = this.serverQuery.getType();
                switch (queryType.getId()) {
                    case DEVICE_DISCOVERY_QUERY_ID: {
                        ServerQuery.DeviceDiscoveryQuery deviceDiscoveryQuery = (ServerQuery.DeviceDiscoveryQuery)queryType;
                        serverMethod = new DeviceDiscoveryServerMethod(deviceDiscoveryQuery.identity);
                        break;
                    }
                    case PUT_USER_DATA_QUERY_ID: {
                        byte[] buffer;
                        ServerQuery.PutUserDataQuery putUserDataQuery = (ServerQuery.PutUserDataQuery)queryType;
                        byte[] serverSessionToken = ServerSession.getToken(fetchManagerSession, putUserDataQuery.ownedIdentity);
                        if (serverSessionToken == null) {
                            this.cancel(3);
                            return;
                        }
                        String absoluteOrNotPhotoUrl = putUserDataQuery.dataUrl;
                        SecureFile photoFile = new File(absoluteOrNotPhotoUrl).isAbsolute() ? new SecureFile(absoluteOrNotPhotoUrl) : new SecureFile(fetchManagerSession.engineBaseDirectory, absoluteOrNotPhotoUrl);
                        try {
                            buffer = new byte[(int)photoFile.length()];
                            if (buffer.length == 0) {
                                throw new Exception();
                            }
                        }
                        catch (Exception e) {
                            Logger.e("PutUserData Error: Unable to open file " + String.valueOf(photoFile));
                            this.serverResponse = null;
                            finished = true;
                            if (finished) {
                                this.setFinished();
                            } else {
                                if (this.hasNoReasonForCancel()) {
                                    this.cancel(null);
                                }
                                this.processCancel();
                            }
                            if (fetchManagerSession == null) return;
                            fetchManagerSession.close();
                            return;
                        }
                        try (SecureFileInputStream f = new SecureFileInputStream(photoFile);){
                            int count;
                            for (int bufferFullness = 0; bufferFullness < buffer.length && (count = f.read(buffer, bufferFullness, buffer.length - bufferFullness)) >= 0; bufferFullness += count) {
                            }
                        }
                        AuthEnc authEnc = Suite.getAuthEnc(putUserDataQuery.dataKey);
                        EncryptedBytes encryptedPhoto = authEnc.encrypt(putUserDataQuery.dataKey, buffer, this.prng);
                        serverMethod = new PutUserDataServerMethod(putUserDataQuery.ownedIdentity, serverSessionToken, putUserDataQuery.serverLabel, encryptedPhoto);
                        break;
                    }
                    case GET_USER_DATA_QUERY_ID: {
                        ServerQuery.GetUserDataQuery getUserDataQuery = (ServerQuery.GetUserDataQuery)queryType;
                        serverMethod = new GetUserDataServerMethod(getUserDataQuery.identity, getUserDataQuery.serverLabel, fetchManagerSession.engineBaseDirectory);
                        break;
                    }
                    case CHECK_KEYCLOAK_REVOCATION_QUERY_ID: {
                        ServerQuery.CheckKeycloakRevocationQuery checkKeycloakRevocationQuery = (ServerQuery.CheckKeycloakRevocationQuery)queryType;
                        serverMethod = new CheckKeycloakRevocationServerMethod(checkKeycloakRevocationQuery.server, checkKeycloakRevocationQuery.signedContactDetails);
                        break;
                    }
                    case CREATE_GROUP_BLOB_QUERY_ID: {
                        ServerQuery.CreateGroupBlobQuery createGroupBlobQuery = (ServerQuery.CreateGroupBlobQuery)queryType;
                        byte[] serverSessionToken = ServerSession.getToken(fetchManagerSession, this.serverQuery.getOwnedIdentity());
                        if (serverSessionToken == null) {
                            this.cancel(3);
                            return;
                        }
                        serverMethod = new CreateGroupBlobServerMethod(this.serverQuery.getOwnedIdentity(), serverSessionToken, createGroupBlobQuery.server, createGroupBlobQuery.groupUid, createGroupBlobQuery.encodedGroupAdminPublicKey, createGroupBlobQuery.encryptedBlob);
                        break;
                    }
                    case GET_GROUP_BLOB_QUERY_ID: {
                        ServerQuery.GetGroupBlobQuery groupBlobQuery = (ServerQuery.GetGroupBlobQuery)queryType;
                        serverMethod = new GetGroupBlobServerMethod(groupBlobQuery.server, groupBlobQuery.groupUid, groupBlobQuery.serverQueryNonce);
                        break;
                    }
                    case LOCK_GROUP_BLOB_QUERY_ID: {
                        ServerQuery.LockGroupBlobQuery lockGroupBlobQuery = (ServerQuery.LockGroupBlobQuery)queryType;
                        serverMethod = new LockGroupBlobServerMethod(lockGroupBlobQuery.server, lockGroupBlobQuery.groupUid, lockGroupBlobQuery.lockNonce, lockGroupBlobQuery.signature);
                        break;
                    }
                    case UPDATE_GROUP_BLOB_QUERY_ID: {
                        ServerQuery.UpdateGroupBlobQuery updateGroupBlobQuery = (ServerQuery.UpdateGroupBlobQuery)queryType;
                        serverMethod = new UpdateGroupBlobServerMethod(updateGroupBlobQuery.server, updateGroupBlobQuery.groupUid, updateGroupBlobQuery.lockNonce, updateGroupBlobQuery.encryptedBlob, updateGroupBlobQuery.encodedGroupAdminPublicKey, updateGroupBlobQuery.signature);
                        break;
                    }
                    case PUT_GROUP_LOG_QUERY_ID: {
                        ServerQuery.PutGroupLogQuery putGroupLogQuery = (ServerQuery.PutGroupLogQuery)queryType;
                        serverMethod = new PutGroupLogServerMethod(putGroupLogQuery.server, putGroupLogQuery.groupUid, putGroupLogQuery.signature);
                        break;
                    }
                    case DELETE_GROUP_BLOB_QUERY_ID: {
                        ServerQuery.DeleteGroupBlobQuery deleteGroupBlobQuery = (ServerQuery.DeleteGroupBlobQuery)queryType;
                        serverMethod = new DeleteGroupBlobServerMethod(deleteGroupBlobQuery.server, deleteGroupBlobQuery.groupUid, deleteGroupBlobQuery.signature);
                        break;
                    }
                    case GET_KEYCLOAK_DATA_QUERY_ID: {
                        ServerQuery.GetKeycloakDataQuery getKeycloakDataQuery = (ServerQuery.GetKeycloakDataQuery)queryType;
                        serverMethod = new GetKeycloakDataServerMethod(getKeycloakDataQuery.server, getKeycloakDataQuery.serverLabel, fetchManagerSession.engineBaseDirectory);
                        break;
                    }
                    case OWNED_DEVICE_DISCOVERY_QUERY_ID: {
                        serverMethod = new OwnedDeviceDiscoveryServerMethod(this.serverQuery.getOwnedIdentity());
                        break;
                    }
                    case DEVICE_MANAGEMENT_SET_NICKNAME_QUERY_ID: 
                    case DEVICE_MANAGEMENT_DEACTIVATE_DEVICE_QUERY_ID: 
                    case DEVICE_MANAGEMENT_SET_UNEXPIRING_DEVICE_QUERY_ID: {
                        byte[] serverSessionToken = ServerSession.getToken(fetchManagerSession, this.serverQuery.getOwnedIdentity());
                        if (serverSessionToken == null) {
                            this.cancel(3);
                            return;
                        }
                        serverMethod = new DeviceManagementServerMethod(this.serverQuery.getOwnedIdentity(), serverSessionToken, this.serverQuery.getType());
                        break;
                    }
                    case UPLOAD_PRE_KEY_QUERY_ID: {
                        ServerQuery.UploadPreKeyQuery uploadPreKeyQuery = (ServerQuery.UploadPreKeyQuery)queryType;
                        byte[] serverSessionToken = ServerSession.getToken(fetchManagerSession, this.serverQuery.getOwnedIdentity());
                        if (serverSessionToken == null) {
                            this.cancel(3);
                            return;
                        }
                        serverMethod = new UploadPreKeyServerMethod(this.serverQuery.getOwnedIdentity(), serverSessionToken, uploadPreKeyQuery.deviceUid, uploadPreKeyQuery.preKeyBytes);
                        break;
                    }
                    default: {
                        this.cancel(2);
                        return;
                    }
                }
                serverMethod.setSslSocketFactory(this.sslSocketFactory, this.userAgentOverride);
                byte returnStatus = serverMethod.execute(fetchManagerSession.identityDelegate.isActiveOwnedIdentity(fetchManagerSession.session, this.serverQuery.getOwnedIdentity()));
                Logger.d("?? Server query return status (after parse): " + returnStatus);
                switch (returnStatus) {
                    case 0: {
                        this.serverResponse = serverMethod.getServerResponse();
                        finished = true;
                        return;
                    }
                    case 4: {
                        this.cancel(3);
                        return;
                    }
                    case -114: {
                        this.cancel(4);
                        return;
                    }
                    case 24: {
                        this.cancel(5);
                        return;
                    }
                    case 11: {
                        if (this.serverQuery.getType() instanceof ServerQuery.DeviceManagementSetNicknameQuery && ((ServerQuery.DeviceManagementSetNicknameQuery)this.serverQuery.getType()).isCurrentDevice) {
                            this.cancel(7);
                            return;
                        }
                        this.cancel(6);
                        return;
                    }
                    case -128: {
                        this.cancel(8);
                        return;
                    }
                }
                if (System.currentTimeMillis() > pendingServerQuery.getCreationTimestamp() + 1296000000L) {
                    switch (this.serverQuery.getType().getId()) {
                        case DEVICE_DISCOVERY_QUERY_ID: {
                            this.serverResponse = Encoded.of(new HashMap<DictionaryKey, Encoded>());
                            finished = true;
                            return;
                        }
                        case OWNED_DEVICE_DISCOVERY_QUERY_ID: {
                            this.serverResponse = Encoded.of(new byte[0]);
                            finished = true;
                            return;
                        }
                        case PUT_USER_DATA_QUERY_ID: 
                        case GET_GROUP_BLOB_QUERY_ID: 
                        case LOCK_GROUP_BLOB_QUERY_ID: 
                        case PUT_GROUP_LOG_QUERY_ID: 
                        case UPLOAD_PRE_KEY_QUERY_ID: {
                            this.serverResponse = null;
                            finished = true;
                            return;
                        }
                        case GET_USER_DATA_QUERY_ID: 
                        case GET_KEYCLOAK_DATA_QUERY_ID: {
                            this.serverResponse = Encoded.of("");
                            finished = true;
                            return;
                        }
                        case CHECK_KEYCLOAK_REVOCATION_QUERY_ID: {
                            this.serverResponse = Encoded.of(true);
                            finished = true;
                            return;
                        }
                        case CREATE_GROUP_BLOB_QUERY_ID: 
                        case UPDATE_GROUP_BLOB_QUERY_ID: 
                        case DELETE_GROUP_BLOB_QUERY_ID: {
                            this.serverResponse = Encoded.of(false);
                            finished = true;
                            return;
                        }
                    }
                } else if (this.serverQuery.getType().getId() == ServerQuery.TypeId.CHECK_KEYCLOAK_REVOCATION_QUERY_ID && returnStatus == -127) {
                    this.serverResponse = Encoded.of(true);
                    finished = true;
                    return;
                }
                this.cancel(1);
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                return;
            }
            finally {
                if (finished) {
                    this.setFinished();
                } else {
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void doCancel() {
    }
}

