/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.PushNotificationTypeAndParameters;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.Encoded;
import java.util.List;

class RegisterPushNotificationServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/registerPushNotification";
    private final String server;
    private final Identity ownedIdentity;
    private final byte[] token;
    private final UID deviceUid;
    private final PushNotificationTypeAndParameters pushNotificationTypeAndParameters;
    private final String[] keycloakPushTopics;
    private final EncryptedBytes encryptedDeviceNameForFirstRegistration;

    RegisterPushNotificationServerMethod(Identity ownedIdentity, byte[] token, UID deviceUid, PushNotificationTypeAndParameters pushNotificationTypeAndParameters, List<String> keycloakPushTopics, EncryptedBytes encryptedDeviceNameForFirstRegistration) {
        this.server = ownedIdentity.getServer();
        this.ownedIdentity = ownedIdentity;
        this.token = token;
        this.deviceUid = deviceUid;
        this.pushNotificationTypeAndParameters = pushNotificationTypeAndParameters;
        this.keycloakPushTopics = keycloakPushTopics == null ? new String[]{} : keycloakPushTopics.toArray(new String[0]);
        this.encryptedDeviceNameForFirstRegistration = encryptedDeviceNameForFirstRegistration;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        Encoded extraInfo = switch (this.pushNotificationTypeAndParameters.pushNotificationType) {
            case 1 -> Encoded.of(new Encoded[]{Encoded.of(this.pushNotificationTypeAndParameters.token), Encoded.of(this.pushNotificationTypeAndParameters.identityMaskingUid)});
            default -> Encoded.of(new Encoded[0]);
        };
        if (this.pushNotificationTypeAndParameters.deviceUidToReplace != null) {
            return Encoded.of(new Encoded[]{Encoded.of(this.ownedIdentity), Encoded.of(this.token), Encoded.of(this.deviceUid), Encoded.of(new byte[]{this.pushNotificationTypeAndParameters.pushNotificationType}), extraInfo, Encoded.of(this.pushNotificationTypeAndParameters.reactivateCurrentDevice), Encoded.of(this.keycloakPushTopics), Encoded.of(this.encryptedDeviceNameForFirstRegistration), Encoded.of(this.pushNotificationTypeAndParameters.deviceUidToReplace)}).getBytes();
        }
        return Encoded.of(new Encoded[]{Encoded.of(this.ownedIdentity), Encoded.of(this.token), Encoded.of(this.deviceUid), Encoded.of(new byte[]{this.pushNotificationTypeAndParameters.pushNotificationType}), extraInfo, Encoded.of(this.pushNotificationTypeAndParameters.reactivateCurrentDevice), Encoded.of(this.keycloakPushTopics), Encoded.of(this.encryptedDeviceNameForFirstRegistration)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return false;
    }
}

