/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.operations.ServerQueryServerMethod;

class PutUserDataServerMethod
extends ServerQueryServerMethod {
    private static final String SERVER_METHOD_PATH = "/putUserData";
    private final String server;
    private final Identity identity;
    private final byte[] token;
    private final UID serverLabel;
    private final EncryptedBytes data;
    private Encoded serverResponse;

    public PutUserDataServerMethod(Identity identity, byte[] token, UID serverLabel, EncryptedBytes data) {
        this.server = identity.getServer();
        this.identity = identity;
        this.token = token;
        this.serverLabel = serverLabel;
        this.data = data;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.token), Encoded.of(this.serverLabel), Encoded.of(this.data)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        super.parseReceivedData(receivedData);
        if (this.returnStatus == 0) {
            if (receivedData.length == 0) {
                this.serverResponse = null;
            } else {
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    public Encoded getServerResponse() {
        return this.serverResponse;
    }
}

