/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.Hash;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.PriorityOperation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.networkfetch.databases.InboxMessage;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import java.sql.SQLException;

public class ProcessWebsocketReceivedMessageOperation
extends PriorityOperation {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final Identity ownedIdentity;
    private final UID deviceUid;
    private final byte[] messagePayload;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getDeviceUid() {
        return this.deviceUid;
    }

    public ProcessWebsocketReceivedMessageOperation(FetchManagerSessionFactory fetchManagerSessionFactory, Identity ownedIdentity, UID deviceUid, byte[] messagePayload, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(ProcessWebsocketReceivedMessageOperation.computeUniqueUid(ownedIdentity, messagePayload), onFinishCallback, onCancelCallback);
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.ownedIdentity = ownedIdentity;
        this.deviceUid = deviceUid;
        this.messagePayload = messagePayload;
    }

    @Override
    public long getPriority() {
        return 1L;
    }

    private static UID computeUniqueUid(Identity ownedIdentity, byte[] messagePayload) {
        Hash sha256 = Suite.getHash("sha-256");
        byte[] input = new byte[ownedIdentity.getBytes().length + messagePayload.length];
        System.arraycopy(ownedIdentity.getBytes(), 0, input, 0, ownedIdentity.getBytes().length);
        System.arraycopy(messagePayload, 0, input, ownedIdentity.getBytes().length, messagePayload.length);
        return new UID(sha256.digest(input));
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            boolean finished = false;
            try {
                Encoded[] parts = new Encoded(this.messagePayload).decodeList();
                if (parts.length != 4) {
                    return;
                }
                UID messageUid = parts[0].decodeUid();
                long serverTimestamp = parts[1].decodeLong();
                EncryptedBytes wrappedKey = parts[2].decodeEncryptedData();
                EncryptedBytes messageContent = parts[3].decodeEncryptedData();
                fetchManagerSession.session.startTransaction();
                InboxMessage message = InboxMessage.get(fetchManagerSession, this.ownedIdentity, messageUid);
                if (message == null) {
                    InboxMessage.create(fetchManagerSession, this.ownedIdentity, messageUid, messageContent, wrappedKey, serverTimestamp, serverTimestamp, System.currentTimeMillis(), false);
                }
                finished = true;
            }
            catch (Exception e) {
                Logger.x(e);
                fetchManagerSession.session.rollback();
            }
            finally {
                if (finished) {
                    fetchManagerSession.session.commit();
                    this.setFinished();
                } else {
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

