/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.networkfetch.coordinators.WellKnownCoordinator;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.datatypes.WellKnownCacheDelegate;
import io.olvid.engine.networkfetch.operations.GetTurnCredentialsServerMethod;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.SSLSocketFactory;

public class GetTurnCredentialsOperation
extends Operation {
    public static final int RFC_INVALID_SERVER_SESSION = 1;
    public static final int RFC_WELL_KNOWN_NOT_CACHED = 2;
    public static final int RFC_PERMISSION_DENIED = 3;
    public static final int RFC_SERVER_DOES_NOT_SUPPORT_CALLS = 4;
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final WellKnownCacheDelegate wellKnownCacheDelegate;
    private final Identity ownedIdentity;
    private final UUID callUuid;
    private final String username1;
    private final String username2;
    private List<String> turnServers;
    private String expiringUsername1;
    private String password1;
    private String expiringUsername2;
    private String password2;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UUID getCallUuid() {
        return this.callUuid;
    }

    public List<String> getTurnServers() {
        return this.turnServers;
    }

    public String getExpiringUsername1() {
        return this.expiringUsername1;
    }

    public String getPassword1() {
        return this.password1;
    }

    public String getExpiringUsername2() {
        return this.expiringUsername2;
    }

    public String getPassword2() {
        return this.password2;
    }

    public GetTurnCredentialsOperation(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, WellKnownCacheDelegate wellKnownCacheDelegate, Identity ownedIdentity, UUID callUuid, String username1, String username2, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(ownedIdentity.computeUniqueUid(), onFinishCallback, onCancelCallback);
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.wellKnownCacheDelegate = wellKnownCacheDelegate;
        this.ownedIdentity = ownedIdentity;
        this.callUuid = callUuid;
        this.username1 = username1;
        this.username2 = username2;
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            try {
                try {
                    this.turnServers = this.wellKnownCacheDelegate.getTurnUrls(this.ownedIdentity.getServer());
                }
                catch (WellKnownCoordinator.NotCachedException e) {
                    this.cancel(2);
                    if (finished) {
                        this.setFinished();
                    } else {
                        if (this.hasNoReasonForCancel()) {
                            this.cancel(null);
                        }
                        this.processCancel();
                    }
                    if (fetchManagerSession == null) return;
                    fetchManagerSession.close();
                    return;
                }
                if (this.turnServers == null || this.turnServers.isEmpty()) {
                    this.cancel(4);
                    return;
                }
                byte[] serverSessionToken = ServerSession.getToken(fetchManagerSession, this.ownedIdentity);
                if (serverSessionToken == null) {
                    this.cancel(1);
                    return;
                }
                GetTurnCredentialsServerMethod serverMethod = new GetTurnCredentialsServerMethod(this.ownedIdentity, serverSessionToken, this.username1, this.username2);
                serverMethod.setSslSocketFactory(this.sslSocketFactory, this.userAgentOverride);
                byte returnStatus = serverMethod.execute(fetchManagerSession.identityDelegate.isActiveOwnedIdentity(fetchManagerSession.session, this.ownedIdentity));
                switch (returnStatus) {
                    case 0: {
                        this.expiringUsername1 = serverMethod.getExpiringUsername1();
                        this.password1 = serverMethod.getPassword1();
                        this.expiringUsername2 = serverMethod.getExpiringUsername2();
                        this.password2 = serverMethod.getPassword2();
                        break;
                    }
                    case 4: {
                        ServerSession.deleteCurrentTokenIfEqualTo(fetchManagerSession, serverSessionToken, this.ownedIdentity);
                        fetchManagerSession.session.commit();
                        this.cancel(1);
                        return;
                    }
                    case -114: 
                    case 14: {
                        this.cancel(3);
                        return;
                    }
                }
                finished = true;
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                fetchManagerSession.session.rollback();
                return;
            }
            finally {
                if (finished) {
                    this.setFinished();
                } else {
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

