/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.Arrays;

class GetTokenServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/getToken";
    private final String server;
    private final Identity identity;
    private final byte[] response;
    private final byte[] nonce;
    private byte[] token = null;
    private int apiKeyStatus = -1;
    private long permissions = 0L;
    private long apiKeyExpiration = 0L;

    public GetTokenServerMethod(Identity identity, byte[] response, byte[] nonce) {
        this.server = identity.getServer();
        this.identity = identity;
        this.response = response;
        this.nonce = nonce;
    }

    public byte[] getToken() {
        return this.token;
    }

    public int getApiKeyStatus() {
        return this.apiKeyStatus;
    }

    public long getPermissions() {
        return this.permissions;
    }

    public long getApiKeyExpiration() {
        return this.apiKeyExpiration;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.response), Encoded.of(this.nonce)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0) {
            try {
                byte[] token = receivedData[0].decodeBytes();
                byte[] serverNonce = receivedData[1].decodeBytes();
                if (!Arrays.equals(this.nonce, serverNonce) || token.length != 32) {
                    this.returnStatus = (byte)-1;
                    return;
                }
                this.token = token;
                this.apiKeyStatus = (int)receivedData[2].decodeLong();
                this.permissions = receivedData[3].decodeLong();
                this.apiKeyExpiration = receivedData[4].decodeLong();
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return false;
    }
}

