/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.FreeTrialServerMethod;
import java.sql.SQLException;
import java.util.HashMap;
import javax.net.ssl.SSLSocketFactory;

public class FreeTrialOperation
extends Operation {
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final Identity ownedIdentity;
    private final boolean retrieveApiKey;

    public FreeTrialOperation(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, Identity ownedIdentity, boolean retrieveApiKey) {
        super(ownedIdentity.computeUniqueUid(), null, null);
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.ownedIdentity = ownedIdentity;
        this.retrieveApiKey = retrieveApiKey;
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            try {
                HashMap<String, Object> userInfo;
                byte[] serverSessionToken = ServerSession.getToken(fetchManagerSession, this.ownedIdentity);
                if (serverSessionToken != null) {
                    FreeTrialServerMethod serverMethod = new FreeTrialServerMethod(this.ownedIdentity, serverSessionToken, this.retrieveApiKey);
                    serverMethod.setSslSocketFactory(this.sslSocketFactory, this.userAgentOverride);
                    byte returnStatus = serverMethod.execute(fetchManagerSession.identityDelegate.isActiveOwnedIdentity(fetchManagerSession.session, this.ownedIdentity));
                    fetchManagerSession.session.startTransaction();
                    switch (returnStatus) {
                        case 0: {
                            if (this.retrieveApiKey) {
                                HashMap<String, Object> userInfo2 = new HashMap<String, Object>();
                                userInfo2.put("owned_identity", this.ownedIdentity);
                                fetchManagerSession.notificationPostingDelegate.postNotification("network_fetch_notification_free_trial_retrieve_success", userInfo2);
                                ServerSession.deleteForIdentity(fetchManagerSession, this.ownedIdentity);
                                fetchManagerSession.createServerSessionDelegate.createServerSession(this.ownedIdentity);
                            } else {
                                HashMap<String, Object> userInfo3 = new HashMap<String, Object>();
                                userInfo3.put("owned_identity", this.ownedIdentity);
                                userInfo3.put("available", true);
                                fetchManagerSession.notificationPostingDelegate.postNotification("network_fetch_notification_free_trial_query_success", userInfo3);
                            }
                            finished = true;
                            return;
                        }
                        case 15: {
                            if (this.retrieveApiKey) break;
                            HashMap<String, Object> userInfo4 = new HashMap<String, Object>();
                            userInfo4.put("owned_identity", this.ownedIdentity);
                            userInfo4.put("available", false);
                            fetchManagerSession.notificationPostingDelegate.postNotification("network_fetch_notification_free_trial_query_success", userInfo4);
                            finished = true;
                            return;
                        }
                        case 4: {
                            ServerSession.deleteCurrentTokenIfEqualTo(fetchManagerSession, serverSessionToken, this.ownedIdentity);
                            fetchManagerSession.session.commit();
                            break;
                        }
                    }
                }
                if (this.retrieveApiKey) {
                    userInfo = new HashMap<String, Object>();
                    userInfo.put("owned_identity", this.ownedIdentity);
                    fetchManagerSession.notificationPostingDelegate.postNotification("network_fetch_notification_free_trial_retrieve_failed", userInfo);
                    return;
                }
                userInfo = new HashMap();
                userInfo.put("owned_identity", this.ownedIdentity);
                fetchManagerSession.notificationPostingDelegate.postNotification("network_fetch_notification_free_trial_query_failed", userInfo);
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                fetchManagerSession.session.rollback();
                return;
            }
            finally {
                if (finished) {
                    fetchManagerSession.session.commit();
                    this.setFinished();
                } else {
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

