/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ServerMethod;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;

class DownloadMessagesExtendedPayloadServerMethod
extends ServerMethod {
    private static final String SERVER_METHOD_PATH = "/downloadMessageExtendedContent";
    private final String server;
    private final Identity ownedIdentity;
    private final byte[] token;
    private final UID messageUid;
    private EncryptedBytes encryptedMessageExtendedPayload;

    public EncryptedBytes getEncryptedMessageExtendedPayload() {
        return this.encryptedMessageExtendedPayload;
    }

    DownloadMessagesExtendedPayloadServerMethod(Identity ownedIdentity, byte[] token, UID messageUid) {
        this.server = ownedIdentity.getServer();
        this.ownedIdentity = ownedIdentity;
        this.token = token;
        this.messageUid = messageUid;
    }

    @Override
    protected String getServer() {
        return this.server;
    }

    @Override
    protected String getServerMethod() {
        return SERVER_METHOD_PATH;
    }

    @Override
    protected byte[] getDataToSend() {
        return Encoded.of(new Encoded[]{Encoded.of(this.ownedIdentity), Encoded.of(this.token), Encoded.of(this.messageUid)}).getBytes();
    }

    @Override
    protected void parseReceivedData(Encoded[] receivedData) {
        if (this.returnStatus == 0) {
            try {
                this.encryptedMessageExtendedPayload = receivedData[0].decodeEncryptedData();
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.returnStatus = (byte)-1;
            }
        }
    }

    @Override
    protected boolean isActiveIdentityRequired() {
        return true;
    }
}

