/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.networkfetch.operations;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Operation;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.networkfetch.databases.InboxMessage;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSession;
import io.olvid.engine.networkfetch.datatypes.FetchManagerSessionFactory;
import io.olvid.engine.networkfetch.operations.DownloadMessagesExtendedPayloadServerMethod;
import java.sql.SQLException;
import javax.net.ssl.SSLSocketFactory;

public class DownloadMessagesExtendedPayloadOperation
extends Operation {
    public static final int RFC_NETWORK_ERROR = 1;
    public static final int RFC_INVALID_SERVER_SESSION = 2;
    public static final int RFC_IDENTITY_IS_INACTIVE = 3;
    public static final int RFC_EXTENDED_PAYLOAD_UNAVAILABLE_OR_INVALID = 4;
    public static final int RFC_MESSAGE_CANNOT_BE_FOUND = 5;
    private final FetchManagerSessionFactory fetchManagerSessionFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final String userAgentOverride;
    private final Identity ownedIdentity;
    private final UID messageUid;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    public DownloadMessagesExtendedPayloadOperation(FetchManagerSessionFactory fetchManagerSessionFactory, SSLSocketFactory sslSocketFactory, String userAgentOverride, Identity ownedIdentity, UID messageUid, Operation.OnFinishCallback onFinishCallback, Operation.OnCancelCallback onCancelCallback) {
        super(ownedIdentity.computeUniqueUid(), onFinishCallback, onCancelCallback);
        this.fetchManagerSessionFactory = fetchManagerSessionFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.userAgentOverride = userAgentOverride;
        this.ownedIdentity = ownedIdentity;
        this.messageUid = messageUid;
    }

    @Override
    public void doCancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() {
        boolean finished = false;
        try (FetchManagerSession fetchManagerSession = this.fetchManagerSessionFactory.getSession();){
            try {
                byte[] serverSessionToken = ServerSession.getToken(fetchManagerSession, this.ownedIdentity);
                if (serverSessionToken == null) {
                    this.cancel(2);
                    return;
                }
                InboxMessage inboxMessage = InboxMessage.get(fetchManagerSession, this.ownedIdentity, this.messageUid);
                if (inboxMessage == null) {
                    this.cancel(5);
                    return;
                }
                AuthEncKey extendedPayloadKey = inboxMessage.getExtendedPayloadKey();
                if (extendedPayloadKey == null) {
                    this.cancel(4);
                    return;
                }
                if (this.cancelWasRequested()) {
                    return;
                }
                DownloadMessagesExtendedPayloadServerMethod serverMethod = new DownloadMessagesExtendedPayloadServerMethod(this.ownedIdentity, serverSessionToken, this.messageUid);
                serverMethod.setSslSocketFactory(this.sslSocketFactory, this.userAgentOverride);
                byte returnStatus = serverMethod.execute(fetchManagerSession.identityDelegate.isActiveOwnedIdentity(fetchManagerSession.session, this.ownedIdentity));
                switch (returnStatus) {
                    case 0: {
                        byte[] messageExtendedPayload;
                        try {
                            AuthEnc authEnc = Suite.getAuthEnc(extendedPayloadKey);
                            messageExtendedPayload = authEnc.decrypt(extendedPayloadKey, serverMethod.getEncryptedMessageExtendedPayload());
                        }
                        catch (Exception e) {
                            this.cancel(4);
                            if (finished) {
                                fetchManagerSession.session.commit();
                                this.setFinished();
                            } else {
                                if (this.hasNoReasonForCancel()) {
                                    this.cancel(null);
                                }
                                this.processCancel();
                            }
                            if (fetchManagerSession == null) return;
                            fetchManagerSession.close();
                            return;
                        }
                        fetchManagerSession.session.startTransaction();
                        inboxMessage.setExtendedPayload(messageExtendedPayload);
                        finished = true;
                        return;
                    }
                    case 4: {
                        ServerSession.deleteCurrentTokenIfEqualTo(fetchManagerSession, serverSessionToken, this.ownedIdentity);
                        fetchManagerSession.session.commit();
                        this.cancel(2);
                        return;
                    }
                    case 17: {
                        this.cancel(4);
                        return;
                    }
                    case -114: {
                        this.cancel(3);
                        return;
                    }
                }
                this.cancel(1);
                return;
            }
            catch (Exception e) {
                Logger.x(e);
                fetchManagerSession.session.rollback();
                return;
            }
            finally {
                if (finished) {
                    fetchManagerSession.session.commit();
                    this.setFinished();
                } else {
                    if (this.hasNoReasonForCancel()) {
                        this.cancel(null);
                    }
                    this.processCancel();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            this.cancel(null);
            this.processCancel();
        }
    }
}

